// $Id: inf_fe_lagrange_eval.C 3874 2010-07-02 21:57:26Z roystgnr $

// The libMesh Finite Element Library.
// Copyright (C) 2002-2008 Benjamin S. Kirk, John W. Peterson, Roy H. Stogner

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


// Local Includes
#include "libmesh_config.h"
#ifdef LIBMESH_ENABLE_INFINITE_ELEMENTS
#include "inf_fe.h"

namespace libMesh
{



template <unsigned int Dim, FEFamily T_radial, InfMapType T_map>
Real InfFE<Dim,T_radial,T_map>::eval(const Real v,
				     const Order o_radial,
				     const unsigned int i)
{
  libmesh_assert (-1.-1.e-5 <= v && v < 1.);

  switch (o_radial)
    {
    case CONSTANT:
      switch (i)
        {
        case 0:
          return 1.;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FIRST:
      switch (i)
        {
        case 0:
          return -1.*v;

        case 1:
          return v+1.;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case SECOND:
      switch (i)
        {
        case 0:
          return 2.*v*(v+.5);

        case 1:
          return 2.*(v+1.)*(v+.5);

        case 2:
          return -4.*(v+1.)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case THIRD:
      switch (i)
        {
        case 0:
          return -4.5*v*(v+.6666666666666667)*(v+.3333333333333333);

        case 1:
          return 4.5*(v+1.)*(v+.6666666666666667)*(v+.3333333333333333);

        case 2:
          return 13.5*(v+1.)*v*(v+.3333333333333333);

        case 3:
          return -13.5*(v+1.)*v*(v+.6666666666666667);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FOURTH:
      switch (i)
        {
        case 0:
          return 10.66666666666667*v*(v+.75)*(v+.5)*(v+.25);

        case 1:
          return 10.66666666666667*(v+1.)*(v+.75)*(v+.5)*(v+.25);

        case 2:
          return -42.66666666666667*(v+1.)*v*(v+.5)*(v+.25);

        case 3:
          return 64.*(v+1.)*v*(v+.75)*(v+.25);

        case 4:
          return -42.66666666666667*(v+1.)*v*(v+.75)*(v+.5);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FIFTH:
      switch (i)
        {
        case 0:
          return -26.04166666666667*v*(v+.8)*(v+.6)*(v+.4)*(v+.2);

        case 1:
          return 26.04166666666667*(v+1.)*(v+.8)*(v+.6)*(v+.4)*(v+.2);

        case 2:
          return 130.2083333333333*(v+1.)*v*(v+.6)*(v+.4)*(v+.2);

        case 3:
          return -260.4166666666667*(v+1.)*v*(v+.8)*(v+.4)*(v+.2);

        case 4:
          return 260.4166666666667*(v+1.)*v*(v+.8)*(v+.6)*(v+.2);

        case 5:
          return -130.2083333333333*(v+1.)*v*(v+.8)*(v+.6)*(v+.4);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case SIXTH:
      switch (i)
        {
        case 0:
          return 64.8*v*(v+.8333333333333333)*(v+.6666666666666667)*(v+.5)*(v+.3333333333333333)*(v+.1666666666666667);

        case 1:
          return 64.8*(v+1.)*(v+.8333333333333333)*(v+.6666666666666667)*(v+.5)*(v+.3333333333333333)*(v+.1666666666666667);

        case 2:
          return -388.8*(v+1.)*v*(v+.6666666666666667)*(v+.5)*(v+.3333333333333333)*(v+.1666666666666667);

        case 3:
          return 972.*(v+1.)*v*(v+.8333333333333333)*(v+.5)*(v+.3333333333333333)*(v+.1666666666666667);

        case 4:
          return -1296.*(v+1.)*v*(v+.8333333333333333)*(v+.6666666666666667)*(v+.3333333333333333)*(v+.1666666666666667);

        case 5:
          return 972.*(v+1.)*v*(v+.8333333333333333)*(v+.6666666666666667)*(v+.5)*(v+.1666666666666667);

        case 6:
          return -388.8*(v+1.)*v*(v+.8333333333333333)*(v+.6666666666666667)*(v+.5)*(v+.3333333333333333);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case SEVENTH:
      switch (i)
        {
        case 0:
          return -163.401388888889*v*(v+.8571428571428571)*(v+.7142857142857143)*(v+.5714285714285714)*(v+.4285714285714286)*(v+.2857142857142857)*(v+.1428571428571429);

        case 1:
          return 163.4013888888888*(v+1.)*(v+.8571428571428571)*(v+.7142857142857143)*(v+.5714285714285714)*(v+.4285714285714286)*(v+.2857142857142857)*(v+.1428571428571429);

        case 2:
          return 1143.809722222222*(v+1.)*v*(v+.7142857142857143)*(v+.5714285714285714)*(v+.4285714285714286)*(v+.2857142857142857)*(v+.1428571428571429);

        case 3:
          return -3431.429166666665*(v+1.)*v*(v+.8571428571428571)*(v+.5714285714285714)*(v+.4285714285714286)*(v+.2857142857142857)*(v+.1428571428571429);

        case 4:
          return 5719.048611111112*(v+1.)*v*(v+.8571428571428571)*(v+.7142857142857143)*(v+.4285714285714286)*(v+.2857142857142857)*(v+.1428571428571429);

        case 5:
          return -5719.048611111112*(v+1.)*v*(v+.8571428571428571)*(v+.7142857142857143)*(v+.5714285714285714)*(v+.2857142857142857)*(v+.1428571428571429);

        case 6:
          return 3431.429166666666*(v+1.)*v*(v+.8571428571428571)*(v+.7142857142857143)*(v+.5714285714285714)*(v+.4285714285714286)*(v+.1428571428571429);

        case 7:
          return -1143.809722222223*(v+1.)*v*(v+.8571428571428571)*(v+.7142857142857143)*(v+.5714285714285714)*(v+.4285714285714286)*(v+.2857142857142857);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case EIGHTH:
      switch (i)
        {
        case 0:
          return 416.1015873015873*v*(v+.875)*(v+.75)*(v+.625)*(v+.5)*(v+.375)*(v+.25)*(v+.125);

        case 1:
          return 416.1015873015873*(v+1.)*(v+.875)*(v+.75)*(v+.625)*(v+.5)*(v+.375)*(v+.25)*(v+.125);

        case 2:
          return -3328.812698412698*(v+1.)*v*(v+.75)*(v+.625)*(v+.5)*(v+.375)*(v+.25)*(v+.125);

        case 3:
          return 11650.84444444444*(v+1.)*v*(v+.875)*(v+.625)*(v+.5)*(v+.375)*(v+.25)*(v+.125);

        case 4:
          return -23301.68888888889*(v+1.)*v*(v+.875)*(v+.75)*(v+.5)*(v+.375)*(v+.25)*(v+.125);

        case 5:
          return 29127.11111111111*(v+1.)*v*(v+.875)*(v+.75)*(v+.625)*(v+.375)*(v+.25)*(v+.125);

        case 6:
          return -23301.68888888889*(v+1.)*v*(v+.875)*(v+.75)*(v+.625)*(v+.5)*(v+.25)*(v+.125);

        case 7:
          return 11650.84444444444*(v+1.)*v*(v+.875)*(v+.75)*(v+.625)*(v+.5)*(v+.375)*(v+.125);

        case 8:
          return -3328.812698412698*(v+1.)*v*(v+.875)*(v+.75)*(v+.625)*(v+.5)*(v+.375)*(v+.25);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case NINTH:
      switch (i)
        {
        case 0:
          return -1067.627008928571*v*(v+.8888888888888889)*(v+.7777777777777778)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.2222222222222222)*(v+.1111111111111111);

        case 1:
          return 1067.627008928571*(v+1.)*(v+.8888888888888889)*(v+.7777777777777778)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.2222222222222222)*(v+.1111111111111111);

        case 2:
          return 9608.643080357158*(v+1.)*v*(v+.7777777777777778)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.2222222222222222)*(v+.1111111111111111);

        case 3:
          return -38434.57232142862*(v+1.)*v*(v+.8888888888888889)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.2222222222222222)*(v+.1111111111111111);

        case 4:
          return 89680.66874999999*(v+1.)*v*(v+.8888888888888889)*(v+.7777777777777778)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.2222222222222222)*(v+.1111111111111111);

        case 5:
          return -134521.0031249999*(v+1.)*v*(v+.8888888888888889)*(v+.7777777777777778)*(v+.6666666666666667)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.2222222222222222)*(v+.1111111111111111);

        case 6:
          return 134521.003125*(v+1.)*v*(v+.8888888888888889)*(v+.7777777777777778)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.3333333333333333)*(v+.2222222222222222)*(v+.1111111111111111);

        case 7:
          return -89680.66875000004*(v+1.)*v*(v+.8888888888888889)*(v+.7777777777777778)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.2222222222222222)*(v+.1111111111111111);

        case 8:
          return 38434.57232142857*(v+1.)*v*(v+.8888888888888889)*(v+.7777777777777778)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.1111111111111111);

        case 9:
          return -9608.643080357148*(v+1.)*v*(v+.8888888888888889)*(v+.7777777777777778)*(v+.6666666666666667)*(v+.5555555555555556)*(v+.4444444444444444)*(v+.3333333333333333)*(v+.2222222222222222);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case TENTH:
      switch (i)
        {
        case 0:
          return 2755.73192239859*v*(v+.9)*(v+.8)*(v+.7)*(v+.6)*(v+.5)*(v+.4)*(v+.3)*(v+.2)*(v+.1);

        case 1:
          return 2755.73192239859*(v+1.)*(v+.9)*(v+.8)*(v+.7)*(v+.6)*(v+.5)*(v+.4)*(v+.3)*(v+.2)*(v+.1);

        case 2:
          return -27557.31922398588*(v+1.)*v*(v+.8)*(v+.7)*(v+.6)*(v+.5)*(v+.4)*(v+.3)*(v+.2)*(v+.1);

        case 3:
          return 124007.9365079364*(v+1.)*v*(v+.9)*(v+.7)*(v+.6)*(v+.5)*(v+.4)*(v+.3)*(v+.2)*(v+.1);

        case 4:
          return -330687.8306878306*(v+1.)*v*(v+.9)*(v+.8)*(v+.6)*(v+.5)*(v+.4)*(v+.3)*(v+.2)*(v+.1);

        case 5:
          return 578703.7037037039*(v+1.)*v*(v+.9)*(v+.8)*(v+.7)*(v+.5)*(v+.4)*(v+.3)*(v+.2)*(v+.1);

        case 6:
          return -694444.4444444449*(v+1.)*v*(v+.9)*(v+.8)*(v+.7)*(v+.6)*(v+.4)*(v+.3)*(v+.2)*(v+.1);

        case 7:
          return 578703.7037037039*(v+1.)*v*(v+.9)*(v+.8)*(v+.7)*(v+.6)*(v+.5)*(v+.3)*(v+.2)*(v+.1);

        case 8:
          return -330687.8306878306*(v+1.)*v*(v+.9)*(v+.8)*(v+.7)*(v+.6)*(v+.5)*(v+.4)*(v+.2)*(v+.1);

        case 9:
          return 124007.9365079364*(v+1.)*v*(v+.9)*(v+.8)*(v+.7)*(v+.6)*(v+.5)*(v+.4)*(v+.3)*(v+.1);

        case 10:
          return -27557.31922398588*(v+1.)*v*(v+.9)*(v+.8)*(v+.7)*(v+.6)*(v+.5)*(v+.4)*(v+.3)*(v+.2);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case ELEVENTH:
      switch (i)
        {
        case 0:
          return -7147.658895778214*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 1:
          return 7147.65889577822*(v+1.)*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 2:
          return 78624.2478535604*(v+1.)*v*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 3:
          return -393121.2392678026*(v+1.)*v*(v+.9090909090909091)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 4:
          return 1179363.717803407*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 5:
          return -2358727.435606812*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 6:
          return 3302218.409849539*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 7:
          return -3302218.40984954*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 8:
          return 2358727.435606811*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.2727272727272727)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 9:
          return -1179363.717803406*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.1818181818181818)*(v+.9090909090909091e-1);

        case 10:
          return 393121.2392678019*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.9090909090909091e-1);

        case 11:
          return -78624.24785356052*(v+1.)*v*(v+.9090909090909091)*(v+.8181818181818182)*(v+.7272727272727273)*(v+.6363636363636364)*(v+.5454545454545455)*(v+.4545454545454545)*(v+.3636363636363636)*(v+.2727272727272727)*(v+.1818181818181818);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case TWELFTH:
      switch (i)
        {
        case 0:
          return 18613.92623376623*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 1:
          return 18613.92623376623*(v+1.)*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 2:
          return -223367.1148051951*(v+1.)*v*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 3:
          return 1228519.131428571*(v+1.)*v*(v+.9166666666666667)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 4:
          return -4095063.771428572*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 5:
          return 9213893.485714271*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 6:
          return -14742229.57714284*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 7:
          return 17199267.84*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 8:
          return -14742229.57714286*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 9:
          return 9213893.485714291*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.25)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 10:
          return -4095063.77142857*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.1666666666666667)*(v+.8333333333333333e-1);

        case 11:
          return 1228519.131428571*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.8333333333333333e-1);

        case 12:
          return -223367.1148051951*(v+1.)*v*(v+.9166666666666667)*(v+.8333333333333333)*(v+.75)*(v+.6666666666666667)*(v+.5833333333333333)*(v+.5)*(v+.4166666666666667)*(v+.3333333333333333)*(v+.25)*(v+.1666666666666667);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case THIRTEENTH:
      switch (i)
        {
        case 0:
          return -48638.84613847011*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 1:
          return 48638.84613847013*(v+1.)*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 2:
          return 632304.9998001099*(v+1.)*v*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 3:
          return -3793829.998800662*(v+1.)*v*(v+.9230769230769231)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 4:
          return 13910709.99560246*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 5:
          return -34776774.98900616*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 6:
          return 62598194.98021102*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 7:
          return -83464259.97361468*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 8:
          return 83464259.97361466*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 9:
          return -62598194.98021099*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 10:
          return 34776774.98900612*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.2307692307692308)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 11:
          return -13910709.99560244*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.1538461538461538)*(v+.7692307692307692e-1);

        case 12:
          return 3793829.998800668*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.7692307692307692e-1);

        case 13:
          return -632304.9998001105*(v+1.)*v*(v+.9230769230769231)*(v+.8461538461538462)*(v+.7692307692307692)*(v+.6923076923076923)*(v+.6153846153846154)*(v+.5384615384615385)*(v+.4615384615384615)*(v+.3846153846153846)*(v+.3076923076923077)*(v+.2307692307692308)*(v+.1538461538461538);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FOURTEENTH:
      switch (i)
        {
        case 0:
          return 127463.0033762123*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 1:
          return 127463.0033762123*(v+1.)*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 2:
          return -1784482.047266971*(v+1.)*v*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 3:
          return 11599133.30723529*(v+1.)*v*(v+.9285714285714286)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 4:
          return -46396533.2289412*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 5:
          return 127590466.3795883*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 6:
          return -255180932.7591769*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 7:
          return 382771399.1387658*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 8:
          return -437453027.5871608*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 9:
          return 382771399.1387654*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 10:
          return -255180932.7591768*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 11:
          return 127590466.3795886*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2142857142857143)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 12:
          return -46396533.22894132*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.1428571428571429)*(v+.7142857142857143e-1);

        case 13:
          return 11599133.30723532*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.7142857142857143e-1);

        case 14:
          return -1784482.047266969*(v+1.)*v*(v+.9285714285714286)*(v+.8571428571428571)*(v+.7857142857142857)*(v+.7142857142857143)*(v+.6428571428571429)*(v+.5714285714285714)*(v+.5)*(v+.4285714285714286)*(v+.3571428571428571)*(v+.2857142857142857)*(v+.2142857142857143)*(v+.1428571428571429);

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    // provided the constructor worked fine, we should never end up here.
    default:
      libMesh::err << "Lagrange polynomials only defined up to 15. "
		    << std::endl;
      libmesh_error();
    }

  // we never end up here.
  return 0.;
}



template <unsigned int Dim, FEFamily T_radial, InfMapType T_map>
Real InfFE<Dim,T_radial,T_map>::eval_deriv(const Real v,
					   const Order o_radial,
					   const unsigned int i)
{
  libmesh_assert (-1.-1.e-5 <= v && v < 1.);

  switch (o_radial)
    {
    case CONSTANT:
      switch (i)
        {
        case 0:
          return 0.;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FIRST:
      switch (i)
        {
        case 0:
          return -1.;

        case 1:
          return 1.;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case SECOND:
      switch (i)
        {
        case 0:
          return 4.*v+1.;

        case 1:
          return 4.*v+3.;

        case 2:
          return -8.*v-4.;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case THIRD:
      switch (i)
        {
        case 0:
          return -1.+(-9.-13.5*v)*v;

        case 1:
          return 5.5+(18.+13.5*v)*v;

        case 2:
          return 4.5+(36.+40.5*v)*v;

        case 3:
          return -9.+(-45.-40.5*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FOURTH:
      switch (i)
        {
        case 0:
          return 1.+(14.66666666666667+(48.+42.66666666666667*v)*v)*v;

        case 1:
          return 8.333333333333333+(46.66666666666667+(80.+42.66666666666667*v)*v)*v;

        case 2:
          return -5.333333333333333+(-74.66666666666667+(-224.-170.6666666666667*v)*v)*v;

        case 3:
          return 12.+(152.+(384.+256.*v)*v)*v;

        case 4:
          return -16.+(-138.6666666666667+(-288.-170.6666666666667*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FIFTH:
      switch (i)
        {
        case 0:
          return -1.+(-20.83333333333333+(-109.375+(-208.3333333333333-130.2083333333333*v)*v)*v)*v;

        case 1:
          return 11.41666666666667+(93.75+(265.625+(312.5+130.2083333333333*v)*v)*v)*v;

        case 2:
          return 6.25+(127.0833333333333+(640.625+(1145.833333333333+651.0416666666667*v)*v)*v)*v;

        case 3:
          return -16.66666666666667+(-325.+(-1531.25+(-2500.-1302.083333333333*v)*v)*v)*v;

        case 4:
          return 25.+(445.8333333333333+(1843.75+(2708.333333333333+1302.083333333333*v)*v)*v)*v;

        case 5:
          return -25.+(-320.8333333333333+(-1109.375+(-1458.333333333333-651.0416666666667*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case SIXTH:
      switch (i)
        {
        case 0:
          return 1.+(27.4+(202.5+(612.+(810.+388.8*v)*v)*v)*v)*v;

        case 1:
          return 14.7+(162.4+(661.5+(1260.+(1134.+388.8*v)*v)*v)*v)*v;

        case 2:
          return -7.2+(-194.4+(-1404.+(-4104.+(-5184.-2332.8*v)*v)*v)*v)*v;

        case 3:
          return 22.5+(594.+(4144.5+(11556.+(13770.+5832.*v)*v)*v)*v)*v;

        case 4:
          return -40.+(-1016.+(-6696.+(-17424.+(-19440.-7776.*v)*v)*v)*v)*v;

        case 5:
          return 45.+(1053.+(6223.5+(14796.+(15390.+5832.*v)*v)*v)*v)*v;

        case 6:
          return -36.+(-626.4+(-3132.+(-6696.+(-6480.-2332.8*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case SEVENTH:
      switch (i)
        {
        case 0:
          return -1.000000000000001+(-34.30000000000002+(-331.5666666666668+(-1400.583333333334+(-2917.881944444446+(-2941.225000000002-1143.809722222223*v)*v)*v)*v)*v)*v;

        case 1:
          return 18.14999999999999+(255.3444444444444+(1382.004166666666+(3734.888888888888+(5368.902777777776+(3921.633333333332+1143.809722222222*v)*v)*v)*v)*v)*v;

        case 2:
          return 8.166666666666662+(277.3944444444443+(2642.529166666665+(10937.88888888888+(22175.90277777776+(21568.98333333332+8006.668055555551*v)*v)*v)*v)*v)*v;

        case 3:
          return -29.39999999999998+(-984.8999999999994+(-9192.399999999994+(-37015.41666666664+(-72480.18749999995+(-67648.17499999996-24020.00416666665*v)*v)*v)*v)*v)*v;

        case 4:
          return 61.25000000000001+(2009.+(18186.14583333333+(70429.33333333334+(131888.2638888889+(117649.+40033.34027777778*v)*v)*v)*v)*v)*v;

        case 5:
          return -81.66666666666667+(-2583.388888888889+(-22237.83333333334+(-81300.52777777778+(-144143.3680555556+(-122551.0416666667-40033.34027777778*v)*v)*v)*v)*v)*v;

        case 6:
          return 73.49999999999999+(2153.55+(16845.5875+(56823.66666666666+(94539.37499999999+(76471.84999999999+24020.00416666666*v)*v)*v)*v)*v)*v;

        case 7:
          return -49.00000000000003+(-1092.700000000001+(-7294.466666666671+(-22209.25000000001+(-34431.00694444447+(-26471.02500000002-8006.66805555556*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case EIGHTH:
      switch (i)
        {
        case 0:
          return 1.+(41.48571428571429+(500.2666666666667+(2750.577777777778+(7964.444444444444+(12561.06666666667+(10194.48888888889+3328.812698412698*v)*v)*v)*v)*v)*v)*v;

        case 1:
          return 21.74285714285714+(374.9968253968254+(2563.2+(9122.133333333333+(18432.+(21299.2+(13107.2+3328.812698412698*v)*v)*v)*v)*v)*v)*v;

        case 2:
          return -9.142857142857143+(-376.6857142857143+(-4497.066666666667+(-24393.95555555556+(-69404.44444444444+(-107042.1333333333+(-84468.62222222222-26630.50158730159*v)*v)*v)*v)*v)*v)*v;

        case 3:
          return 37.33333333333333+(1523.911111111111+(17952.+(95675.73333333333+(266240.+(399769.6+(305834.6666666667+93206.75555555556*v)*v)*v)*v)*v)*v)*v;

        case 4:
          return -89.6+(-3609.6+(-41736.53333333333+(-217179.0222222222+(-587320.8888888889+(-854152.5333333333+(-632058.3111111111-186413.5111111111*v)*v)*v)*v)*v)*v)*v;

        case 5:
          return 140.+(5528.+(62165.33333333333+(312689.7777777778+(814648.8888888889+(1141418.666666667+(815559.1111111111+233016.8888888889*v)*v)*v)*v)*v)*v)*v;

        case 6:
          return -149.3333333333333+(-5697.422222222222+(-61209.6+(-292727.4666666667+(-727040.+(-976486.4+(-672836.2666666667-186413.5111111111*v)*v)*v)*v)*v)*v)*v;

        case 7:
          return 112.+(3974.4+(39153.06666666667+(173954.8444444444+(407324.4444444444+(522103.4666666667+(346612.6222222222+93206.75555555556*v)*v)*v)*v)*v)*v)*v;

        case 8:
          return -64.+(-1759.085714285714+(-14890.66666666667+(-59892.62222222222+(-130844.4444444444+(-159470.9333333333+(-101944.8888888889-26630.50158730159*v)*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case NINTH:
      switch (i)
        {
        case 0:
          return -.9999999999999998+(-48.92142857142856+(-711.9080357142856+(-4866.074999999999+(-18264.8671875+(-39858.07499999999+(-50376.17812499999+(-34164.06428571428-9608.643080357141*v)*v)*v)*v)*v)*v)*v)*v;

        case 1:
          return 25.46071428571428+(523.5267857142855+(4361.464285714284+(19477.96874999999+(51479.92968749998+(83037.65624999997+(80269.73437499997+(42705.08035714284+9608.643080357139*v)*v)*v)*v)*v)*v)*v)*v;

        case 2:
          return 10.12500000000002+(492.7982142857151+(7119.466071428583+(48200.56875000008+(178735.9921875003+(384187.5562500006+(476636.1468750008+(316017.5946428576+86477.78772321442*v)*v)*v)*v)*v)*v)*v)*v;

        case 3:
          return -46.28571428571434+(-2237.914285714288+(-32031.73928571432+(-214253.1000000003+(-782604.2812500009+(-1651895.775000002+(-2006189.775000002+(-1298234.442857144-345911.1508928576*v)*v)*v)*v)*v)*v)*v)*v;

        case 4:
          return 126.+(6038.1+(85360.8375+(562004.325+(2014021.96875+(4158525.825+(4929115.275+(3108929.85+807126.01875*v)*v)*v)*v)*v)*v)*v)*v;

        case 5:
          return -226.7999999999999+(-10732.49999999999+(-149126.0624999999+(-961004.2499999995+(-3359744.578124998+(-6753729.374999997+(-7788932.156249996+(-4782968.999999998-1210689.028124999*v)*v)*v)*v)*v)*v)*v)*v;

        case 6:
          return 283.5+(13160.475+(178213.1625+(1113994.0125+(3769397.015624999+(7336100.137499999+(8207441.943749999+(4902543.224999999+1210689.028125*v)*v)*v)*v)*v)*v)*v)*v;

        case 7:
          return -252.0000000000001+(-11320.2+(-146952.2250000001+(-877643.1000000003+(-2844398.531250001+(-5327696.025000002+(-5766134.850000002+(-3348078.300000001-807126.0187500003*v)*v)*v)*v)*v)*v)*v)*v;

        case 8:
          return 162.+(6791.271428571428+(81375.92678571428+(453820.725+(1391547.09375+(2493344.025+(2604060.9+(1469054.764285714+345911.1508928571*v)*v)*v)*v)*v)*v)*v)*v;

        case 9:
          return -81.00000000000004+(-2666.635714285716+(-27608.92232142859+(-139731.0750000001+(-400169.7421875002+(-682015.9500000004+(-685891.0406250004+(-375804.7071428573-86477.78772321433*v)*v)*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case TENTH:
      switch (i)
        {
        case 0:
          return 1.+(56.57936507936509+(969.4940476190478+(7977.072310405645+(37109.37500000001+(104618.0555555556+(182291.6666666667+(191798.9417989418+(111607.1428571429+27557.3192239859*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 1:
          return 29.28968253968254+(702.9087301587303+(6952.298280423282+(37664.57231040565+(124291.087962963+(260868.0555555556+(350115.7407407408+(291005.2910052911+(136408.7301587302+27557.3192239859*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 2:
          return -11.11111111111111+(-626.190476190476+(-10671.49470899471+(-87187.38977072308+(-402025.4629629629+(-1121180.555555555+(-1928240.74074074+(-1997354.497354497+(-1140873.015873016-275573.1922398588*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 3:
          return 56.24999999999993+(3154.464285714282+(53393.30357142851+(432433.5317460312+(1972612.84722222+(5430729.16666666+(9199652.777777767+(9365079.365079354+(5245535.714285708+1240079.365079364*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 4:
          return -171.4285714285714+(-9552.380952380949+(-160278.5714285714+(-1283804.232804232+(-5778472.22222222+(-15662499.99999999+(-26069444.44444444+(-26031746.03174602+(-14285714.28571428-3306878.306878306*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 5:
          return 350.0000000000001+(19336.11111111112+(320686.8055555557+(2531768.518518519+(11203732.63888889+(29794791.66666668+(48586805.55555557+(47500000.00000002+(25520833.33333334+5787037.037037039*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 6:
          return -504.0000000000003+(-27508.00000000002+(-448875.0000000003+(-3474944.444444447+(-15041319.44444445+(-39072083.33333336+(-62222222.22222226+(-59444444.44444448+(-31250000.00000002-6944444.444444449*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 7:
          return 525.0000000000002+(28129.16666666668+(448056.2500000002+(3373087.962962964+(14176475.69444445+(35773958.33333335+(55440972.22222224+(51666666.66666669+(26562500.00000001+5787037.037037039*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 8:
          return -399.9999999999999+(-20765.07936507936+(-317919.8412698412+(-2294915.343915343+(-9270138.888888886+(-22579166.66666666+(-33930555.55555554+(-30793650.79365078+(-15476190.47619047-3306878.306878306*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 9:
          return 224.9999999999997+(10930.35714285713+(155254.0178571427+(1050662.698412697+(4026519.097222217+(9399479.166666656+(13647569.44444443+(12043650.79365078+(5915178.571428564+1240079.365079364*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 10:
          return -99.99999999999998+(-3857.936507936507+(-47567.26190476189+(-292742.9453262786+(-1048784.722222222+(-2329513.888888888+(-3256944.444444444+(-2791005.29100529+(-1339285.714285714-275573.1922398588*v)*v)*v)*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case ELEVENTH:
      switch (i)
        {
        case 0:
          return -.9999999999999994+(-64.43730158730155+(-1275.779345238094+(-12338.01201499117+(-68930.87539958109+(-240206.4480902776+(-539167.6189293978+(-779744.6068121688+(-701770.1461309519+(-357382.9447889107-78624.24785356036*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 1:
          return 33.2186507936508+(914.9568650793652+(10529.28835648148+(67482.7123346561+(269102.9154748127+(702350.1214583334+(1221444.149890046+(1403540.292261905+(1023414.796440972+(428859.5337466932+78624.24785356042*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 2:
          return 12.1+(777.2713492063492+(15323.969375+(147397.3637345679+(818004.6489266424+(2827608.196111111+(6286078.696244213+(8988328.740343915+(7982635.412239583+(4002688.981635802+864866.7263891644*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 3:
          return -67.22222222222232+(-4301.74206349207+(-84371.62344576732+(-806241.7181878318+(-4438664.17533345+(-15197594.39114585+(-33411814.74551509+(-47167460.12480165+(-41287476.93070442+(-20370827.85296795-4324333.631945828*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 4:
          return 226.8750000000001+(14449.05654761906+(281570.0790178573+(2668897.916302912+(14550507.15751076+(49254931.92812503+(106890177.8054688+(148732739.4557541+(128160772.9371653+(62184632.39327054+12973000.89583747*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 5:
          return -518.5714285714285+(-32822.69047619047+(-634337.9624999999+(-5951161.742195766+(-32053476.18047288+(-107015202.0322916+(-228727286.4230902+(-313117079.7464285+(-265269115.2375+(-126513562.4552744-25946001.79167493*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 6:
          return 847.0000000000005+(53166.72777777781+(1016244.195694445+(9406923.838888894+(49889787.88686346+(163758669.9375001+(343777378.7658683+(462062476.8222225+(384394597.5432294+(180121004.1736112+36324402.50834493*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 7:
          return -1016.400000000001+(-63054.71333333338+(-1186862.682500001+(-10787827.71203705+(-56070259.81307875+(-180193958.0397918+(-370348948.3898267+(-487666454.2750004+(-397903672.8562503+(-183123020.9098381-36324402.50834493*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 8:
          return 907.4999999999995+(55300.60119047616+(1017370.052678571+(9010082.051521159+(45578544.75252147+(142643877.2687499+(285964084.8567707+(368067808.7646823+(294217133.7654016+(132946455.4614748+25946001.79167492*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 9:
          return -604.9999999999997+(-35757.90079365078+(-633654.9006944442+(-5395757.537499998+(-26303245.82287532+(-79634435.01406247+(-155083710.9469617+(-194666785.3843253+(-152284121.7104166+(-67545376.56510414-12973000.89583746*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 10:
          return 302.4999999999999+(16769.78373015873+(276810.9617559523+(2216865.917570546+(10275947.41824432+(29863105.35694444+(56249470.99094327+(68702588.44748676+(52545039.69155505+(22872508.46649029+4324333.631945821*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 11:
          return -121.0000000000002+(-5376.9134920635+(-77345.59839285725+(-564323.0784171084+(-2447317.912381507+(-6769146.883506954+(-12277707.14086229+(-14559958.38538362+(-10877437.26502978+(-4645978.282255849-864866.7263891657*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case TWELFTH:
      switch (i)
        {
        case 0:
          return .9999999999999998+(72.47705627705626+(1633.311428571428+(18226.50666666666+(119469.4285714285+(498933.257142857+(1381121.28+(2566761.325714285+(3167275.885714285+(2488319.999999999+(1126142.537142857+223367.1148051948*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 1:
          return 37.23852813852813+(1161.351341991342+(15303.19142857143+(113802.0495238095+(535247.1428571427+(1682751.497142857+(3627037.439999999+(5382117.668571427+(5406763.885714285+(3512085.942857142+(1330895.725714285+223367.1148051948*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 2:
          return -13.09090909090911+(-946.410389610391+(-21256.04571428574+(-236192.3657142861+(-1540134.857142859+(-6392069.485714295+(-17564843.52000003+(-32365222.76571433+(-39542959.5428572+(-30712978.28571433+(-13718463.63428573-2680405.377662341*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 3:
          return 79.19999999999997+(5708.502857142855+(127693.2342857142+(1411707.84+(9148841.14285714+(37695557.21142856+(102712458.24+(187435903.2685714+(226508214.8571428+(173784268.7999999+(76577692.52571426+14742229.57714285*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 4:
          return -293.3333333333333+(-21064.38095238095+(-468865.8285714286+(-5151708.952380953+(-33141236.57142857+(-135381015.7714286+(-365282265.6+(-659300527.5428572+(-787148039.3142857+(-596059282.2857143+(-259012783.5428571-49140765.25714286*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 5:
          return 742.4999999999988+(53071.7142857142+(1174043.699999998+(12802072.11428569+(81618641.99999987+(329991648.6857138+(880198099.1999986+(1568889314.742855+(1848249446.399997+(1380164461.714284+(591224831.9999991+110566721.8285713*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 6:
          return -1357.714285714284+(-96463.54285714276+(-2117125.851428569+(-22864004.02285712+(-144144041.142857+(-575530346.0571423+(-1514417679.359998+(-2660955375.908569+(-3088957791.085711+(-2272760393.142855+(-959473441.6457133-176906754.9257141*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 7:
          return 1848.+(130241.6+(2828541.120000001+(30164287.36000001+(187472016.+(737031225.6000001+(1908272701.44+(3298536898.560001+(3767714611.200001+(2729189376.+(1135151677.44+206391214.08*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 8:
          return -1900.800000000001+(-132442.1485714286+(-2834453.211428572+(-29714158.08000001+(-181251195.4285715+(-698873880.1371431+(-1774822855.680001+(-3011083328.365715+(-3379195435.885715+(-2407897497.600001+(-986500862.5371432-176906754.9257143*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 9:
          return 1485.000000000001+(101688.4285714286+(2129312.185714287+(21783070.2857143+(129558540.8571429+(487399661.4857146+(1209468153.600001+(2008852728.685716+(2211622370.742859+(1549085842.285715+(625009108.1142861+110566721.8285715*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 10:
          return -879.9999999999996+(-58499.8095238095+(-1181984.914285714+(-11651825.06666666+(-66923129.14285712+(-243989962.9714285+(-589005043.1999998+(-955168885.028571+(-1030036509.257142+(-708673535.9999997+(-281535634.2857142-49140765.25714284*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 11:
          return 395.9999999999998+(24740.91428571427+(467174.4685714284+(4342689.325714284+(23761844.57142856+(83264161.37142853+(194582062.0799999+(307216518.582857+(324021920.9142856+(218829970.2857142+(85586832.8228571+14742229.57714285*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 12:
          return -144.0000000000002+(-7268.696103896113+(-120015.3600000001+(-1017966.994285716+(-5214864.000000006+(-17396664.68571431+(-39148945.92000005+(-60006903.22285722+(-61809868.80000008+(-40950637.71428576+(-15765995.52000002-2680405.377662341*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case THIRTEENTH:
      switch (i)
        {
        case 0:
          return -1.+(-80.68347763347765+(-2044.462258297259+(-25942.2157164903+(-195933.4211304931+(-958398.5214740412+(-3173506.650750547+(-7259032.308898811+(-11486892.61199839+(-12346784.01976549+(-8601592.867103291+(-3501996.921969848-632304.9998001114*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 1:
          return 41.34173881673884+(1443.658316498317+(21501.124045665+(182688.9526208849+(994598.8556921946+(3678547.079260226+(9525159.921037011+(17469603.51956405+(22598998.22978734+(20166413.89895031+(11811756.71224232+(4085663.075631491+632304.9998001117*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 2:
          return 14.0833333333333+(1133.945087782585+(28654.62116838017+(362353.3209476036+(2725399.981313606+(13265700.68549035+(43674200.44979463+(99236897.21980192+(155839062.2764586+(166048415.8555637+(114536999.7566909+(46109626.13926956+8219964.997401429*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 3:
          return -92.18181818181805+(-7404.029004328994+(-186493.2485281383+(-2348815.46078042+(-17580908.74629903+(-85087791.92399955+(-278293001.5682587+(-627605520.9915996+(-977247224.5855008+(-1031431341.958869+(-704013624.8070271+(-280159753.7575874-49319789.98440861*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 4:
          return 371.8000000000002+(29775.036984127+(747066.9209920639+(9363907.89718475+(69688340.39763103+(335036414.4353251+(1087492542.853534+(2431673317.636533+(3750776185.102226+(3918109445.780044+(2644763448.927234+(1040093085.825045+180839229.9428319*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 5:
          return -1032.777777777779+(-82410.07804232813+(-2057912.1728836+(-25644457.74177325+(-189543869.9955658+(-904096807.162213+(-2908738078.894543+(-6440986214.655237+(-9830892990.478734+(-10155071564.15431+(-6774886171.378993+(-2632334353.014005-452098074.8570801*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 6:
          return 2091.375+(166125.1892857143+(4123916.218616072+(51020732.59433532+(373953022.277135+(1766886624.747501+(5625702404.785355+(12318759910.9515+(18582195606.11107+(18963235625.43443+(12496303574.24485+(4795984784.637706+813776534.7427433*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 7:
          return -3186.857142857142+(-251663.5333333333+(-6200036.526666666+(-76008876.2598148+(-551305314.9444829+(-2574950087.743402+(-8097779517.245471+(-17504674905.19222+(-26060004891.47182+(-26247363320.78761+(-17074614556.61409+(-6471690311.800277-1085035379.656991*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 8:
          return 3717.999999999998+(291305.8365079364+(7104538.462460314+(86064016.71082448+(615956862.0470787+(2836014413.233886+(8787496836.24099+(18714249266.16391+(27455001535.18193+(27263598620.87599+(17498356184.17243+(6548734244.083612+1085035379.656991*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 9:
          return -3346.199999999998+(-259275.2128571427+(-6234980.857857139+(-74314814.73490075+(-522619068.6865779+(-2363180534.798538+(-7192365653.835081+(-15054787917.48891+(-21728631050.65575+(-21251474605.34373+(-13449722236.25113+(-4969333632.275211-813776534.7427428*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 10:
          return 2323.75+(177031.3561507936+(4169023.658209325+(48551880.14924492+(333412303.9596687+(1473130923.654975+(4387072985.810989+(9001260757.284597+(12758505432.0885+(12276977202.42297+(7657681228.792217+(2792842545.270953+452098074.8570795*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 11:
          return -1239.333333333332+(-91731.50105820099+(-2087506.053492062+(-23468266.89172691+(-155895856.7716664+(-668508962.9727646+(-1939086147.461385+(-3888161778.825734+(-5402206035.376699+(-5109035910.537828+(-3139128681.07864+(-1129977673.488937-180839229.9428317*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 12:
          return 507.0000000000001+(35329.52316017317+(753439.2988852815+(8004952.597863758+(50738883.86584271+(209350649.6495577+(588284837.5399432+(1149033869.66415+(1561914935.552244+(1450272246.013992+(877362472.4445357+(311677726.0553165+49319789.98440869*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 13:
          return -168.9999999999998+(-9579.507720057708+(-179166.9826911975+(-1739358.918309081+(-10328458.8186393+(-40580690.36360362+(-109813061.9461516+(-208208252.9774634+(-276362669.3617079+(-251684443.4798346+(-149848802.0532203+(-52529953.82954764-8219964.997401437*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    case FOURTEENTH:
      switch (i)
        {
        case 0:
          return 1.000000000000001+(89.0437451437452+(2511.452929292931+(35805.84699214368+(307157.435133745+(1728831.305617285+(6694701.358837453+(18287612.31917697+(35556011.50111113+(48922521.07901238+(46544481.35786011+(29116191.77122336+(10770623.78528994+1784482.047266973*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 1:
          return 45.52187257187257+(1763.345698005698+(29365.83817340067+(281531.7950991395+(1747850.189814815+(7467146.756049383+(22696362.13811728+(49892955.87572016+(79586280.47222222+(91235685.94979424+(73234323.81481481+(39058306.0345679+(12427642.8291807+1784482.047266972*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 2:
          return -15.07692307692307+(-1340.186169386169+(-37713.82505050504+(-536175.4596184062+(-4584016.86584362+(-25698683.17679012+(-99057107.66633743+(-269159338.175144+(-520164399.5644443+(-710821314.4148147+(-671058896.060576+(-416148497.0228506+(-152445752.0379498-24982748.6617376*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 3:
          return 106.1666666666664+(9418.0887205387+(264331.1471464641+(3745715.752540209+(31899113.16882709+(178017355.746049+(682587693.1574368+(1843708348.548309+(3539222709.936659+(4800352165.04608+(4494355579.027644+(2761777312.15335+(1001668012.031962+162387866.3012941*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 4:
          return -463.2727272727266+(-40998.84444444439+(-1147094.434747473+(-16192604.75699212+(-137271541.0485595+(-762026508.285431+(-2904385776.815469+(-7792130969.395215+(-14846386660.68442+(-19971946670.39009+(-18532980221.46894+(-11280038782.78319+(-4049754543.269010-649551465.2051768*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 5:
          return 1401.399999999998+(123664.7844444442+(3447032.944444439+(48436585.99197523+(408409296.5789602+(2253197088.95512+(8528314129.288823+(22705190993.54646+(42899311094.9277+(57192419912.08138+(52567132654.44024+(31676286194.03451+(11255301855.62796+1786266529.314236*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 6:
          return -3114.222222222221+(-273841.7629629629+(-7598211.423703702+(-106176407.7618107+(-889486589.4962961+(-4871457715.624196+(-18289286459.60543+(-48264587628.2762+(-90336942561.1022+(-119250255953.088+(-108490582744.8178+(-64696178115.65826+(-22747557434.53234-3572533058.628476*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 7:
          return 5255.250000000005+(460064.2666666671+(12692565.01916668+(176150443.0362965+(1464070863.601545+(7947918838.465933+(29555009192.81537+(77204332615.9018+(142978921074.0568+(186702987302.2742+(168009721889.5444+(99106545732.11268+(34476766736.71312+5358799587.942721*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 8:
          return -6864.000000000005+(-597468.2666666671+(-16363002.50666668+(-225121477.611852+(-1852739107.920989+(-9950118584.456304+(-36579967858.71213+(-94431878855.5576+(-172801677847.3068+(-222974303851.9113+(-198322454721.1221+(-115675079151.9764+(-39808225510.43164-6124342386.220252*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 9:
          return 7007.+(605244.1888888889+(16415290.29777778+(223285445.4038272+(1814617394.563426+(9615694831.261296+(34866622054.4775+(88774809190.10321+(160266060424.7967+(204118806975.1876+(179312358692.2474+(103371712751.0874+(35187627906.54222+5358799587.942716*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 10:
          return -5605.599999999996+(-478963.4577777775+(-12815269.44444444+(-171640517.3604937+(-1371951477.497941+(-7147541864.43802+(-25485507407.83126+(-63848350696.57444+(-113517642944.8444+(-142532726188.3604+(-123573040616.0328+(-70383067474.29131+(-23695372327.63784-3572533058.628475*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 11:
          return 3503.500000000003+(294447.2611111113+(7720974.358611117+(101146405.0471606+(790417783.0809677+(4028557079.079386+(14071398696.88138+(34590639213.49616+(60449325371.26783+(74730994261.10376+(63894320392.36532+(35941453213.00941+(11966163025.45713+1786266529.31424*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 12:
          return -1698.666666666669+(-138798.752861953+(-3521413.568484853+(-44599342.83238314+(-337623011.738272+(-1672128961.184199+(-5694412271.43013+(-13691005583.17104+(-23467659366.85336+(-28527575611.29551+(-24035365582.07213+(-13347998549.55889+(-4394414504.398299-649551465.2051785*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 13:
          return 637.0000000000005+(49076.86565656569+(1169569.725050506+(14025401.12147027+(101447432.0348252+(483898256.0019139+(1597498806.855073+(3742961181.708809+(6278720198.481116+(7494910301.597536+(6218035822.71984+(3408014739.270754+(1109374249.884864+162387866.3012945*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        case 14:
          return -195.9999999999997+(-12356.57404817403+(-258935.5802020198+(-2840808.212210995+(-19261146.08559668+(-87507110.40641962+(-278204754.9117691+(-632709040.3499579+(-1036229385.084443+(-1212999534.859257+(-990221053.9430438+(-535453868.1829846+(-172329980.5646387-24982748.66173757*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v)*v;

        default:
          libMesh::err << "bad index i = " << i << std::endl;
          libmesh_error();
        }


    // provided the constructor worked fine, we should never end up here.
    default:
      libMesh::err << "Lagrange polynomials only defined up to 15. "
		    << std::endl;
      libmesh_error();
    }

  // we never end up here.
  return 0.;
}



//-----------------------------------------------------------------
// Explicit instantiations
// template class InfFE<1,LAGRANGE,CARTESIAN>;
// template class InfFE<2,LAGRANGE,CARTESIAN>;
// template class InfFE<3,LAGRANGE,CARTESIAN>;

// template class InfFE<1,LAGRANGE,SPHERICAL>;
// template class InfFE<2,LAGRANGE,SPHERICAL>;
// template class InfFE<3,LAGRANGE,SPHERICAL>;

// template class InfFE<1,LAGRANGE,ELLIPSOIDAL>;
// template class InfFE<2,LAGRANGE,ELLIPSOIDAL>;
// template class InfFE<3,LAGRANGE,ELLIPSOIDAL>;

template Real InfFE<1,LAGRANGE,CARTESIAN>::eval(const Real,const Order,const unsigned int);
template Real InfFE<1,LAGRANGE,CARTESIAN>::eval_deriv(const Real,const Order,const unsigned int);
template Real InfFE<2,LAGRANGE,CARTESIAN>::eval(const Real,const Order,const unsigned int);
template Real InfFE<2,LAGRANGE,CARTESIAN>::eval_deriv(const Real,const Order,const unsigned int);
template Real InfFE<3,LAGRANGE,CARTESIAN>::eval(const Real,const Order,const unsigned int);
template Real InfFE<3,LAGRANGE,CARTESIAN>::eval_deriv(const Real,const Order,const unsigned int);

} // namespace libMesh

#endif //ifdef LIBMESH_ENABLE_INFINITE_ELEMENTS

