package Locales::DB::Territory::kn;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::kn::VERSION = '0.09';

$Locales::DB::Territory::kn::cldr_version = '2.0';

%Locales::DB::Territory::kn::code_to_name = (
    '001' => 'ವಿಶ್ವ',
    '002' => 'ಆಫ್ರಿಕಾ',
    '003' => "ಉತ್ತರ\ ಅಮೇರಿಕಾ",
    '005' => "ದಕ್ಷಿಣ\ ಅಮೇರಿಕಾ",
    '009' => 'ಓಶಿಯಾನಾ',
    '011' => "ಪಶ್ಚಿಮ\ ಆಫ್ರಿಕಾ",
    '013' => "ಮಧ್ಯ\ ಅಮೇರಿಕಾ",
    '014' => "ಪೂರ್ವ\ ಆಫ್ರಿಕಾ",
    '015' => "ಉತ್ತರ\ ಆಫ್ರಿಕಾ",
    '017' => "ಮಧ್ಯ\ ಆಫ್ರಿಕಾ",
    '018' => "ಆಫ್ರಿಕಾದ\ ದಕ್ಷಿಣ\ ಭಾಗ",
    '019' => 'ಅಮೆರಿಕಾಸ್',
    '021' => "ಅಮೇರಿಕಾದ\ ಉತ್ತರ\ ಭಾಗ",
    '029' => 'ಕೆರೇಬಿಯನ್',
    '030' => "ಏಷ್ಯಾದ\ ಪೂರ್ವ\ ಭಾಗ",
    '034' => "ಏಷ್ಯಾದ\ ದಕ್ಷಿಣ\ ಭಾಗ",
    '035' => "ಆಗ್ನೇಯ\ ಏಷ್ಯಾ",
    '039' => "ದಕ್ಷಿಣ\ ಯೂರೋಪ್",
    '053' => "ಆಸ್ಟ್ರೇಲಿಯಾ\ ಹಾಗೂ\ ನ್ಯೂಝಿಲ್ಯಾಂಡ್",
    '054' => 'ಮೇಲಿನೇಶಿಯಾ',
    '057' => "ಮೈಕ್ರೋನೇಶಿಯನ್\ ಪ್ರದೇಶ",
    '061' => 'ಪೋಲಿನೇಶಿಯಾ',
    '062' => "ದಕ್ಷಿಣ\-ಮಧ್ಯ\ ಏಷ್ಯಾ",
    142   => 'ಏಷ್ಯಾ',
    143   => "ಮಧ್ಯ\ ಏಷ್ಯಾ",
    145   => "ಪಶ್ಚಿಮ\ ಏಷ್ಯಾ",
    150   => 'ಯೂರೋಪ್',
    151   => "ಪೂರ್ವ\ ಯೂರೋಪ್",
    154   => "ಉತ್ತರ\ ಯೂರೋಪ್",
    155   => "ಪಶ್ಚಿಮ\ ಯೂರೋಪ್",
    172   => "ಸ್ವಂತಂತ್ರ್ಯ\ ರಾಷ್ಟ್ರಗಳ\ ಕಾಮನ್‌ವೆಲ್ತ್",
    200   => 'ಜೆಕೊಸ್ಲೋವಾಕಿಯಾ',
    419   => "ಲ್ಯಾಟಿನ್\ ಅಮೇರಿಕಾ\ ಮತ್ತು\ ಕೆರಿಬಿಯನ್",
    830   => "ಛಾನೆಲ್\ ದ್ವೀಪಗಳು",
    'ac'  => "ಅಸೆನ್ಶನ್\ ದ್ವೀಪ",
    'ad'  => 'ಅಂಡೋರಾ',
    'ae'  => "ಸಂಯುಕ್ತ\ ಅರಬ್\ ಎಮಿರೇಟಸ್",
    'af'  => 'ಅಫಘಾನಿಸ್ಥಾನ್',
    'ag'  => "ಆಂಟಿಗುವಾ\ ಮತ್ತು\ ಬರ್ಬುಡಾ",
    'ai'  => 'ಆಂಗುಯಿಲ್ಲಾ',
    'al'  => 'ಅಲ್ಬೇನಿಯಾ',
    'am'  => 'ಅರ್ಮೇನಿಯಾ',
    'an'  => 'ನೆದರ್‌ಲ್ಯಾಂಡ್',
    'ao'  => 'ಅಂಗೋಲಾ',
    'aq'  => 'ಅಂಟಾರ್ಟಿಕಾ',
    'ar'  => 'ಅರ್ಜೆಂಟೈನಾ',
    'as'  => "ಅಮೇರಿಕನ್\ ಸಮೋವಾ",
    'at'  => 'ಆಸ್ಟ್ರಿಯಾ',
    'au'  => 'ಆಸ್ಟ್ರೇಲಿಯ',
    'aw'  => 'ಅರುಬಾ',
    'ax'  => "ಆಲ್ಯಾಂಡ್\ ದ್ವೀಪಗಳು",
    'az'  => 'ಅಜರ್ಬೈಜಾನ್',
    'ba'  => "ಬೋಸ್ನಿಯಾ\ ಮತ್ತು\ ಹರ್ಜೆಗೋವಿನಾ",
    'bb'  => 'ಬಾರ್ಬಡೋಸ್',
    'bd'  => 'ಬಾಂಗ್ಲಾದೇಶ್',
    'be'  => 'ಬೆಲ್ಜಿಯಮ್',
    'bf'  => "ಬುರ್ಕಿನಾ\ ಫಾಸೋ",
    'bg'  => 'ಬಲ್ಗೇರಿಯನ್',
    'bh'  => 'ಬಹರೈನ್',
    'bi'  => 'ಬುರುಂಡಿ',
    'bj'  => 'ಬೆನಿನ್',
    'bl'  => "ಸೇಂಟ್\ ಬಾರ್ಥೆಲೆಮಿ",
    'bm'  => 'ಬರ್ಮುಡಾ',
    'bn'  => 'ಬ್ರೂನಿ',
    'bo'  => 'ಬಲ್ಗೇರಿಯಾ',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'ಬ್ರೆಜಿಲ್',
    'bs'  => 'ಬಹಾಮಾಸ್',
    'bt'  => 'ಭೂತಾನ್',
    'bv'  => "ಬೋವೆಟ್\ ದ್ವೀಪ",
    'bw'  => 'ಬೋಟ್ಸ್‌ವಾನಾ',
    'by'  => 'ಬೊಲಿವಿಯಾ',
    'bz'  => 'ಬೆಲಿಜ್',
    'ca'  => 'ಕೆನಡಾ',
    'cc'  => "ಕೊಕೊಸ್\ ದ್ವೀಪಗಳು",
    'cd'  => "ಕಾಂಗೋ\ \[DRC\]",
    'cf'  => "ಮಧ್ಯ\ ಆಫ್ರಿಕಾ\ ಗಣರಾಜ್ಯ",
    'cg'  => "ಕಾಂಗೋ\ \[ರಿಪಬ್ಲಿಕ್‌\]",
    'ch'  => 'ಸ್ವಿಡ್ಜರ್‌ಲ್ಯಾಂಡ್',
    'ci'  => "ಐವರಿ\ ಕೋಸ್ಟ್‌‌",
    'ck'  => "ಕುಕ್\ ದ್ವೀಪಗಳು",
    'cl'  => 'ಚಿಲಿ',
    'cm'  => 'ಕ್ಯಾಮರೋನ್',
    'cn'  => 'ಚೀನ',
    'co'  => 'ಕೊಲಂಬಿಯಾ',
    'cp'  => "ಕ್ಲಿಪರ್ಟನ್‌\ ಐಲ್ಯಾಂಡ್‌",
    'cr'  => "ಕೊಸ್ಟಾ\ ರಿಕಾ",
    'cs'  => "ಸೆರ್ಬಿಯಾ\ ಮತ್ತು\ ಮೊಂಟೊನೆಗ್ರೋ",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'ಕ್ಯೂಬಾ',
    'cv'  => "ಕೇಪ್\ ವರ್ಡೆ",
    'cx'  => "ಕ್ರಿಸ್‌ಮಸ್\ ದ್ವೀಪ",
    'cy'  => 'ಸೈಪ್ರಸ್',
    'cz'  => "ಚೆಕ್\ ರಿಪಬ್ಲಿಕ್",
    'dd'  => "East\ Germany",
    'de'  => 'ಜರ್ಮನಿ',
    'dg'  => "ಡೈಗೋ\ ಗಾರ್ಸಿಯ",
    'dj'  => 'ಜಿಬೋಟಿ',
    'dk'  => 'ಡೆನ್ಮಾರ್ಕ್',
    'dm'  => 'ಡೊಮಿನಿಕಾ',
    'do'  => "ಡೊಮೆನಿಕ್\ ರಿಪಬ್ಲಿಕ್",
    'dz'  => 'ಅಲ್ಗೇರಿಯಾ',
    'ea'  => "ಸೆಯುಟಾ\ ಹಾಗೂ\ ಮೆಲಿಲ್ಲಾ",
    'ec'  => 'ಈಕ್ವೆಡಾರ್',
    'ee'  => 'ಎಸ್ತೊನಿಯ',
    'eg'  => 'ಈಜಿಪ್ಟ್',
    'eh'  => "ಪಶ್ಚಿಮ\ ಸಹಾರಾ",
    'er'  => 'ಏರಿಟ್ರಿಯಾ',
    'es'  => 'ಸ್ಪೈನ್',
    'et'  => 'ಇಥಿಯೋಪಿಯಾ',
    'eu'  => "ಯುರೋಪಿಯನ್\ ಯೂನಿಯನ್",
    'fi'  => 'ಫಿನ್‌ಲ್ಯಾಂಡ್',
    'fj'  => 'ಫಿಜಿ',
    'fk'  => "ಫ್ಹಾಕ್‌ಲ್ಯಾಂಡ್\ ದ್ವೀಪಗಳು",
    'fm'  => 'ಮೈಕ್ರೋನೇಶಿಯಾ',
    'fo'  => "ಫರೋ\ ದ್ವೀಪಗಳು",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'ಫ್ರಾನ್ಸ್',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'ಗೆಬೊನ್',
    'gb'  => "ಬ್ರಿಟನ್\/ಇಂಗ್ಲೆಂಡ್",
    'gd'  => 'ಗ್ರೆನೆಡಾ',
    'ge'  => 'ಜಾರ್ಜಿಯಾ',
    'gf'  => "ಫ್ರೆಂಚ್\ ಗಯಾನಾ",
    'gg'  => 'ಗುರ್ನಜೀ',
    'gh'  => 'ಘಾನಾ',
    'gi'  => 'ಗಿಬ್ರಾಲ್ಟರ್',
    'gl'  => 'ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್',
    'gm'  => 'ಗ್ಯಾಂಬಿಯಾ',
    'gn'  => 'ಗಿನಿ',
    'gp'  => 'ಗುಡೆಲೋಪ್',
    'gq'  => "ಈಕ್ವೆಟೋರಿಯಲ್\ ಗಿನಿ",
    'gr'  => 'ಗ್ರೀಸ್',
    'gs'  => "ದಕ್ಷಿಣ\ ಜಾರ್ಜಿಯಾ\ ಮತ್ತು\ ದಕ್ಷಿಣ\ ಸ್ಯಾಂಡ್‌ವಿಚ್\ ದ್ವೀಪಗಳು",
    'gt'  => 'ಗ್ವಾಟೆಮಾಲಾ',
    'gu'  => 'ಗುಯಾಮ್',
    'gw'  => "ಗಿನಿ\-ಬಿಸ್ಸಾವ್",
    'gy'  => 'ಗಯಾನಾ',
    'hk'  => "ಹಾಂಗ್\ ಕಾಂಗ್",
    'hm'  => "ಹರ್ಡ್\ ದ್ವೀಪ\ ಮತ್ತು\ ಮಾಕ್‌ಡೊನಾಲ್ಡ್\ ದ್ವೀಪಗಳು",
    'hn'  => 'ಹೊಂಡುರಾಸ್',
    'hr'  => 'ಕ್ರೋಯೇಶಿಯಾ',
    'ht'  => 'ಹೈಟಿ',
    'hu'  => 'ಹಂಗೇರಿ',
    'ic'  => "ಕ್ಯಾನರಿ\ ದ್ವೀಪಗಳು",
    'id'  => 'ಇಂಡೋನೇಶಿಯಾ',
    'ie'  => 'ಐರ್ಲೆಂಡ್',
    'il'  => 'ಇಸ್ರೇಲ್',
    'im'  => "ಐಲ್\ ಆಫ್\ ಮ್ಯಾನ್",
    'in'  => 'ಭಾರತ',
    'io'  => "ಬ್ರಿಟೀಶ್\ ಇಂಡಿಯನ್\ ಮಹಾಸಾಗರ\ ಪ್ರದೇಶ",
    'iq'  => 'ಇರಾಕ್',
    'ir'  => 'ಇರಾನ್',
    'is'  => 'ಐಸ್‌ಲ್ಯಾಂಡ್',
    'it'  => 'ಇಟಲಿ',
    'je'  => 'ಜೆರ್ಸಿ',
    'jm'  => 'ಜಮೈಕಾ',
    'jo'  => 'ಜೋರ್ಡಾನ್',
    'jp'  => 'ಜಪಾನ್',
    'jt'  => "Johnston\ Island",
    'ke'  => 'ಕೀನ್ಯಾ',
    'kg'  => 'ಕಿರ್ಗಿಸ್ಥಾನ್',
    'kh'  => 'ಕಾಂಬೋಡಿಯಾ',
    'ki'  => 'ಕಿರಿಬಾತಿ',
    'km'  => 'ಕೊಮೊರೊಸ್',
    'kn'  => "ಸೇಂಟ್\ ಕಿಟ್ಸ್\ ಮತ್ತು\ ನೆವಿಸ್",
    'kp'  => "ಉತ್ತರ\ ಕೋರಿಯಾ",
    'kr'  => "ದಕ್ಷಿಣ\ ಕೋರಿಯಾ",
    'kw'  => 'ಕುವೈತ್',
    'ky'  => "ಕೇಮನ್\ ದ್ವೀಪಗಳು",
    'kz'  => 'ಕಝಾಕಿಸ್ಥಾನ್',
    'la'  => 'ಲಾವೋಸ್',
    'lb'  => 'ಲೆಬನಾನ್',
    'lc'  => "ಸೇಂಟ್\ ಲೂಸಿಯಾ",
    'li'  => 'ಲಿಚೆನ್‌ಸ್ಟೈನ್',
    'lk'  => 'ಶ್ರೀಲಂಕಾ',
    'lr'  => 'ಲಿಬೇರಿಯಾ',
    'ls'  => 'ಲೆಥೋಸೊ',
    'lt'  => 'ಲಿಥುವೇನಿಯಾ',
    'lu'  => 'ಲಕ್ಸಂಬರ್ಗ್',
    'lv'  => 'ಲಾಟ್ವಿಯಾ',
    'ly'  => 'ಲಿಬಿಯಾ',
    'ma'  => 'ಮೊರಾಕ್ಕೊ',
    'mc'  => 'ಮೊನಾಕೊ',
    'md'  => 'ಮೊಲ್ಡೋವಾ',
    'me'  => 'ಮೊಂಟೆನೆಗ್ರೋ',
    'mf'  => "ಸೇಂಟ್\ ಮಾರ್ಟಿನ್",
    'mg'  => 'ಮಡಗಾಸ್ಕರ್',
    'mh'  => "ಮಾರ್ಶಲ್\ ದ್ವೀಪಗಳು",
    'mi'  => "Midway\ Islands",
    'mk'  => "ಮೆಸೆಡೋನಿಯಾ\ \[FYROM\]",
    'ml'  => 'ಮಾಲಿ',
    'mm'  => 'ಮಯನ್ಮಾರ್',
    'mn'  => 'ಮೊಂಗೋಲಿಯಾ',
    'mo'  => 'ಮಖಾವ್',
    'mp'  => "ಉತ್ತರ\ ಮರಿಯಾನಾ\ ದ್ವೀಪಗಳು",
    'mq'  => 'ಮಾರ್ಟಿನಿಕ್',
    'mr'  => 'ಮಾರಿಟಾನಿಯಾ',
    'ms'  => 'ಮೋಂಟ್‌ಸೆರೆಟ್',
    'mt'  => 'ಮಾಲ್ಟಾ',
    'mu'  => 'ಮಾರಿಶಿಯಸ್',
    'mv'  => 'ಮಾಲ್ಡಿವ್ಸ್',
    'mw'  => 'ಮಲಾವಿ',
    'mx'  => 'ಮೆಕ್ಸಿಕೊ',
    'my'  => 'ಮಲೇಶಿಯಾ',
    'mz'  => 'ಮೊಜಾಂಬಿಕ್',
    'na'  => 'ನಮೀಬಿಯಾ',
    'nc'  => "ನ್ಯೂ\ ಕ್ಯಾಲಿಡೋನಿಯಾ",
    'ne'  => 'ನೈಜರ್',
    'nf'  => "ನಾರ್‌ಫೋಕ್\ ದ್ವೀಪ",
    'ng'  => 'ನೈಜೀರಿಯಾ',
    'ni'  => 'ನಿಕಾರಾಗುವಾ',
    'nl'  => 'ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್',
    'no'  => 'ನಾರ್ವೇ',
    'np'  => 'ನೇಪಾಳ',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'ನೌರು',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'ನಿಯು',
    'nz'  => 'ನ್ಯೂಜಿಲೆಂಡ್',
    'om'  => 'ಓಮನ್',
    'pa'  => 'ಪನಾಮಾ',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'ಪೆರು',
    'pf'  => "ಫ್ರೆಂಚ್\ ಪೋಲಿನೇಶಿಯಾ",
    'pg'  => "ಪಪುವಾ\ ನ್ಯೂಗೀನಿಯಾ",
    'ph'  => 'ಫಿಲಿಫೈನ್ಸ್',
    'pk'  => 'ಪಾಕಿಸ್ತಾನ',
    'pl'  => 'ಪೋಲ್ಯಾಂಡ್',
    'pm'  => "ಸೇಂಟ್\ ಪಿಯರೆ\ ಮತ್ತು\ ಮಿಕೆಲನ್",
    'pn'  => 'ಪಿಟ್‌ಕೈರ್ನ್',
    'pr'  => "ಪ್ಯೂರ್ಟೋ\ ರಿಕೊ",
    'ps'  => "ಪ್ಯಾಲಿಸ್ಟೇನಿಯನ್\ ಪ್ರದೇಶ",
    'pt'  => 'ಪೋರ್ಚುಗಲ್',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'ಪಲಾವು',
    'py'  => 'ಪರಾಗ್ವೇ',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'ಕತಾರ್',
    'qo'  => "ಔಟ್‌ಲೈಯಿಂಗ್\ ಓಶಿಯಾನಿಯಾ",
    're'  => 'ರೀಯೂನಿಯನ್',
    'ro'  => 'ರೊಮ್ಯಾನಿಯಾ',
    'rs'  => 'ಸೆರ್ಬಿಯಾ',
    'ru'  => 'ರಶಿಯಾ',
    'rw'  => 'ರುವಾಂಡಾ',
    'sa'  => "ಸೌದಿ\ ಅರೇಬಿಯಾ",
    'sb'  => "ಸೊಲೊಮನ್\ ದ್ವೀಪಗಳು",
    'sc'  => 'ಸೀಶೆಲ್ಲೆಸ್',
    'sd'  => 'ಸೂಡಾನ್',
    'se'  => 'ಸ್ವೀಡನ್',
    'sg'  => 'ಸಿಂಗಪುರ',
    'sh'  => "ಸೇಂಟ್\ ಹೆಲೆನಾ",
    'si'  => 'ಸ್ಲೋವೇನಿಯಾ',
    'sj'  => "ಸ್ವಾಲ್ಬಾರ್ಡ್\ ಮತ್ತು\ ಜಾನ್\ ಮಾಯೆನ್",
    'sk'  => 'ಸ್ಲೋವಾಕಿಯಾ',
    'sl'  => "ಸಿಯೆರ್ರಾ\ ಲಿಯೋನ್",
    'sm'  => "ಸ್ಯಾನ್\ ಮೆರಿನೋ",
    'sn'  => 'ಸೆನೆಗಲ್',
    'so'  => 'ಸೊಮಾಲಿಯಾ',
    'sr'  => 'ಸುರಿನಾಮ',
    'st'  => "ಸಾವೋ\ ಟೋಮ್\ ಮತ್ತು\ ಪ್ರಿನ್ಸಿಪೆ",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "ಎಲ್\ ಸಾಲ್ವೇಡಾರ್",
    'sy'  => 'ಸಿರಿಯಾ',
    'sz'  => 'ಸ್ವಾಜಿಲ್ಯಾಂಡ್',
    'ta'  => "ತ್ರಿಸ್ತಾನ್‌\ ದ\ ಕುನ್ಹಾ",
    'tc'  => "ಟರ್ಕ್ಸ್\ ಮತ್ತು\ ಕೈಕೋಸ್\ ದ್ವೀಪಗಳು",
    'td'  => 'ಚಾಡ್',
    'tf'  => "ಫ್ರೆಂಚ್\ ದಕ್ಷಿಣ\ ಪ್ರದೇಶಗಳು",
    'tg'  => 'ಟೋಗೋ',
    'th'  => 'ಥೈಲ್ಯಾಂಡ್',
    'tj'  => 'ತಜಾಕಿಸ್ಥಾನ್',
    'tk'  => 'ಟೊಕೆಲಾವ್',
    'tl'  => "ಈಸ್ಟ್\ ಟಿಮೋರ್",
    'tm'  => 'ತುರ್ಕಮೆನಿಸ್ಥಾನ್',
    'tn'  => 'ಟುನಿಶಿಯಾ',
    'to'  => 'ಟೊಂಗ',
    'tr'  => 'ಟರ್ಕಿ',
    'tt'  => "ಟ್ರಿನಿಡಾಡ್\ ಮತ್ತು\ ಟೊಬ್ಯಾಗೊ",
    'tv'  => 'ಟುವಾಲು',
    'tw'  => 'ಥೈವಾನ್',
    'tz'  => 'ಟಾಂಜಾನಿಯಾ',
    'ua'  => 'ಉಕ್ರೈನ್',
    'ug'  => 'ಉಗಾಂಡಾ',
    'um'  => "ಸಂಯುಕ್ತ\ ಸಂಸ್ಥಾನ\ ಮೈನರ್\ ಔಟ್‌ಲೈಯಿಂಗ್\ ದ್ವೀಪಗಳು",
    'us'  => "ಅಮೇರಿಕಾ\ ಸಂಯುಕ್ತ\ ಸಂಸ್ಥಾನ",
    'uy'  => 'ಉರುಗ್ವೇ',
    'uz'  => 'ಉಜ್ಬೇಕಿಸ್ಥಾನ್',
    'va'  => 'ವ್ಯಾಟಿಕನ್',
    'vc'  => "ಸೇಂಟ್\ ವಿನ್ಸೆಂಟ್\ ಮತ್ತು\ ಗ್ರೆನೆಡೈನ್ಸ್",
    'vd'  => "North\ Vietnam",
    've'  => 'ವೆನೆಜುವೆಲಾ',
    'vg'  => "ಬ್ರಿಟಿಷ್\ ವರ್ಜಿನ್\ ದ್ವೀಪಗಳು",
    'vi'  => "ಯು\.ಎಸ್\.\ ವರ್ಜಿನ್\ ದ್ವೀಪಗಳು",
    'vn'  => 'ವಿಯೇಟ್ನಾಮ್',
    'vu'  => 'ವನೌಟು',
    'wf'  => "ವಾಲಿಸ್\ ಮತ್ತು\ ಫುಟುನಾ",
    'wk'  => "Wake\ Island",
    'ws'  => 'ಸಮೋವಾ',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'ಯೆಮನ್',
    'yt'  => 'ಮಯೊಟ್ಟೆ',
    'za'  => "ದಕ್ಷಿಣ\ ಆಫ್ರಿಕಾ",
    'zm'  => 'ಝಾಂಬಿಯಾ',
    'zw'  => 'ಜಿಂಬಾಬ್ವೆ',
    'zz'  => "ಅಪರಿಚಿತ\ ಅಥವಾ\ ಅಮಾನ್ಯ\ ಪ್ರದೇಶ",
);

%Locales::DB::Territory::kn::name_to_code = (
    'britishantarcticterritory'                                                                                                               => 'bq',
    'cantonandenderburyislands'                                                                                                               => 'ct',
    'dronningmaudland'                                                                                                                        => 'nq',
    'eastgermany'                                                                                                                             => 'dd',
    'frenchsouthernandantarcticterritories'                                                                                                   => 'fq',
    'johnstonisland'                                                                                                                          => 'jt',
    'metropolitanfrance'                                                                                                                      => 'fx',
    'midwayislands'                                                                                                                           => 'mi',
    'neutralzone'                                                                                                                             => 'nt',
    'northvietnam'                                                                                                                            => 'vd',
    'pacificislandstrustterritory'                                                                                                            => 'pc',
    'panamacanalzone'                                                                                                                         => 'pz',
    "people\â\\sdemocraticrepublicofyemen"                                                                                               => 'yd',
    "u\.s\.miscellaneouspacificislands"                                                                                                       => 'pu',
    'unionofsovietsocialistrepublics'                                                                                                         => 'su',
    'wakeisland'                                                                                                                              => 'wk',
    'ಅಂಗೋಲಾ'                                                                                                                      => 'ao',
    'ಅಂಟಾರ್ಟಿಕಾ'                                                                                                          => 'aq',
    'ಅಂಡೋರಾ'                                                                                                                      => 'ad',
    'ಅಜರ್ಬೈಜಾನ್'                                                                                                          => 'az',
    'ಅಪರಿಚಿತಅಥವಾಅಮಾನ್ಯಪ್ರದೇಶ'                                                                   => 'zz',
    'ಅಫಘಾನಿಸ್ಥಾನ್'                                                                                                    => 'af',
    'ಅಮೆರಿಕಾಸ್'                                                                                                             => '019',
    'ಅಮೇರಿಕನ್ಸಮೋವಾ'                                                                                                 => 'as',
    'ಅಮೇರಿಕಾದಉತ್ತರಭಾಗ'                                                                                        => '021',
    'ಅಮೇರಿಕಾಸಂಯುಕ್ತಸಂಸ್ಥಾನ'                                                                         => 'us',
    'ಅರುಬಾ'                                                                                                                         => 'aw',
    'ಅರ್ಜೆಂಟೈನಾ'                                                                                                          => 'ar',
    'ಅರ್ಮೇನಿಯಾ'                                                                                                             => 'am',
    'ಅಲ್ಗೇರಿಯಾ'                                                                                                             => 'dz',
    'ಅಲ್ಬೇನಿಯಾ'                                                                                                             => 'al',
    'ಅಸೆನ್ಶನ್ದ್ವೀಪ'                                                                                                 => 'ac',
    'ಆಂಗುಯಿಲ್ಲಾ'                                                                                                          => 'ai',
    'ಆಂಟಿಗುವಾಮತ್ತುಬರ್ಬುಡಾ'                                                                            => 'ag',
    'ಆಗ್ನೇಯಏಷ್ಯಾ'                                                                                                       => '035',
    'ಆಫ್ರಿಕಾ'                                                                                                                   => '002',
    'ಆಫ್ರಿಕಾದದಕ್ಷಿಣಭಾಗ'                                                                                     => '018',
    'ಆಲ್ಯಾಂಡ್ದ್ವೀಪಗಳು'                                                                                        => 'ax',
    'ಆಸ್ಟ್ರಿಯಾ'                                                                                                             => 'at',
    'ಆಸ್ಟ್ರೇಲಿಯ'                                                                                                          => 'au',
    'ಆಸ್ಟ್ರೇಲಿಯಾಹಾಗೂನ್ಯೂಝಿಲ್ಯಾಂಡ್'                                                    => '053',
    'ಇಂಡೋನೇಶಿಯಾ'                                                                                                          => 'id',
    'ಇಟಲಿ'                                                                                                                            => 'it',
    'ಇಥಿಯೋಪಿಯಾ'                                                                                                             => 'et',
    'ಇರಾಕ್'                                                                                                                         => 'iq',
    'ಇರಾನ್'                                                                                                                         => 'ir',
    'ಇಸ್ರೇಲ್'                                                                                                                   => 'il',
    'ಈಕ್ವೆಟೋರಿಯಲ್ಗಿನಿ'                                                                                        => 'gq',
    'ಈಕ್ವೆಡಾರ್'                                                                                                             => 'ec',
    'ಈಜಿಪ್ಟ್'                                                                                                                   => 'eg',
    'ಈಸ್ಟ್ಟಿಮೋರ್'                                                                                                       => 'tl',
    'ಉಕ್ರೈನ್'                                                                                                                   => 'ua',
    'ಉಗಾಂಡಾ'                                                                                                                      => 'ug',
    'ಉಜ್ಬೇಕಿಸ್ಥಾನ್'                                                                                                 => 'uz',
    'ಉತ್ತರಅಮೇರಿಕಾ'                                                                                                    => '003',
    'ಉತ್ತರಆಫ್ರಿಕಾ'                                                                                                    => '015',
    'ಉತ್ತರಕೋರಿಯಾ'                                                                                                       => 'kp',
    'ಉತ್ತರಮರಿಯಾನಾದ್ವೀಪಗಳು'                                                                            => 'mp',
    'ಉತ್ತರಯೂರೋಪ್'                                                                                                       => 154,
    'ಉರುಗ್ವೇ'                                                                                                                   => 'uy',
    'ಎಲ್ಸಾಲ್ವೇಡಾರ್'                                                                                                 => 'sv',
    'ಎಸ್ತೊನಿಯ'                                                                                                                => 'ee',
    'ಏರಿಟ್ರಿಯಾ'                                                                                                             => 'er',
    'ಏಷ್ಯಾ'                                                                                                                         => 142,
    'ಏಷ್ಯಾದದಕ್ಷಿಣಭಾಗ'                                                                                           => '034',
    'ಏಷ್ಯಾದಪೂರ್ವಭಾಗ'                                                                                              => '030',
    'ಐರ್ಲೆಂಡ್'                                                                                                                => 'ie',
    'ಐಲ್ಆಫ್ಮ್ಯಾನ್'                                                                                                    => 'im',
    'ಐವರಿಕೋಸ್ಟ್‌‌'                                                                                                    => 'ci',
    'ಐಸ್‌ಲ್ಯಾಂಡ್'                                                                                                       => 'is',
    'ಓಮನ್'                                                                                                                            => 'om',
    'ಓಶಿಯಾನಾ'                                                                                                                   => '009',
    'ಔಟ್‌ಲೈಯಿಂಗ್ಓಶಿಯಾನಿಯಾ'                                                                            => 'qo',
    'ಕಝಾಕಿಸ್ಥಾನ್'                                                                                                       => 'kz',
    'ಕತಾರ್'                                                                                                                         => 'qa',
    'ಕಾಂಗೋdrc'                                                                                                                      => 'cd',
    'ಕಾಂಗೋರಿಪಬ್ಲಿಕ್‌'                                                                                           => 'cg',
    'ಕಾಂಬೋಡಿಯಾ'                                                                                                             => 'kh',
    'ಕಿರಿಬಾತಿ'                                                                                                                => 'ki',
    'ಕಿರ್ಗಿಸ್ಥಾನ್'                                                                                                    => 'kg',
    'ಕೀನ್ಯಾ'                                                                                                                      => 'ke',
    'ಕುಕ್ದ್ವೀಪಗಳು'                                                                                                    => 'ck',
    'ಕುವೈತ್'                                                                                                                      => 'kw',
    'ಕೆನಡಾ'                                                                                                                         => 'ca',
    'ಕೆರೇಬಿಯನ್'                                                                                                             => '029',
    'ಕೇಪ್ವರ್ಡೆ'                                                                                                             => 'cv',
    'ಕೇಮನ್ದ್ವೀಪಗಳು'                                                                                                 => 'ky',
    'ಕೊಕೊಸ್ದ್ವೀಪಗಳು'                                                                                              => 'cc',
    'ಕೊಮೊರೊಸ್'                                                                                                                => 'km',
    'ಕೊಲಂಬಿಯಾ'                                                                                                                => 'co',
    'ಕೊಸ್ಟಾರಿಕಾ'                                                                                                          => 'cr',
    'ಕ್ಯಾನರಿದ್ವೀಪಗಳು'                                                                                           => 'ic',
    'ಕ್ಯಾಮರೋನ್'                                                                                                             => 'cm',
    'ಕ್ಯೂಬಾ'                                                                                                                      => 'cu',
    'ಕ್ರಿಸ್‌ಮಸ್ದ್ವೀಪ'                                                                                           => 'cx',
    'ಕ್ರೋಯೇಶಿಯಾ'                                                                                                          => 'hr',
    'ಕ್ಲಿಪರ್ಟನ್‌ಐಲ್ಯಾಂಡ್‌'                                                                            => 'cp',
    'ಗಯಾನಾ'                                                                                                                         => 'gy',
    'ಗಿನಿ'                                                                                                                            => 'gn',
    'ಗಿನಿಬಿಸ್ಸಾವ್'                                                                                                    => 'gw',
    'ಗಿಬ್ರಾಲ್ಟರ್'                                                                                                       => 'gi',
    'ಗುಡೆಲೋಪ್'                                                                                                                => 'gp',
    'ಗುಯಾಮ್'                                                                                                                      => 'gu',
    'ಗುರ್ನಜೀ'                                                                                                                   => 'gg',
    'ಗೆಬೊನ್'                                                                                                                      => 'ga',
    'ಗ್ಯಾಂಬಿಯಾ'                                                                                                             => 'gm',
    'ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್'                                                                                              => 'gl',
    'ಗ್ರೀಸ್'                                                                                                                      => 'gr',
    'ಗ್ರೆನೆಡಾ'                                                                                                                => 'gd',
    'ಗ್ವಾಟೆಮಾಲಾ'                                                                                                          => 'gt',
    'ಘಾನಾ'                                                                                                                            => 'gh',
    'ಚಾಡ್'                                                                                                                            => 'td',
    'ಚಿಲಿ'                                                                                                                            => 'cl',
    'ಚೀನ'                                                                                                                               => 'cn',
    'ಚೆಕ್ರಿಪಬ್ಲಿಕ್'                                                                                                 => 'cz',
    'ಛಾನೆಲ್ದ್ವೀಪಗಳು'                                                                                              => 830,
    'ಜಪಾನ್'                                                                                                                         => 'jp',
    'ಜಮೈಕಾ'                                                                                                                         => 'jm',
    'ಜರ್ಮನಿ'                                                                                                                      => 'de',
    'ಜಾರ್ಜಿಯಾ'                                                                                                                => 'ge',
    'ಜಿಂಬಾಬ್ವೆ'                                                                                                             => 'zw',
    'ಜಿಬೋಟಿ'                                                                                                                      => 'dj',
    'ಜೆಕೊಸ್ಲೋವಾಕಿಯಾ'                                                                                              => 200,
    'ಜೆರ್ಸಿ'                                                                                                                      => 'je',
    'ಜೋರ್ಡಾನ್'                                                                                                                => 'jo',
    'ಝಾಂಬಿಯಾ'                                                                                                                   => 'zm',
    'ಟರ್ಕಿ'                                                                                                                         => 'tr',
    'ಟರ್ಕ್ಸ್ಮತ್ತುಕೈಕೋಸ್ದ್ವೀಪಗಳು'                                                          => 'tc',
    'ಟಾಂಜಾನಿಯಾ'                                                                                                             => 'tz',
    'ಟುನಿಶಿಯಾ'                                                                                                                => 'tn',
    'ಟುವಾಲು'                                                                                                                      => 'tv',
    'ಟೊಂಗ'                                                                                                                            => 'to',
    'ಟೊಕೆಲಾವ್'                                                                                                                => 'tk',
    'ಟೋಗೋ'                                                                                                                            => 'tg',
    'ಟ್ರಿನಿಡಾಡ್ಮತ್ತುಟೊಬ್ಯಾಗೊ'                                                                   => 'tt',
    'ಡೆನ್ಮಾರ್ಕ್'                                                                                                          => 'dk',
    'ಡೈಗೋಗಾರ್ಸಿಯ'                                                                                                       => 'dg',
    'ಡೊಮಿನಿಕಾ'                                                                                                                => 'dm',
    'ಡೊಮೆನಿಕ್ರಿಪಬ್ಲಿಕ್'                                                                                     => 'do',
    'ತಜಾಕಿಸ್ಥಾನ್'                                                                                                       => 'tj',
    'ತುರ್ಕಮೆನಿಸ್ಥಾನ್'                                                                                           => 'tm',
    'ತ್ರಿಸ್ತಾನ್‌ದಕುನ್ಹಾ'                                                                                  => 'ta',
    'ಥೈಲ್ಯಾಂಡ್'                                                                                                             => 'th',
    'ಥೈವಾನ್'                                                                                                                      => 'tw',
    'ದಕ್ಷಿಣಅಮೇರಿಕಾ'                                                                                                 => '005',
    'ದಕ್ಷಿಣಆಫ್ರಿಕಾ'                                                                                                 => 'za',
    'ದಕ್ಷಿಣಕೋರಿಯಾ'                                                                                                    => 'kr',
    'ದಕ್ಷಿಣಜಾರ್ಜಿಯಾಮತ್ತುದಕ್ಷಿಣಸ್ಯಾಂಡ್‌ವಿಚ್ದ್ವೀಪಗಳು' => 'gs',
    'ದಕ್ಷಿಣಮಧ್ಯಏಷ್ಯಾ'                                                                                           => '062',
    'ದಕ್ಷಿಣಯೂರೋಪ್'                                                                                                    => '039',
    'ನಮೀಬಿಯಾ'                                                                                                                   => 'na',
    'ನಾರ್ವೇ'                                                                                                                      => 'no',
    'ನಾರ್‌ಫೋಕ್ದ್ವೀಪ'                                                                                              => 'nf',
    'ನಿಕಾರಾಗುವಾ'                                                                                                          => 'ni',
    'ನಿಯು'                                                                                                                            => 'nu',
    'ನೆದರ್‌ಲ್ಯಾಂಡ್'                                                                                                 => 'an',
    'ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್'                                                                                           => 'nl',
    'ನೇಪಾಳ'                                                                                                                         => 'np',
    'ನೈಜರ್'                                                                                                                         => 'ne',
    'ನೈಜೀರಿಯಾ'                                                                                                                => 'ng',
    'ನೌರು'                                                                                                                            => 'nr',
    'ನ್ಯೂಕ್ಯಾಲಿಡೋನಿಯಾ'                                                                                        => 'nc',
    'ನ್ಯೂಜಿಲೆಂಡ್'                                                                                                       => 'nz',
    'ಪನಾಮಾ'                                                                                                                         => 'pa',
    'ಪಪುವಾನ್ಯೂಗೀನಿಯಾ'                                                                                           => 'pg',
    'ಪರಾಗ್ವೇ'                                                                                                                   => 'py',
    'ಪಲಾವು'                                                                                                                         => 'pw',
    'ಪಶ್ಚಿಮಆಫ್ರಿಕಾ'                                                                                                 => '011',
    'ಪಶ್ಚಿಮಏಷ್ಯಾ'                                                                                                       => 145,
    'ಪಶ್ಚಿಮಯೂರೋಪ್'                                                                                                    => 155,
    'ಪಶ್ಚಿಮಸಹಾರಾ'                                                                                                       => 'eh',
    'ಪಾಕಿಸ್ತಾನ'                                                                                                             => 'pk',
    'ಪಿಟ್‌ಕೈರ್ನ್'                                                                                                       => 'pn',
    'ಪೂರ್ವಆಫ್ರಿಕಾ'                                                                                                    => '014',
    'ಪೂರ್ವಯೂರೋಪ್'                                                                                                       => 151,
    'ಪೆರು'                                                                                                                            => 'pe',
    'ಪೋರ್ಚುಗಲ್'                                                                                                             => 'pt',
    'ಪೋಲಿನೇಶಿಯಾ'                                                                                                          => '061',
    'ಪೋಲ್ಯಾಂಡ್'                                                                                                             => 'pl',
    'ಪ್ಯಾಲಿಸ್ಟೇನಿಯನ್ಪ್ರದೇಶ'                                                                         => 'ps',
    'ಪ್ಯೂರ್ಟೋರಿಕೊ'                                                                                                    => 'pr',
    'ಫರೋದ್ವೀಪಗಳು'                                                                                                       => 'fo',
    'ಫಿಜಿ'                                                                                                                            => 'fj',
    'ಫಿನ್‌ಲ್ಯಾಂಡ್'                                                                                                    => 'fi',
    'ಫಿಲಿಫೈನ್ಸ್'                                                                                                          => 'ph',
    'ಫ್ರಾನ್ಸ್'                                                                                                                => 'fr',
    'ಫ್ರೆಂಚ್ಗಯಾನಾ'                                                                                                    => 'gf',
    'ಫ್ರೆಂಚ್ದಕ್ಷಿಣಪ್ರದೇಶಗಳು'                                                                      => 'tf',
    'ಫ್ರೆಂಚ್ಪೋಲಿನೇಶಿಯಾ'                                                                                     => 'pf',
    'ಫ್ಹಾಕ್‌ಲ್ಯಾಂಡ್ದ್ವೀಪಗಳು'                                                                      => 'fk',
    'ಬರ್ಮುಡಾ'                                                                                                                   => 'bm',
    'ಬಲ್ಗೇರಿಯನ್'                                                                                                          => 'bg',
    'ಬಲ್ಗೇರಿಯಾ'                                                                                                             => 'bo',
    'ಬಹರೈನ್'                                                                                                                      => 'bh',
    'ಬಹಾಮಾಸ್'                                                                                                                   => 'bs',
    'ಬಾಂಗ್ಲಾದೇಶ್'                                                                                                       => 'bd',
    'ಬಾರ್ಬಡೋಸ್'                                                                                                             => 'bb',
    'ಬುರುಂಡಿ'                                                                                                                   => 'bi',
    'ಬುರ್ಕಿನಾಫಾಸೋ'                                                                                                    => 'bf',
    'ಬೆನಿನ್'                                                                                                                      => 'bj',
    'ಬೆಲಿಜ್'                                                                                                                      => 'bz',
    'ಬೆಲ್ಜಿಯಮ್'                                                                                                             => 'be',
    'ಬೊಲಿವಿಯಾ'                                                                                                                => 'by',
    'ಬೋಟ್ಸ್‌ವಾನಾ'                                                                                                       => 'bw',
    'ಬೋವೆಟ್ದ್ವೀಪ'                                                                                                       => 'bv',
    'ಬೋಸ್ನಿಯಾಮತ್ತುಹರ್ಜೆಗೋವಿನಾ'                                                                => 'ba',
    "ಬ್ರಿಟನ್\/ಇಂಗ್ಲೆಂಡ್"                                                                                      => 'gb',
    'ಬ್ರಿಟಿಷ್ವರ್ಜಿನ್ದ್ವೀಪಗಳು'                                                                   => 'vg',
    'ಬ್ರಿಟೀಶ್ಇಂಡಿಯನ್ಮಹಾಸಾಗರಪ್ರದೇಶ'                                                    => 'io',
    'ಬ್ರೂನಿ'                                                                                                                      => 'bn',
    'ಬ್ರೆಜಿಲ್'                                                                                                                => 'br',
    'ಭಾರತ'                                                                                                                            => 'in',
    'ಭೂತಾನ್'                                                                                                                      => 'bt',
    'ಮಖಾವ್'                                                                                                                         => 'mo',
    'ಮಡಗಾಸ್ಕರ್'                                                                                                             => 'mg',
    'ಮಧ್ಯಅಮೇರಿಕಾ'                                                                                                       => '013',
    'ಮಧ್ಯಆಫ್ರಿಕಾ'                                                                                                       => '017',
    'ಮಧ್ಯಆಫ್ರಿಕಾಗಣರಾಜ್ಯ'                                                                                  => 'cf',
    'ಮಧ್ಯಏಷ್ಯಾ'                                                                                                             => 143,
    'ಮಯನ್ಮಾರ್'                                                                                                                => 'mm',
    'ಮಯೊಟ್ಟೆ'                                                                                                                   => 'yt',
    'ಮಲಾವಿ'                                                                                                                         => 'mw',
    'ಮಲೇಶಿಯಾ'                                                                                                                   => 'my',
    'ಮಾರಿಟಾನಿಯಾ'                                                                                                          => 'mr',
    'ಮಾರಿಶಿಯಸ್'                                                                                                             => 'mu',
    'ಮಾರ್ಟಿನಿಕ್'                                                                                                          => 'mq',
    'ಮಾರ್ಶಲ್ದ್ವೀಪಗಳು'                                                                                           => 'mh',
    'ಮಾಲಿ'                                                                                                                            => 'ml',
    'ಮಾಲ್ಟಾ'                                                                                                                      => 'mt',
    'ಮಾಲ್ಡಿವ್ಸ್'                                                                                                          => 'mv',
    'ಮೆಕ್ಸಿಕೊ'                                                                                                                => 'mx',
    'ಮೆಸೆಡೋನಿಯಾfyrom'                                                                                                     => 'mk',
    'ಮೇಲಿನೇಶಿಯಾ'                                                                                                          => '054',
    'ಮೈಕ್ರೋನೇಶಿಯನ್ಪ್ರದೇಶ'                                                                               => '057',
    'ಮೈಕ್ರೋನೇಶಿಯಾ'                                                                                                    => 'fm',
    'ಮೊಂಗೋಲಿಯಾ'                                                                                                             => 'mn',
    'ಮೊಂಟೆನೆಗ್ರೋ'                                                                                                       => 'me',
    'ಮೊಜಾಂಬಿಕ್'                                                                                                             => 'mz',
    'ಮೊನಾಕೊ'                                                                                                                      => 'mc',
    'ಮೊರಾಕ್ಕೊ'                                                                                                                => 'ma',
    'ಮೊಲ್ಡೋವಾ'                                                                                                                => 'md',
    'ಮೋಂಟ್‌ಸೆರೆಟ್'                                                                                                    => 'ms',
    "ಯು\.ಎಸ್\.ವರ್ಜಿನ್ದ್ವೀಪಗಳು"                                                                        => 'vi',
    'ಯುರೋಪಿಯನ್ಯೂನಿಯನ್'                                                                                        => 'eu',
    'ಯೂರೋಪ್'                                                                                                                      => 150,
    'ಯೆಮನ್'                                                                                                                         => 'ye',
    'ರಶಿಯಾ'                                                                                                                         => 'ru',
    'ರೀಯೂನಿಯನ್'                                                                                                             => 're',
    'ರುವಾಂಡಾ'                                                                                                                   => 'rw',
    'ರೊಮ್ಯಾನಿಯಾ'                                                                                                          => 'ro',
    'ಲಕ್ಸಂಬರ್ಗ್'                                                                                                          => 'lu',
    'ಲಾಟ್ವಿಯಾ'                                                                                                                => 'lv',
    'ಲಾವೋಸ್'                                                                                                                      => 'la',
    'ಲಿಚೆನ್‌ಸ್ಟೈನ್'                                                                                                 => 'li',
    'ಲಿಥುವೇನಿಯಾ'                                                                                                          => 'lt',
    'ಲಿಬಿಯಾ'                                                                                                                      => 'ly',
    'ಲಿಬೇರಿಯಾ'                                                                                                                => 'lr',
    'ಲೆಥೋಸೊ'                                                                                                                      => 'ls',
    'ಲೆಬನಾನ್'                                                                                                                   => 'lb',
    'ಲ್ಯಾಟಿನ್ಅಮೇರಿಕಾಮತ್ತುಕೆರಿಬಿಯನ್'                                                 => 419,
    'ವನೌಟು'                                                                                                                         => 'vu',
    'ವಾಲಿಸ್ಮತ್ತುಫುಟುನಾ'                                                                                     => 'wf',
    'ವಿಯೇಟ್ನಾಮ್'                                                                                                          => 'vn',
    'ವಿಶ್ವ'                                                                                                                         => '001',
    'ವೆನೆಜುವೆಲಾ'                                                                                                          => 've',
    'ವ್ಯಾಟಿಕನ್'                                                                                                             => 'va',
    'ಶ್ರೀಲಂಕಾ'                                                                                                                => 'lk',
    'ಸಂಯುಕ್ತಅರಬ್ಎಮಿರೇಟಸ್'                                                                               => 'ae',
    'ಸಂಯುಕ್ತಸಂಸ್ಥಾನಮೈನರ್ಔಟ್‌ಲೈಯಿಂಗ್ದ್ವೀಪಗಳು'                      => 'um',
    'ಸಮೋವಾ'                                                                                                                         => 'ws',
    'ಸಾವೋಟೋಮ್ಮತ್ತುಪ್ರಿನ್ಸಿಪೆ'                                                                   => 'st',
    'ಸಿಂಗಪುರ'                                                                                                                   => 'sg',
    'ಸಿಯೆರ್ರಾಲಿಯೋನ್'                                                                                              => 'sl',
    'ಸಿರಿಯಾ'                                                                                                                      => 'sy',
    'ಸೀಶೆಲ್ಲೆಸ್'                                                                                                          => 'sc',
    'ಸುರಿನಾಮ'                                                                                                                   => 'sr',
    'ಸೂಡಾನ್'                                                                                                                      => 'sd',
    'ಸೆನೆಗಲ್'                                                                                                                   => 'sn',
    'ಸೆಯುಟಾಹಾಗೂಮೆಲಿಲ್ಲಾ'                                                                                  => 'ea',
    'ಸೆರ್ಬಿಯಾ'                                                                                                                => 'rs',
    'ಸೆರ್ಬಿಯಾಮತ್ತುಮೊಂಟೊನೆಗ್ರೋ'                                                                => 'cs',
    'ಸೇಂಟ್ಕಿಟ್ಸ್ಮತ್ತುನೆವಿಸ್'                                                                      => 'kn',
    'ಸೇಂಟ್ಪಿಯರೆಮತ್ತುಮಿಕೆಲನ್'                                                                      => 'pm',
    'ಸೇಂಟ್ಬಾರ್ಥೆಲೆಮಿ'                                                                                           => 'bl',
    'ಸೇಂಟ್ಮಾರ್ಟಿನ್'                                                                                                 => 'mf',
    'ಸೇಂಟ್ಲೂಸಿಯಾ'                                                                                                       => 'lc',
    'ಸೇಂಟ್ವಿನ್ಸೆಂಟ್ಮತ್ತುಗ್ರೆನೆಡೈನ್ಸ್'                                           => 'vc',
    'ಸೇಂಟ್ಹೆಲೆನಾ'                                                                                                       => 'sh',
    'ಸೈಪ್ರಸ್'                                                                                                                   => 'cy',
    'ಸೊಮಾಲಿಯಾ'                                                                                                                => 'so',
    'ಸೊಲೊಮನ್ದ್ವೀಪಗಳು'                                                                                           => 'sb',
    'ಸೌದಿಅರೇಬಿಯಾ'                                                                                                       => 'sa',
    'ಸ್ಪೈನ್'                                                                                                                      => 'es',
    'ಸ್ಯಾನ್ಮೆರಿನೋ'                                                                                                    => 'sm',
    'ಸ್ಲೋವಾಕಿಯಾ'                                                                                                          => 'sk',
    'ಸ್ಲೋವೇನಿಯಾ'                                                                                                          => 'si',
    'ಸ್ವಂತಂತ್ರ್ಯರಾಷ್ಟ್ರಗಳಕಾಮನ್‌ವೆಲ್ತ್'                                        => 172,
    'ಸ್ವಾಜಿಲ್ಯಾಂಡ್'                                                                                                 => 'sz',
    'ಸ್ವಾಲ್ಬಾರ್ಡ್ಮತ್ತುಜಾನ್ಮಾಯೆನ್'                                                       => 'sj',
    'ಸ್ವಿಡ್ಜರ್‌ಲ್ಯಾಂಡ್'                                                                                     => 'ch',
    'ಸ್ವೀಡನ್'                                                                                                                   => 'se',
    'ಹಂಗೇರಿ'                                                                                                                      => 'hu',
    'ಹರ್ಡ್ದ್ವೀಪಮತ್ತುಮಾಕ್‌ಡೊನಾಲ್ಡ್ದ್ವೀಪಗಳು'                            => 'hm',
    'ಹಾಂಗ್ಕಾಂಗ್'                                                                                                          => 'hk',
    'ಹೈಟಿ'                                                                                                                            => 'ht',
    'ಹೊಂಡುರಾಸ್'                                                                                                             => 'hn',
);

1;

