package Locales::DB::Language::es;

# Auto generated from CLDR

$Locales::DB::Language::es::VERSION = '0.09';

$Locales::DB::Language::es::cldr_version = '2.0';

%Locales::DB::Language::es::misc_info = (
    'characters'   => { 'more_information' => "\[\.\.\.\]" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\ \{0\}",
            'medial'  => "\{0\}…\ \{1\}"
        },
        'language' => "Idioma\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ y\ \{1\}",
            'end'    => "\{0\}\ y\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Región\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "sí\:si\:s"
    },
);

%Locales::DB::Language::es::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abjasio',
    'ace'   => 'acehnés',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adigeo',
    'ae'    => 'avéstico',
    'af'    => 'afrikaans',
    'afa'   => "lengua\ afroasiática",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'acadio',
    'ale'   => 'aleutiano',
    'alg'   => "lenguas\ algonquinas",
    'alt'   => "altái\ meridional",
    'am'    => 'amárico',
    'an'    => 'aragonés',
    'ang'   => "inglés\ antiguo",
    'anp'   => 'angika',
    'apa'   => "lenguas\ apache",
    'ar'    => 'árabe',
    'arc'   => 'arameo',
    'arn'   => 'araucano',
    'arp'   => 'arapaho',
    'art'   => "lengua\ artificial",
    'arw'   => 'arahuaco',
    'as'    => 'asamés',
    'asa'   => 'Asu',
    'ast'   => 'asturiano',
    'ath'   => "lenguas\ atabascas",
    'aus'   => "lenguas\ australianas",
    'av'    => 'avar',
    'awa'   => 'avadhi',
    'ay'    => 'aimara',
    'az'    => 'azerí',
    'ba'    => 'bashkir',
    'bad'   => 'banda',
    'bai'   => "lenguas\ bamileke",
    'bal'   => 'baluchi',
    'ban'   => 'balinés',
    'bas'   => 'basa',
    'bat'   => "lengua\ báltica",
    'be'    => 'bielorruso',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'bereber',
    'bez'   => 'Bena',
    'bg'    => 'búlgaro',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalí',
    'bnt'   => 'bantú',
    'bo'    => 'tibetano',
    'br'    => 'bretón',
    'bra'   => 'braj',
    'brx'   => 'Bodo',
    'bs'    => 'bosnio',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'buginés',
    'byn'   => 'blin',
    'ca'    => 'catalán',
    'cad'   => 'caddo',
    'cai'   => "lengua\ india\ centroamericana",
    'car'   => 'caribe',
    'cau'   => "lengua\ caucásica",
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'checheno',
    'ceb'   => 'cebuano',
    'cel'   => "lengua\ celta",
    'cgg'   => 'Chiga',
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatái',
    'chk'   => 'trukés',
    'chm'   => 'marí',
    'chn'   => "jerga\ chinuk",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyene',
    'cmc'   => "lenguas\ chámicas",
    'co'    => 'corso',
    'cop'   => 'copto',
    'cpe'   => "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ inglés",
    'cpf'   => "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ francés",
    'cpp'   => "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ portugués",
    'cr'    => 'cree',
    'crh'   => "tártaro\ de\ Crimea",
    'crp'   => "lengua\ criolla\ o\ pidgin",
    'cs'    => 'checo',
    'csb'   => 'casubio',
    'cu'    => "eslavo\ eclesiástico",
    'cus'   => "lengua\ cusita",
    'cv'    => 'chuvash',
    'cy'    => 'galés',
    'da'    => 'danés',
    'dak'   => 'dakota',
    'dar'   => 'dargva',
    'dav'   => 'Taita',
    'day'   => 'dayak',
    'de'    => 'alemán',
    'de_at' => "alemán\ austríaco",
    'de_ch' => "alto\ alemán\ de\ Suiza",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "lengua\ dravídica",
    'dsb'   => "sorbio\ inferior",
    'dua'   => 'duala',
    'dum'   => "neerlandés\ medieval",
    'dv'    => 'divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'diula',
    'dz'    => 'dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egipcio\ antiguo",
    'eka'   => 'ekajuk',
    'el'    => 'griego',
    'elx'   => 'elamita',
    'en'    => 'inglés',
    'en_au' => "inglés\ australiano",
    'en_ca' => "inglés\ canadiense",
    'en_gb' => "inglés\ británico",
    'en_us' => "inglés\ estadounidense",
    'enm'   => "inglés\ medieval",
    'eo'    => 'esperanto',
    'es'    => 'español',
    'es_es' => "español\ de\ España",
    'et'    => 'estonio',
    'eu'    => 'vasco',
    'ewo'   => 'ewondo',
    'fa'    => 'persa',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fula',
    'fi'    => 'finés',
    'fil'   => 'filipino',
    'fiu'   => "lengua\ finoúgria",
    'fj'    => 'fidjiano',
    'fo'    => 'feroés',
    'fon'   => 'fon',
    'fr'    => 'francés',
    'fr_ca' => "francés\ canadiense",
    'fr_ch' => "francés\ de\ Suiza",
    'frm'   => "francés\ medieval",
    'fro'   => "francés\ antiguo",
    'frr'   => "frisón\ septentrional",
    'frs'   => "frisón\ oriental",
    'fur'   => 'friulano',
    'fy'    => "frisón\ occidental",
    'ga'    => 'irlandés',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaélico\ escocés",
    'gem'   => "lengua\ germánica",
    'gez'   => 'geez',
    'gil'   => 'gilbertés',
    'gl'    => 'gallego',
    'gmh'   => "alemán\ de\ la\ alta\ edad\ media",
    'gn'    => 'guaraní',
    'goh'   => "alemán\ de\ la\ alta\ edad\ antigua",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gótico',
    'grb'   => 'grebo',
    'grc'   => "griego\ antiguo",
    'gsw'   => "alemán\ suizo",
    'gu'    => 'gujarati',
    'guz'   => 'Gusii',
    'gv'    => "gaélico\ manés",
    'gwi'   => 'kutchin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'hawaiano',
    'he'    => 'hebreo',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hitita',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croata',
    'hsb'   => "sorbio\ superior",
    'ht'    => 'haitiano',
    'hu'    => 'húngaro',
    'hup'   => 'hupa',
    'hy'    => 'armenio',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesio',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'ijo',
    'ik'    => 'inupiaq',
    'ilo'   => 'ilocano',
    'inc'   => "lengua\ índica",
    'ine'   => "lengua\ indoeuropea",
    'inh'   => 'ingush',
    'io'    => 'ido',
    'ira'   => "lengua\ irania",
    'iro'   => "lenguas\ iroquesas",
    'is'    => 'islandés',
    'it'    => 'italiano',
    'iu'    => 'inuktitut',
    'ja'    => 'japonés',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "judeo\-persa",
    'jrb'   => "judeo\-árabe",
    'jv'    => 'javanés',
    'ka'    => 'georgiano',
    'kaa'   => 'karakalpako',
    'kab'   => 'cabila',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardiano',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "lengua\ joisana",
    'kho'   => 'kotanés',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazajo',
    'kl'    => 'groenlandés',
    'kln'   => 'Kalenjin',
    'km'    => 'jemer',
    'kmb'   => 'kimbundu',
    'kn'    => 'canarés',
    'ko'    => 'coreano',
    'kok'   => 'konkani',
    'kos'   => 'kosraeano',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-balkar",
    'krl'   => 'carelio',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'cachemiro',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdo',
    'kum'   => 'kumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'córnico',
    'ky'    => 'kirghiz',
    'la'    => 'latín',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgués',
    'lez'   => 'lezgiano',
    'lg'    => 'ganda',
    'li'    => 'limburgués',
    'ln'    => 'lingala',
    'lo'    => 'laosiano',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituano',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseño',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'Luyia',
    'lv'    => 'letón',
    'mad'   => 'madurés',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'macasar',
    'man'   => 'mandingo',
    'map'   => "lengua\ austronesia",
    'mas'   => 'masai',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgache',
    'mga'   => "irlandés\ medieval",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'marshalés',
    'mi'    => 'maorí',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "lenguas\ varias",
    'mk'    => 'macedonio',
    'mkh'   => "lengua\ mon\-jemer",
    'ml'    => 'malayalam',
    'mn'    => 'mongol',
    'mnc'   => 'manchú',
    'mni'   => 'manipuri',
    'mno'   => "lenguas\ manobo",
    'mo'    => 'moldavo',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malayo',
    'mt'    => 'maltés',
    'mua'   => 'Mundang',
    'mul'   => "lenguas\ múltiples",
    'mun'   => "lenguas\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandés',
    'mwr'   => 'marwari',
    'my'    => 'birmano',
    'myn'   => 'maya',
    'myv'   => 'erzya',
    'na'    => 'nauruano',
    'nah'   => 'náhuatl',
    'nai'   => "lengua\ india\ norteamericana",
    'nap'   => 'napolitano',
    'naq'   => 'Nama',
    'nb'    => "bokmal\ noruego",
    'nd'    => "ndebele\ septentrional",
    'nds'   => "bajo\ alemán",
    'ne'    => 'nepalí',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "lengua\ níger\-cordofana",
    'niu'   => 'niueano',
    'nl'    => 'neerlandés',
    'nl_be' => 'flamenco',
    'nmg'   => 'Kwasio',
    'nn'    => "nynorsk\ noruego",
    'no'    => 'noruego',
    'nog'   => 'nogai',
    'non'   => "nórdico\ antiguo",
    'nqo'   => 'n’ko',
    'nr'    => "ndebele\ meridional",
    'nso'   => "sotho\ septentrional",
    'nub'   => "lenguas\ nubias",
    'nus'   => 'Nuer',
    'nv'    => 'navajo',
    'nwc'   => "newari\ clásico",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitano',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'osético',
    'osa'   => 'osage',
    'ota'   => "turco\ otomano",
    'oto'   => "lenguas\ otomanas",
    'pa'    => 'punjabí',
    'paa'   => "lengua\ papú",
    'pag'   => 'pangasinán',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauano',
    'peo'   => "persa\ antiguo",
    'phi'   => "lengua\ filipina",
    'phn'   => 'fenicio',
    'pi'    => 'pali',
    'pl'    => 'polaco',
    'pon'   => 'pohnpeiano',
    'pra'   => "lenguas\ prácritas",
    'pro'   => "provenzal\ antiguo",
    'ps'    => 'pashto',
    'pt'    => 'portugués',
    'pt_br' => "portugués\ de\ Brasil",
    'pt_pt' => "portugués\ de\ Portugal",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongano',
    'rm'    => 'retorrománico',
    'rn'    => 'kiroundi',
    'ro'    => 'rumano',
    'roa'   => "lengua\ romance",
    'rof'   => 'Rombo',
    'rom'   => 'romaní',
    'ru'    => 'ruso',
    'rup'   => 'arrumano',
    'rw'    => 'kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sánscrito',
    'sad'   => 'sandawe',
    'sah'   => 'sakha',
    'sai'   => "lengua\ india\ sudamericana",
    'sal'   => "lenguas\ salish",
    'sam'   => "arameo\ samaritano",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sardo',
    'scn'   => 'siciliano',
    'sco'   => 'escocés',
    'sd'    => 'sindhi',
    'se'    => "sami\ septentrional",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkup',
    'sem'   => "lengua\ semítica",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => "irlandés\ antiguo",
    'sgn'   => "lenguajes\ de\ signos",
    'sh'    => 'serbocroata',
    'shi'   => 'Tachelhit',
    'shn'   => 'shan',
    'si'    => 'cingalés',
    'sid'   => 'sidamo',
    'sio'   => "lenguas\ sioux",
    'sit'   => "lengua\ sino\-tibetana",
    'sk'    => 'eslovaco',
    'sl'    => 'esloveno',
    'sla'   => "lengua\ eslava",
    'sm'    => 'samoano',
    'sma'   => "sami\ meridional",
    'smi'   => "lengua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninké',
    'so'    => 'somalí',
    'sog'   => 'sogdiano',
    'son'   => 'songhai',
    'sq'    => 'albanés',
    'sr'    => 'serbio',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => "lengua\ nilo\-sahariana",
    'ssy'   => 'Saho',
    'st'    => "sesotho\ meridional",
    'su'    => 'sundanés',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerio',
    'sv'    => 'sueco',
    'sw'    => 'swahili',
    'swb'   => 'comorense',
    'swc'   => "Congo\ Swahili",
    'syc'   => "siríaco\ clásico",
    'syr'   => 'siriaco',
    'ta'    => 'tamil',
    'tai'   => "lengua\ tai",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetún',
    'tg'    => 'tayiko',
    'th'    => 'tailandés',
    'ti'    => 'tigriña',
    'tig'   => 'tigré',
    'tiv'   => 'tiv',
    'tk'    => 'turcomano',
    'tkl'   => 'tokelauano',
    'tl'    => 'tagalo',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'setchwana',
    'to'    => 'tongano',
    'tog'   => "tonga\ del\ Nyasa",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turco',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshiano',
    'tt'    => 'tártaro',
    'tum'   => 'tumbuka',
    'tup'   => "lenguas\ tupí",
    'tut'   => "lengua\ altaica",
    'tvl'   => 'tuvaluano',
    'tw'    => 'twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'tahitiano',
    'tyv'   => 'tuviniano',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurt',
    'ug'    => 'uygur',
    'uga'   => 'ugarítico',
    'uk'    => 'ucraniano',
    'umb'   => 'umbundu',
    'und'   => "lengua\ desconocida",
    'ur'    => 'urdu',
    'uz'    => 'uzbeko',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapük',
    'vot'   => 'vótico',
    'vun'   => 'Vunjo',
    'wa'    => 'valón',
    'wae'   => 'Walser',
    'wak'   => "lenguas\ wakasha",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "lenguas\ sorbias",
    'wo'    => 'uolof',
    'xal'   => 'kalmyk',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'yao',
    'yap'   => 'yapés',
    'yav'   => 'Yangben',
    'yi'    => 'yídish',
    'yo'    => 'yoruba',
    'ypk'   => "lenguas\ yupik",
    'yue'   => 'cantonés',
    'za'    => 'zhuang',
    'zap'   => 'zapoteco',
    'zbl'   => "símbolos\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'chino',
    'znd'   => 'zande',
    'zu'    => 'zulú',
    'zun'   => 'zuni',
    'zxx'   => "sin\ contenido\ lingüístico",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::es::name_to_code = (
    'abjasio'                                  => 'ab',
    'acadio'                                   => 'akk',
    'acehnés'                                 => 'ace',
    'acoli'                                    => 'ach',
    'adangme'                                  => 'ada',
    'adigeo'                                   => 'ady',
    'afar'                                     => 'aa',
    'afrihili'                                 => 'afh',
    'afrikaans'                                => 'af',
    'aghem'                                    => 'agq',
    'aimara'                                   => 'ay',
    'ainu'                                     => 'ain',
    'akan'                                     => 'ak',
    'albanés'                                 => 'sq',
    'alemán'                                  => 'de',
    'alemánaustríaco'                        => 'de_at',
    'alemándelaaltaedadantigua'               => 'goh',
    'alemándelaaltaedadmedia'                 => 'gmh',
    'alemánsuizo'                             => 'gsw',
    'aleutiano'                                => 'ale',
    'altoalemándesuiza'                       => 'de_ch',
    'altáimeridional'                         => 'alt',
    'amárico'                                 => 'am',
    'angika'                                   => 'anp',
    'aragonés'                                => 'an',
    'arahuaco'                                 => 'arw',
    'arameo'                                   => 'arc',
    'arameosamaritano'                         => 'sam',
    'arapaho'                                  => 'arp',
    'araucano'                                 => 'arn',
    'armenio'                                  => 'hy',
    'arrumano'                                 => 'rup',
    'asamés'                                  => 'as',
    'asturiano'                                => 'ast',
    'asu'                                      => 'asa',
    'atsam'                                    => 'cch',
    'avadhi'                                   => 'awa',
    'avar'                                     => 'av',
    'avéstico'                                => 'ae',
    'azerí'                                   => 'az',
    'bafia'                                    => 'ksf',
    'bajoalemán'                              => 'nds',
    'balinés'                                 => 'ban',
    'baluchi'                                  => 'bal',
    'bambara'                                  => 'bm',
    'banda'                                    => 'bad',
    'bantú'                                   => 'bnt',
    'basa'                                     => 'bas',
    'bashkir'                                  => 'ba',
    'batak'                                    => 'btk',
    'beja'                                     => 'bej',
    'bemba'                                    => 'bem',
    'bena'                                     => 'bez',
    'bengalí'                                 => 'bn',
    'bereber'                                  => 'ber',
    'bhojpuri'                                 => 'bho',
    'bicol'                                    => 'bik',
    'bielorruso'                               => 'be',
    'bihari'                                   => 'bh',
    'bini'                                     => 'bin',
    'birmano'                                  => 'my',
    'bislama'                                  => 'bi',
    'blin'                                     => 'byn',
    'bodo'                                     => 'brx',
    'bokmalnoruego'                            => 'nb',
    'bosnio'                                   => 'bs',
    'braj'                                     => 'bra',
    'bretón'                                  => 'br',
    'buginés'                                 => 'bug',
    'buriat'                                   => 'bua',
    'búlgaro'                                 => 'bg',
    'cabila'                                   => 'kab',
    'cachemiro'                                => 'ks',
    'caddo'                                    => 'cad',
    'canarés'                                 => 'kn',
    'cantonés'                                => 'yue',
    'carelio'                                  => 'krl',
    'caribe'                                   => 'car',
    'casubio'                                  => 'csb',
    'catalán'                                 => 'ca',
    'cayuga'                                   => 'cay',
    'cebuano'                                  => 'ceb',
    'centralmoroccotamazight'                  => 'tzm',
    'chagatái'                                => 'chg',
    'chamorro'                                 => 'ch',
    'checheno'                                 => 'ce',
    'checo'                                    => 'cs',
    'cherokee'                                 => 'chr',
    'cheyene'                                  => 'chy',
    'chibcha'                                  => 'chb',
    'chiga'                                    => 'cgg',
    'chino'                                    => 'zh',
    'chipewyan'                                => 'chp',
    'choctaw'                                  => 'cho',
    'chuvash'                                  => 'cv',
    'cingalés'                                => 'si',
    'colognian'                                => 'ksh',
    'comorense'                                => 'swb',
    'congoswahili'                             => 'swc',
    'copto'                                    => 'cop',
    'coreano'                                  => 'ko',
    'corso'                                    => 'co',
    'cree'                                     => 'cr',
    'creek'                                    => 'mus',
    'croata'                                   => 'hr',
    'córnico'                                 => 'kw',
    'dakota'                                   => 'dak',
    'danés'                                   => 'da',
    'dargva'                                   => 'dar',
    'dayak'                                    => 'day',
    'delaware'                                 => 'del',
    'dinka'                                    => 'din',
    'diula'                                    => 'dyu',
    'divehi'                                   => 'dv',
    'dogri'                                    => 'doi',
    'dogrib'                                   => 'dgr',
    'duala'                                    => 'dua',
    'dzongkha'                                 => 'dz',
    'efik'                                     => 'efi',
    'egipcioantiguo'                           => 'egy',
    'ekajuk'                                   => 'eka',
    'elamita'                                  => 'elx',
    'embu'                                     => 'ebu',
    'erzya'                                    => 'myv',
    'escocés'                                 => 'sco',
    'eslavoeclesiástico'                      => 'cu',
    'eslovaco'                                 => 'sk',
    'esloveno'                                 => 'sl',
    'español'                                 => 'es',
    'españoldeespaña'                        => 'es_es',
    'esperanto'                                => 'eo',
    'estonio'                                  => 'et',
    'ewe'                                      => 'ee',
    'ewondo'                                   => 'ewo',
    'fang'                                     => 'fan',
    'fanti'                                    => 'fat',
    'fenicio'                                  => 'phn',
    'feroés'                                  => 'fo',
    'fidjiano'                                 => 'fj',
    'filipino'                                 => 'fil',
    'finés'                                   => 'fi',
    'flamenco'                                 => 'nl_be',
    'fon'                                      => 'fon',
    'francés'                                 => 'fr',
    'francésantiguo'                          => 'fro',
    'francéscanadiense'                       => 'fr_ca',
    'francésdesuiza'                          => 'fr_ch',
    'francésmedieval'                         => 'frm',
    'frisónoccidental'                        => 'fy',
    'frisónoriental'                          => 'frs',
    'frisónseptentrional'                     => 'frr',
    'friulano'                                 => 'fur',
    'fula'                                     => 'ff',
    'ga'                                       => 'gaa',
    'gallego'                                  => 'gl',
    'galés'                                   => 'cy',
    'ganda'                                    => 'lg',
    'gayo'                                     => 'gay',
    'gaélicoescocés'                         => 'gd',
    'gaélicomanés'                           => 'gv',
    'gbaya'                                    => 'gba',
    'geez'                                     => 'gez',
    'georgiano'                                => 'ka',
    'gilbertés'                               => 'gil',
    'gondi'                                    => 'gon',
    'gorontalo'                                => 'gor',
    'grebo'                                    => 'grb',
    'griego'                                   => 'el',
    'griegoantiguo'                            => 'grc',
    'groenlandés'                             => 'kl',
    'guaraní'                                 => 'gn',
    'gujarati'                                 => 'gu',
    'gusii'                                    => 'guz',
    'gótico'                                  => 'got',
    'haida'                                    => 'hai',
    'haitiano'                                 => 'ht',
    'hausa'                                    => 'ha',
    'hawaiano'                                 => 'haw',
    'hebreo'                                   => 'he',
    'herero'                                   => 'hz',
    'hiligaynon'                               => 'hil',
    'himachali'                                => 'him',
    'hindi'                                    => 'hi',
    'hirimotu'                                 => 'ho',
    'hitita'                                   => 'hit',
    'hmong'                                    => 'hmn',
    'hupa'                                     => 'hup',
    'húngaro'                                 => 'hu',
    'iban'                                     => 'iba',
    'ido'                                      => 'io',
    'igbo'                                     => 'ig',
    'ijo'                                      => 'ijo',
    'ilocano'                                  => 'ilo',
    'indonesio'                                => 'id',
    'inglés'                                  => 'en',
    'inglésantiguo'                           => 'ang',
    'inglésaustraliano'                       => 'en_au',
    'inglésbritánico'                        => 'en_gb',
    'ingléscanadiense'                        => 'en_ca',
    'inglésestadounidense'                    => 'en_us',
    'inglésmedieval'                          => 'enm',
    'ingush'                                   => 'inh',
    'interlingua'                              => 'ia',
    'interlingue'                              => 'ie',
    'inuktitut'                                => 'iu',
    'inupiaq'                                  => 'ik',
    'irlandés'                                => 'ga',
    'irlandésantiguo'                         => 'sga',
    'irlandésmedieval'                        => 'mga',
    'islandés'                                => 'is',
    'italiano'                                 => 'it',
    'japonés'                                 => 'ja',
    'javanés'                                 => 'jv',
    'jemer'                                    => 'km',
    'jergachinuk'                              => 'chn',
    'jju'                                      => 'kaj',
    'jolafonyi'                                => 'dyo',
    'judeopersa'                               => 'jpr',
    'judeoárabe'                              => 'jrb',
    'kabardiano'                               => 'kbd',
    'kabuverdianu'                             => 'kea',
    'kachin'                                   => 'kac',
    'kalenjin'                                 => 'kln',
    'kalmyk'                                   => 'xal',
    'kamba'                                    => 'kam',
    'kanuri'                                   => 'kr',
    'karachaybalkar'                           => 'krc',
    'karakalpako'                              => 'kaa',
    'karen'                                    => 'kar',
    'kawi'                                     => 'kaw',
    'kazajo'                                   => 'kk',
    'khasi'                                    => 'kha',
    'kikuyu'                                   => 'ki',
    'kimbundu'                                 => 'kmb',
    'kinyarwanda'                              => 'rw',
    'kirghiz'                                  => 'ky',
    'kiroundi'                                 => 'rn',
    'klingon'                                  => 'tlh',
    'komi'                                     => 'kv',
    'kongo'                                    => 'kg',
    'konkani'                                  => 'kok',
    'koro'                                     => 'kfo',
    'kosraeano'                                => 'kos',
    'kotanés'                                 => 'kho',
    'koyraborosenni'                           => 'ses',
    'koyrachiini'                              => 'khq',
    'kpelle'                                   => 'kpe',
    'kru'                                      => 'kro',
    'kuanyama'                                 => 'kj',
    'kumyk'                                    => 'kum',
    'kurdo'                                    => 'ku',
    'kurukh'                                   => 'kru',
    'kutchin'                                  => 'gwi',
    'kutenai'                                  => 'kut',
    'kwasio'                                   => 'nmg',
    'ladino'                                   => 'lad',
    'lahnda'                                   => 'lah',
    'lamba'                                    => 'lam',
    'langi'                                    => 'lag',
    'laosiano'                                 => 'lo',
    'latín'                                   => 'la',
    'lenguaafroasiática'                      => 'afa',
    'lenguaaltaica'                            => 'tut',
    'lenguaartificial'                         => 'art',
    'lenguaaustronesia'                        => 'map',
    'lenguabáltica'                           => 'bat',
    'lenguacaucásica'                         => 'cau',
    'lenguacelta'                              => 'cel',
    'lenguacriollaopidgin'                     => 'crp',
    'lenguacriollaopidginbasadaenelfrancés'   => 'cpf',
    'lenguacriollaopidginbasadaenelinglés'    => 'cpe',
    'lenguacriollaopidginbasadaenelportugués' => 'cpp',
    'lenguacusita'                             => 'cus',
    'lenguadesconocida'                        => 'und',
    'lenguadravídica'                         => 'dra',
    'lenguaeslava'                             => 'sla',
    'lenguafilipina'                           => 'phi',
    'lenguafinoúgria'                         => 'fiu',
    'lenguagermánica'                         => 'gem',
    'lenguaindiacentroamericana'               => 'cai',
    'lenguaindianorteamericana'                => 'nai',
    'lenguaindiasudamericana'                  => 'sai',
    'lenguaindoeuropea'                        => 'ine',
    'lenguairania'                             => 'ira',
    'lenguajesdesignos'                        => 'sgn',
    'lenguajoisana'                            => 'khi',
    'lenguamonjemer'                           => 'mkh',
    'lenguanilosahariana'                      => 'ssa',
    'lenguanígercordofana'                    => 'nic',
    'lenguapapú'                              => 'paa',
    'lenguaromance'                            => 'roa',
    'lenguasalgonquinas'                       => 'alg',
    'lenguasami'                               => 'smi',
    'lenguasapache'                            => 'apa',
    'lenguasatabascas'                         => 'ath',
    'lenguasaustralianas'                      => 'aus',
    'lenguasbamileke'                          => 'bai',
    'lenguaschámicas'                         => 'cmc',
    'lenguasemítica'                          => 'sem',
    'lenguasinotibetana'                       => 'sit',
    'lenguasiroquesas'                         => 'iro',
    'lenguasmanobo'                            => 'mno',
    'lenguasmunda'                             => 'mun',
    'lenguasmúltiples'                        => 'mul',
    'lenguasnubias'                            => 'nub',
    'lenguasotomanas'                          => 'oto',
    'lenguasprácritas'                        => 'pra',
    'lenguassalish'                            => 'sal',
    'lenguassioux'                             => 'sio',
    'lenguassorbias'                           => 'wen',
    'lenguastupí'                             => 'tup',
    'lenguasvarias'                            => 'mis',
    'lenguaswakasha'                           => 'wak',
    'lenguasyupik'                             => 'ypk',
    'lenguatai'                                => 'tai',
    'lenguaíndica'                            => 'inc',
    'letón'                                   => 'lv',
    'lezgiano'                                 => 'lez',
    'limburgués'                              => 'li',
    'lingala'                                  => 'ln',
    'lituano'                                  => 'lt',
    'lojban'                                   => 'jbo',
    'lozi'                                     => 'loz',
    'lubakatanga'                              => 'lu',
    'lubalulua'                                => 'lua',
    'luiseño'                                 => 'lui',
    'lunda'                                    => 'lun',
    'luo'                                      => 'luo',
    'lushai'                                   => 'lus',
    'luxemburgués'                            => 'lb',
    'luyia'                                    => 'luy',
    'macasar'                                  => 'mak',
    'macedonio'                                => 'mk',
    'machame'                                  => 'jmc',
    'madurés'                                 => 'mad',
    'magahi'                                   => 'mag',
    'maithili'                                 => 'mai',
    'makhuwameetto'                            => 'mgh',
    'makonde'                                  => 'kde',
    'malayalam'                                => 'ml',
    'malayo'                                   => 'ms',
    'malgache'                                 => 'mg',
    'maltés'                                  => 'mt',
    'manchú'                                  => 'mnc',
    'mandar'                                   => 'mdr',
    'mandingo'                                 => 'man',
    'manipuri'                                 => 'mni',
    'maorí'                                   => 'mi',
    'marathi'                                  => 'mr',
    'marshalés'                               => 'mh',
    'marwari'                                  => 'mwr',
    'marí'                                    => 'chm',
    'masai'                                    => 'mas',
    'maya'                                     => 'myn',
    'mende'                                    => 'men',
    'meru'                                     => 'mer',
    'micmac'                                   => 'mic',
    'minangkabau'                              => 'min',
    'mirandés'                                => 'mwl',
    'mohawk'                                   => 'moh',
    'moksha'                                   => 'mdf',
    'moldavo'                                  => 'mo',
    'mongo'                                    => 'lol',
    'mongol'                                   => 'mn',
    'morisyen'                                 => 'mfe',
    'mossi'                                    => 'mos',
    'mundang'                                  => 'mua',
    'nama'                                     => 'naq',
    'napolitano'                               => 'nap',
    'nauruano'                                 => 'na',
    'navajo'                                   => 'nv',
    'ndebelemeridional'                        => 'nr',
    'ndebeleseptentrional'                     => 'nd',
    'ndonga'                                   => 'ng',
    'neerlandés'                              => 'nl',
    'neerlandésmedieval'                      => 'dum',
    'nepalí'                                  => 'ne',
    'newari'                                   => 'new',
    'newariclásico'                           => 'nwc',
    'nias'                                     => 'nia',
    'niueano'                                  => 'niu',
    'nogai'                                    => 'nog',
    'noruego'                                  => 'no',
    'nuer'                                     => 'nus',
    'nyamwezi'                                 => 'nym',
    'nyanja'                                   => 'ny',
    'nyankole'                                 => 'nyn',
    'nynorsknoruego'                           => 'nn',
    'nyoro'                                    => 'nyo',
    'nzima'                                    => 'nzi',
    'náhuatl'                                 => 'nah',
    'nórdicoantiguo'                          => 'non',
    'n’ko'                                   => 'nqo',
    'occitano'                                 => 'oc',
    'ojibwa'                                   => 'oj',
    'oriya'                                    => 'or',
    'oromo'                                    => 'om',
    'osage'                                    => 'osa',
    'osético'                                 => 'os',
    'pahlavi'                                  => 'pal',
    'palauano'                                 => 'pau',
    'pali'                                     => 'pi',
    'pampanga'                                 => 'pam',
    'pangasinán'                              => 'pag',
    'papiamento'                               => 'pap',
    'pashto'                                   => 'ps',
    'persa'                                    => 'fa',
    'persaantiguo'                             => 'peo',
    'pohnpeiano'                               => 'pon',
    'polaco'                                   => 'pl',
    'portugués'                               => 'pt',
    'portuguésdebrasil'                       => 'pt_br',
    'portuguésdeportugal'                     => 'pt_pt',
    'provenzalantiguo'                         => 'pro',
    'punjabí'                                 => 'pa',
    'quechua'                                  => 'qu',
    'rajasthani'                               => 'raj',
    'rapanui'                                  => 'rap',
    'rarotongano'                              => 'rar',
    'retorrománico'                           => 'rm',
    'romaní'                                  => 'rom',
    'rombo'                                    => 'rof',
    'rumano'                                   => 'ro',
    'ruso'                                     => 'ru',
    'rwa'                                      => 'rwk',
    'saho'                                     => 'ssy',
    'sakha'                                    => 'sah',
    'samburu'                                  => 'saq',
    'samiinari'                                => 'smn',
    'samilule'                                 => 'smj',
    'samimeridional'                           => 'sma',
    'samiseptentrional'                        => 'se',
    'samiskolt'                                => 'sms',
    'samoano'                                  => 'sm',
    'sandawe'                                  => 'sad',
    'sango'                                    => 'sg',
    'sangu'                                    => 'sbp',
    'santali'                                  => 'sat',
    'sardo'                                    => 'sc',
    'sasak'                                    => 'sas',
    'selkup'                                   => 'sel',
    'sena'                                     => 'seh',
    'seneca'                                   => 'see',
    'serbio'                                   => 'sr',
    'serbocroata'                              => 'sh',
    'serer'                                    => 'srr',
    'sesothomeridional'                        => 'st',
    'setchwana'                                => 'tn',
    'shambala'                                 => 'ksb',
    'shan'                                     => 'shn',
    'shona'                                    => 'sn',
    'sichuanyi'                                => 'ii',
    'siciliano'                                => 'scn',
    'sidamo'                                   => 'sid',
    'siksika'                                  => 'bla',
    'sincontenidolingüístico'                => 'zxx',
    'sindhi'                                   => 'sd',
    'siriaco'                                  => 'syr',
    'siríacoclásico'                         => 'syc',
    'siswati'                                  => 'ss',
    'slave'                                    => 'den',
    'soga'                                     => 'xog',
    'sogdiano'                                 => 'sog',
    'somalí'                                  => 'so',
    'songhai'                                  => 'son',
    'soninké'                                 => 'snk',
    'sorbioinferior'                           => 'dsb',
    'sorbiosuperior'                           => 'hsb',
    'sothoseptentrional'                       => 'nso',
    'sranantongo'                              => 'srn',
    'sueco'                                    => 'sv',
    'sukuma'                                   => 'suk',
    'sumerio'                                  => 'sux',
    'sundanés'                                => 'su',
    'susu'                                     => 'sus',
    'swahili'                                  => 'sw',
    'sánscrito'                               => 'sa',
    'símbolosbliss'                           => 'zbl',
    'tachelhit'                                => 'shi',
    'tagalo'                                   => 'tl',
    'tahitiano'                                => 'ty',
    'tailandés'                               => 'th',
    'taita'                                    => 'dav',
    'tamashek'                                 => 'tmh',
    'tamil'                                    => 'ta',
    'taroko'                                   => 'trv',
    'tasawaq'                                  => 'twq',
    'tayiko'                                   => 'tg',
    'telugu'                                   => 'te',
    'temne'                                    => 'tem',
    'tereno'                                   => 'ter',
    'teso'                                     => 'teo',
    'tetún'                                   => 'tet',
    'tibetano'                                 => 'bo',
    'tigriña'                                 => 'ti',
    'tigré'                                   => 'tig',
    'tiv'                                      => 'tiv',
    'tlingit'                                  => 'tli',
    'tokelauano'                               => 'tkl',
    'tokpisin'                                 => 'tpi',
    'tongadelnyasa'                            => 'tog',
    'tongano'                                  => 'to',
    'trukés'                                  => 'chk',
    'tsimshiano'                               => 'tsi',
    'tsonga'                                   => 'ts',
    'tumbuka'                                  => 'tum',
    'turco'                                    => 'tr',
    'turcomano'                                => 'tk',
    'turcootomano'                             => 'ota',
    'tuvaluano'                                => 'tvl',
    'tuviniano'                                => 'tyv',
    'twi'                                      => 'tw',
    'tyap'                                     => 'kcg',
    'tártaro'                                 => 'tt',
    'tártarodecrimea'                         => 'crh',
    'ucraniano'                                => 'uk',
    'udmurt'                                   => 'udm',
    'ugarítico'                               => 'uga',
    'umbundu'                                  => 'umb',
    'uolof'                                    => 'wo',
    'urdu'                                     => 'ur',
    'uygur'                                    => 'ug',
    'uzbeko'                                   => 'uz',
    'vai'                                      => 'vai',
    'valón'                                   => 'wa',
    'vasco'                                    => 'eu',
    'venda'                                    => 've',
    'vietnamita'                               => 'vi',
    'volapük'                                 => 'vo',
    'vunjo'                                    => 'vun',
    'vótico'                                  => 'vot',
    'walamo'                                   => 'wal',
    'walser'                                   => 'wae',
    'waray'                                    => 'war',
    'washo'                                    => 'was',
    'xhosa'                                    => 'xh',
    'yangben'                                  => 'yav',
    'yao'                                      => 'yao',
    'yapés'                                   => 'yap',
    'yoruba'                                   => 'yo',
    'yídish'                                  => 'yi',
    'zande'                                    => 'znd',
    'zapoteco'                                 => 'zap',
    'zarma'                                    => 'dje',
    'zazaki'                                   => 'zza',
    'zenaga'                                   => 'zen',
    'zhuang'                                   => 'za',
    'zulú'                                    => 'zu',
    'zuni'                                     => 'zun',
    'árabe'                                   => 'ar',
);

1;
