package Locales::DB::Language::lo;

# Auto generated from CLDR

$Locales::DB::Language::lo::VERSION = '0.09';

$Locales::DB::Language::lo::cldr_version = '2.0';

%Locales::DB::Language::lo::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::lo::code_to_name = (
    'aa'    => 'ອາຟາ',
    'ab'    => 'ແອບຄາເຊຍ',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'ອັຟຣິກາ',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'ອຳຫາຣິກ',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'ອາຣັບ',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'ອັສສຳ',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'ໄອມາລາ',
    'az'    => 'ອາແຊກບາຍຊານ',
    'ba'    => 'ບາສສີ',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'ເບລາລຸດຊີ',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'ບຸນກາຣີ',
    'bh'    => 'ບີຮາຣີ',
    'bho'   => 'Bhojpuri',
    'bi'    => 'ບິສລາມາ',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'ເບັງການ',
    'bnt'   => 'Bantu',
    'bo'    => 'ທິເບດ',
    'br'    => 'ບເຣີຕົງ',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'ບອສນີ',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'ກາຕາລັງ',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'ຄໍຊິກ້າ',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ເຊັກ',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'ແວວ',
    'da'    => 'ເດັນມາກ',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'ເຍຍລະມັນ',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'ພູຖານີ',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ກເຣັກ',
    'elx'   => 'Elamite',
    'en'    => 'ອັງກິດ',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'ເອສເປຣັງໂຕ',
    'es'    => 'ແອສປາໂຍນ',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'ເອສໂຕນີ',
    'eu'    => 'ບັສເກີ',
    'ewo'   => 'Ewondo',
    'fa'    => 'ເປີເຊຍ',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'ແຟງລັງ',
    'fil'   => 'ຕາກາລ໊ອກ',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'ຟິຈິ',
    'fo'    => 'ຟາໂຣ',
    'fon'   => 'Fon',
    'fr'    => 'ຝຣັ່ງ',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'ຟຣີຊຽນ',
    'ga'    => 'ໄອແລນ',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "ສະກັອດ\ ແກລິກ",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'ກາລິດ',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'ກົວຣານີ',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'ກູຊາຣາຕີ',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'ໂອຊາ',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'ຍິວ',
    'hi'    => 'ຮິນດູ',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'ໂກຣອາຊີ',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'ຮັງກາຣີ',
    'hup'   => 'Hupa',
    'hy'    => 'ອາກເມນີ',
    'hz'    => 'Herero',
    'ia'    => 'ອິນເຕີລິງກາ',
    'iba'   => 'Iban',
    'id'    => 'ອິນໂດເນເຊຍ',
    'ie'    => 'ອິນເຕີລິງ',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'ໄອນູປຽກ',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'ອິສລັງ',
    'it'    => 'ອີຕາລີ',
    'iu'    => 'ໄອນຸກຕິຕັກ',
    'ja'    => 'ຍີ່ປຸ່ນ',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'ຊວາ',
    'ka'    => 'ຊອກຊີ',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'ຄາຊັກ',
    'kl'    => 'ກຼີນແລນດິດ',
    'kln'   => 'Kalenjin',
    'km'    => 'ກຳປູເຈຍ',
    'kmb'   => 'Kimbundu',
    'kn'    => 'ກັນນາດາ',
    'ko'    => 'ເກົາຫຼີ',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'ຄັດຊະມີລີ',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'ເຄີດິສ',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'ເກຍກິສ',
    'la'    => 'ລາແຕັງ',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'ລິງກາລາ',
    'lo'    => 'ລາວ',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'ລີທົວນີ',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'ລັດເວຍ',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'ມາລາກາຊິ',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'ເມົາລີ',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'ມາເຊໂດນີ',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'ມາລາຢາລຳ',
    'mn'    => 'ມົງໂກນ',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'ໂມຄາເວຍ',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'ມາຣາທີ',
    'ms'    => 'ມາເລ',
    'mt'    => 'ມານຕາ',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'ພະມ່າ',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'ນໍລູ',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'ເນປານ',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ໂຮນລັງ',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => "ນອກແວ\ \(ນີນອກ\)",
    'no'    => 'ນອກແວ',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'ອົກຊີຕານ',
    'oj'    => 'Ojibwa',
    'om'    => "ໂອໂລໂມ\(ອາຟານ\)",
    'or'    => 'ໂອຣີຢາ',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'ປັນຈາບ',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'ໂປໂລຍ',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'ປາສໂຕ',
    'pt'    => 'ປອກຕຸຍການ',
    'pt_br' => "ປອກຕຸຍການ\ \(ບຣາຊີນ\)",
    'pt_pt' => "ປອກຕຸຍການ\ \(ປອກຕຸຍການ\)",
    'qu'    => 'ຄິວຊົວ',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "ເລໂຕ\-ໂລແມນ",
    'rn'    => 'ຄິລັນສີ',
    'ro'    => 'ໂຣມານີ',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'ລັດເຊຍ',
    'rup'   => 'Aromanian',
    'rw'    => 'ຄິນຍາວັນດາ',
    'rwk'   => 'Rwa',
    'sa'    => 'ສັນສະກິດ',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'ສິນທິ',
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'ສັນໂຄ',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "ແຊັກໂບ\-ໂກຣແອັດ",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'ສິງຫານ',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'ສະໂລວັກກີ',
    'sl'    => 'ສະໂລວານີ',
    'sla'   => "Slavic\ Language",
    'sm'    => 'ຊາມົວ',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'ໂຊນາ',
    'snk'   => 'Soninke',
    'so'    => 'ໂຊມາລີ',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'ອານບານີ',
    'sr'    => 'ແຊກບີ',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'ຊິສວາຕິ',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => 'ເຊໂຊໂທ',
    'su'    => 'ຊັນດານ',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ຊູແອັດ',
    'sw'    => 'ຊວາຮີລີ',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'ທະມິນ',
    'tai'   => "Tai\ Language",
    'te'    => 'ເຕລູກູ',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'ທາຈິດ',
    'th'    => 'ໄທ',
    'ti'    => 'ຕີກຣິນຢາ',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'ຕວຽກເມນ',
    'tkl'   => 'Tokelau',
    'tl'    => 'ຕາກາລັອກ',
    'tlh'   => 'ກລິງກອງ',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'ເຊຕະສະວານາ',
    'to'    => 'ທອງກ້າ',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'ຕວກກີ',
    'trv'   => 'Taroko',
    'ts'    => 'ຊອງກາ',
    'tsi'   => 'Tsimshian',
    'tt'    => 'ຕາດ',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'ຕວີ',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'ອຸຍເຄີ',
    'uga'   => 'Ugaritic',
    'uk'    => 'ອູແກຣນ',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ Language",
    'ur'    => 'ອູຣະດູ',
    'uz'    => 'ອຸດຊະເບັກກິດສະຖານ',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ຫວຽດນາມ',
    'vo'    => 'ໂວລາພຸກ',
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'ວູບ',
    'xal'   => 'Kalmyk',
    'xh'    => 'ໂຊຊາ',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'ຢິດດິສ',
    'yo'    => 'ໂຢລູບາ',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'ຈວງ',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'ຈີນ',
    'znd'   => 'Zande',
    'zu'    => 'ຊູລູ',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::lo::name_to_code = (
    'achinese'                                               => 'ace',
    'acoli'                                                  => 'ach',
    'adangme'                                                => 'ada',
    'adyghe'                                                 => 'ady',
    'afrihili'                                               => 'afh',
    'afroasiaticlanguage'                                    => 'afa',
    'aghem'                                                  => 'agq',
    'ainu'                                                   => 'ain',
    'akan'                                                   => 'ak',
    'akkadian'                                               => 'akk',
    'aleut'                                                  => 'ale',
    'algonquianlanguage'                                     => 'alg',
    'altaiclanguage'                                         => 'tut',
    'ancientegyptian'                                        => 'egy',
    'ancientgreek'                                           => 'grc',
    'angika'                                                 => 'anp',
    'apachelanguage'                                         => 'apa',
    'aragonese'                                              => 'an',
    'aramaic'                                                => 'arc',
    'arapaho'                                                => 'arp',
    'araucanian'                                             => 'arn',
    'arawak'                                                 => 'arw',
    'aromanian'                                              => 'rup',
    'artificiallanguage'                                     => 'art',
    'asturian'                                               => 'ast',
    'asu'                                                    => 'asa',
    'athapascanlanguage'                                     => 'ath',
    'atsam'                                                  => 'cch',
    'australianenglish'                                      => 'en_au',
    'australianlanguage'                                     => 'aus',
    'austriangerman'                                         => 'de_at',
    'austronesianlanguage'                                   => 'map',
    'avaric'                                                 => 'av',
    'avestan'                                                => 'ae',
    'awadhi'                                                 => 'awa',
    'bafia'                                                  => 'ksf',
    'balinese'                                               => 'ban',
    'balticlanguage'                                         => 'bat',
    'baluchi'                                                => 'bal',
    'bambara'                                                => 'bm',
    'bamilekelanguage'                                       => 'bai',
    'banda'                                                  => 'bad',
    'bantu'                                                  => 'bnt',
    'basaa'                                                  => 'bas',
    'batak'                                                  => 'btk',
    'beja'                                                   => 'bej',
    'bemba'                                                  => 'bem',
    'bena'                                                   => 'bez',
    'berber'                                                 => 'ber',
    'bhojpuri'                                               => 'bho',
    'bikol'                                                  => 'bik',
    'bini'                                                   => 'bin',
    'blin'                                                   => 'byn',
    'blissymbols'                                            => 'zbl',
    'bodo'                                                   => 'brx',
    'braj'                                                   => 'bra',
    'britishenglish'                                         => 'en_gb',
    'buginese'                                               => 'bug',
    'buriat'                                                 => 'bua',
    'caddo'                                                  => 'cad',
    'canadianenglish'                                        => 'en_ca',
    'canadianfrench'                                         => 'fr_ca',
    'cantonese'                                              => 'yue',
    'carib'                                                  => 'car',
    'caucasianlanguage'                                      => 'cau',
    'cayuga'                                                 => 'cay',
    'cebuano'                                                => 'ceb',
    'celticlanguage'                                         => 'cel',
    'centralamericanindianlanguage'                          => 'cai',
    'centralmoroccotamazight'                                => 'tzm',
    'chagatai'                                               => 'chg',
    'chamiclanguage'                                         => 'cmc',
    'chamorro'                                               => 'ch',
    'chechen'                                                => 'ce',
    'cherokee'                                               => 'chr',
    'cheyenne'                                               => 'chy',
    'chibcha'                                                => 'chb',
    'chiga'                                                  => 'cgg',
    'chinookjargon'                                          => 'chn',
    'chipewyan'                                              => 'chp',
    'choctaw'                                                => 'cho',
    'churchslavic'                                           => 'cu',
    'chuukese'                                               => 'chk',
    'chuvash'                                                => 'cv',
    'classicalnewari'                                        => 'nwc',
    'classicalsyriac'                                        => 'syc',
    'colognian'                                              => 'ksh',
    'comorian'                                               => 'swb',
    'congoswahili'                                           => 'swc',
    'coptic'                                                 => 'cop',
    'cornish'                                                => 'kw',
    'cree'                                                   => 'cr',
    'creek'                                                  => 'mus',
    'creoleorpidgin'                                         => 'crp',
    'crimeanturkish'                                         => 'crh',
    'cushiticlanguage'                                       => 'cus',
    'dakota'                                                 => 'dak',
    'dargwa'                                                 => 'dar',
    'dayak'                                                  => 'day',
    'delaware'                                               => 'del',
    'dinka'                                                  => 'din',
    'divehi'                                                 => 'dv',
    'dogri'                                                  => 'doi',
    'dogrib'                                                 => 'dgr',
    'dravidianlanguage'                                      => 'dra',
    'duala'                                                  => 'dua',
    'dyula'                                                  => 'dyu',
    'easternfrisian'                                         => 'frs',
    'efik'                                                   => 'efi',
    'ekajuk'                                                 => 'eka',
    'elamite'                                                => 'elx',
    'embu'                                                   => 'ebu',
    'englishbasedcreoleorpidgin'                             => 'cpe',
    'erzya'                                                  => 'myv',
    'ewe'                                                    => 'ee',
    'ewondo'                                                 => 'ewo',
    'fang'                                                   => 'fan',
    'fanti'                                                  => 'fat',
    'finnougrianlanguage'                                    => 'fiu',
    'flemish'                                                => 'nl_be',
    'fon'                                                    => 'fon',
    'frenchbasedcreoleorpidgin'                              => 'cpf',
    'friulian'                                               => 'fur',
    'fulah'                                                  => 'ff',
    'ga'                                                     => 'gaa',
    'ganda'                                                  => 'lg',
    'gayo'                                                   => 'gay',
    'gbaya'                                                  => 'gba',
    'geez'                                                   => 'gez',
    'germaniclanguage'                                       => 'gem',
    'gilbertese'                                             => 'gil',
    'gondi'                                                  => 'gon',
    'gorontalo'                                              => 'gor',
    'gothic'                                                 => 'got',
    'grebo'                                                  => 'grb',
    'gusii'                                                  => 'guz',
    "gwich\Ê\¼in"                                          => 'gwi',
    'haida'                                                  => 'hai',
    'haitian'                                                => 'ht',
    'hawaiian'                                               => 'haw',
    'herero'                                                 => 'hz',
    'hiligaynon'                                             => 'hil',
    'himachali'                                              => 'him',
    'hirimotu'                                               => 'ho',
    'hittite'                                                => 'hit',
    'hmong'                                                  => 'hmn',
    'hupa'                                                   => 'hup',
    'iban'                                                   => 'iba',
    'iberianspanish'                                         => 'es_es',
    'ido'                                                    => 'io',
    'igbo'                                                   => 'ig',
    'ijo'                                                    => 'ijo',
    'iloko'                                                  => 'ilo',
    'inarisami'                                              => 'smn',
    'indiclanguage'                                          => 'inc',
    'indoeuropeanlanguage'                                   => 'ine',
    'ingush'                                                 => 'inh',
    'iranianlanguage'                                        => 'ira',
    'iroquoianlanguage'                                      => 'iro',
    'jju'                                                    => 'kaj',
    'jolafonyi'                                              => 'dyo',
    'judeoarabic'                                            => 'jrb',
    'judeopersian'                                           => 'jpr',
    'kabardian'                                              => 'kbd',
    'kabuverdianu'                                           => 'kea',
    'kabyle'                                                 => 'kab',
    'kachin'                                                 => 'kac',
    'kalenjin'                                               => 'kln',
    'kalmyk'                                                 => 'xal',
    'kamba'                                                  => 'kam',
    'kanuri'                                                 => 'kr',
    'karachaybalkar'                                         => 'krc',
    'karakalpak'                                             => 'kaa',
    'karelian'                                               => 'krl',
    'karen'                                                  => 'kar',
    'kashubian'                                              => 'csb',
    'kawi'                                                   => 'kaw',
    'khasi'                                                  => 'kha',
    'khoisanlanguage'                                        => 'khi',
    'khotanese'                                              => 'kho',
    'kikuyu'                                                 => 'ki',
    'kimbundu'                                               => 'kmb',
    'komi'                                                   => 'kv',
    'kongo'                                                  => 'kg',
    'konkani'                                                => 'kok',
    'koro'                                                   => 'kfo',
    'kosraean'                                               => 'kos',
    'koyraborosenni'                                         => 'ses',
    'koyrachiini'                                            => 'khq',
    'kpelle'                                                 => 'kpe',
    'kru'                                                    => 'kro',
    'kuanyama'                                               => 'kj',
    'kumyk'                                                  => 'kum',
    'kurukh'                                                 => 'kru',
    'kutenai'                                                => 'kut',
    'kwasio'                                                 => 'nmg',
    'ladino'                                                 => 'lad',
    'lahnda'                                                 => 'lah',
    'lamba'                                                  => 'lam',
    'langi'                                                  => 'lag',
    'lezghian'                                               => 'lez',
    'limburgish'                                             => 'li',
    'lojban'                                                 => 'jbo',
    'lowersorbian'                                           => 'dsb',
    'lowgerman'                                              => 'nds',
    'lozi'                                                   => 'loz',
    'lubakatanga'                                            => 'lu',
    'lubalulua'                                              => 'lua',
    'luiseno'                                                => 'lui',
    'lulesami'                                               => 'smj',
    'lunda'                                                  => 'lun',
    'luo'                                                    => 'luo',
    'lushai'                                                 => 'lus',
    'luxembourgish'                                          => 'lb',
    'luyia'                                                  => 'luy',
    'machame'                                                => 'jmc',
    'madurese'                                               => 'mad',
    'magahi'                                                 => 'mag',
    'maithili'                                               => 'mai',
    'makasar'                                                => 'mak',
    'makhuwameetto'                                          => 'mgh',
    'makonde'                                                => 'kde',
    'manchu'                                                 => 'mnc',
    'mandar'                                                 => 'mdr',
    'mandingo'                                               => 'man',
    'manipuri'                                               => 'mni',
    'manobolanguage'                                         => 'mno',
    'manx'                                                   => 'gv',
    'mari'                                                   => 'chm',
    'marshallese'                                            => 'mh',
    'marwari'                                                => 'mwr',
    'masai'                                                  => 'mas',
    'mayanlanguage'                                          => 'myn',
    'mende'                                                  => 'men',
    'meru'                                                   => 'mer',
    'micmac'                                                 => 'mic',
    'middledutch'                                            => 'dum',
    'middleenglish'                                          => 'enm',
    'middlefrench'                                           => 'frm',
    'middlehighgerman'                                       => 'gmh',
    'middleirish'                                            => 'mga',
    'minangkabau'                                            => 'min',
    'mirandese'                                              => 'mwl',
    'miscellaneouslanguage'                                  => 'mis',
    'mohawk'                                                 => 'moh',
    'moksha'                                                 => 'mdf',
    'mongo'                                                  => 'lol',
    'monkhmerlanguage'                                       => 'mkh',
    'morisyen'                                               => 'mfe',
    'mossi'                                                  => 'mos',
    'multiplelanguages'                                      => 'mul',
    'mundalanguage'                                          => 'mun',
    'mundang'                                                => 'mua',
    'nahuatl'                                                => 'nah',
    'nama'                                                   => 'naq',
    'navajo'                                                 => 'nv',
    'ndonga'                                                 => 'ng',
    'neapolitan'                                             => 'nap',
    'newari'                                                 => 'new',
    'nias'                                                   => 'nia',
    'nigerkordofanianlanguage'                               => 'nic',
    'nilosaharanlanguage'                                    => 'ssa',
    'niuean'                                                 => 'niu',
    'nogai'                                                  => 'nog',
    'nolinguisticcontent'                                    => 'zxx',
    'northamericanindianlanguage'                            => 'nai',
    'northernfrisian'                                        => 'frr',
    'northernsami'                                           => 'se',
    'northernsotho'                                          => 'nso',
    'northndebele'                                           => 'nd',
    "norwegianbokm\Ã\¥l"                                   => 'nb',
    'nubianlanguage'                                         => 'nub',
    'nuer'                                                   => 'nus',
    'nyamwezi'                                               => 'nym',
    'nyanja'                                                 => 'ny',
    'nyankole'                                               => 'nyn',
    'nyasatonga'                                             => 'tog',
    'nyoro'                                                  => 'nyo',
    'nzima'                                                  => 'nzi',
    "n\â\\ko"                                           => 'nqo',
    'ojibwa'                                                 => 'oj',
    'oldenglish'                                             => 'ang',
    'oldfrench'                                              => 'fro',
    'oldhighgerman'                                          => 'goh',
    'oldirish'                                               => 'sga',
    'oldnorse'                                               => 'non',
    'oldpersian'                                             => 'peo',
    "oldproven\Ã\§al"                                      => 'pro',
    'osage'                                                  => 'osa',
    'ossetic'                                                => 'os',
    'otomianlanguage'                                        => 'oto',
    'ottomanturkish'                                         => 'ota',
    'pahlavi'                                                => 'pal',
    'palauan'                                                => 'pau',
    'pali'                                                   => 'pi',
    'pampanga'                                               => 'pam',
    'pangasinan'                                             => 'pag',
    'papiamento'                                             => 'pap',
    'papuanlanguage'                                         => 'paa',
    'philippinelanguage'                                     => 'phi',
    'phoenician'                                             => 'phn',
    'pohnpeian'                                              => 'pon',
    'portuguesebasedcreoleorpidgin'                          => 'cpp',
    'prakritlanguage'                                        => 'pra',
    'rajasthani'                                             => 'raj',
    'rapanui'                                                => 'rap',
    'rarotongan'                                             => 'rar',
    'romancelanguage'                                        => 'roa',
    'romany'                                                 => 'rom',
    'rombo'                                                  => 'rof',
    'rwa'                                                    => 'rwk',
    'saho'                                                   => 'ssy',
    'sakha'                                                  => 'sah',
    'salishanlanguage'                                       => 'sal',
    'samaritanaramaic'                                       => 'sam',
    'samburu'                                                => 'saq',
    'samilanguage'                                           => 'smi',
    'sandawe'                                                => 'sad',
    'sangu'                                                  => 'sbp',
    'santali'                                                => 'sat',
    'sardinian'                                              => 'sc',
    'sasak'                                                  => 'sas',
    'scots'                                                  => 'sco',
    'selkup'                                                 => 'sel',
    'semiticlanguage'                                        => 'sem',
    'sena'                                                   => 'seh',
    'seneca'                                                 => 'see',
    'serer'                                                  => 'srr',
    'shambala'                                               => 'ksb',
    'shan'                                                   => 'shn',
    'sichuanyi'                                              => 'ii',
    'sicilian'                                               => 'scn',
    'sidamo'                                                 => 'sid',
    'signlanguage'                                           => 'sgn',
    'siksika'                                                => 'bla',
    'sinotibetanlanguage'                                    => 'sit',
    'siouanlanguage'                                         => 'sio',
    'skoltsami'                                              => 'sms',
    'slave'                                                  => 'den',
    'slaviclanguage'                                         => 'sla',
    'soga'                                                   => 'xog',
    'sogdien'                                                => 'sog',
    'songhai'                                                => 'son',
    'soninke'                                                => 'snk',
    'sorbianlanguage'                                        => 'wen',
    'southamericanindianlanguage'                            => 'sai',
    'southernaltai'                                          => 'alt',
    'southernsami'                                           => 'sma',
    'southndebele'                                           => 'nr',
    'sranantongo'                                            => 'srn',
    'sukuma'                                                 => 'suk',
    'sumerian'                                               => 'sux',
    'susu'                                                   => 'sus',
    'swissfrench'                                            => 'fr_ch',
    'swissgerman'                                            => 'gsw',
    'swisshighgerman'                                        => 'de_ch',
    'syriac'                                                 => 'syr',
    'tachelhit'                                              => 'shi',
    'tahitian'                                               => 'ty',
    'tailanguage'                                            => 'tai',
    'taita'                                                  => 'dav',
    'tamashek'                                               => 'tmh',
    'taroko'                                                 => 'trv',
    'tasawaq'                                                => 'twq',
    'tereno'                                                 => 'ter',
    'teso'                                                   => 'teo',
    'tetum'                                                  => 'tet',
    'tigre'                                                  => 'tig',
    'timne'                                                  => 'tem',
    'tiv'                                                    => 'tiv',
    'tlingit'                                                => 'tli',
    'tokelau'                                                => 'tkl',
    'tokpisin'                                               => 'tpi',
    'tsimshian'                                              => 'tsi',
    'tumbuka'                                                => 'tum',
    'tupilanguage'                                           => 'tup',
    'tuvalu'                                                 => 'tvl',
    'tuvinian'                                               => 'tyv',
    'tyap'                                                   => 'kcg',
    "u\.s\.english"                                          => 'en_us',
    'udmurt'                                                 => 'udm',
    'ugaritic'                                               => 'uga',
    'umbundu'                                                => 'umb',
    'unknownlanguage'                                        => 'und',
    'uppersorbian'                                           => 'hsb',
    'vai'                                                    => 'vai',
    'venda'                                                  => 've',
    'votic'                                                  => 'vot',
    'vunjo'                                                  => 'vun',
    'wakashanlanguage'                                       => 'wak',
    'walamo'                                                 => 'wal',
    'walloon'                                                => 'wa',
    'walser'                                                 => 'wae',
    'waray'                                                  => 'war',
    'washo'                                                  => 'was',
    'yangben'                                                => 'yav',
    'yao'                                                    => 'yao',
    'yapese'                                                 => 'yap',
    'yupiklanguage'                                          => 'ypk',
    'zande'                                                  => 'znd',
    'zapotec'                                                => 'zap',
    'zarma'                                                  => 'dje',
    'zaza'                                                   => 'zza',
    'zenaga'                                                 => 'zen',
    'zuni'                                                   => 'zun',
    'ກລິງກອງ'                                  => 'tlh',
    'ກັນນາດາ'                                  => 'kn',
    'ກາຕາລັງ'                                  => 'ca',
    'ກາລິດ'                                        => 'gl',
    'ກຳປູເຈຍ'                                  => 'km',
    'ກູຊາຣາຕີ'                               => 'gu',
    'ກົວຣານີ'                                  => 'gn',
    'ກຼີນແລນດິດ'                         => 'kl',
    'ກເຣັກ'                                        => 'el',
    'ຄັດຊະມີລີ'                            => 'ks',
    'ຄາຊັກ'                                        => 'kk',
    'ຄິນຍາວັນດາ'                         => 'rw',
    'ຄິລັນສີ'                                  => 'rn',
    'ຄິວຊົວ'                                     => 'qu',
    'ຄໍຊິກ້າ'                                  => 'co',
    'ຈວງ'                                              => 'za',
    'ຈີນ'                                              => 'zh',
    'ຊວາ'                                              => 'jv',
    'ຊວາຮີລີ'                                  => 'sw',
    'ຊອກຊີ'                                        => 'ka',
    'ຊອງກາ'                                        => 'ts',
    'ຊັນດານ'                                     => 'su',
    'ຊາມົວ'                                        => 'sm',
    'ຊິສວາຕິ'                                  => 'ss',
    'ຊູລູ'                                           => 'zu',
    'ຊູແອັດ'                                     => 'sv',
    'ຍິວ'                                              => 'he',
    'ຍີ່ປຸ່ນ'                                  => 'ja',
    'ຕວກກີ'                                        => 'tr',
    'ຕວີ'                                              => 'tw',
    'ຕວຽກເມນ'                                  => 'tk',
    'ຕາກາລັອກ'                               => 'tl',
    'ຕາກາລ໊ອກ'                               => 'fil',
    'ຕາດ'                                              => 'tt',
    'ຕີກຣິນຢາ'                               => 'ti',
    'ທອງກ້າ'                                     => 'to',
    'ທະມິນ'                                        => 'ta',
    'ທາຈິດ'                                        => 'tg',
    'ທິເບດ'                                        => 'bo',
    'ນອກແວ'                                        => 'no',
    'ນອກແວນີນອກ'                         => 'nn',
    'ນໍລູ'                                           => 'na',
    'ບອສນີ'                                        => 'bs',
    'ບັສເກີ'                                     => 'eu',
    'ບາສສີ'                                        => 'ba',
    'ບິສລາມາ'                                  => 'bi',
    'ບີຮາຣີ'                                     => 'bh',
    'ບຸນກາຣີ'                                  => 'bg',
    'ບເຣີຕົງ'                                  => 'br',
    'ປອກຕຸຍການ'                            => 'pt',
    'ປອກຕຸຍການບຣາຊີນ'          => 'pt_br',
    'ປອກຕຸຍການປອກຕຸຍການ' => 'pt_pt',
    'ປັນຈາບ'                                     => 'pa',
    'ປາສໂຕ'                                        => 'ps',
    'ຝຣັ່ງ'                                        => 'fr',
    'ພະມ່າ'                                        => 'my',
    'ພູຖານີ'                                     => 'dz',
    'ຟຣີຊຽນ'                                     => 'fy',
    'ຟາໂຣ'                                           => 'fo',
    'ຟິຈິ'                                           => 'fj',
    'ມານຕາ'                                        => 'mt',
    'ມາຣາທີ'                                     => 'mr',
    'ມາລາກາຊິ'                               => 'mg',
    'ມາລາຢາລຳ'                               => 'ml',
    'ມາເຊໂດນີ'                               => 'mk',
    'ມາເລ'                                           => 'ms',
    'ມົງໂກນ'                                     => 'mn',
    'ຢິດດິສ'                                     => 'yi',
    'ລັດເຊຍ'                                     => 'ru',
    'ລັດເວຍ'                                     => 'lv',
    'ລາວ'                                              => 'lo',
    'ລາແຕັງ'                                     => 'la',
    'ລິງກາລາ'                                  => 'ln',
    'ລີທົວນີ'                                  => 'lt',
    'ວູບ'                                              => 'wo',
    'ສະກັອດແກລິກ'                      => 'gd',
    'ສະໂລວັກກີ'                            => 'sk',
    'ສະໂລວານີ'                               => 'sl',
    'ສັນສະກິດ'                               => 'sa',
    'ສັນໂຄ'                                        => 'sg',
    'ສິງຫານ'                                     => 'si',
    'ສິນທິ'                                        => 'sd',
    'ຫວຽດນາມ'                                  => 'vi',
    'ອັງກິດ'                                     => 'en',
    'ອັຟຣິກາ'                                  => 'af',
    'ອັສສຳ'                                        => 'as',
    'ອາກເມນີ'                                  => 'hy',
    'ອານບານີ'                                  => 'sq',
    'ອາຟາ'                                           => 'aa',
    'ອາຣັບ'                                        => 'ar',
    'ອາແຊກບາຍຊານ'                      => 'az',
    'ອຳຫາຣິກ'                                  => 'am',
    'ອິນເຕີລິງ'                            => 'ie',
    'ອິນເຕີລິງກາ'                      => 'ia',
    'ອິນໂດເນເຊຍ'                         => 'id',
    'ອິສລັງ'                                     => 'is',
    'ອີຕາລີ'                                     => 'it',
    'ອຸຍເຄີ'                                     => 'ug',
    'ອຸດຊະເບັກກິດສະຖານ'    => 'uz',
    'ອູຣະດູ'                                     => 'ur',
    'ອູແກຣນ'                                     => 'uk',
    'ອົກຊີຕານ'                               => 'oc',
    'ຮັງກາຣີ'                                  => 'hu',
    'ຮິນດູ'                                        => 'hi',
    'ເກຍກິສ'                                     => 'ky',
    'ເກົາຫຼີ'                                  => 'ko',
    'ເຄີດິສ'                                     => 'ku',
    'ເຊຕະສະວານາ'                         => 'tn',
    'ເຊັກ'                                           => 'cs',
    'ເຊໂຊໂທ'                                     => 'st',
    'ເຍຍລະມັນ'                               => 'de',
    'ເດັນມາກ'                                  => 'da',
    'ເຕລູກູ'                                     => 'te',
    'ເນປານ'                                        => 'ne',
    'ເບລາລຸດຊີ'                            => 'be',
    'ເບັງການ'                                  => 'bn',
    'ເປີເຊຍ'                                     => 'fa',
    'ເມົາລີ'                                     => 'mi',
    'ເລໂຕໂລແມນ'                            => 'rm',
    'ເອສເປຣັງໂຕ'                         => 'eo',
    'ເອສໂຕນີ'                                  => 'et',
    'ແຊກບີ'                                        => 'sr',
    'ແຊັກໂບໂກຣແອັດ'                => 'sh',
    'ແຟງລັງ'                                     => 'fi',
    'ແວວ'                                              => 'cy',
    'ແອບຄາເຊຍ'                               => 'ab',
    'ແອສປາໂຍນ'                               => 'es',
    'ໂກຣອາຊີ'                                  => 'hr',
    'ໂຊຊາ'                                           => 'xh',
    'ໂຊນາ'                                           => 'sn',
    'ໂຊມາລີ'                                     => 'so',
    'ໂປໂລຍ'                                        => 'pl',
    'ໂມຄາເວຍ'                                  => 'mo',
    'ໂຢລູບາ'                                     => 'yo',
    'ໂຣມານີ'                                     => 'ro',
    'ໂວລາພຸກ'                                  => 'vo',
    'ໂອຊາ'                                           => 'ha',
    'ໂອຣີຢາ'                                     => 'or',
    'ໂອໂລໂມອາຟານ'                      => 'om',
    'ໂຮນລັງ'                                     => 'nl',
    'ໄທ'                                                 => 'th',
    'ໄອນຸກຕິຕັກ'                         => 'iu',
    'ໄອນູປຽກ'                                  => 'ik',
    'ໄອມາລາ'                                     => 'ay',
    'ໄອແລນ'                                        => 'ga',
);

1;
