#!/bin/bash

dobuild=0
doprep=0
dotest=0
doinstall=0

srcdir=$(pwd)

while [ $# -gt 0 ]; do
    case "$1" in
        --build|-b)
            dobuild=1
            shift
        ;;

        --prep|-p)
            doprep=1
            shift
        ;;

        --test|-t)
            dotest=1
            shift
        ;;

        --install|-i)
            doinstall=1
            shift
        ;;

    esac
done

if [ ${dobuild} -eq 0 -a ${doprep} -eq 0 -a ${dotest} -eq 0 -a ${doinstall} -eq 0 ]; then
    dobuild=1
    doprep=1
    dotest=1
    doinstall=1
fi

# Rebuilds the entire foo in one go. One shot, one kill.
rm -rf build/
mkdir -p build
cd build
if [ ${doprep} -eq 1 ]; then
    cmake \
        -DCMAKE_VERBOSE_MAKEFILE=ON \
        -DCMAKE_INSTALL_PREFIX=/usr \
        -DINCLUDE_INSTALL_DIR=/usr/include \
        -DLIB_INSTALL_DIR=/usr/lib64 \
        -DPHP_BINDINGS=ON \
        -DPYTHON_BINDINGS=ON \
        ..
fi

if [ ${dobuild} -eq 1 ]; then
    make
fi

if [ ${dotest} -eq 1 ]; then
    # Execute some tests?

    pushd tests
    ./bindingstest
    ./conversiontest
    ./parsingtest
    popd

    if [ -f "${srcdir}/build/src/csharp/test.exe" ]; then
       LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$(pwd)/build/src/csharp/ MONO_LOG_LEVEL=debug mono ${srcdir}/build/src/csharp/test.exe
    fi

    if [ -f "${srcdir}/build/src/php/test.php" ]; then
        php -d enable_dl=On -dextension=${srcdir}/build/src/php/kolabformat.so ${srcdir}/build/src/php/test.php
    fi

    if [ -f "${srcdir}/build/src/python/test.py" ]; then
        python ${srcdir}/build/src/python/test.py
    fi
fi

if [ ${doinstall} -eq 1 ]; then
    make install DESTDIR=${TMPDIR:-/tmp}
fi

cd ..

git archive --prefix=libkolabxml-0.7.0/ HEAD | gzip -c > libkolabxml-0.7.0.tar.gz

cp libkolabxml-0.7.0.tar.gz `rpm --eval='%{_sourcedir}'`

