#!/bin/sh -e
# called by uscan with '--upstream-version' <version> <file>

VERSION=$2
TAR=../libjoda-time-java_$VERSION.orig.tar.gz
DIR=joda-time-$VERSION

# clean up the upstream tarball
tar zxvf $3
mv joda-time-$VERSION $DIR
GZIP=--best tar -czf $TAR --exclude '*.jar' $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
