/* SynchronizedRandom.java -- Thread-safe IRandom wrapper.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This file is a part of Jessie.

Jessie is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Jessie is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Jessie; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie.provider;

import java.util.Map;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;

class SynchronizedRandom implements IRandom
{

  // Field.
  // -------------------------------------------------------------------------

  private final IRandom random;

  // Constructor.
  // -------------------------------------------------------------------------

  SynchronizedRandom(IRandom random)
  {
    this.random = random;
  }

  // Instance methods.
  // -------------------------------------------------------------------------

  public String name()
  {
    return random.name();
  }

  public synchronized void init(Map attrib)
  {
    random.init(attrib);
  }

  public synchronized byte nextByte()
    throws IllegalStateException, LimitReachedException
  {
    return random.nextByte();
  }

  public synchronized void nextBytes(byte[] buf, int off, int len)
    throws IllegalStateException, LimitReachedException
  {
    random.nextBytes(buf, off, len);
  }

  public synchronized Object clone()
  {
    return new SynchronizedRandom((IRandom) random.clone());
  }
}
