/* SSLServerSocketFactory.java -- factory for SSL server sockets.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This file is a part of Jessie.

Jessie is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Jessie is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Jessie; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie.provider;

import java.io.IOException;

import java.net.InetAddress;
import java.net.ServerSocket;

import java.security.SecureRandom;

import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

import org.metastatic.jessie.SRPTrustManager;

class SSLServerSocketFactory extends javax.net.ssl.SSLServerSocketFactory
{

  // Fields.
  // -------------------------------------------------------------------------

  private final SessionContext sessions;
  private final X509KeyManager keyManager;
  private final X509TrustManager trustManager;
  private final SRPTrustManager srpTrustManager;
  private final SecureRandom random;

  // Constructor.
  // -------------------------------------------------------------------------

  SSLServerSocketFactory(X509TrustManager trustManager,
                         SRPTrustManager srpTrustManager,
                         X509KeyManager keyManager,
                         SecureRandom random,
                         SessionContext sessions)
  {
    super();
    this.trustManager = trustManager;
    this.srpTrustManager = srpTrustManager;
    this.keyManager = keyManager;
    this.random = random;
    this.sessions = sessions;
  }

  // Instance methods.
  // -------------------------------------------------------------------------

  public String[] getDefaultCipherSuites()
  {
    return getSupportedCipherSuites();
  }

  public String[] getSupportedCipherSuites()
  {
    return (String[]) CipherSuite.availableSuiteNames().toArray(new String[0]);
  }

  public ServerSocket createServerSocket() throws IOException
  {
    SSLServerSocket socket = new SSLServerSocket();
    setup(socket);
    return socket;
  }

  public ServerSocket createServerSocket(int port) throws IOException
  {
    SSLServerSocket socket = new SSLServerSocket(port);
    setup(socket);
    return socket;
  }

  public ServerSocket createServerSocket(int port, int backlog)
    throws IOException
  {
    SSLServerSocket socket = new SSLServerSocket(port, backlog);
    setup(socket);
    return socket;
  }

  public ServerSocket createServerSocket(int port, int backlog, InetAddress addr)
    throws IOException
  {
    SSLServerSocket socket = new SSLServerSocket(port, backlog, addr);
    setup(socket);
    return socket;
  }

  // Own methods.
  // -------------------------------------------------------------------------

  private void setup(SSLServerSocket socket)
  {
    socket.setSessionContext(sessions);
    socket.setKeyManager(keyManager);
    socket.setTrustManager(trustManager);
    socket.setSRPTrustManager(srpTrustManager);
    socket.setRandom(random);
  }
}
