/* CertificateType.java -- the certificate type extension.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie.provider;

import java.io.EOFException;
import java.io.InputStream;
import java.io.IOException;

final class CertificateType implements Enumerated
{

  // Constants and fields.
  // -------------------------------------------------------------------------

  static final CertificateType X509     = new CertificateType(0);
  static final CertificateType OPEN_PGP = new CertificateType(1);

  private final int value;

  // Constructor.
  // -------------------------------------------------------------------------

  private CertificateType(int value)
  {
    this.value = value;
  }

  // Class method.
  // -------------------------------------------------------------------------

  static CertificateType read(InputStream in) throws IOException
  {
    int value = in.read();
    if (value == -1)
      {
        throw new EOFException("unexpected end of input stream");
      }
    switch (value & 0xFF)
      {
      case 0: return X509;
      case 1: return OPEN_PGP;
      default: return new CertificateType(value);
      }
  }

  // Instance methods.
  // -------------------------------------------------------------------------

  public byte[] getEncoded()
  {
    return new byte[] { (byte) value };
  }

  public int getValue()
  {
    return value;
  }

  public String toString()
  {
    switch (value)
      {
      case 0: return "X.509";
      case 1: return "OpenPGP";
      default: return "unknown(" + value + ")";
      }
  }
}
