/* NullManagerParameters.java -- parameters for empty managers.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This file is a part of Jessie.

Jessie is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Jessie is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Jessie; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie;

import javax.net.ssl.ManagerFactoryParameters;

/**
 * This empty class can be used to initialize {@link
 * javax.net.ssl.KeyManagerFactory} and {@link
 * javax.net.ssl.TrustManagerFactory} instances for the ``JessieX509''
 * algorithm, for cases when no keys or trusted certificates are
 * desired or needed.
 *
 * <p>This is the default manager parameters object used in {@link
 * javax.net.ssl.KeyManagerFactory} instances if no key stores are
 * specified through security properties.
 */
public final class NullManagerParameters implements ManagerFactoryParameters
{
}
