/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class BeanObjectDescription
extends AbstractObjectDescription {
    private TreeSet ignoredParameters = new TreeSet();
    private transient HashMap properties;

    public BeanObjectDescription(Class className) {
        this(className, true);
    }

    public BeanObjectDescription(Class className, boolean init) {
        super(className);
        this.readBeanDescription(className, init);
    }

    public Object createObject() {
        try {
            Object o = this.getObjectClass().newInstance();
            Iterator it = this.getParameterNames();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (this.isParameterIgnored(name)) continue;
                Method method = this.findSetMethod(name);
                Object parameterValue = this.getParameter(name);
                if (parameterValue == null) continue;
                method.invoke(o, parameterValue);
            }
            return o;
        }
        catch (Exception e) {
            Log.error((Object)"Unable to invoke bean method", (Exception)e);
            return null;
        }
    }

    private Method findGetMethod(String parameterName) {
        PropertyDescriptor descriptor = (PropertyDescriptor)this.properties.get(parameterName);
        return descriptor.getReadMethod();
    }

    private Method findSetMethod(String parameterName) {
        PropertyDescriptor descriptor = (PropertyDescriptor)this.properties.get(parameterName);
        return descriptor.getWriteMethod();
    }

    protected void ignoreParameter(String parameter) {
        this.ignoredParameters.add(parameter);
    }

    protected boolean isParameterIgnored(String parameter) {
        return this.ignoredParameters.contains(parameter);
    }

    private boolean isValidMethod(Method method, int parCount) {
        if (method == null) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return method.getParameterTypes().length == parCount;
    }

    private void readBeanDescription(Class className, boolean init) {
        try {
            this.properties = new HashMap();
            BeanInfo bi = Introspector.getBeanInfo(className);
            PropertyDescriptor[] propertyDescriptors = bi.getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescriptors.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                Method readMethod = propertyDescriptor.getReadMethod();
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (this.isValidMethod(readMethod, 0) && this.isValidMethod(writeMethod, 1)) {
                    String name = propertyDescriptor.getName();
                    this.properties.put(name, propertyDescriptor);
                    if (init) {
                        super.setParameterDefinition(name, propertyDescriptor.getPropertyType());
                    }
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            Log.error((Object)"Unable to build bean description", (Exception)e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readBeanDescription(this.getObjectClass(), false);
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new NullPointerException("Given object is null");
        }
        Class c = this.getObjectClass();
        if (!c.isInstance(o)) {
            throw new ObjectFactoryException("Object is no instance of " + c + "(is " + o.getClass() + ")");
        }
        Iterator it = this.getParameterNames();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if (this.isParameterIgnored(propertyName)) continue;
            try {
                Method method = this.findGetMethod(propertyName);
                Object retval = method.invoke(o, null);
                if (retval == null) continue;
                this.setParameter(propertyName, retval);
            }
            catch (Exception e) {
                Log.info((Object)"Exception on method invokation.", (Exception)e);
            }
        }
    }
}

