/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.javaee.metadata.support;

import javax.xml.bind.annotation.XmlTransient;


/**
 * IdMetaDataImplWithDescriptionGroup.
 *
 * @param <T> the overriden type
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public abstract class IdMetaDataImplWithDescriptionGroupWithOverride<T> extends IdMetaDataImplWithDescriptionGroup implements OverrideMetaData<T>
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 7273605180933967019L;
   
   /** The overriden metadata */
   private T data;
   
   public T getOverridenMetaData()
   {
      return data;
   }
   
   /**
    * Get the override metadata
    * 
    * @return the data
    * @throws IllegalStateException when not set
    */
   protected T getOverridenMetaDataWithCheck()
   {
      if (data == null)
         throw new IllegalStateException("Override metadata has not been set " + this);
      return data;
   }

   //@SchemaProperty(ignore=true)
   @XmlTransient
   public void setOverridenMetaData(T data)
   {
      if (data == null)
         throw new IllegalArgumentException("Null data");
      this.data = data;
   }
}
