package org.jboss.cache.loader;

import org.jboss.cache.Cache;
import org.jboss.cache.config.CacheLoaderConfig.IndividualCacheLoaderConfig;

public class LocalDelegatingCacheLoaderConfig extends IndividualCacheLoaderConfig
{
   private static final long serialVersionUID = 4626734068542420865L;

   private transient Cache delegate;

   public LocalDelegatingCacheLoaderConfig()
   {
      setClassName(LocalDelegatingCacheLoader.class.getName());
   }

   /**
    * For use by {@link org.jboss.cache.loader.FileCacheLoader}.
    *
    * @param base generic config object created by XML parsing.
    */
   LocalDelegatingCacheLoaderConfig(IndividualCacheLoaderConfig base)
   {
      setClassName(LocalDelegatingCacheLoader.class.getName());
      populateFromBaseConfig(base);
   }

   @Override
   public boolean equals(Object obj)
   {
      return obj instanceof LocalDelegatingCacheLoaderConfig && equalsExcludingProperties(obj) && delegate == ((LocalDelegatingCacheLoaderConfig) obj).delegate;
   }

   @Override
   public int hashCode()
   {
      return 31 * hashCodeExcludingProperties() + (delegate == null ? 0 : delegate.hashCode());
   }

   @Override
   public LocalDelegatingCacheLoaderConfig clone() throws CloneNotSupportedException
   {
      LocalDelegatingCacheLoaderConfig clone = (LocalDelegatingCacheLoaderConfig) super.clone();
      clone.delegate = delegate;
      return clone;
   }

   public Cache getDelegate()
   {
      return delegate;
   }

   public void setDelegate(Cache delegate)
   {
      this.delegate = delegate;
   }
}