/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  tearoffmenuitem.cc - GtkTearoffMenuItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "tearoffmenuitem.h"
#include "private/tearoffmenuitem_p.h"

using namespace Inti;

/*  Gtk::TearoffMenuItem
 */

Gtk::TearoffMenuItem::TearoffMenuItem(GtkTearoffMenuItem *tearoff_menu_item, bool reference)
: MenuItem((GtkMenuItem*)tearoff_menu_item, reference)
{
}

Gtk::TearoffMenuItem::TearoffMenuItem() 
: MenuItem((GtkMenuItem*)TearoffMenuItemClass::create())
{
}

Gtk::TearoffMenuItem::~TearoffMenuItem()
{
}

GtkTearoffMenuItemClass* 
Gtk::TearoffMenuItem::gtk_tearoff_menu_item_class() const 
{ 
	return get_class<GtkTearoffMenuItemClass>(); 
}
	
Gtk::TearoffMenuItem::operator GtkTearoffMenuItem* () const 
{ 
	return this ? gtk_tearoff_menu_item() : 0; 
}

bool
Gtk::TearoffMenuItem::is_torn_off() const
{
	return gtk_tearoff_menu_item()->torn_off;
}

/*  Gtk::TearoffMenuItemClass
 */

void
Gtk::TearoffMenuItemClass::init(GtkTearoffMenuItemClass *g_class)
{
	MenuItemClass::init((GtkMenuItemClass*)g_class);
}

GType
Gtk::TearoffMenuItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TEAROFF_MENU_ITEM, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::TearoffMenuItemClass::create()
{
	return g_object_new(get_type(), 0);
}

