/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  eventbox.cc - GtkEventBox C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "eventbox.h"
#include "private/eventbox_p.h"

using namespace Inti;

/*  Gtk::EventBox
 */

Gtk::EventBox::EventBox(GtkEventBox *event_box, bool reference)
: Bin((GtkBin*)event_box, reference)
{
}

Gtk::EventBox::EventBox() 
: Bin((GtkBin*)EventBoxClass::create())
{
}

Gtk::EventBox::~EventBox()
{
}

GtkEventBoxClass* 
Gtk::EventBox::gtk_event_box_class() const 
{ 
	return get_class<GtkEventBoxClass>(); 
}
	
Gtk::EventBox::operator GtkEventBox* () const 
{ 
	return this ? gtk_event_box() : 0; 
}
	
/*  Gtk::EventBoxClass
 */

void
Gtk::EventBoxClass::init(GtkEventBoxClass *g_class)
{
	BinClass::init((GtkBinClass*)g_class);
}

GType
Gtk::EventBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_EVENT_BOX, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::EventBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

