/* iksemel (XML parser for Jabber)
** Copyright (C) 2000-2003 Gurer Ozen <madcat@e-kolay.net>
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
*/

/* recoding this in a more portable way is left as an exercise to the reader :p */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <sys/time.h>

/* timing functions */

static struct timeval start_tv;

void
t_reset (void)
{
	gettimeofday (&start_tv, NULL);
}

unsigned long
t_elapsed (void)
{
	unsigned long msec;
	struct timeval cur_tv;

	gettimeofday (&cur_tv, NULL);
	msec = (cur_tv.tv_sec * 1000) + (cur_tv.tv_usec / 1000);
	msec -= (start_tv.tv_sec * 1000) + (start_tv.tv_usec / 1000);
	return msec;
}

/* memory functions */

int
m_used (void)
{
	struct mallinfo mi;

	mi = mallinfo ();
	return mi.uordblks;
}

int
m_arena (void)
{
	struct mallinfo mi;

	mi = mallinfo ();
	return mi.arena;
}
