/* iksemel (XML parser for Jabber)
** Copyright (C) 2000-2003 Gurer Ozen <madcat@e-kolay.net>
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "iksemel.h"

void
test_stack (int chunksize)
{
	ikstack *s;
	char *mem;
	int i, j;

	s = iks_stack_new (chunksize);
	for (i = 0; i < 64; i++) {
		mem = iks_stack_strdup (s, "1234567890abcdefghijklmnopqrstuv", 32);
	}
	for (i = 0; i < 64; i++) {
		j = rand () % 256;
		mem = iks_stack_alloc (s, j);
		memset (mem, 'x', j);
	}
	iks_stack_delete (s);
}

int main (int argc, char *argv[])
{
	srand (time (NULL));

	test_stack (0);
	test_stack (16);
	test_stack (237);
	test_stack (1024);

	return 0;
}
