//$Id: QuoteTest.java 14735 2008-06-04 14:05:50Z hardy.ferentschik $
package org.hibernate.test.annotations.quote;

import org.hibernate.test.annotations.TestCase;
import org.hibernate.Session;
import org.hibernate.Transaction;

/**
 * @author Emmanuel Bernard
 */
public class QuoteTest extends TestCase {
	public void testQuoteManytoMany() {
		Session s = openSession();
		Transaction tx = s.beginTransaction();
		User u = new User();
		s.persist( u );
		Role r = new Role();
		s.persist( r );
		u.getRoles().add( r );
		s.flush();
		s.clear();
		u = (User) s.get( User.class, u.getId() );
		assertEquals( 1, u.getRoles().size() );
		tx.rollback();
		String role = User.class.getName() + ".roles";
		assertEquals( "User_Role", getCfg().getCollectionMapping( role ).getCollectionTable().getName() );
		s.close();
	}
	protected Class[] getMappings() {
		return new Class[] {
				User.class,
				Role.class
		};
	}
}
