/* GtkDatabox - An extension to the gtk+ library
 * Copyright (C) 1998 - 2007  Dr. Roland Bock
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/**
 * @file gtkdatabox_canvas.h
 * A GtkDataboxCanvas holds all relevant information for positioning graph elements 
 * on the screen.
 *
 * It implements linear and logarithmic scales. 
 * 
 */

#ifndef __GTK_DATABOX_CANVAS_H__
#define __GTK_DATABOX_CANVAS_H__

#include <gtk/gtkstyle.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <gtkdatabox_scale.h>

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define GTK_DATABOX_TYPE_CANVAS		  (gtk_databox_canvas_get_type ())
#define GTK_DATABOX_CANVAS(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                           GTK_DATABOX_TYPE_CANVAS, \
                                           GtkDataboxCanvas))
#define GTK_DATABOX_CANVAS_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                           GTK_DATABOX_TYPE_CANVAS, \
                                           GtkDataboxCanvasClass))
#define GTK_DATABOX_IS_CANVAS(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                           GTK_DATABOX_TYPE_CANVAS))
#define GTK_DATABOX_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                           GTK_DATABOX_TYPE_CANVAS))
#define GTK_DATABOX_CANVAS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                           GTK_DATABOX_TYPE_CANVAS, \
                                           GtkDataboxCanvasClass))

   typedef struct _GtkDataboxCanvas GtkDataboxCanvas;

   typedef struct _GtkDataboxCanvasClass GtkDataboxCanvasClass;

   typedef struct _GtkDataboxCanvasPrivate GtkDataboxCanvasPrivate;

   struct _GtkDataboxCanvas
   {
      GObject parent;

      GtkDataboxCanvasPrivate *priv;
      /* Eliminate this: */
      GdkPixmap *pixmap;
      GtkStyle *style;
      PangoContext *context;
   };

   struct _GtkDataboxCanvasClass
   {
      GObjectClass parent_class;
   };

   GType gtk_databox_canvas_get_type (void);

   GObject *gtk_databox_canvas_new (void);

   void gtk_databox_canvas_values_to_pixels (GtkDataboxCanvas * canvas,
					     guint len,
					     const gfloat * values_x,
					     const gfloat * values_y,
					     GdkPoint * pixels);
   gint16 gtk_databox_canvas_value_to_pixel_x (GtkDataboxCanvas * canvas,
					       gfloat value);
   gint16 gtk_databox_canvas_value_to_pixel_y (GtkDataboxCanvas * canvas,
					       gfloat value);
   gfloat gtk_databox_canvas_pixel_to_value_x (GtkDataboxCanvas * canvas,
					       gint16 pixel);
   gfloat gtk_databox_canvas_pixel_to_value_y (GtkDataboxCanvas * canvas,
					       gint16 pixel);
   void gtk_databox_canvas_set_visible_range_x (GtkDataboxCanvas * canvas,
						gfloat offset,
						gfloat page_size);
   void gtk_databox_canvas_set_visible_range_y (GtkDataboxCanvas * canvas,
						gfloat offset,
						gfloat page_size);
   gfloat gtk_databox_canvas_get_offset_x (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_page_size_x (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_offset_y (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_page_size_y (GtkDataboxCanvas * canvas);

   void gtk_databox_canvas_set_scale_type_x (GtkDataboxCanvas * canvas,
					     GtkDataboxScaleType scale_type);
   void gtk_databox_canvas_set_scale_type_y (GtkDataboxCanvas * canvas,
					     GtkDataboxScaleType scale_type);
   GtkDataboxScaleType gtk_databox_canvas_get_scale_type_x (GtkDataboxCanvas *
							    canvas);
   GtkDataboxScaleType gtk_databox_canvas_get_scale_type_y (GtkDataboxCanvas *
							    canvas);

   gint gtk_databox_canvas_get_width (GtkDataboxCanvas * canvas);
   gint gtk_databox_canvas_get_height (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_total_left (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_total_right (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_total_top (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_total_bottom (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_visible_left (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_visible_right (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_visible_top (GtkDataboxCanvas * canvas);
   gfloat gtk_databox_canvas_get_visible_bottom (GtkDataboxCanvas * canvas);

   void gtk_databox_canvas_set_width (GtkDataboxCanvas * canvas, gint width);
   void gtk_databox_canvas_set_height (GtkDataboxCanvas * canvas,
				       gint height);
   void gtk_databox_canvas_set_total_limits (GtkDataboxCanvas * canvas,
					     gfloat left, gfloat right,
					     gfloat top, gfloat bottom);
   void gtk_databox_canvas_set_visible_limits (GtkDataboxCanvas * canvas,
					       gfloat left, gfloat right,
					       gfloat top, gfloat bottom);


#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif				/* __GTK_DATABOX_CANVAS_H__ */
