=begin
extconf.rb for Ruby/GtkMozEmbed extention library
=end

PACKAGE_NAME = "gtkmozembed"

TOPDIR = File.dirname(__FILE__)
SRCDIR = TOPDIR + '/src'

require 'mkmf-gnome2'

#
# detect GTK+ configurations
#

PKGConfig.have_package('gtk+-2.0')
PKGConfig.have_package('mozilla-gtkmozembed')

mozpath = PKGConfig.libs_only_L("mozilla-gtkmozembed")

if mozpath 
  mozpath.sub!(/-L/, " -Wl,-rpath ")
  $LDFLAGS << mozpath
else
  $stderr.puts "mozilla-gtkmozembed.pc cannot be found."
  exit 1
end

# Needed to check for ruby-gtk2 since we are in an
# external package
begin
  require 'gtk2'
rescue => e
  $stderr.puts "Ruby/GTK couldn't be initialized ('#{e}')"
  exit 1
end

#
# detect GtkMozEmbed configuration
#
have_library("gtkembedmoz") or exit 1

have_func('gtk_moz_embed_new') or exit 1
have_func('gtk_moz_embed_set_profile_path') or exit 1

create_makefile("gtkmozembed", "src")

