#!/usr/bin/env ruby
require 'rubygems'
spec = Gem::Specification.new do |s|
	s.name = 'rb-gsl'
	s.version = '1.9.0'
	s.author = 'Yoshiki Tsunesada'
	s.homepage = 'http://rb-gsl.rubyforge.org/'
	s.platform = Gem::Platform::RUBY
	s.summary = 'Ruby interface to the GSL (GNU Scientific Library)'
	s.require_path = 'lib'
	s.autorequire = 'gsl'
	s.has_rdoc = true
	s.files = Dir.glob("{ext,include,lib,tests}/**/*") + ['README','VERSION']
	s.require_path = 'lib'
	s.extra_rdoc_files = ['README']
	s.extensions = ['ext/extconf.rb']
end

if $0 == __FILE__
  Gem::manage_gems
  Gem::Builder.new(spec).build
end
