
#ifndef _CGETPARAM_H
#define _CGETPARAM_H


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <string.h>
#include <string>
using namespace std;

#include "dpu_ant_messages.h"
#include "dpu_edhipc_decl.h"


class CGetParam
{
public:
  CGetParam(char * FileName);
  ~CGetParam();

  int    GetInt(char *ValName);
  char  *GetString(char *ValName);
  char  *GetString(char *ValName, bool allowSpace);
  float  GetFloat(char *ValName);


  int do_antenna(m_ant_service_position                    object);
  int do_antenna(m_ant_ttu_inactive                        object);
  int do_antenna(m_ant_in_ftp                              object);
  int do_antenna(m_ant_in_lock                             object);
  int do_antenna(m_ant_in_new_ori                          object);
  int do_antenna(m_ant_in_opz                              object);
  int do_antenna(m_ant_in_orp                              object);
  int do_antenna(m_ant_turning_aborted                     object);
  int do_antenna(m_ant_ori_chg                             object);
  int do_antenna(m_ant_ORP_ori                             object);
  int do_antenna(m_ant_ori_limits                          object);
  int do_antenna(m_ant_temp                                object);
  int do_antenna(M_ANTENNA_IDENT                           object);
  int do_antenna(m_cs_active                               object);
  int do_antenna(m_ins_attitude_data                       object);
  int do_antenna(m_req_ant_ori_chg                         object, int rt, int rp, int ra);
  int do_antenna(m_req_ant_orp_ori                         object, int rt, int rp, int ra);
  int do_antenna(m_req_ant_position_status                 object, int rt, int rp, int ra);
  int do_antenna(m_req_ant_temp                            object, int rt, int rp, int ra);
  int do_antenna(m_req_ant_to_new_ori                      object);
  int do_antenna(m_req_ant_to_orp                          object);
  int do_antenna(M_REQ_ANTENNA_IDENT                       object, int rt, int rp, int ra);



  int nRetVal;
  char *buf;
  struct stat stbuf;
  int nSiz;
  string s;


};
#endif  /* _CGETPARAM_H */
