=begin
  locale_win32.rb - Locale module for win32.

  Copyright (C) 2002,2003  Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: locale_win32.rb,v 1.4 2005/12/29 07:02:52 mutoh Exp $
=end

require 'gettext/locale_table_win32'

module Locale
  @@locale_win32 = {}
  def __get(lctype = Locale::CTYPE)
    ret = nil
    if @@locale_win32[lctype] 
      ret = @@locale_win32[lctype]
    else
      ["LC_ALL", "LC_MESSAGES", "LANG"].each do |env|
	ret = ENV[env]
	break if ret
      end
      unless ret
	pri_id, sub_id = __locale_id
	lang = LocaleTable.assoc(pri_id)
	if lang.size == 3
	  lang = lang[2].assoc(sub_id)
	end
	ret = lang ? lang[1] : "C"
      end
      @@locale_win32[lctype] = ret
    end
    ret
  end

  def set(lctype, loc)
    if lctype == ALL
      @@locale_win32[lctype] = loc
    end
  end

  unless defined? CTYPE
    CTYPE = 0
    NUMERIC = 1
    TIME = 2
    COLLATE = 3
    MONETARY = 4
    MESSAGES = 5
    ALL = 6
  end
  module_function :__get
end

