// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_QUERYTARGET_H
#define _LIBGDAMM_QUERYTARGET_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* querytarget.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/dict.h>
#include <libgdamm/datamodel.h>

#include <libgdamm/entity.h>
#include <libgdamm/xmlstorage.h>
#include <libgdamm/referer.h>
#include <libgdamm/renderer.h>
#include <libgdamm/queryobject.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaQueryTarget GdaQueryTarget;
typedef struct _GdaQueryTargetClass GdaQueryTargetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class QueryTarget_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class Query;

/** Represents a target entity within a query.
 * A QueryTarget object represents an entity (usually a table, as a DictTable) which is taking part in a query. 
 * For SELECT queries, the targets are the entities listed after the FROM clause; 
 * for the INSERT, DELETE and UPDATE queries, there is only one target which is the entity to which the modifications apply.
 *
 * Within a single SELECT query, there can be more than one QueryTarget object representing the same entity for queries 
 * making usage of an entity more than one time. 
 *
 * @ingroup Queries
 */

class QueryTarget
 : public QueryObject,
   public XmlStorage,
   public Referer,
   public Renderer
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef QueryTarget CppObjectType;
  typedef QueryTarget_Class CppClassType;
  typedef GdaQueryTarget BaseObjectType;
  typedef GdaQueryTargetClass BaseClassType;

private:  friend class QueryTarget_Class;
  static CppClassType querytarget_class_;

private:
  // noncopyable
  QueryTarget(const QueryTarget&);
  QueryTarget& operator=(const QueryTarget&);

protected:
  explicit QueryTarget(const Glib::ConstructParams& construct_params);
  explicit QueryTarget(GdaQueryTarget* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~QueryTarget();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaQueryTarget*       gobj()       { return reinterpret_cast<GdaQueryTarget*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaQueryTarget* gobj() const { return reinterpret_cast<GdaQueryTarget*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaQueryTarget* gobj_copy();

private:


protected:
  QueryTarget(const Glib::RefPtr<Query>& query, const Glib::ustring& table);
  

public:
  
  static Glib::RefPtr<QueryTarget> create(const Glib::RefPtr<Query>& query, const Glib::ustring& table);


  /** Makes a copy of an existing object (copy constructor)
   * @return The new object.
   */
  Glib::RefPtr<QueryTarget> copy() const;
  
  /** Get the Gda::Query in which @a target  is
   * @return The Gda::Query object.
   */
  Glib::RefPtr<Query> get_query();
  
  /** Get the Gda::Query in which @a target  is
   * @return The Gda::Query object.
   */
  Glib::RefPtr<const Query> get_query() const;

  
  /** Get the Gda::Entity object which is represented by @a target 
   * @return The Gda::Entity object or <tt>0</tt> if @a target  is not active.
   */
  Glib::RefPtr<Entity> get_represented_entity();
  
  /** Get the Gda::Entity object which is represented by @a target 
   * @return The Gda::Entity object or <tt>0</tt> if @a target  is not active.
   */
  Glib::RefPtr<const Entity> get_represented_entity() const;

  
  /** Get the table name represented by @a target 
   * @return The table name or <tt>0</tt> if @a target  does not represent a database table.
   */
  Glib::ustring get_represented_table_name() const;

  
  /** Sets @a target 's alias to @a alias 
   * @param alias The alias.
   */
  void set_alias(const Glib::ustring& alias);
  
  /** Get @a target 's alias
   * @return The alias.
   */
  Glib::ustring get_alias() const;
  
  /** Get a complete name for target in the form of "&lt;entity name&gt; AS &lt;target alias&gt;"
   * @return A new string.
   */
  Glib::ustring get_complete_name() const;
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Entity> > property_entity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Entity> > property_entity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_entity_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_entity_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Query> > property_query() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::QueryTarget
   */
  Glib::RefPtr<Gnome::Gda::QueryTarget> wrap(GdaQueryTarget* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_QUERYTARGET_H */

