/**
 * @file libgalago-gtk/galago-gtk-entry-completion.c
 *       GtkEntryCompletion utility functions
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libgalago-gtk/galago-gtk-entry-completion.h>

GtkEntryCompletion *
galago_gtk_entry_completion_new_with_accounts(const GalagoService *service,
											  gboolean query)
{
	GList *l;
	GalagoPerson *me;
	GtkEntryCompletion *completion;
	GtkListStore *store;

	completion = gtk_entry_completion_new();

	store = gtk_list_store_new(1, G_TYPE_STRING);
	gtk_entry_completion_set_model(completion, GTK_TREE_MODEL(store));
	gtk_entry_completion_set_text_column(completion, 0);
	g_object_unref(store);

	me = galago_get_me(GALAGO_REMOTE, query);

	for (l = galago_person_get_accounts(me, query); l != NULL; l = l->next)
	{
		GalagoAccount *account = (GalagoAccount *)l->data;

		if (service == NULL || galago_account_get_service(account) == service)
		{
			GtkTreeIter iter;

			gtk_list_store_append(store, &iter);
			gtk_list_store_set(store, &iter,
							   0, galago_account_get_username(account),
							   -1);
		}
	}

	return completion;
}

GtkEntryCompletion *
galago_gtk_entry_completion_new_with_contacts(const GalagoAccount *account,
											  gboolean query)
{
	return NULL;
}

GtkEntryCompletion *
galago_gtk_entry_completion_new_with_services(gboolean query)
{
	return NULL;
}
