/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Tools.cc,v 1.20 2002/08/29 00:34:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <fwbuilder/libfwbuilder-config.h>
#include <fwbuilder/Tools.hh>
#include <fwbuilder/XMLTools.hh>
//#include <fwbuilder/dns.hh>

#include <string.h>
#include <stdio.h>

#ifdef HAVE_LIBSSL
//# include <openssl/ssl.h>
//# include <openssl/bio.h>
//# include <openssl/evp.h>
#endif

#include <glib.h>

using namespace std;

char *libfwbuilder::cxx_strdup(const string &x)
{
    char *res=new char[x.length()+1];
    strcpy(res, x.c_str());
    return res;
}

char *libfwbuilder::cxx_strdup(const char *x)
{
    if(!x)
        return (char*)NULL;

    char *res=new char[strlen(x)+1];
    strcpy(res,x);
    return res;
}

string libfwbuilder::int2string(int n)
{
    char x[32];
    sprintf(x,"%d", n);
    return x;
}

string libfwbuilder::substituteMacros(const string &source, const map<string, string> &macros, bool strict) throw(libfwbuilder::FWException)
{
    string name;
    string res;

    enum {
        MODE_TEXT,
        MODE_META,
        MODE_NAME
    } m = MODE_TEXT;
    
    for(size_t i=0;i<source.length();i++)
    {
        char c = source[i];
        switch(m)
        {
        case MODE_TEXT:
            if(c=='$')
                m=MODE_META;
            else
                res+=c;
            break;
        case MODE_META:
            if(c=='$')
            {
                // double '$' means '$'
                res+=c;
            } else
            {
                if(c=='{')
                {
                    m    = MODE_NAME;
                    name = "";
                } else
                    throw FWException(string("Unexpected symbol after '$' at postion ")+int2string(i));
            }
            break;
        case MODE_NAME:
            if(c=='}')
            {
                map<string, string>::const_iterator i=macros.find(name);
                if(i!=macros.end())
                    res+=(*i).second;
                else if(strict)
                    throw FWException(string("Undefined macro '")+name+"'");
                m = MODE_TEXT;
            } else
                name+=c;
            break;
        }
    }
    
    if(m!=MODE_TEXT)
        throw FWException("Unexpected end of string");

    return res;
}

char *libfwbuilder::strtok_r(char *s, const char *delim, char **save_ptr)
{
#ifndef HAVE_STRTOK_R
    char *token;

    token = 0;     /* Initialize to no token. */

    if (s == 0) {  			/* If not first time called... */
        s = *save_ptr;          /* restart from where we left off. */
    }
        
    if (s != 0) { 	/* If not finished... */
        *save_ptr = 0;

        s += strspn(s, delim); /* Skip past any leading delimiters. */
        if (*s != '\0') {      /* We have a token. */
            token = s;
            *save_ptr = strpbrk(token, delim); /* Find token's end. */
            if (*save_ptr != 0) {
                /* Terminate the token and make SAVE_PTR point past it.  */
                *(*save_ptr)++ = '\0';
            }
        }
    }
    
    return token;
#else
    return ::strtok_r(s, delim, save_ptr);
#endif
}


void libfwbuilder::init()
{
    /* init threads */
    g_thread_init(NULL);

    /* Initialize classes which need static initialization */
//    DNS::init();

    /* Init XML parser */
    XMLTools::initXMLTools();
    
//#ifdef HAVE_LIBSSL
//    /* Initialize OpenSSL library */
//    OpenSSL_add_all_algorithms();
//    SSL_library_init();
//    SSL_load_error_strings();
//#endif
}


