/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org
           Vadim Zaliva      lord@crocodile.org

  $Id: Logger.cc,v 1.4 2002/08/29 00:34:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <fwbuilder/libfwbuilder-config.h>

#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include <iostream>
#include <sstream>

#include <unistd.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>

#include <glib.h>

#include <fwbuilder/BackgroundOp.hh>

using namespace std;
using namespace libfwbuilder;

/*
Logger &libfwbuilder::start(Logger &l)
{
    l.line_lock.lock();
    return l;
}

Logger &libfwbuilder::end(Logger &l)
{
    l.line_lock.unlock();
    return l;
}
*/

void    Logger::blackhole()
{
    line_lock.lock();
    blackhole_mode=true;
    line_lock.unlock();
}


Logger& NullLogger::operator<< (char c)            { return *this;}
Logger& NullLogger::operator<< (char  *str)        { return *this;}
Logger& NullLogger::operator<< (const string &str) { return *this;}
Logger& NullLogger::operator<< (int    i  )        { return *this;}
Logger& NullLogger::operator<< (long   l  )        { return *this;}



QueueLogger::QueueLogger() {}

Logger& QueueLogger::operator<< (char c)            
{ 
    if (blackhole_mode) return *this;

    std::ostringstream str;
    str << c;
    line_lock.lock();
    linequeue.push(str.str());
    line_lock.unlock();
    return *this;
}

Logger& QueueLogger::operator<< (char  *str)        
{ 
    if (blackhole_mode) return *this;

    line_lock.lock();
    linequeue.push(str);
    line_lock.unlock();
    return *this;
}

Logger& QueueLogger::operator<< (const string &str) 
{ 
    if (blackhole_mode) return *this;

    line_lock.lock();
    linequeue.push(str);
    line_lock.unlock();
    return *this;
}

Logger& QueueLogger::operator<< (int    i  )        
{ 
    if (blackhole_mode) return *this;

    std::ostringstream str;
    str << i;
    line_lock.lock();
    linequeue.push(str.str());
    line_lock.unlock();
    return *this;
}

Logger& QueueLogger::operator<< (long   l  )        
{ 
    if (blackhole_mode) return *this;

    std::ostringstream str;
    str << l;
    line_lock.lock();
    linequeue.push(str.str());
    line_lock.unlock();
    return *this;
}

bool   QueueLogger::ready()
{
    if (blackhole_mode) return false;

    bool res=false;
    line_lock.lock();
    res=(!linequeue.empty());
    line_lock.unlock();
    return res;
}

string QueueLogger::getLine()
{
    if (blackhole_mode) return "";

    string str;
    line_lock.lock();
    if(!linequeue.empty()) {
	str=linequeue.front();
	linequeue.pop();
    }
    line_lock.unlock();
    return str;
}

