/*
 * $Id: fwbdclient.c,v 1.12 2002/01/13 06:37:02 lord Exp $
 *
 * This is simple command line client which could
 * be used to connect to 'fwbd'. It is mainly
 * written for protocol debugging purpose.
 */

#include <fwbd/fwbd.h>

#include <readline/readline.h>
#include <readline/history.h>


static char *rl_gets()
{
    char * line_read = readline ("fwbd# ");
    
    if(line_read && *line_read)
        add_history(line_read);
    
    return line_read;
}

static int commandName(const char *s, const char *cmd)
{
    return strncasecmp(s,cmd,strlen(cmd))==0;
}

static void do_disconnect(struct fwbd_connection *con)
{
    if(fwbd_disconnect(con))
    {
        if(con->lasterr)
        {
            printf("Disconnection error: %s.\n",con->lasterr);
            free(con->lasterr);
        } else
        {
            printf("Unknown disconnection error.\n");
        }
    }
}

int main(int ac, char **av)
{
    struct fwbd_connection *con; 
    
    fwbd_init();
    con = fwdb_new_connection();
    
    while(1)
    {
        char *s=rl_gets();
        
        if(s==NULL || strcasecmp(s,"QUIT")==0 ||
           strcasecmp(s,"EXIT")==0 ||
           strcasecmp(s,"BYE")==0
        ){
            free(s);
            break;
        } else if(commandName(s,"CONNECT"))
        {
            if(con->connected)
            {
                printf("Already connected to '%s:%d'. You must disconnect first.\n",
                       con->host,
                       con->port
                );
            } else
            {
                char *t,*host,*ports,*tmp,*keyfile, *certfile, *pass;
                tmp      = strtok_r(s   ,"\r\n\t ", &t);
                host     = strtok_r(NULL,"\r\n\t ", &t);
                ports    = strtok_r(NULL,"\r\n\t ", &t);
                keyfile  = strtok_r(NULL,"\r\n\t ", &t);
                certfile = strtok_r(NULL,"\r\n\t ", &t);
                pass     = strtok_r(NULL,"\r\n\t ", &t);
                
                if(!tmp || !host || !ports)
                {
                    printf("Invalid argument. Usage: CONNECT host port [keyfile certfile pass]\n");
                } else
                {
                    while(1)
                    {
                        int      port  ;
                        FILE     *f    ;
                        EVP_PKEY *pkey ;
                        X509     *cert, *pcert ;

                        port = atoi(ports); /* TODO: error detection */
                        
                        if((f=fopen(keyfile,"r"))==NULL)
                        {
                            printf("Error opening key file: '%s'\n",keyfile);
                            break;
                        }
                        pkey = PEM_read_PrivateKey(f, NULL, 0, pass);
                        if(pkey == NULL)
                        {
                            fclose(f);
                            break;
                        }
                        fclose(f);
                        
                        if((f=fopen(certfile,"r"))==NULL)
                        {
                            printf("Error opening certificae file: '%s'\n",certfile);
                            break;
                        }
                        cert = NULL;
                        if(!PEM_read_X509(f, &cert, 0, NULL))
                        {
                            fclose(f);
                            break;
                        }
                        fclose(f);

                        /*
                        {
                            EVP_PKEY *pkey = X509_get_pubkey(cert);
                            char *k = fwbd_key2str(pkey);
                            printf("My Public key:\n%s\n", k);
                            free(k);
                        }
                        */
                        
                        if(fwbd_connect(host, port, con, pkey, cert))
                        {
                            if(con->lasterr)
                            {
                                printf("Connection error: %s.\n",con->lasterr);
                                free(con->lasterr);
                            } else
                            {
                                printf("Unknown connection error.\n");
                            }
                            break;
                        }

                        printf("Successfly connected.\n");
                        pcert  = SSL_get_peer_certificate(con->ssl);
                        if(pcert)
                        {
                            EVP_PKEY *skey=X509_get_pubkey(pcert);
                            char *k = fwbd_key2str(skey);
                            printf("Public key:\n%s\n", k);
                            free(k);
                        }
                        break;
                    }
                }
            }
        } else if(commandName(s,"DISCONNECT"))
        {
            if(!con->connected)
                printf("You are not connected to any host.\n");
            else
                do_disconnect(con);
        } else if(commandName(s,"QUOTE"))
        {
            if(!con->connected)
            {
                printf("You are not connected to any host.\n");
            } else
            {
                if(fwbd_send_protocol_line(con, s+6))
                {
                    if(con->lasterr)
                    {
                        printf("Protocol send error: %s.\n",con->lasterr);
                        free(con->lasterr);
                    } else
                    {
                        printf("Unknown protocol send error.\n");
                    }
                }
            }
        } else if(commandName(s,"PING"))
        {
            if(!con->connected)
            {
                printf("You are not connected to any host.\n");
            } else
            {
                char *rsp = fwbd_send_command(con, "PING");
                if(rsp)
                {
                    if(strcasecmp(rsp,"PONG")==0)
                    {
                        printf("OK\n");
                    } else
                    {
                        printf("PING ERROR: Unexcpected response: '%s'\n",rsp);
                    }
                    free(rsp);
                } else
                {
                    if(con->lasterr)
                    {
                        printf("PING command protocol error: %s.\n",con->lasterr);
                        free(con->lasterr);
                    } else
                    {
                        printf("PING command unknown protocol error.\n");
                    }
                }
            }
        } else
        {
            printf("Unknown command. Must be one of: QUIT, CONNECT, DISCONNECT, PING, QUOTE\n");
        }

        free(s);
    }
    
    if(con->connected)
        do_disconnect(con);

    fwdb_free_connection(con);
    
    return 0;
}

