/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdlib.h>
#include <string.h>


#ifndef HAVE_STRNDUP

/* FUNCTION: strndup
 *
 * PARAMETERS: str, len
 *
 * DESCRIPTION: Like strdup(), mallocs a duplicate of str. No more than len characters
 * (not including the zero-termination) are duplicated, however. The resulting string
 * is zero-terminated.
 *
 * RETURNS: Allocated string if successful, NULL if allocation failed. */

char *strndup(char *str, unsigned int len)
{
  char *r;
  unsigned int n;

  n = strlen(str);
  if (n < len) r = strdup(str);
  else
  {
    r = malloc(len + 1);
    strncpy(r, str, len);
    *(r + len) = 0;
  }

  return(r);
}

#endif /* HAVE_STRNDUP */
