//-------------------------------------------------------------------------
// Desc:	Miscellaneous utility functions and methods for formatting monitor
//			web pages.
// Tabs:	3
//
//		Copyright (c) 2002-2006 Novell, Inc. All Rights Reserved.
//
//		This program is free software; you can redistribute it and/or
//		modify it under the terms of version 2 of the GNU General Public
//		License as published by the Free Software Foundation.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, contact Novell, Inc.
//
//		To contact Novell about this file by physical or electronic mail,
//		you may find current contact information at www.novell.com
//
// $Id: imonutil.cpp 12331 2006-01-23 10:19:55 -0700 (Mon, 23 Jan 2006) ahodgkinson $
//-------------------------------------------------------------------------

#include "flaimsys.h"

// Static data

static FLMBYTE gv_imonhdr_gif[] = 
{
	0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x8A, 0x02, 0x3B, 0x00, 0xE6,
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xEC, 0xE1, 0xEB, 0xFD, 0xFB, 0xFD,
	0xEE, 0xE9, 0xEF, 0xF1, 0xEE, 0xF2, 0xE6, 0xE5, 0xEB, 0xED, 0xEC,
	0xF3, 0xE9, 0xE8, 0xEF, 0xE2, 0xE1, 0xEB, 0xE5, 0xE5, 0xF0, 0xEE,
	0xEE, 0xF6, 0xEA, 0xEA, 0xF2, 0xE2, 0xE2, 0xE6, 0xF7, 0xF7, 0xFA,
	0xF3, 0xF3, 0xF6, 0xDF, 0xDF, 0xE2, 0xFD, 0xFD, 0xFF, 0xF6, 0xF6,
	0xF7, 0xF2, 0xF3, 0xF9, 0xEA, 0xEC, 0xF5, 0xF1, 0xF2, 0xF6, 0xDA,
	0xDB, 0xDF, 0xCE, 0xCF, 0xD2, 0xFA, 0xFB, 0xFD, 0xC8, 0xCA, 0xCD,
	0xF4, 0xF6, 0xF9, 0xB5, 0xB7, 0xB9, 0xEF, 0xF1, 0xF3, 0xED, 0xEF,
	0xF1, 0xEA, 0xEC, 0xEE, 0xF3, 0xF8, 0xFC, 0xEC, 0xF2, 0xF6, 0xE6,
	0xEA, 0xEC, 0xEA, 0xEF, 0xF1, 0xF6, 0xF9, 0xFA, 0xF2, 0xF5, 0xF6,
	0xE2, 0xE6, 0xE7, 0xFB, 0xFD, 0xFD, 0xFA, 0xFB, 0xFB, 0xF2, 0xF3,
	0xF3, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFD, 0xFD, 0xFD, 0xFB, 0xC1,
	0xC1, 0xBF, 0xF9, 0xF9, 0xF8, 0x9C, 0x9B, 0x80, 0xA0, 0x9F, 0x86,
	0xDB, 0xDA, 0xC2, 0xA7, 0xA4, 0x8F, 0xAB, 0xA8, 0x9A, 0xE1, 0xDF,
	0xD5, 0xD2, 0xD1, 0xCC, 0xE4, 0xE2, 0xDA, 0xE1, 0xDF, 0xD7, 0xDF,
	0xDD, 0xD5, 0xB2, 0xAB, 0x96, 0xB7, 0xB3, 0xA7, 0xC1, 0xBD, 0xB1,
	0xDC, 0xDA, 0xD4, 0xFB, 0xF6, 0xE8, 0xC7, 0xC2, 0xB5, 0xE5, 0xE0,
	0xD3, 0xEE, 0xE9, 0xDC, 0xBC, 0xB8, 0xAE, 0xD9, 0xD7, 0xD2, 0xB3,
	0xAD, 0xA0, 0xDA, 0xD6, 0xCD, 0xCF, 0xC6, 0xB3, 0xE3, 0xDD, 0xD1,
	0xCB, 0xC6, 0xBC, 0xD6, 0xD1, 0xC7, 0xE3, 0xDF, 0xD7, 0xCF, 0xCC,
	0xC6, 0xE0, 0xDD, 0xD7, 0xD6, 0xD4, 0xD0, 0xC2, 0xB8, 0xA5, 0xBC,
	0xB2, 0xA0, 0xDF, 0xDB, 0xD4, 0xCB, 0xC8, 0xC3, 0xD2, 0xCA, 0xBE,
	0xF2, 0xF0, 0xED, 0xE7, 0xE4, 0xE0, 0xDA, 0xCF, 0xC1, 0xF6, 0xF4,
	0xF2, 0xEC, 0xEA, 0xE8, 0xEA, 0xE6, 0xE3, 0xF8, 0xEC, 0xE5, 0xF9,
	0xF7, 0xF6, 0xF2, 0xE6, 0xE4, 0xFF, 0xFD, 0xFD, 0xFD, 0xFB, 0xFB,
	0xFD, 0xFD, 0xFD, 0xD9, 0xD9, 0xD9, 0xD5, 0xD5, 0xD5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x02, 0x3B, 0x00, 0x00,
	0x07, 0xFF, 0x80, 0x35, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88,
	0x89, 0x8A, 0x8B, 0x88, 0x32, 0x8E, 0x35, 0x32, 0x82, 0x49, 0x93,
	0x35, 0x93, 0x49, 0x36, 0x36, 0x4D, 0x9A, 0x9B, 0x3A, 0x4D, 0x3A,
	0x9F, 0xA0, 0xA1, 0x40, 0xA3, 0xA4, 0xA5, 0x40, 0x3A, 0x40, 0x5D,
	0xAA, 0xA7, 0x9F, 0xAA, 0x4A, 0xAF, 0xB0, 0xB1, 0xB2, 0xB1, 0xAA,
	0x5C, 0xA0, 0xA9, 0xAB, 0xA6, 0xAC, 0xA0, 0x98, 0xBD, 0xBE, 0xBF,
	0x99, 0x9B, 0x9E, 0xA0, 0xC2, 0xC5, 0xC5, 0xA2, 0x40, 0x42, 0x42,
	0x38, 0x37, 0xCD, 0xCE, 0x37, 0x41, 0xD1, 0xD2, 0xD2, 0x38, 0xD5,
	0xD6, 0x4C, 0xD6, 0xD9, 0x4B, 0xDB, 0x4B, 0x39, 0xDE, 0xDE, 0x3F,
	0x39, 0x3C, 0xDE, 0x3C, 0xE5, 0xE5, 0x45, 0x45, 0x43, 0x3C, 0x43,
	0xEC, 0x4F, 0xEE, 0xEF, 0xF0, 0xF0, 0xE8, 0xF3, 0x45, 0x4E, 0x48,
	0xB3, 0xB0, 0xA4, 0xF9, 0xB1, 0x33, 0xFD, 0xFD, 0xAF, 0x48, 0xDE,
	0xD1, 0x9B, 0x67, 0xAE, 0x1E, 0x3F, 0x24, 0x48, 0x9C, 0x60, 0x70,
	0xF2, 0x4F, 0xC9, 0x3F, 0x21, 0x46, 0xE2, 0x49, 0x84, 0xE7, 0xC4,
	0x89, 0xBB, 0x8A, 0x18, 0xDD, 0x21, 0xAC, 0x98, 0x10, 0xA1, 0xC7,
	0x8F, 0x20, 0x91, 0xF8, 0x1B, 0x49, 0xD2, 0x9F, 0x43, 0x7C, 0xB2,
	0x74, 0x8D, 0x0A, 0xC5, 0x32, 0x94, 0xB1, 0x4D, 0x98, 0x9A, 0x00,
	0xBB, 0x34, 0xC9, 0x91, 0xCD, 0x9B, 0x36, 0x07, 0x1D, 0xD9, 0x49,
	0xA3, 0xA7, 0xCF, 0x9F, 0x40, 0xA3, 0x08, 0x1D, 0x4A, 0x34, 0x4A,
	0x95, 0xA3, 0x48, 0x93, 0x52, 0x59, 0xCA, 0xB4, 0xA9, 0x53, 0x2A,
	0x50, 0xA2, 0x4A, 0x9D, 0x4A, 0x95, 0xEA, 0x94, 0xAB, 0x58, 0xB3,
	0x4E, 0x89, 0xC0, 0xF5, 0x8A, 0xD7, 0xAF, 0x2C, 0xC2, 0x8A, 0x65,
	0x61, 0xA2, 0x6C, 0x59, 0x2D, 0x2A, 0xD2, 0x0A, 0x10, 0x90, 0x56,
	0x45, 0x96, 0x2C, 0x29, 0xFF, 0x00, 0xC8, 0x9D, 0x4B, 0xB7, 0xAE,
	0xDD, 0xBB, 0x78, 0xF3, 0xEA, 0xDD, 0xCB, 0xB7, 0xAF, 0xDF, 0xBF,
	0x10, 0x02, 0x0B, 0x16, 0x5C, 0xA2, 0xF0, 0x85, 0xC3, 0x26, 0x2E,
	0x90, 0x35, 0x11, 0xB6, 0x81, 0xE3, 0xC7, 0x0D, 0x32, 0x48, 0x9E,
	0x9C, 0xC1, 0x83, 0x08, 0x0F, 0x12, 0x46, 0x64, 0xCE, 0x6C, 0xF9,
	0xB2, 0x07, 0xCD, 0x14, 0x42, 0x8B, 0xA6, 0xF0, 0xA1, 0xB4, 0x69,
	0xD1, 0x12, 0x24, 0x58, 0xBE, 0x70, 0x99, 0xF2, 0x64, 0x11, 0x8E,
	0x45, 0xC8, 0x3E, 0x7C, 0xB8, 0xB0, 0xED, 0x12, 0x02, 0x68, 0x3F,
	0x8E, 0x90, 0xC1, 0x81, 0xEF, 0xDF, 0xBE, 0xB9, 0x36, 0x08, 0x6B,
	0x62, 0xAD, 0x71, 0x2D, 0x5A, 0x18, 0xB3, 0xF0, 0xDA, 0xE0, 0x4A,
	0x14, 0x73, 0xE7, 0x06, 0xD2, 0x7B, 0xC2, 0x31, 0xE4, 0x47, 0x23,
	0xD8, 0x95, 0x29, 0x23, 0x42, 0xA4, 0x89, 0x10, 0x25, 0x40, 0x26,
	0xE9, 0x48, 0x52, 0x03, 0x28, 0x4F, 0x1A, 0x3E, 0xD2, 0xAB, 0x5F,
	0xAF, 0x1E, 0x4B, 0x95, 0xA1, 0x34, 0x18, 0xC8, 0x2F, 0x30, 0x80,
	0xC2, 0xEF, 0xD0, 0x92, 0x53, 0x67, 0x70, 0x2C, 0x81, 0x82, 0x84,
	0x06, 0x14, 0x18, 0x10, 0x9A, 0x02, 0x04, 0x4A, 0x66, 0x00, 0x16,
	0x58, 0x10, 0xF5, 0xC0, 0x82, 0x0C, 0x2E, 0x18, 0xC5, 0x00, 0x09,
	0x24, 0x80, 0x00, 0x02, 0x11, 0x1E, 0xB0, 0x80, 0x01, 0x0A, 0x50,
	0x90, 0xA1, 0x04, 0x0A, 0x18, 0x40, 0xC0, 0x14, 0x04, 0x20, 0x28,
	0xE2, 0x88, 0x22, 0x26, 0xE5, 0xDE, 0x51, 0x05, 0xA0, 0x98, 0x54,
	0x15, 0x05, 0xB4, 0x08, 0xC2, 0x8B, 0x30, 0xC2, 0xD8, 0xC1, 0x8C,
	0x34, 0xCE, 0x18, 0xC2, 0x8D, 0x21, 0x70, 0xA0, 0xE3, 0x8E, 0x1C,
	0x6C, 0xE0, 0xE3, 0x8F, 0x1B, 0x8C, 0x46, 0xC1, 0x08, 0x44, 0x16,
	0x29, 0x19, 0x57, 0x11, 0x34, 0x20, 0x5B, 0xFF, 0x6C, 0x22, 0xB0,
	0x20, 0x82, 0x59, 0x65, 0xD1, 0x56, 0x5B, 0x61, 0xC6, 0xAD, 0x65,
	0xDB, 0x16, 0x58, 0x42, 0x20, 0x97, 0x96, 0x7F, 0x75, 0xE9, 0xE5,
	0x97, 0x60, 0x86, 0x29, 0xE6, 0x98, 0x63, 0x32, 0x62, 0xE6, 0x99,
	0x68, 0xA6, 0x49, 0xC8, 0x23, 0x82, 0x38, 0x62, 0x83, 0x25, 0x98,
	0xD0, 0xF4, 0x0B, 0x27, 0x2D, 0xDD, 0xA2, 0xD2, 0x27, 0xA3, 0xE0,
	0xB3, 0x12, 0x9E, 0x5D, 0xA0, 0x84, 0x52, 0x17, 0xA4, 0x20, 0xB3,
	0x27, 0x4B, 0x32, 0x01, 0x93, 0x09, 0x2A, 0x40, 0xA0, 0x94, 0xA8,
	0xA2, 0xA7, 0xBC, 0x34, 0x0C, 0x9E, 0x39, 0x38, 0x33, 0xCD, 0xA4,
	0xD1, 0x60, 0x93, 0xCD, 0xA5, 0x97, 0x72, 0x93, 0x43, 0x37, 0xE6,
	0xE4, 0x10, 0x0E, 0x74, 0x3C, 0x0C, 0xB4, 0x0E, 0x3B, 0x43, 0x4C,
	0x64, 0xEA, 0x13, 0x03, 0xD9, 0x13, 0xCB, 0xA2, 0xE0, 0x2D, 0xAA,
	0x8F, 0x12, 0x22, 0x25, 0x6A, 0x52, 0xA2, 0x45, 0x48, 0x21, 0x1D,
	0x41, 0xE7, 0x28, 0x24, 0x52, 0x3E, 0xA5, 0xBC, 0x42, 0x92, 0x12,
	0x11, 0x9D, 0xFA, 0x84, 0x47, 0x1A, 0x61, 0x84, 0x51, 0x47, 0xC3,
	0xDA, 0x53, 0x9D, 0x75, 0x21, 0x95, 0xE4, 0xEC, 0x48, 0x7E, 0xF2,
	0xAA, 0x4B, 0x4B, 0x8F, 0x7E, 0xE2, 0xA8, 0x26, 0x86, 0xBE, 0x19,
	0x27, 0x4E, 0xDC, 0x12, 0xB2, 0xD3, 0x11, 0x40, 0x85, 0xEB, 0x53,
	0x51, 0xE4, 0xAE, 0xB8, 0xE2, 0x53, 0xE8, 0x32, 0x55, 0xD5, 0xBA,
	0xEB, 0x6A, 0xE5, 0xEE, 0x56, 0x11, 0x7C, 0x05, 0xD6, 0x58, 0xC4,
	0x41, 0x89, 0x9C, 0x5A, 0x6C, 0xA9, 0x80, 0x25, 0x5C, 0x64, 0xF6,
	0xEB, 0xEF, 0xBF, 0x63, 0x0E, 0x26, 0x80, 0x6D, 0x83, 0x05, 0x66,
	0xD8, 0x05, 0x65, 0xD1, 0x0B, 0x19, 0x6F, 0xAF, 0x89, 0x30, 0x99,
	0x66, 0x23, 0x0C, 0x19, 0x31, 0xC4, 0x1E, 0x58, 0x56, 0x71, 0xFF,
	0xC4, 0x42, 0x86, 0x96, 0xDA, 0xC6, 0x15, 0x67, 0x20, 0x41, 0x65,
	0x22, 0x1C, 0xB6, 0xA4, 0x92, 0x21, 0x4B, 0x39, 0xE5, 0x61, 0x2C,
	0x34, 0x10, 0xC1, 0xC6, 0xFB, 0xC9, 0xE6, 0xB2, 0xC9, 0x2E, 0xC3,
	0xE6, 0x71, 0x7F, 0xC1, 0x91, 0x75, 0x5C, 0xC2, 0x2C, 0x50, 0x71,
	0x6B, 0xAA, 0x19, 0x69, 0xE4, 0x11, 0x76, 0x3F, 0x63, 0x67, 0x84,
	0x76, 0x42, 0x34, 0xC1, 0x1D, 0x11, 0xCA, 0x00, 0x61, 0x43, 0x25,
	0x93, 0x3C, 0x40, 0xC3, 0x50, 0x49, 0xF4, 0x80, 0x1E, 0x7B, 0x54,
	0xA7, 0x87, 0x60, 0x52, 0x51, 0xC8, 0xC7, 0xC0, 0x01, 0x1B, 0x44,
	0xF6, 0xB1, 0xCA, 0x11, 0x10, 0x20, 0xF6, 0x00, 0x03, 0x2C, 0xC5,
	0xE2, 0x01, 0x1E, 0x12, 0x90, 0xA1, 0x86, 0x0A, 0x40, 0x51, 0x85,
	0x7B, 0xF0, 0xD1, 0xD0, 0x20, 0x83, 0x54, 0x40, 0xE6, 0x98, 0x6B,
	0x1E, 0xB3, 0x1D, 0x9A, 0x87, 0x53, 0x0C, 0x60, 0xE2, 0xD5, 0x7F,
	0x9F, 0x98, 0x62, 0x52, 0x83, 0xA3, 0x58, 0x40, 0x8C, 0x88, 0x83,
	0x50, 0x63, 0x8D, 0x38, 0xF2, 0xC8, 0x23, 0x90, 0x3F, 0x0A, 0x59,
	0x24, 0x91, 0x94, 0x21, 0x49, 0xF2, 0x70, 0x5A, 0x84, 0xF5, 0xA4,
	0x59, 0x52, 0xDA, 0x56, 0xA5, 0x95, 0x58, 0x66, 0xA9, 0x25, 0x97,
	0x00, 0x97, 0x6E, 0xFA, 0xE9, 0xA8, 0x93, 0xA9, 0xE6, 0xEA, 0xAC,
	0xB7, 0xBE, 0xA6, 0x23, 0x96, 0x5C, 0x92, 0xED, 0x9C, 0xD5, 0xDE,
	0x82, 0xE8, 0x9E, 0xBD, 0x46, 0x0B, 0x1E, 0x9F, 0x7D, 0x32, 0x7A,
	0xA7, 0x0E, 0xBD, 0x58, 0x5B, 0xA8, 0x2F, 0x9E, 0xE4, 0x39, 0xA8,
	0xA0, 0xD3, 0xB6, 0xC4, 0xEA, 0xEE, 0xC6, 0xE8, 0x90, 0x03, 0xA5,
	0x93, 0xE2, 0x60, 0x29, 0xA6, 0x38, 0xFC, 0x60, 0xBD, 0x35, 0xD6,
	0x6B, 0xFA, 0x4D, 0xA7, 0xDB, 0x17, 0x84, 0x8E, 0x13, 0x45, 0x8C,
	0x5A, 0xEA, 0xFF, 0xA9, 0x52, 0x9C, 0x3A, 0x4F, 0x45, 0x33, 0x0C,
	0x6D, 0x44, 0xF9, 0xE5, 0xA3, 0x5A, 0x84, 0xFB, 0xD2, 0x55, 0x37,
	0x43, 0xFB, 0xF0, 0xD3, 0x13, 0x2A, 0x3A, 0x3C, 0x3C, 0xA1, 0x92,
	0x29, 0xE0, 0x9D, 0xE4, 0xEB, 0x0C, 0x10, 0x09, 0x48, 0x3C, 0x10,
	0xE2, 0xB3, 0x8B, 0x1C, 0x2B, 0x21, 0xC7, 0xB2, 0x47, 0x47, 0x98,
	0xD5, 0xAC, 0x67, 0x39, 0x70, 0x06, 0xBA, 0xDB, 0xDF, 0x2E, 0x34,
	0x41, 0xAD, 0x6B, 0x65, 0x2B, 0x76, 0xDC, 0xCA, 0x49, 0x21, 0xC0,
	0x25, 0xAE, 0x70, 0x91, 0xAB, 0x28, 0xE6, 0x52, 0x4A, 0xBA, 0xD0,
	0xC5, 0xAE, 0x12, 0x4A, 0xE5, 0x5D, 0x5A, 0xE9, 0x8A, 0xBC, 0xAE,
	0x40, 0xAF, 0x7A, 0x99, 0xE5, 0x5E, 0x2A, 0x58, 0x4B, 0x5A, 0xF6,
	0x15, 0x97, 0xD4, 0xD9, 0xF0, 0x86, 0x61, 0x1A, 0x4C, 0x61, 0xB6,
	0x80, 0x1B, 0xDC, 0x0C, 0xAC, 0x04, 0x3A, 0x2C, 0x01, 0x62, 0x46,
	0xA6, 0xA4, 0xC8, 0xB8, 0xCC, 0x03, 0x0F, 0x9B, 0x1C, 0xC6, 0x84,
	0x94, 0x9A, 0x8A, 0xB5, 0xA6, 0x3F, 0xFE, 0xF1, 0x8F, 0x6A, 0x3A,
	0x46, 0x99, 0xC7, 0x94, 0xEC, 0x60, 0xB5, 0x19, 0xD8, 0x05, 0x22,
	0xE3, 0x80, 0x8F, 0x95, 0xAC, 0x35, 0x6C, 0x23, 0x90, 0x01, 0xC6,
	0x48, 0x46, 0x0C, 0x11, 0x88, 0x02, 0x20, 0x13, 0x59, 0xDE, 0xEC,
	0x33, 0x9C, 0xE3, 0xE8, 0x6C, 0x67, 0xEF, 0xB3, 0xC8, 0x3B, 0xAC,
	0x63, 0x84, 0xF4, 0x09, 0x4D, 0x68, 0x44, 0x33, 0xDA, 0xD1, 0xBC,
	0x33, 0x0A, 0xF2, 0x08, 0xA2, 0x27, 0x46, 0x89, 0x42, 0x0D, 0xC0,
	0x15, 0x85, 0xAA, 0xB1, 0xC7, 0x0A, 0x88, 0xB4, 0x42, 0x89, 0xDE,
	0x23, 0x14, 0x06, 0x18, 0x05, 0x0B, 0x88, 0x2C, 0x11, 0x51, 0xE4,
	0x36, 0x37, 0xF9, 0x44, 0xE1, 0x01, 0x47, 0xC1, 0x64, 0x82, 0xE0,
	0x13, 0x05, 0x4A, 0x32, 0x28, 0xFF, 0x0A, 0x68, 0x7C, 0x0C, 0xDE,
	0x66, 0xE6, 0x31, 0x02, 0xF5, 0x87, 0x40, 0x0E, 0x08, 0x11, 0xE0,
	0x4E, 0x04, 0x38, 0x15, 0xB5, 0x08, 0x29, 0x83, 0x7B, 0x65, 0x8B,
	0x0E, 0x97, 0xB8, 0xC5, 0x2D, 0x0E, 0x47, 0x39, 0x72, 0x9C, 0x8E,
	0x20, 0xE7, 0x23, 0xC9, 0x29, 0x71, 0x32, 0x96, 0x83, 0xCD, 0x70,
	0x9A, 0x04, 0xA5, 0x28, 0xD1, 0xE6, 0x36, 0xC6, 0xB9, 0xD2, 0x16,
	0x20, 0xB0, 0x4C, 0xD2, 0xE1, 0xF0, 0x99, 0xD0, 0x8C, 0xA6, 0x98,
	0x5C, 0x47, 0xCD, 0x6A, 0x32, 0xC2, 0x26, 0xB1, 0x9B, 0x9D, 0x36,
	0x95, 0x87, 0xBC, 0xE5, 0xE9, 0x6E, 0x77, 0xAD, 0xE8, 0x5D, 0xAB,
	0x72, 0x11, 0xA8, 0x50, 0x18, 0x4A, 0x13, 0xC6, 0x13, 0x85, 0x43,
	0xFA, 0xC1, 0xC0, 0x8F, 0x58, 0xE0, 0x9D, 0x16, 0x80, 0x60, 0x17,
	0xD4, 0xF9, 0x8A, 0x46, 0x35, 0x01, 0x08, 0xCF, 0x9B, 0x06, 0x13,
	0xF6, 0xC9, 0xCF, 0xE9, 0x51, 0xAF, 0x1A, 0xD7, 0xB3, 0xDE, 0x0F,
	0xB4, 0xD7, 0xBD, 0x72, 0x7C, 0x43, 0x1C, 0xF7, 0x3B, 0x5F, 0x3A,
	0xDA, 0x01, 0x0F, 0xFA, 0x3D, 0x41, 0x0A, 0x10, 0x8D, 0x68, 0x44,
	0x2F, 0x32, 0x8F, 0x87, 0x42, 0xB4, 0x7E, 0xF4, 0x30, 0x16, 0x3A,
	0xDC, 0x31, 0x9D, 0x50, 0x61, 0x14, 0x57, 0xE7, 0x90, 0x96, 0x2E,
	0x66, 0x31, 0x83, 0x78, 0x3E, 0x44, 0x22, 0x02, 0x1C, 0xD6, 0x46,
	0x94, 0xC5, 0xD2, 0x04, 0x6E, 0xA4, 0x9D, 0x20, 0x79, 0xA0, 0x03,
	0x23, 0x28, 0xC1, 0x3A, 0x11, 0xC3, 0x82, 0x86, 0xB2, 0x44, 0x06,
	0xD9, 0x54, 0x88, 0x0E, 0x7A, 0xF0, 0x83, 0x43, 0x09, 0x21, 0x52,
	0x46, 0x48, 0x42, 0x13, 0x96, 0x10, 0x85, 0x58, 0x41, 0xD2, 0x0A,
	0x59, 0xD8, 0xC2, 0x62, 0xA2, 0x05, 0x5F, 0x33, 0xDC, 0x02, 0x5C,
	0x6A, 0x28, 0xCD, 0xAA, 0x46, 0x73, 0x30, 0x59, 0xFF, 0xA2, 0x12,
	0x95, 0xAC, 0x44, 0x30, 0x83, 0x09, 0x91, 0x35, 0x4C, 0x92, 0x4D,
	0x12, 0x33, 0x43, 0xA4, 0x8C, 0x99, 0xB5, 0x89, 0x47, 0xAC, 0x18,
	0x12, 0xAB, 0xE8, 0x18, 0x27, 0xB1, 0x40, 0x4A, 0x3F, 0x14, 0xA2,
	0xD7, 0x94, 0xC4, 0x1A, 0x0E, 0x19, 0x60, 0x01, 0x0B, 0x38, 0x80,
	0x5E, 0xF5, 0x0A, 0x82, 0x59, 0xFA, 0xB5, 0x45, 0x7B, 0xB5, 0xD0,
	0x02, 0x26, 0x80, 0x21, 0x09, 0x94, 0x0C, 0x33, 0xA1, 0x71, 0x40,
	0x03, 0x4C, 0x40, 0x83, 0x8D, 0x0E, 0x70, 0x80, 0x20, 0xB9, 0xA3,
	0x64, 0xB3, 0x43, 0xB4, 0xA2, 0xE9, 0x91, 0x08, 0x3D, 0x20, 0xC2,
	0x9E, 0x92, 0x00, 0x48, 0xA1, 0xBC, 0xE7, 0x08, 0x42, 0x31, 0xA4,
	0x0F, 0x20, 0x99, 0xC8, 0xD2, 0x46, 0x92, 0x0A, 0x41, 0x3D, 0x4A,
	0xD6, 0x3C, 0xBB, 0xA2, 0x72, 0x99, 0x8D, 0x91, 0x0B, 0x62, 0x64,
	0x51, 0x3C, 0xB9, 0x20, 0x02, 0x34, 0x40, 0x3F, 0xA3, 0xCC, 0xCF,
	0xC6, 0x02, 0xD4, 0xA1, 0x31, 0x7E, 0x68, 0x00, 0xEE, 0x39, 0x51,
	0x08, 0x0B, 0xA7, 0x22, 0xC3, 0xB1, 0xC8, 0x45, 0x89, 0x53, 0x9C,
	0x2D, 0x69, 0xA4, 0xCB, 0xE6, 0xF2, 0xD2, 0x97, 0x93, 0x03, 0x26,
	0x92, 0x84, 0x29, 0x1B, 0x27, 0x41, 0xC9, 0x64, 0x9E, 0xAB, 0x52,
	0x09, 0x42, 0xD7, 0xCC, 0xC0, 0x58, 0xF5, 0xBB, 0xE0, 0xB5, 0xAA,
	0x35, 0xC7, 0x4B, 0xDE, 0x41, 0x60, 0x13, 0x4E, 0x93, 0xD0, 0xE6,
	0x36, 0x91, 0xF7, 0xCD, 0x68, 0x01, 0xAA, 0x9B, 0x75, 0xC2, 0x56,
	0x2F, 0x8A, 0xB7, 0x0B, 0x59, 0x85, 0xC4, 0x58, 0xF8, 0xCD, 0xEF,
	0x01, 0x11, 0xF2, 0xCE, 0x19, 0xCC, 0xB3, 0x15, 0xB0, 0x40, 0x02,
	0x0E, 0x82, 0xD0, 0xCF, 0x7D, 0xFE, 0xF3, 0x52, 0x02, 0x4D, 0x70,
	0x82, 0xBB, 0x71, 0x50, 0x84, 0x96, 0x83, 0x1D, 0xE3, 0x00, 0x95,
	0xFF, 0xA8, 0xC6, 0xF7, 0x0E, 0x89, 0xB2, 0xCF, 0xC2, 0x16, 0x9D,
	0x28, 0x47, 0x7A, 0x26, 0x11, 0x38, 0xD6, 0x83, 0x80, 0xA8, 0xB2,
	0x15, 0x1C, 0xCF, 0x81, 0x84, 0x3C, 0xB5, 0x4A, 0x82, 0xFE, 0x6B,
	0x48, 0x3F, 0x20, 0x02, 0x0F, 0x01, 0xAE, 0x74, 0x59, 0x0A, 0x34,
	0x96, 0x47, 0x14, 0x08, 0x53, 0x91, 0xC8, 0x74, 0xA6, 0x34, 0xFD,
	0x9D, 0x4D, 0xAF, 0x35, 0xBC, 0x5F, 0x60, 0x10, 0x27, 0x88, 0xE0,
	0x20, 0x07, 0xC5, 0x05, 0xD4, 0xD4, 0x0A, 0x95, 0xA8, 0x4F, 0x31,
	0xEA, 0x51, 0x91, 0x0A, 0xAF, 0x78, 0xAD, 0xB0, 0x85, 0x8B, 0x79,
	0xE1, 0x53, 0x65, 0xA8, 0x2F, 0xA9, 0x52, 0x35, 0xBC, 0x58, 0x2E,
	0x5D, 0xC1, 0x02, 0xB3, 0x4C, 0xEE, 0x62, 0xC9, 0x87, 0x5C, 0xBD,
	0xCD, 0x57, 0xC1, 0x9A, 0x01, 0xDE, 0x14, 0x09, 0x38, 0x66, 0xCD,
	0xD8, 0x6F, 0x3E, 0xD6, 0x19, 0xD6, 0xB8, 0x2C, 0x36, 0x6F, 0x85,
	0xAB, 0x16, 0x55, 0x96, 0x81, 0x90, 0x89, 0x80, 0x43, 0x34, 0xD2,
	0x6B, 0x8B, 0x48, 0x40, 0x02, 0xAD, 0xF9, 0xF9, 0xCF, 0x80, 0x66,
	0xC0, 0x2C, 0x2D, 0x44, 0x58, 0x0A, 0x78, 0x80, 0x35, 0x19, 0xA0,
	0xC0, 0x01, 0x66, 0xE0, 0xD8, 0x39, 0xB6, 0x18, 0x09, 0x46, 0xB8,
	0x8E, 0x64, 0x81, 0xD5, 0x0F, 0x3C, 0x2A, 0x63, 0x13, 0xDC, 0xD1,
	0x63, 0x0F, 0x36, 0x2D, 0x03, 0x4D, 0xC4, 0x2E, 0x09, 0x43, 0x9E,
	0xDA, 0x7A, 0xAC, 0xE0, 0x83, 0x48, 0x92, 0xD6, 0xB4, 0xA6, 0xA5,
	0x82, 0x6A, 0x8D, 0xB2, 0x22, 0xE1, 0xAE, 0x5A, 0x41, 0x4E, 0x73,
	0xE4, 0x6A, 0x81, 0xDA, 0x93, 0x05, 0xD1, 0xA0, 0x0A, 0xA9, 0xF1,
	0xDA, 0xC7, 0x72, 0x6B, 0x57, 0xFF, 0x6C, 0xA8, 0x43, 0x0A, 0x48,
	0x65, 0x70, 0x8F, 0x22, 0xB8, 0x57, 0x56, 0x81, 0x0A, 0xC6, 0x3E,
	0x6E, 0x01, 0x90, 0xFF, 0x3D, 0xCB, 0xE4, 0x2A, 0x77, 0xB9, 0x1D,
	0xC0, 0x65, 0x2E, 0x75, 0xC9, 0xCB, 0x5E, 0x8A, 0x46, 0x89, 0x23,
	0x90, 0x6E, 0x92, 0xA8, 0x4B, 0xCC, 0xEB, 0x76, 0x2E, 0xBB, 0x3F,
	0xE4, 0xAE, 0x77, 0xB3, 0x4C, 0xEE, 0x72, 0xFB, 0xAB, 0xBC, 0xE8,
	0xAE, 0xE6, 0x79, 0x3F, 0xFD, 0x69, 0x6D, 0xCA, 0xF7, 0x17, 0x78,
	0x32, 0x71, 0x7B, 0x15, 0x85, 0xA8, 0xF8, 0x16, 0x23, 0x26, 0xF5,
	0xFE, 0x84, 0x43, 0x40, 0xA2, 0x51, 0x0F, 0xDF, 0x4A, 0xBF, 0x0A,
	0x8C, 0x27, 0x2B, 0x94, 0x10, 0xA9, 0x68, 0x48, 0xEF, 0xC0, 0x07,
	0x47, 0xB0, 0x82, 0x15, 0xCC, 0xE0, 0x82, 0x9A, 0x83, 0x54, 0xEA,
	0x00, 0x55, 0x42, 0xF3, 0x27, 0x91, 0x89, 0x66, 0xD8, 0xC2, 0x18,
	0x26, 0x9F, 0x44, 0x3B, 0x7C, 0x2B, 0x8F, 0xFA, 0xBB, 0x08, 0xBC,
	0xAA, 0xE7, 0xFE, 0xFC, 0xF1, 0x4E, 0x24, 0x98, 0x34, 0x9E, 0xC0,
	0x9A, 0x63, 0x40, 0x10, 0x48, 0x63, 0x7E, 0xCF, 0x78, 0xBF, 0xED,
	0xBC, 0xF1, 0x8D, 0xBF, 0xA9, 0xE3, 0x1D, 0x3B, 0x6A, 0x76, 0x3A,
	0xBD, 0x49, 0x90, 0x7D, 0x3A, 0xAE, 0x22, 0xB3, 0xFA, 0xC8, 0x48,
	0x6E, 0x8A, 0x92, 0xD9, 0xC5, 0xE4, 0xAB, 0xA8, 0x50, 0x5E, 0x50,
	0x76, 0x6A, 0x5B, 0xA8, 0xAC, 0xAF, 0xA9, 0x9A, 0xFB, 0xE9, 0x39,
	0x9C, 0xCB, 0x96, 0xA7, 0x9E, 0x5D, 0x2C, 0x9A, 0xCC, 0xCD, 0xF9,
	0x41, 0x73, 0x9A, 0x45, 0x03, 0x1C, 0x25, 0x79, 0xC0, 0x8A, 0x25,
	0xC3, 0xAE, 0x71, 0x52, 0x56, 0x67, 0xD6, 0x38, 0x80, 0x03, 0x34,
	0xEA, 0x6B, 0x01, 0xF8, 0xFC, 0xE7, 0xB9, 0xB9, 0xBD, 0x41, 0x81,
	0x9E, 0x4F, 0x01, 0x0E, 0x30, 0x01, 0x05, 0xD4, 0xB9, 0x06, 0xE1,
	0xBB, 0x9F, 0x4A, 0x23, 0x2D, 0xE9, 0xC9, 0x4E, 0x56, 0x16, 0x95,
	0x15, 0x46, 0x77, 0x30, 0xBB, 0xE9, 0xFF, 0xA9, 0xD1, 0xE0, 0x08,
	0x93, 0xF8, 0xD6, 0xE1, 0x8F, 0x50, 0x05, 0xAA, 0x25, 0x52, 0x44,
	0xA5, 0x3D, 0xF5, 0x0E, 0x4C, 0x8B, 0x20, 0x54, 0x5B, 0xDE, 0xD4,
	0x48, 0x89, 0x9B, 0xD3, 0x02, 0xE9, 0x73, 0x03, 0x78, 0x6D, 0x3F,
	0xB8, 0xC5, 0x9B, 0x18, 0x15, 0xA0, 0x57, 0x0C, 0x8D, 0xB1, 0x43,
	0x14, 0x20, 0x80, 0xDF, 0xCC, 0x85, 0xAE, 0xBF, 0xFE, 0x15, 0x46,
	0x07, 0x58, 0x8A, 0x8C, 0xA0, 0x6D, 0xA3, 0xC6, 0x35, 0xB7, 0x47,
	0xD5, 0x1E, 0x0D, 0xB6, 0x2B, 0xC7, 0x15, 0x61, 0x0E, 0xB3, 0x98,
	0xDF, 0xDE, 0x2A, 0x57, 0x43, 0x27, 0x18, 0xA8, 0x1B, 0xFF, 0xF8,
	0x79, 0x49, 0xB7, 0xF2, 0x59, 0x87, 0xCD, 0xE6, 0xCB, 0x80, 0xDD,
	0xB2, 0x53, 0x6F, 0xED, 0x90, 0x31, 0x6F, 0x5E, 0xDD, 0x6E, 0x17,
	0xC0, 0x3B, 0x67, 0xBE, 0xF7, 0xFD, 0x11, 0xFC, 0xFA, 0x7B, 0x05,
	0xE0, 0x0F, 0xFF, 0x0A, 0xE2, 0xA7, 0x5F, 0x93, 0xCF, 0x80, 0x07,
	0x94, 0xFA, 0xE7, 0x0F, 0xAA, 0x37, 0xD0, 0x85, 0xBB, 0xDF, 0x7A,
	0x0D, 0x76, 0x30, 0x74, 0x20, 0x2E, 0x8F, 0x81, 0x3C, 0xD4, 0x1D,
	0x17, 0xC5, 0x78, 0x86, 0x1B, 0xBA, 0xF1, 0x8B, 0x63, 0xFC, 0xFF,
	0x17, 0x55, 0x7F, 0xF6, 0x77, 0x2B, 0x1C, 0x85, 0x04, 0x7D, 0xE2,
	0x2A, 0x22, 0x37, 0x52, 0xBE, 0xD2, 0x3F, 0x10, 0xB4, 0x4E, 0xC0,
	0x82, 0x2C, 0x3E, 0xC3, 0x40, 0x30, 0x57, 0x63, 0x08, 0x21, 0x73,
	0x33, 0x17, 0x2D, 0xFB, 0x63, 0x53, 0xC2, 0xF3, 0x12, 0x31, 0x31,
	0x13, 0x39, 0x17, 0x09, 0x87, 0xA0, 0x78, 0x3E, 0xE5, 0x73, 0x3F,
	0x17, 0x42, 0x41, 0x27, 0x74, 0x43, 0x57, 0x15, 0x45, 0x07, 0x2F,
	0x4B, 0x95, 0x74, 0xF6, 0xB2, 0x74, 0xF9, 0xD2, 0x74, 0x57, 0x86,
	0x7C, 0x34, 0x78, 0x17, 0xCE, 0xB4, 0x25, 0x00, 0x20, 0xFF, 0x18,
	0xC9, 0x94, 0x1B, 0x17, 0xF0, 0x39, 0x3F, 0x84, 0x30, 0x9A, 0x43,
	0x32, 0x5F, 0x84, 0x44, 0x4B, 0x24, 0x24, 0xBE, 0x61, 0x1F, 0x5E,
	0xE4, 0x7B, 0x4C, 0x92, 0x18, 0x17, 0x50, 0x18, 0x3A, 0x98, 0x32,
	0x74, 0x95, 0x01, 0x1B, 0x30, 0x23, 0x30, 0xC2, 0x67, 0x7D, 0xE6,
	0x67, 0x6F, 0x97, 0x85, 0x59, 0xE8, 0x67, 0x13, 0x22, 0x77, 0x4A,
	0x10, 0x2A, 0x15, 0x71, 0x3E, 0x90, 0xE6, 0x77, 0x64, 0x28, 0x34,
	0xF8, 0x60, 0x59, 0x14, 0x74, 0x59, 0xDC, 0x71, 0x04, 0x85, 0x27,
	0x6A, 0xA2, 0x35, 0x5A, 0xA5, 0x86, 0x6A, 0x95, 0xA7, 0x48, 0xAB,
	0xE4, 0x6A, 0xC4, 0x76, 0x35, 0xC1, 0x75, 0x6A, 0x97, 0xA7, 0x48,
	0xAD, 0x05, 0x42, 0x40, 0x55, 0x05, 0xA4, 0xA4, 0x1F, 0xFD, 0xB1,
	0x6B, 0x78, 0xD3, 0x6B, 0xA5, 0xE4, 0x6B, 0x69, 0xB3, 0x7A, 0x80,
	0xC3, 0x6C, 0xCB, 0xC6, 0x14, 0x7E, 0x05, 0x23, 0xB4, 0x04, 0x02,
	0xB2, 0x17, 0x23, 0xB4, 0x57, 0x7B, 0xB6, 0xE7, 0x5C, 0xB9, 0x77,
	0x6D, 0xBB, 0x57, 0x66, 0xBD, 0x07, 0x1B, 0xD5, 0x05, 0x7C, 0xC1,
	0x07, 0x66, 0x3B, 0x94, 0x25, 0xCB, 0x54, 0x83, 0xA6, 0x08, 0x75,
	0xCB, 0x97, 0x8A, 0x68, 0xB2, 0x53, 0xB0, 0x03, 0x27, 0xEA, 0x35,
	0x5F, 0x14, 0x64, 0x27, 0xC7, 0x83, 0x0A, 0x18, 0xC8, 0x0A, 0xA5,
	0x40, 0x28, 0xF2, 0x75, 0x09, 0xA8, 0x00, 0x0A, 0xDC, 0xF7, 0x62,
	0x61, 0x08, 0x47, 0x2B, 0x00, 0x1D, 0xC1, 0x28, 0x7E, 0xE5, 0x20,
	0x7E, 0xE7, 0x83, 0x5F, 0x2B, 0x80, 0x03, 0x31, 0xB0, 0x8C, 0x41,
	0x50, 0x0D, 0xD4, 0x80, 0x03, 0x4B, 0xF0, 0x7E, 0x03, 0xB5, 0x0D,
	0xD3, 0x18, 0x8D, 0xEE, 0x47, 0x0E, 0x0E, 0x07, 0x2A, 0xA4, 0x22,
	0x2C, 0xFE, 0xA7, 0x7F, 0xFD, 0xD7, 0x61, 0xE0, 0x03, 0x47, 0x15,
	0xF6, 0xFF, 0x7F, 0xF7, 0x27, 0x10, 0xF6, 0xC7, 0x51, 0xD2, 0xD1,
	0x3F, 0xEA, 0x68, 0x62, 0xFB, 0xE3, 0x3F, 0xFF, 0x13, 0x4F, 0x28,
	0x17, 0x2C, 0x30, 0xB5, 0x61, 0x14, 0x68, 0x1D, 0x16, 0x28, 0x53,
	0x39, 0x66, 0x0A, 0x1A, 0xD8, 0x09, 0x16, 0xD4, 0x63, 0x71, 0x52,
	0x13, 0x20, 0x68, 0x08, 0xDF, 0x12, 0x6A, 0x41, 0xE1, 0x73, 0x42,
	0x75, 0x14, 0x27, 0xA8, 0x2E, 0x29, 0x68, 0x15, 0x45, 0x77, 0x74,
	0xF3, 0x42, 0x2F, 0x4A, 0x07, 0x55, 0x55, 0xC6, 0x2F, 0xA7, 0x58,
	0x91, 0x79, 0x21, 0x30, 0xB6, 0x71, 0x75, 0xDF, 0x86, 0x18, 0x8D,
	0xE1, 0x18, 0x0C, 0x23, 0x19, 0x31, 0x93, 0x1F, 0xF6, 0xF1, 0x1B,
	0x75, 0xE6, 0x32, 0xFB, 0xD1, 0x56, 0x71, 0x46, 0x1B, 0xC6, 0xB1,
	0x45, 0x0D, 0x70, 0x18, 0x19, 0x80, 0x76, 0x54, 0x08, 0x02, 0x56,
	0x88, 0x85, 0x5A, 0x58, 0x93, 0x35, 0xA9, 0x35, 0x08, 0xD0, 0x05,
	0x45, 0x10, 0x0E, 0x39, 0x30, 0x7E, 0x1B, 0xF1, 0x3D, 0x63, 0x78,
	0x47, 0x95, 0x35, 0x94, 0x44, 0x99, 0x34, 0xFC, 0xA8, 0x09, 0x6B,
	0xD8, 0x03, 0x03, 0x29, 0x35, 0x4F, 0x53, 0x48, 0xEB, 0xD1, 0x78,
	0x08, 0x32, 0x5A, 0x72, 0x18, 0x49, 0x54, 0xB9, 0x48, 0x58, 0x43,
	0x2E, 0xC4, 0xE5, 0x59, 0x24, 0x02, 0x79, 0x74, 0x28, 0x5B, 0x44,
	0x71, 0x35, 0xB3, 0x45, 0x00, 0xBA, 0x45, 0x4A, 0x89, 0xB6, 0x6B,
	0xB8, 0x65, 0x96, 0x1B, 0x63, 0x57, 0xBD, 0xA5, 0x00, 0xAA, 0x77,
	0x2E, 0x4B, 0xE1, 0x7A, 0xCD, 0x86, 0x38, 0x7C, 0x55, 0x4B, 0xCB,
	0x25, 0x6D, 0xB7, 0xF7, 0x38, 0xD5, 0x16, 0x24, 0xA1, 0xB1, 0x89,
	0x5C, 0x01, 0x92, 0x24, 0xE3, 0x42, 0xC6, 0x74, 0x4C, 0xC2, 0x17,
	0x6E, 0xDD, 0x75, 0x83, 0x16, 0x79, 0x98, 0xCF, 0xA4, 0x8A, 0x8A,
	0xB9, 0x08, 0xAC, 0xF8, 0xFF, 0x7C, 0xD1, 0x37, 0x27, 0x1D, 0x08,
	0x8B, 0x74, 0x12, 0x6F, 0xFA, 0x50, 0x4E, 0x88, 0xB2, 0x2A, 0x94,
	0x89, 0x8B, 0xEF, 0x76, 0x4F, 0xC0, 0xA3, 0x03, 0xBD, 0xC8, 0x72,
	0xBF, 0x78, 0x2B, 0xC1, 0x28, 0x71, 0x3C, 0x20, 0x7E, 0xE3, 0x77,
	0x8C, 0xE0, 0x93, 0x9A, 0x15, 0x91, 0x8C, 0x31, 0x00, 0x03, 0xAE,
	0xB9, 0x8C, 0x31, 0xD0, 0x8C, 0x03, 0x66, 0x70, 0xEC, 0x27, 0x8D,
	0x3C, 0x19, 0x7F, 0xF1, 0x47, 0x9A, 0xE2, 0x43, 0x2A, 0xF3, 0x40,
	0x61, 0xF1, 0xD0, 0x3E, 0x00, 0x78, 0x61, 0xE5, 0x28, 0x80, 0x1F,
	0xD6, 0x80, 0xAB, 0x02, 0x04, 0xFD, 0x00, 0x3E, 0xE3, 0xA8, 0x7F,
	0xE6, 0x68, 0x3E, 0x45, 0x70, 0x0F, 0xEB, 0x28, 0x72, 0x09, 0xD8,
	0x2A, 0x28, 0xA1, 0x62, 0x10, 0xC4, 0x77, 0xC9, 0xD2, 0x4E, 0x2D,
	0x57, 0x8F, 0x36, 0x76, 0x8F, 0x0F, 0x44, 0x73, 0xFA, 0xA8, 0x81,
	0x38, 0x75, 0x41, 0x94, 0x10, 0x82, 0x22, 0x48, 0x64, 0x06, 0x79,
	0x90, 0x09, 0xB9, 0x14, 0x0B, 0xC9, 0x90, 0x4C, 0xE6, 0x90, 0x5E,
	0xE1, 0x82, 0x52, 0x26, 0x91, 0x34, 0x34, 0x83, 0x88, 0x79, 0x8A,
	0x3A, 0xA8, 0x45, 0x1A, 0xB9, 0x9F, 0x08, 0xA3, 0x1C, 0x77, 0x33,
	0x19, 0x0E, 0x40, 0x24, 0xBB, 0x16, 0x33, 0x4E, 0x24, 0x56, 0xB1,
	0xD1, 0x56, 0x9D, 0x63, 0x1C, 0xB1, 0x71, 0x01, 0x2F, 0x99, 0x76,
	0x32, 0xC9, 0x76, 0x6D, 0x67, 0x93, 0x95, 0xC4, 0x85, 0x38, 0x39,
	0x21, 0x16, 0xAA, 0x93, 0x09, 0xF6, 0x0D, 0x3E, 0xF9, 0x62, 0x90,
	0x56, 0x94, 0x44, 0xA9, 0x03, 0x42, 0x70, 0x94, 0xC6, 0x70, 0x34,
	0xDF, 0xC2, 0x94, 0x3D, 0xE7, 0x59, 0xEC, 0x31, 0x22, 0x6F, 0x73,
	0x79, 0x22, 0x42, 0x05, 0xAD, 0xA4, 0x5A, 0x2C, 0x42, 0x01, 0x0D,
	0xA0, 0x58, 0x76, 0xB3, 0x5B, 0x18, 0x22, 0xFF, 0x19, 0x21, 0xB2,
	0x87, 0x74, 0xB8, 0x95, 0x22, 0x02, 0x1F, 0xB8, 0xE6, 0x1F, 0x79,
	0xF3, 0x31, 0x40, 0x0A, 0xA4, 0x33, 0x93, 0x96, 0x46, 0x7A, 0x4A,
	0x6A, 0x99, 0x7A, 0xB0, 0xD4, 0x14, 0x83, 0x36, 0x97, 0xC9, 0xE5,
	0xA4, 0xB3, 0x77, 0x4B, 0xD2, 0x76, 0x89, 0xD4, 0x96, 0x97, 0xBA,
	0x17, 0x5D, 0x47, 0xC2, 0x1B, 0xD4, 0x25, 0x16, 0xA0, 0x38, 0x25,
	0xA2, 0x38, 0x8A, 0x83, 0x71, 0x9F, 0x62, 0x7A, 0x43, 0x8B, 0x59,
	0xA6, 0x87, 0xC0, 0x8A, 0xE9, 0x95, 0x2D, 0xD4, 0x12, 0x0C, 0xC2,
	0xD0, 0x4D, 0xCB, 0x63, 0x99, 0x36, 0x10, 0x6F, 0x9A, 0x39, 0x5F,
	0xA8, 0x10, 0xA7, 0x9F, 0x09, 0x9A, 0xE1, 0xB8, 0x33, 0xC2, 0x08,
	0x7E, 0xDF, 0x03, 0x70, 0xFA, 0xF5, 0x3C, 0xAE, 0x19, 0xA8, 0x30,
	0x00, 0x9B, 0xB1, 0x69, 0x0D, 0xB4, 0x59, 0x3D, 0xB8, 0x99, 0xA8,
	0xD9, 0xA8, 0x9B, 0x10, 0x37, 0x04, 0xD3, 0xC1, 0x7F, 0x17, 0x16,
	0xA9, 0xE4, 0x38, 0x11, 0xE8, 0x03, 0x41, 0xB4, 0x68, 0x99, 0x9E,
	0x89, 0x10, 0x00, 0x81, 0x1D, 0x21, 0x16, 0x9C, 0xCC, 0x09, 0x3F,
	0xEE, 0x23, 0x2B, 0xEA, 0x18, 0x9D, 0xF5, 0xD4, 0x5E, 0x25, 0x65,
	0x52, 0x0F, 0xB8, 0x40, 0xDC, 0xC9, 0x9D, 0xDE, 0xF9, 0x9D, 0xF9,
	0x88, 0xA9, 0x15, 0xC4, 0x81, 0xE4, 0xE9, 0x47, 0x1B, 0x34, 0x90,
	0x1D, 0x44, 0x82, 0x07, 0x79, 0x6C, 0xEB, 0xD9, 0x9E, 0x53, 0xD1,
	0x90, 0xF0, 0xC9, 0x54, 0x10, 0xF9, 0x82, 0xF4, 0x69, 0x65, 0xF6,
	0x39, 0xA6, 0xC7, 0xA7, 0x83, 0x19, 0xC9, 0x9F, 0xFB, 0x59, 0x16,
	0x4D, 0x22, 0x33, 0x0F, 0x13, 0xA0, 0x24, 0x09, 0x92, 0x57, 0xE7,
	0x56, 0x4C, 0xD8, 0x83, 0x6B, 0xC1, 0x92, 0xAC, 0xB1, 0x01, 0x30,
	0xF9, 0x96, 0x6B, 0x07, 0xA1, 0xF2, 0x21, 0xA1, 0x0F, 0xC0, 0xFF,
	0x00, 0x5D, 0xC8, 0x85, 0x16, 0x5A, 0xAE, 0x08, 0xF0, 0x00, 0x5D,
	0xE0, 0x04, 0x0B, 0xD7, 0x60, 0xE0, 0x67, 0x0F, 0x33, 0xC0, 0x72,
	0x1D, 0x4A, 0x34, 0xB7, 0xB8, 0x8B, 0xA8, 0x50, 0x0C, 0xDC, 0xE1,
	0x08, 0x3D, 0x20, 0x03, 0x03, 0x19, 0x6A, 0x42, 0xD1, 0x94, 0x46,
	0x31, 0x6A, 0x8A, 0xA4, 0xA3, 0x8F, 0xB7, 0x14, 0x76, 0xD8, 0x01,
	0xA1, 0x61, 0x5B, 0x33, 0x4A, 0xA3, 0x5C, 0x14, 0x20, 0x79, 0x55,
	0x36, 0x77, 0x58, 0x05, 0x0B, 0x62, 0x79, 0x7A, 0xB8, 0x48, 0x8F,
	0xC4, 0x48, 0x34, 0x80, 0x21, 0x0B, 0x90, 0x21, 0x41, 0x5A, 0x96,
	0x41, 0x2A, 0x88, 0x47, 0x6A, 0xA3, 0x0A, 0x70, 0x21, 0x19, 0x42,
	0x00, 0x2A, 0x82, 0x6C, 0xB1, 0x77, 0x00, 0xCE, 0x26, 0x97, 0x93,
	0x18, 0xA5, 0x34, 0x72, 0x23, 0x3A, 0x32, 0xA5, 0x77, 0x99, 0x97,
	0xD6, 0x26, 0x31, 0x58, 0xCA, 0x89, 0x25, 0x29, 0x84, 0x9C, 0x83,
	0x5D, 0x83, 0x39, 0x8A, 0xA2, 0x63, 0xAC, 0x3E, 0x0B, 0x30, 0x66,
	0x1A, 0xB4, 0xE6, 0x05, 0x64, 0x8E, 0xB9, 0x5E, 0xB8, 0xC8, 0xA6,
	0xB1, 0xA8, 0x12, 0x29, 0x71, 0x3C, 0xC0, 0xF0, 0x6E, 0x99, 0x70,
	0x0A, 0x36, 0x80, 0x9C, 0xEF, 0xDA, 0x7D, 0xDE, 0xE7, 0x61, 0x7C,
	0xEA, 0xA7, 0xFA, 0xB5, 0x02, 0x3F, 0x10, 0x04, 0x31, 0xE0, 0x02,
	0x5E, 0x2B, 0xA8, 0x81, 0x4A, 0xA8, 0x85, 0xBA, 0x7E, 0x08, 0xA6,
	0xA8, 0xDB, 0x23, 0x7F, 0xA4, 0xD9, 0xA8, 0xEC, 0x80, 0x0E, 0xE3,
	0xD3, 0x68, 0x90, 0xEA, 0xA9, 0x0E, 0x75, 0x11, 0xBB, 0xE2, 0x2B,
	0x2B, 0x01, 0x0B, 0x25, 0xA1, 0x04, 0x92, 0xCA, 0x51, 0xA1, 0x42,
	0x8E, 0x19, 0x37, 0x11, 0xCF, 0x59, 0x52, 0x73, 0xDB, 0x80, 0x08,
	0xD8, 0x10, 0xD1, 0xF2, 0xAE, 0xFF, 0xF0, 0x0F, 0x91, 0x66, 0x11,
	0xAB, 0xCA, 0xFF, 0xAA, 0xAD, 0xEA, 0x2C, 0xED, 0x55, 0x73, 0xB1,
	0x7A, 0x6F, 0xFE, 0xE8, 0x0B, 0xB4, 0x5A, 0xAB, 0x04, 0xF9, 0x13,
	0xB8, 0xAA, 0x9E, 0xBB, 0xCA, 0xAB, 0x51, 0xE1, 0xAB, 0x4E, 0x86,
	0x74, 0x4D, 0x65, 0x2F, 0x53, 0x96, 0x2F, 0xF5, 0xF9, 0xB3, 0x35,
	0x18, 0x18, 0x61, 0xA6, 0xAC, 0xFC, 0xC9, 0x18, 0xBB, 0xD1, 0x97,
	0x19, 0x30, 0x02, 0xD1, 0x5A, 0x44, 0x56, 0x34, 0x25, 0xA8, 0x2B,
	0x00, 0x5B, 0x20, 0x00, 0x29, 0xE3, 0x92, 0x3A, 0x32, 0x23, 0x54,
	0xF0, 0x22, 0xDD, 0x0A, 0x68, 0x37, 0x29, 0xAE, 0x38, 0xC9, 0x05,
	0x0F, 0xD0, 0x85, 0x15, 0xC0, 0x05, 0xB0, 0x12, 0x3E, 0x64, 0x8B,
	0x3D, 0xEB, 0xAA, 0xA1, 0xED, 0xCA, 0x4E, 0xD5, 0x61, 0x04, 0x4A,
	0x40, 0x2D, 0x37, 0x85, 0x2D, 0xD8, 0x92, 0x78, 0x97, 0x7B, 0xA2,
	0x8D, 0xE7, 0x03, 0xAC, 0x15, 0x95, 0x95, 0xA7, 0x87, 0x72, 0xF8,
	0x5A, 0xC7, 0xA6, 0x21, 0x62, 0x93, 0x7A, 0x32, 0xEA, 0x18, 0x0E,
	0x30, 0x00, 0x22, 0xBB, 0x01, 0x0A, 0xB0, 0x01, 0x53, 0x50, 0x5A,
	0xDC, 0x7B, 0x49, 0x0C, 0xE2, 0x03, 0x93, 0x17, 0x79, 0x01, 0x4B,
	0x95, 0x01, 0x2B, 0x49, 0x51, 0x50, 0x00, 0x04, 0xA2, 0x00, 0x50,
	0x94, 0x1A, 0x43, 0xFA, 0x31, 0x1C, 0x02, 0xC0, 0x52, 0x24, 0xC0,
	0x14, 0xB0, 0x00, 0x12, 0x82, 0x00, 0x19, 0x7B, 0x4A, 0x02, 0x42,
	0x00, 0xAA, 0x76, 0x5C, 0x28, 0x9B, 0xB2, 0x12, 0xCC, 0xB2, 0x36,
	0xA2, 0x4B, 0x54, 0xFA, 0x38, 0xB8, 0xF7, 0x5C, 0x57, 0x4A, 0x39,
	0xD2, 0xF5, 0x66, 0x2E, 0xD3, 0xA5, 0x4D, 0x08, 0x6E, 0x84, 0xD9,
	0x4C, 0xA6, 0x5B, 0xC2, 0x61, 0x12, 0xA8, 0x5E, 0x9B, 0xC2, 0x2A,
	0xBC, 0xC2, 0x2C, 0xDC, 0xC2, 0x2E, 0xFC, 0xC2, 0x30, 0xDC, 0xC2,
	0x30, 0x20, 0xC3, 0x60, 0x5B, 0xFF, 0xC3, 0x28, 0x1C, 0xC3, 0x34,
	0x5C, 0xC3, 0x38, 0xEC, 0x02, 0x36, 0x6C, 0xC3, 0xCB, 0xA8, 0xC3,
	0x29, 0xDC, 0x02, 0x42, 0x3C, 0xC4, 0x44, 0x5C, 0xC4, 0x46, 0x4C,
	0xC4, 0x3B, 0xEC, 0xC2, 0x3D, 0xFC, 0x9A, 0xB0, 0x69, 0x70, 0xCB,
	0x8B, 0x3D, 0x0D, 0xA6, 0x9B, 0x52, 0xBC, 0x9B, 0x8E, 0x5A, 0x51,
	0xC2, 0x12, 0x80, 0x70, 0x5B, 0x3E, 0xEE, 0x5A, 0x4F, 0x9E, 0xE9,
	0x0F, 0xB9, 0xB3, 0x4E, 0x96, 0xDA, 0x3E, 0x6E, 0x8B, 0x7F, 0x19,
	0x37, 0x51, 0xDE, 0x28, 0xC6, 0x06, 0xF1, 0x0F, 0xAC, 0x22, 0xB8,
	0xFC, 0xC0, 0x0F, 0xD0, 0x7B, 0x2C, 0xFD, 0x00, 0x4F, 0x88, 0xAB,
	0xAA, 0x8B, 0x0B, 0x53, 0x8D, 0xFB, 0x2C, 0x8F, 0x9B, 0x3C, 0x36,
	0xC7, 0x81, 0x93, 0x5B, 0xB9, 0xDE, 0x72, 0x1E, 0xE8, 0x59, 0x64,
	0xB9, 0xBA, 0x9E, 0x50, 0xC1, 0xB9, 0x50, 0xE0, 0xB9, 0x2D, 0x18,
	0xBA, 0x2F, 0x04, 0x83, 0x51, 0x45, 0x91, 0xD0, 0xC4, 0x0D, 0x08,
	0x17, 0xC9, 0x92, 0x3C, 0xC9, 0x94, 0x2C, 0xC9, 0xF0, 0xD7, 0x60,
	0x09, 0x56, 0xC9, 0xD9, 0xF0, 0x7E, 0x96, 0xFC, 0x7E, 0x8A, 0xCA,
	0x93, 0x97, 0x02, 0x3D, 0xA2, 0x3C, 0xCA, 0xD3, 0x90, 0x0D, 0xCF,
	0x78, 0x60, 0xD7, 0x78, 0x50, 0xE2, 0xC7, 0x10, 0xEC, 0xA4, 0xAA,
	0x33, 0x00, 0xB5, 0x38, 0x17, 0x3B, 0xFB, 0xFA, 0x53, 0xFF, 0xCA,
	0x1E, 0x48, 0xC1, 0xA3, 0x96, 0xD7, 0x14, 0x1C, 0x40, 0xA3, 0x89,
	0xB6, 0x1F, 0x19, 0xE0, 0x21, 0x27, 0x39, 0xA3, 0x49, 0x72, 0xC0,
	0x32, 0xAA, 0x48, 0x97, 0x54, 0x05, 0x3B, 0x90, 0xCC, 0x12, 0x8B,
	0x48, 0x51, 0x60, 0x6A, 0x73, 0xF8, 0x78, 0x24, 0x22, 0x37, 0x1C,
	0x40, 0x7A, 0x02, 0x92, 0x68, 0x76, 0xC7, 0x21, 0x68, 0x84, 0x1F,
	0x1A, 0xC2, 0xBE, 0x0A, 0x90, 0xC0, 0x13, 0x92, 0xFF, 0x00, 0x19,
	0x2B, 0x1A, 0x21, 0xDB, 0x5B, 0x0D, 0x6C, 0xB2, 0x73, 0xF7, 0x22,
	0x81, 0x35, 0xC1, 0x74, 0xC9, 0x38, 0xD3, 0x76, 0x97, 0x55, 0x9A,
	0x89, 0x7B, 0x59, 0xB3, 0x65, 0x76, 0xB3, 0x1F, 0xEC, 0x6D, 0xC1,
	0x97, 0x4C, 0xDB, 0x25, 0x3A, 0x86, 0x69, 0xC2, 0xFC, 0x8C, 0x17,
	0x37, 0xBC, 0xC2, 0x33, 0x9C, 0xC4, 0x02, 0x3D, 0xD0, 0x2C, 0x1C,
	0xD0, 0x31, 0xBC, 0xC4, 0x06, 0x3D, 0xD0, 0x3D, 0x8C, 0xC3, 0x08,
	0x8D, 0xD0, 0x2B, 0x7C, 0xC4, 0x10, 0x1D, 0xD1, 0x2D, 0xC0, 0xC2,
	0x43, 0x7C, 0xD0, 0x60, 0x2B, 0xB6, 0x18, 0xED, 0xC4, 0x4F, 0x0C,
	0x50, 0x9F, 0x32, 0xC5, 0xBA, 0xB9, 0x33, 0xA6, 0x12, 0x80, 0x64,
	0xBC, 0x3E, 0x00, 0xD8, 0x11, 0xA7, 0xF0, 0xC5, 0xA5, 0x4A, 0x9D,
	0xCB, 0x13, 0x11, 0xE8, 0x20, 0x05, 0x2F, 0x90, 0xC5, 0x0E, 0x85,
	0xC5, 0x7D, 0x5B, 0x80, 0xBE, 0x62, 0x01, 0xA3, 0xAA, 0xC6, 0xA5,
	0xFA, 0xAE, 0x18, 0x81, 0x01, 0x36, 0x5D, 0x9D, 0x27, 0x97, 0x3E,
	0x75, 0x5C, 0x8F, 0x77, 0x8C, 0xC7, 0xE0, 0x39, 0xAF, 0x7B, 0xCC,
	0xC7, 0x94, 0xCB, 0x53, 0x82, 0x30, 0xCB, 0x81, 0xFC, 0x87, 0x9A,
	0x9B, 0x90, 0x86, 0x7C, 0xC8, 0xEF, 0xF9, 0xAB, 0xF2, 0x79, 0x16,
	0x8C, 0x3C, 0x91, 0x29, 0x50, 0xAC, 0xA8, 0x03, 0xC9, 0x98, 0xB2,
	0x04, 0x91, 0xBC, 0xD1, 0xD5, 0xE0, 0x4F, 0x9A, 0xFC, 0xD5, 0x9A,
	0xEC, 0x7E, 0x63, 0xCD, 0xBC, 0x0B, 0xF7, 0xD5, 0xA9, 0x1C, 0x7F,
	0xF0, 0xF7, 0xC4, 0xA4, 0xFC, 0xD6, 0xA2, 0x3C, 0x9B, 0xA5, 0x8C,
	0x29, 0xD2, 0x18, 0x7F, 0xA6, 0xD9, 0xAE, 0xD0, 0x19, 0x12, 0x75,
	0x14, 0xA2, 0x36, 0x10, 0x90, 0xE6, 0x39, 0x82, 0x85, 0xB4, 0xBD,
	0xEC, 0x41, 0xB0, 0x54, 0x20, 0xB0, 0x0F, 0x8C, 0x14, 0x03, 0x40,
	0xFF, 0x00, 0x0A, 0xEB, 0x00, 0xFE, 0x81, 0xB0, 0xB7, 0xD5, 0xD8,
	0xA1, 0x71, 0x37, 0x09, 0xF2, 0x00, 0x56, 0x50, 0xBF, 0x94, 0x07,
	0x79, 0x92, 0x74, 0xBF, 0xCF, 0x4C, 0x22, 0xEF, 0x41, 0x03, 0x05,
	0x00, 0x45, 0x63, 0x94, 0xCD, 0x52, 0xA4, 0xCD, 0x68, 0xC4, 0x21,
	0xE0, 0xEC, 0xBF, 0x47, 0x3A, 0x1A, 0x17, 0x32, 0x20, 0x23, 0xEB,
	0x88, 0x20, 0x10, 0x58, 0x11, 0x2C, 0xC1, 0x54, 0xD0, 0x01, 0x8A,
	0xF3, 0x22, 0xB6, 0xD4, 0xCE, 0xEE, 0xEC, 0x38, 0xDA, 0xAA, 0xC1,
	0xF1, 0x2C, 0xCF, 0x20, 0xE9, 0x89, 0xB2, 0x01, 0xC2, 0x22, 0x4C,
	0x98, 0x5C, 0xD6, 0xCF, 0xC6, 0x9D, 0x17, 0xAE, 0x49, 0xD0, 0x5F,
	0x9B, 0xD0, 0xCA, 0x4D, 0xD0, 0xCC, 0x6D, 0xD1, 0x60, 0xDB, 0xDC,
	0x3C, 0xBC, 0xD0, 0x4A, 0xDC, 0xD0, 0xD4, 0xED, 0xB5, 0x12, 0x9D,
	0xDD, 0x45, 0x8C, 0xDD, 0x46, 0x9C, 0xC3, 0x3E, 0x8C, 0xD1, 0x62,
	0x4B, 0x0D, 0xE1, 0x40, 0x3D, 0xF0, 0x57, 0x10, 0xA4, 0xF9, 0x71,
	0xEF, 0x33, 0x11, 0xF9, 0x07, 0xD3, 0xF8, 0x15, 0x10, 0xF6, 0x80,
	0x1D, 0x0C, 0xB8, 0x2A, 0xFB, 0x46, 0x12, 0xA8, 0xF2, 0x04, 0x2F,
	0xAD, 0x7F, 0x56, 0x9C, 0xDE, 0x32, 0x9D, 0xB7, 0xF1, 0x50, 0x0F,
	0x26, 0x66, 0x7E, 0xEF, 0xA4, 0x04, 0x28, 0x17, 0x9D, 0xC6, 0xA9,
	0x3B, 0x24, 0x37, 0xC7, 0x41, 0x6D, 0xC7, 0x43, 0xED, 0xB8, 0x45,
	0x0D, 0xAB, 0x9A, 0x69, 0x0C, 0x3E, 0xA6, 0xD4, 0x83, 0x64, 0xAB,
	0x4D, 0xFD, 0x41, 0x83, 0xBC, 0xB9, 0x9C, 0xBB, 0x82, 0x54, 0xAD,
	0xC8, 0x56, 0x3D, 0xAC, 0x8E, 0xFC, 0x4C, 0x5E, 0x7D, 0xD6, 0xEC,
	0x27, 0xE2, 0x93, 0x7C, 0xA8, 0x23, 0x5E, 0xC9, 0x66, 0x2D, 0xE2,
	0x97, 0xAC, 0x60, 0xEA, 0xE7, 0xC9, 0x6C, 0x1D, 0x0E, 0x1B, 0x0D,
	0xD7, 0x32, 0x4E, 0xFF, 0xCA, 0x9B, 0x7C, 0xC9, 0x9E, 0xA2, 0x60,
	0x76, 0x7D, 0xD7, 0x2B, 0x80, 0x11, 0xAF, 0x3C, 0xB5, 0x1E, 0x61,
	0x12, 0xE3, 0xC1, 0x73, 0x27, 0x6A, 0xE1, 0x47, 0x31, 0x5A, 0x6F,
	0xF3, 0xCC, 0xF8, 0x6B, 0x79, 0x51, 0x41, 0x05, 0xB1, 0x07, 0x4B,
	0x2C, 0xB2, 0x35, 0x07, 0x50, 0x00, 0xA7, 0x67, 0x00, 0xDC, 0xAC,
	0x21, 0x56, 0x4E, 0xB2, 0x94, 0x2D, 0x87, 0x9B, 0x14, 0x48, 0x3E,
	0x41, 0x6C, 0x5A, 0x0E, 0xCD, 0x08, 0x62, 0x14, 0x0F, 0x20, 0xA3,
	0x89, 0x76, 0xC0, 0x64, 0xB4, 0x00, 0xA5, 0x4D, 0xDA, 0x48, 0xBA,
	0x5B, 0xA3, 0x31, 0x88, 0xA9, 0xA1, 0x00, 0x84, 0x15, 0xB2, 0x69,
	0x83, 0x6C, 0xE8, 0xFC, 0xDA, 0xEA, 0xEC, 0x6C, 0xB6, 0x94, 0xDB,
	0xBA, 0xED, 0x23, 0x3B, 0x02, 0xCF, 0x34, 0xCB, 0xC1, 0x94, 0x11,
	0x33, 0xC1, 0x9D, 0xB3, 0x82, 0x39, 0x98, 0xB6, 0x4B, 0x7C, 0xFB,
	0x7C, 0xDC, 0xFD, 0xFC, 0xDC, 0x3B, 0x9C, 0xDC, 0xD2, 0xAD, 0xDC,
	0x8C, 0x0E, 0xC3, 0x36, 0x2C, 0xDD, 0x4B, 0xEC, 0xDD, 0xD6, 0x2D,
	0xA8, 0x0F, 0xAD, 0xDD, 0xDA, 0xED, 0x02, 0x10, 0xAD, 0xC2, 0x97,
	0x0E, 0xDE, 0x4D, 0x9C, 0x7E, 0x30, 0x4E, 0xD7, 0x97, 0x9C, 0x50,
	0xE8, 0x3D, 0xC6, 0x15, 0x07, 0xD3, 0x12, 0xA5, 0x0C, 0x40, 0xF3,
	0x72, 0xED, 0x5D, 0xE0, 0x27, 0x01, 0x41, 0x8C, 0x56, 0x2B, 0x7D,
	0xEB, 0x58, 0xF6, 0x93, 0x50, 0xCB, 0xF9, 0x8D, 0x34, 0x6D, 0x62,
	0xFD, 0x55, 0x7D, 0xDF, 0x54, 0x52, 0x07, 0xEE, 0xE3, 0x09, 0xCE,
	0x2C, 0xAD, 0xAA, 0x3E, 0x44, 0xED, 0x27, 0x19, 0x78, 0xD4, 0xF7,
	0xD6, 0x0B, 0x49, 0xA0, 0x41, 0x4B, 0x7D, 0x9E, 0xB4, 0xEC, 0xD4,
	0x40, 0x07, 0xD5, 0x86, 0x8C, 0xC8, 0x4F, 0xC6, 0xE1, 0x26, 0xF0,
	0x54, 0x31, 0x44, 0xBA, 0xC4, 0x1A, 0xFF, 0x4D, 0x21, 0x3E, 0xD6,
	0xD7, 0x43, 0xE2, 0x98, 0x22, 0x9B, 0xE2, 0x4E, 0xEA, 0x2C, 0xAE,
	0xE2, 0x30, 0x7E, 0xEE, 0x35, 0xBE, 0xD6, 0x07, 0xD5, 0xD6, 0xA1,
	0x2C, 0xE3, 0xD0, 0x30, 0xE3, 0xD1, 0x53, 0x9B, 0x02, 0xD5, 0xEE,
	0xF5, 0xEE, 0x0D, 0x3A, 0x7E, 0xD7, 0x3C, 0x9E, 0x28, 0x0D, 0x04,
	0x41, 0xA7, 0x30, 0xE4, 0x24, 0xC8, 0x5A, 0x45, 0xEE, 0x03, 0x85,
	0xAD, 0xA3, 0x4B, 0x71, 0x79, 0x96, 0x4D, 0x05, 0x03, 0x60, 0x00,
	0x65, 0xA3, 0x6A, 0xAE, 0x87, 0x36, 0x6B, 0x63, 0xE5, 0x0A, 0xC0,
	0x00, 0x55, 0x20, 0xB1, 0xB7, 0xDC, 0xD9, 0x3E, 0xE1, 0x76, 0x4F,
	0xC3, 0x95, 0x3B, 0x8A, 0x20, 0x34, 0x00, 0x02, 0xFD, 0xB1, 0x46,
	0x78, 0x25, 0xA4, 0xA3, 0xED, 0x6B, 0x51, 0xE4, 0xBF, 0x5B, 0x57,
	0xC0, 0x67, 0xA4, 0x21, 0x1E, 0x32, 0x00, 0x91, 0x68, 0xE7, 0x77,
	0x4E, 0x89, 0xD0, 0xA6, 0xE7, 0x1C, 0xF0, 0x21, 0x57, 0xA1, 0xAD,
	0x19, 0x0C, 0x39, 0x1B, 0x0C, 0xE8, 0xBF, 0x2D, 0xE8, 0x9B, 0x13,
	0x98, 0xC7, 0xF4, 0x39, 0xF9, 0xDC, 0x65, 0xE3, 0xA6, 0xE8, 0xC7,
	0xED, 0xE8, 0x02, 0x8D, 0xF4, 0x8F, 0x9E, 0xF4, 0xCD, 0x0D, 0xC4,
	0x90, 0x7E, 0xDD, 0x29, 0x7C, 0xE9, 0x4E, 0x1F, 0xC4, 0x9A, 0x5E,
	0xF5, 0xDB, 0xBD, 0xDC, 0x0D, 0x0D, 0xEA, 0xA1, 0x0E, 0x3D, 0x88,
	0x0A, 0xD6, 0xB5, 0x49, 0x0E, 0x56, 0xEC, 0x9C, 0xE7, 0x48, 0xC6,
	0x7C, 0x6B, 0x51, 0x24, 0x9D, 0xC5, 0xF7, 0x55, 0x7E, 0x23, 0x61,
	0x11, 0xF7, 0x6D, 0x71, 0xF8, 0x87, 0x8E, 0xD2, 0x21, 0x61, 0xE9,
	0x6D, 0x51, 0xF2, 0xE0, 0x04, 0x9E, 0x09, 0x2B, 0x24, 0x67, 0xD3,
	0xC8, 0x49, 0x52, 0xBE, 0xFE, 0x3F, 0xC0, 0x0E, 0x41, 0x74, 0x3C,
	0xEC, 0x1F, 0xE1, 0x9D, 0xAC, 0x8E, 0x63, 0xB5, 0x18, 0xFF, 0x9E,
	0xF6, 0x76, 0x73, 0x98, 0xA0, 0x73, 0x3A, 0x01, 0xC8, 0x15, 0x0E,
	0x42, 0x4F, 0x7D, 0x82, 0x51, 0x6D, 0xED, 0xA0, 0x1B, 0xAC, 0x8B,
	0x2C, 0x91, 0x32, 0x28, 0x4D, 0xDF, 0x4E, 0xC9, 0x02, 0x55, 0xEE,
	0xE0, 0x8E, 0xEE, 0x9D, 0x6F, 0xA8, 0x26, 0x8E, 0x70, 0xF7, 0x7E,
	0xE3, 0x1B, 0xED, 0xE2, 0x6C, 0xED, 0x29, 0xE3, 0x2E, 0xEF, 0xAC,
	0x4F, 0xEE, 0xF4, 0x6E, 0xB6, 0x3D, 0x99, 0xEF, 0xA6, 0x89, 0x5F,
	0xAF, 0x0C, 0x2B, 0x0D, 0xC4, 0xC5, 0x9C, 0x65, 0x82, 0x4E, 0x01,
	0xA3, 0xA9, 0xC5, 0xF1, 0x03, 0x5B, 0xF0, 0x3A, 0xBA, 0x03, 0x50,
	0x90, 0x6A, 0xAA, 0xA6, 0xF0, 0x64, 0xC3, 0xAD, 0x82, 0x36, 0x1F,
	0x54, 0x20, 0x36, 0xCD, 0x0C, 0xE6, 0x77, 0x18, 0xE6, 0xB5, 0x46,
	0x5B, 0x49, 0xE0, 0x76, 0xA0, 0x15, 0x05, 0x9C, 0xCD, 0x00, 0x24,
	0x1F, 0x45, 0x2C, 0xFF, 0xE6, 0x27, 0xBF, 0xE6, 0x11, 0x9F, 0xF2,
	0xA7, 0x34, 0x01, 0x17, 0x72, 0x21, 0x04, 0xD0, 0x01, 0x2F, 0x1F,
	0xF3, 0x14, 0xBC, 0x38, 0x34, 0xFF, 0x23, 0x7D, 0x2E, 0xB3, 0x9A,
	0x68, 0x24, 0xAE, 0xE1, 0xF3, 0xF6, 0xFC, 0x6D, 0xF8, 0x2C, 0x6E,
	0x45, 0x6F, 0xF4, 0xFC, 0xAC, 0xD0, 0xD3, 0x1D, 0xE9, 0x4B, 0x0F,
	0x08, 0x2E, 0x82, 0x83, 0x82, 0x30, 0x30, 0x84, 0x88, 0x89, 0x84,
	0x86, 0x8C, 0x8A, 0x8E, 0x2E, 0x87, 0x8B, 0x8C, 0x93, 0x94, 0x95,
	0x96, 0x94, 0x89, 0x2D, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0x9C,
	0x89, 0x97, 0x31, 0xA4, 0xA5, 0xA6, 0xA6, 0x41, 0xA9, 0xAA, 0xAB,
	0x41, 0x38, 0x3F, 0x39, 0x39, 0x38, 0xB2, 0xB3, 0xB2, 0x3F, 0xB6,
	0xB0, 0x3C, 0x3C, 0x45, 0x4F, 0xBC, 0xBC, 0x48, 0xBF, 0xC0, 0xC1,
	0x4F, 0x48, 0xBC, 0x4E, 0xC6, 0x4E, 0xBD, 0xBC, 0x52, 0xBE, 0x52,
	0xCD, 0xFF, 0xCE, 0xCF, 0xD0, 0xD1, 0xCB, 0xBD, 0xC1, 0xBF, 0xC7,
	0xBB, 0x4F, 0x45, 0x45, 0xCE, 0xC9, 0xCA, 0xBC, 0xDA, 0xDA, 0xB9,
	0xE2, 0x3C, 0x4E, 0x33, 0x4E, 0xE3, 0xE2, 0xD8, 0xBD, 0x45, 0x33,
	0x40, 0x40, 0x4A, 0xEE, 0x4A, 0x4A, 0x33, 0x16, 0xED, 0xF3, 0xF2,
	0xF7, 0xF9, 0x33, 0xF8, 0xFC, 0xFD, 0xF5, 0x4A, 0xF5, 0x2C, 0x08,
	0x9C, 0x31, 0xA3, 0x9A, 0xC1, 0x83, 0x08, 0xAB, 0x11, 0x5C, 0xC8,
	0xB0, 0xA1, 0xC3, 0x87, 0xFD, 0x22, 0xC2, 0x73, 0x47, 0x11, 0x88,
	0x8E, 0x8B, 0x18, 0x2F, 0x36, 0xD9, 0xC8, 0xB1, 0xA3, 0x8D, 0x8F,
	0x49, 0x92, 0xC8, 0x18, 0x59, 0xA3, 0xE4, 0x91, 0x1A, 0x47, 0x68,
	0xA8, 0x5C, 0xC9, 0x92, 0x46, 0x94, 0x97, 0x30, 0x61, 0x56, 0x99,
	0x49, 0xB3, 0x26, 0x95, 0x9B, 0x38, 0x73, 0xEA, 0xBC, 0x09, 0xA5,
	0xA7, 0xCF, 0x9F, 0x40, 0x7F, 0x4E, 0x19, 0x4A, 0xB4, 0xE8, 0x94,
	0x08, 0x48, 0xAF, 0x28, 0x5D, 0xCA, 0xA2, 0xA9, 0x53, 0x16, 0x26,
	0xA2, 0x46, 0xD5, 0xA2, 0x45, 0x85, 0x0A, 0x01, 0x02, 0xAC, 0x6E,
	0xC9, 0x92, 0x25, 0x05, 0x80, 0xAF, 0x60, 0xC3, 0x8A, 0x1D, 0x4B,
	0xB6, 0x2C, 0x58, 0x26, 0xB4, 0xD2, 0xAA, 0xB5, 0xC5, 0x56, 0xAD,
	0xDB, 0xB7, 0x70, 0xDF, 0xFE, 0x88, 0x4B, 0x97, 0xAD, 0x2D, 0x5A,
	0xAC, 0x52, 0xC5, 0xB5, 0x6B, 0x17, 0x56, 0x8E, 0x57, 0x7F, 0xF9,
	0xFA, 0x1D, 0x0C, 0x58, 0x6D, 0xDE, 0xC3, 0x88, 0x13, 0xEB, 0x4D,
	0xCB, 0x76, 0xB0, 0x5F, 0x1E, 0x7E, 0x57, 0x48, 0x9E, 0x4C, 0x79,
	0xF2, 0xB1, 0xCB, 0x18, 0x66, 0xE8, 0x00, 0x72, 0x70, 0xA1, 0x3C,
	0x8B, 0x49, 0x5C, 0x56, 0xD9, 0x49, 0x9A, 0x8A, 0x4F, 0x9C, 0x35,
	0x47, 0xDF, 0x54, 0x8D, 0xD3, 0x8A, 0xEB, 0xD7, 0xB0, 0x5D, 0xEF,
	0xD8, 0x01, 0xC5, 0x0A, 0xFF, 0x95, 0xD7, 0x58, 0x72, 0xD3, 0xD4,
	0x19, 0xF3, 0x01, 0x16, 0x2B, 0xB9, 0x75, 0x57, 0xC1, 0x52, 0xE5,
	0xE5, 0xCA, 0x07, 0xC8, 0x93, 0x77, 0xC8, 0xD0, 0x80, 0x42, 0x85,
	0xE4, 0x0F, 0x6A, 0x24, 0xA7, 0x31, 0xBC, 0x0A, 0x0D, 0x10, 0x0D,
	0x32, 0x48, 0x50, 0x90, 0x21, 0x03, 0x05, 0x0A, 0x0A, 0x16, 0x70,
	0xDF, 0x2E, 0x41, 0x02, 0x78, 0xF3, 0x0A, 0xD0, 0x7F, 0x5F, 0xCF,
	0xFE, 0xFB, 0x02, 0xF1, 0xE0, 0x15, 0xC8, 0x37, 0x60, 0x80, 0x00,
	0x95, 0x03, 0xF8, 0x41, 0xE8, 0xDF, 0xCF, 0xBF, 0xFF, 0xFE, 0x0E,
	0x00, 0x06, 0x28, 0x20, 0x07, 0x04, 0x16, 0xB8, 0x41, 0x81, 0x08,
	0x26, 0xB8, 0xC1, 0x82, 0x0C, 0x32, 0xC8, 0xDE, 0x08, 0x10, 0x46,
	0xD8, 0xDD, 0x84, 0x19, 0x88, 0x60, 0xA1, 0x85, 0x52, 0x49, 0x75,
	0xC1, 0x86, 0x17, 0x94, 0xE0, 0x61, 0x09, 0x58, 0x79, 0xB8, 0xC5,
	0x88, 0x5B, 0x40, 0x60, 0x22, 0x04, 0x66, 0xA5, 0xA8, 0xE2, 0x8A,
	0x2C, 0xB6, 0xE8, 0xE2, 0x8B, 0x30, 0xC6, 0xE8, 0xE2, 0x23, 0x8B,
	0x40, 0x82, 0x09, 0x8D, 0x38, 0xE6, 0x38, 0x88, 0x21, 0x3A, 0x3E,
	0x72, 0x63, 0x8F, 0x85, 0x5C, 0x22, 0xE4, 0x90, 0x93, 0x64, 0x02,
	0xCA, 0x91, 0x48, 0x6A, 0xE2, 0x48, 0x25, 0xA7, 0x34, 0x89, 0x4A,
	0x62, 0x38, 0xB4, 0xE2, 0x0A, 0x2C, 0x72, 0x35, 0x96, 0x43, 0x2E,
	0xBB, 0x54, 0x63, 0x84, 0x11, 0x48, 0x70, 0xE9, 0xE5, 0x96, 0x60,
	0x82, 0x29, 0x05, 0x30, 0xC6, 0x24, 0x64, 0x84, 0x34, 0x68, 0x46,
	0xD3, 0x0D, 0x99, 0x4E, 0x80, 0xD3, 0x4C, 0x37, 0xDD, 0x80, 0x93,
	0x8E, 0x66, 0x16, 0x29, 0x81, 0x0E, 0x3A, 0xD8, 0x14, 0xE1, 0xC4,
	0x44, 0x9F, 0xBD, 0x03, 0x90, 0x05, 0xF2, 0x10, 0x34, 0x8F, 0xA0,
	0xFC, 0xEC, 0x23, 0xD1, 0x3C, 0x02, 0xD5, 0xFF, 0x43, 0xCF, 0x3E,
	0x8B, 0x72, 0x99, 0xD0, 0xA3, 0x8F, 0x3E, 0x24, 0xE9, 0xA4, 0x9E,
	0x1D, 0x8A, 0x4F, 0x45, 0x15, 0x65, 0x94, 0x51, 0x47, 0x9C, 0x82,
	0x14, 0x92, 0x0C, 0x25, 0x85, 0x7A, 0x52, 0x4B, 0xA4, 0xBA, 0x14,
	0x93, 0x4C, 0xA9, 0xD9, 0x54, 0x1A, 0x69, 0x41, 0xB5, 0xDA, 0xAA,
	0x51, 0xB0, 0x22, 0x15, 0xC1, 0x52, 0x4C, 0x3D, 0xD5, 0x54, 0x86,
	0x26, 0x54, 0x65, 0x15, 0x56, 0x5A, 0x6D, 0x95, 0x82, 0x57, 0x32,
	0xC6, 0x88, 0x56, 0x5D, 0x7C, 0xCD, 0x45, 0xD7, 0xB1, 0xC8, 0xBA,
	0x92, 0x2C, 0x5C, 0x7C, 0x19, 0x26, 0xCB, 0x62, 0xB4, 0xBC, 0x52,
	0xEC, 0xB4, 0x7F, 0x39, 0x66, 0xED, 0x2D, 0xC6, 0xCE, 0xA2, 0xD8,
	0xB6, 0x8A, 0x55, 0x09, 0xD8, 0x63, 0xB9, 0xAC, 0xC0, 0x43, 0x65,
	0xE4, 0x3A, 0xB1, 0xC2, 0x65, 0x48, 0x10, 0x84, 0x04, 0x06, 0x99,
	0x71, 0xD1, 0x45, 0x41, 0x0A, 0x79, 0xE6, 0x8E, 0x0E, 0x21, 0x45,
	0xC1, 0x9A, 0x69, 0xF8, 0xBA, 0xEA, 0xEA, 0x6A, 0x05, 0xDC, 0xBB,
	0x53, 0x6C, 0x00, 0xCF, 0x06, 0xDC, 0x6F, 0xB0, 0x05, 0x47, 0x53,
	0xBF, 0x51, 0xF8, 0xE0, 0x5A, 0x70, 0x03, 0x2F, 0x5C, 0x1C, 0x72,
	0xD2, 0x1D, 0xE0, 0x40, 0x79, 0x0D, 0x54, 0xCC, 0x40, 0x12, 0xD0,
	0x41, 0x57, 0x43, 0x14, 0xC4, 0x31, 0x90, 0x5E, 0x77, 0xE6, 0x75,
	0xF7, 0x1D, 0x7D, 0x0B, 0x1C, 0xB0, 0x00, 0x7D, 0x06, 0x28, 0x40,
	0xC1, 0x76, 0xE9, 0xC9, 0xD7, 0xDE, 0x7A, 0xE1, 0xBD, 0xB7, 0x40,
	0x02, 0x09, 0xC8, 0x6C, 0xC0, 0xC9, 0x04, 0xE8, 0x77, 0x80, 0x7F,
	0x3C, 0xF7, 0x27, 0xE0, 0xCF, 0x00, 0x22, 0xD8, 0x60, 0x82, 0x44,
	0x73, 0xD0, 0x60, 0x83, 0x0F, 0x46, 0x38, 0x02, 0x85, 0xDD, 0x5D,
	0x78, 0x21, 0xAE, 0x1C, 0x6E, 0xF8, 0x61, 0x88, 0x25, 0x90, 0xFF,
	0x38, 0xA2, 0x89, 0xC1, 0x66, 0xAD, 0xF5, 0xD6, 0x5C, 0x77, 0x3D,
	0x23, 0x8E, 0x97, 0x00, 0x29, 0xB6, 0x28, 0x91, 0x8C, 0x8D, 0x48,
	0x25, 0x40, 0x12, 0xA9, 0x36, 0x0C, 0xA4, 0xFC, 0x38, 0x48, 0x92,
	0x70, 0x7F, 0x02, 0x09, 0xD9, 0x8C, 0x38, 0x69, 0x77, 0x0C, 0x88,
	0x31, 0x56, 0x0B, 0x2C, 0x77, 0x2D, 0x11, 0xAD, 0x95, 0x57, 0x62,
	0xF9, 0x4B, 0x98, 0x84, 0x17, 0x0E, 0xA6, 0x10, 0x88, 0x1B, 0x21,
	0x04, 0x98, 0x90, 0xFE, 0x92, 0xE6, 0x33, 0xCA, 0x40, 0x03, 0xE7,
	0x13, 0x6F, 0x46, 0xBE, 0xCC, 0x34, 0xE1, 0xF0, 0x80, 0x84, 0x12,
	0x17, 0xBD, 0x33, 0x2F, 0x12, 0x77, 0xA6, 0x93, 0xA7, 0xA1, 0xF1,
	0xC0, 0x63, 0x69, 0xA0, 0xA8, 0x0F, 0x7A, 0x68, 0x41, 0xF4, 0x38,
	0x01, 0x8C, 0x05, 0xBF, 0x28, 0xDA, 0xF8, 0xEC, 0xF1, 0x52, 0x6A,
	0x3B, 0xA1, 0xA7, 0xF7, 0x89, 0xA9, 0xA6, 0x18, 0x71, 0xEA, 0x51,
	0x48, 0x22, 0x85, 0x2A, 0x6A, 0xA9, 0x2D, 0x9D, 0x8A, 0x6A, 0xAA,
	0x33, 0xAD, 0xCA, 0xAA, 0xBE, 0xCC, 0xC3, 0x1A, 0xEB, 0xAC, 0xB4,
	0x5E, 0x61, 0xEB, 0xAD, 0x19, 0xEA, 0x7A, 0x55, 0x56, 0x2A, 0x8C,
	0xD8, 0x95, 0xD7, 0x2C, 0x32, 0x81, 0x56, 0x2B, 0x52, 0xFE, 0x5D,
	0xEC, 0xB2, 0xE4, 0xAF, 0x95, 0x6D, 0xF9, 0x8C, 0x35, 0x7B, 0xEC,
	0xB4, 0xEC, 0x0B, 0x66, 0x6D, 0xB5, 0xE7, 0x3F, 0xCB, 0xED, 0xFC,
	0xAB, 0xAC, 0xE5, 0xCA, 0x2D, 0x83, 0xA1, 0x43, 0x6E, 0x65, 0x97,
	0xB9, 0x9E, 0x6E, 0x43, 0xF5, 0xD8, 0xCC, 0x0C, 0x0A, 0xC7, 0x90,
	0x3E, 0xD1, 0x0B, 0x63, 0xA3, 0x61, 0x9E, 0xAB, 0x8C, 0x02, 0x05,
	0x02, 0xFC, 0x64, 0x35, 0xC8, 0x4B, 0xDE, 0x6D, 0x00, 0x86, 0x1B,
	0x82, 0x55, 0x30, 0x38, 0x18, 0xCC, 0x8D, 0x15, 0x76, 0x00, 0x9C,
	0xE2, 0x18, 0xFF, 0xE7, 0x01, 0x34, 0x78, 0x00, 0x09, 0x38, 0xE0,
	0x80, 0x8A, 0x35, 0xA7, 0x01, 0x22, 0x20, 0x40, 0x74, 0x90, 0x63,
	0x2A, 0x98, 0xE8, 0x86, 0x06, 0xCB, 0xD9, 0xC0, 0x84, 0x36, 0x20,
	0x01, 0xED, 0xC0, 0xAC, 0x3C, 0x2A, 0x43, 0x8F, 0x7A, 0xE2, 0xF3,
	0x32, 0x98, 0xBD, 0xE7, 0x3B, 0x0A, 0xA0, 0x4F, 0x10, 0x17, 0x40,
	0x00, 0x0E, 0x80, 0x60, 0x67, 0x3D, 0x4B, 0x22, 0xD0, 0x7E, 0x26,
	0xB4, 0xA1, 0x6D, 0x80, 0x00, 0x45, 0x6C, 0xE2, 0xD1, 0x90, 0x46,
	0x01, 0xA5, 0x49, 0x88, 0x42, 0x4E, 0x13, 0x01, 0xAE, 0x4C, 0x10,
	0xB5, 0x0F, 0x81, 0x48, 0x00, 0x22, 0xB2, 0x1A, 0xD6, 0xB8, 0x47,
	0xC6, 0x32, 0x9A, 0xF1, 0x8C, 0x60, 0xD1, 0x11, 0xDA, 0xCC, 0x66,
	0x36, 0x1E, 0xB1, 0x51, 0x11, 0x96, 0x58, 0xD2, 0xDA, 0xE6, 0xE8,
	0x36, 0x41, 0xC4, 0xED, 0x8E, 0x4A, 0xAA, 0x91, 0x8D, 0x26, 0xE1,
	0xA4, 0x1B, 0x04, 0xC1, 0x49, 0x79, 0x33, 0x9F, 0x2D, 0x20, 0xF3,
	0x83, 0x25, 0x18, 0xD2, 0x90, 0xD4, 0xC2, 0x05, 0x96, 0x5C, 0x67,
	0xB8, 0x46, 0x2E, 0x4E, 0x71, 0x89, 0x7B, 0x24, 0xE2, 0x12, 0xE7,
	0x28, 0x24, 0xF4, 0xEF, 0x32, 0x96, 0x53, 0x93, 0xE4, 0xBA, 0x31,
	0x0D, 0xCA, 0xF5, 0x62, 0x19, 0xE1, 0x58, 0x41, 0xE6, 0x8A, 0x90,
	0xAE, 0x4B, 0x01, 0xA1, 0x08, 0x58, 0x52, 0x47, 0x27, 0xB3, 0xE1,
	0x04, 0x3F, 0xC5, 0xA3, 0x1D, 0x7E, 0xEA, 0x87, 0xA1, 0xF4, 0x91,
	0xBA, 0xD5, 0xC1, 0x4E, 0x1E, 0xFF, 0x58, 0x14, 0xBC, 0x68, 0x47,
	0xBB, 0xDB, 0xF9, 0x32, 0x1F, 0xA7, 0xC3, 0xD4, 0xBC, 0x78, 0xA7,
	0x11, 0xDF, 0xD9, 0x00, 0x78, 0x21, 0x11, 0x5E, 0x49, 0x88, 0xC7,
	0x12, 0xE3, 0xBD, 0x24, 0x82, 0x12, 0x54, 0x5E, 0x4E, 0x14, 0xA8,
	0x2F, 0xE7, 0x15, 0x45, 0x56, 0xFF, 0xD1, 0x93, 0xDE, 0xF4, 0x70,
	0x45, 0x95, 0x5D, 0x61, 0x2F, 0x7B, 0x5D, 0x01, 0x16, 0x1A, 0xC3,
	0xE2, 0x3D, 0x6D, 0x79, 0xEB, 0x2E, 0xE8, 0x43, 0x1F, 0x3A, 0xD3,
	0x79, 0xCE, 0xF6, 0xB1, 0x4F, 0x7C, 0x89, 0x74, 0x0C, 0x60, 0xE2,
	0x47, 0xBF, 0x7A, 0x9A, 0xEF, 0x7E, 0x8D, 0x81, 0xCC, 0x38, 0xF6,
	0x47, 0x99, 0x4B, 0x96, 0x03, 0x5E, 0x0D, 0x51, 0x42, 0x17, 0x92,
	0x00, 0x04, 0x48, 0x52, 0x72, 0x4B, 0xB3, 0x1C, 0x66, 0x48, 0x5C,
	0x42, 0x85, 0x0E, 0x04, 0xE5, 0x04, 0x10, 0x3D, 0x01, 0x14, 0x22,
	0x3A, 0x85, 0x13, 0x10, 0x00, 0xA2, 0x17, 0x85, 0xE2, 0x45, 0x61,
	0xD5, 0x13, 0x08, 0x42, 0x73, 0x34, 0x14, 0x8C, 0x0D, 0x06, 0x87,
	0x93, 0x41, 0x0D, 0x62, 0x21, 0x0A, 0x19, 0x4B, 0x29, 0x08, 0x70,
	0x16, 0x85, 0x24, 0xA4, 0x44, 0x83, 0x0B, 0x0B, 0x0E, 0x4A, 0x6B,
	0xB8, 0x32, 0x90, 0x51, 0x40, 0x64, 0xEC, 0xD1, 0x21, 0xCB, 0x76,
	0x0A, 0x9E, 0x1E, 0xC2, 0x4C, 0x65, 0xE0, 0x39, 0xD9, 0x7B, 0xE8,
	0x43, 0x80, 0x0E, 0x24, 0xF1, 0xA8, 0x20, 0x58, 0x62, 0x80, 0xA4,
	0x38, 0x34, 0xA6, 0x4E, 0x71, 0x41, 0xEB, 0xB1, 0x22, 0x84, 0x98,
	0x96, 0x45, 0x0C, 0x65, 0xA8, 0x8B, 0x5F, 0x04, 0x63, 0x18, 0xAF,
	0x86, 0xA2, 0x71, 0x7A, 0xF5, 0xAB, 0x60, 0x35, 0x4B, 0x8F, 0xEA,
	0xF8, 0xC6, 0x1C, 0xB9, 0xB1, 0xAC, 0x74, 0xA3, 0x63, 0x91, 0xF6,
	0xA8, 0xD6, 0xB3, 0xDA, 0x11, 0x8F, 0x71, 0x4B, 0x2B, 0x1F, 0xEF,
	0xF6, 0x24, 0x28, 0xA5, 0x2F, 0x9F, 0x39, 0x38, 0xA4, 0x5E, 0x97,
	0xE0, 0x3E, 0x45, 0x6A, 0x83, 0x91, 0x8A, 0x53, 0x9C, 0x3C, 0x84,
	0xA0, 0x04, 0xC1, 0x22, 0xAE, 0xB0, 0x93, 0x5C, 0x1C, 0x3F, 0x12,
	0x9B, 0xD8, 0x30, 0x59, 0xD2, 0x9F, 0xC7, 0x48, 0xFF, 0x06, 0x9A,
	0xE0, 0xA4, 0x0D, 0xCA, 0x55, 0x2E, 0x1B, 0xE0, 0xC8, 0x6C, 0xE6,
	0xC8, 0xF1, 0x84, 0x54, 0x5A, 0x96, 0x1B, 0xBD, 0xD0, 0x9C, 0x3B,
	0xF6, 0x51, 0xBA, 0x77, 0x18, 0xEA, 0xB4, 0xF8, 0x40, 0x6D, 0x2D,
	0x73, 0xB7, 0x4B, 0xD8, 0xED, 0x83, 0x97, 0xBD, 0xF4, 0xE5, 0xED,
	0x72, 0x67, 0xCA, 0x4C, 0x11, 0x53, 0x07, 0xC6, 0xF4, 0x54, 0x32,
	0x95, 0x99, 0x12, 0x66, 0x3A, 0xD3, 0x5E, 0xD0, 0x94, 0xA6, 0x4E,
	0xA8, 0xB9, 0x40, 0x6B, 0x0E, 0x05, 0x9B, 0xD1, 0x9B, 0x1E, 0x54,
	0xAA, 0xA7, 0x2B, 0x5E, 0x65, 0xCF, 0x57, 0x61, 0xFD, 0xCA, 0xB2,
	0xEC, 0xC2, 0x4E, 0xF2, 0xB5, 0x05, 0x2E, 0xE0, 0xB3, 0xAE, 0x3B,
	0xA7, 0xE5, 0x16, 0xF6, 0xBD, 0x0F, 0x7E, 0x69, 0xA9, 0x27, 0xFD,
	0xA2, 0x35, 0x0B, 0x6A, 0xDD, 0x89, 0x32, 0x45, 0x38, 0x57, 0x7A,
	0xCF, 0x75, 0xC9, 0xCC, 0x48, 0xAA, 0x1E, 0x5C, 0xA8, 0x01, 0x10,
	0x10, 0xF7, 0x02, 0xC6, 0x1E, 0x56, 0x77, 0x17, 0xC1, 0x98, 0x68,
	0x4C, 0x73, 0x82, 0x8A, 0xF6, 0x37, 0xA2, 0x10, 0xF5, 0xEF, 0x50,
	0x22, 0xEA, 0x80, 0x02, 0x6B, 0xB4, 0xBF, 0xC6, 0xED, 0xE8, 0x4C,
	0x7E, 0xFB, 0x4C, 0x92, 0xBE, 0x66, 0xC1, 0xCF, 0x3C, 0x29, 0x4C,
	0x5C, 0x42, 0x30, 0x86, 0xE5, 0x06, 0xA5, 0xC8, 0x61, 0x00, 0x03,
	0x92, 0x73, 0x84, 0x07, 0xB8, 0x94, 0x63, 0x16, 0x1C, 0x18, 0x71,
	0x92, 0x00, 0x82, 0x9B, 0x4A, 0x40, 0x86, 0xDD, 0xF9, 0x18, 0x78,
	0x36, 0x70, 0x9E, 0xED, 0xAC, 0xEC, 0x3C, 0x30, 0x76, 0x19, 0x10,
	0x55, 0xE6, 0x32, 0x19, 0x83, 0x67, 0x02, 0x32, 0x3B, 0xD9, 0x06,
	0x90, 0xAA, 0x44, 0xA5, 0x06, 0x8D, 0x40, 0x4F, 0x2D, 0xDA, 0x53,
	0x1D, 0xF4, 0x1D, 0xA9, 0x2E, 0x8D, 0xAA, 0x4E, 0xDB, 0x22, 0x17,
	0xFF, 0xA5, 0xE6, 0x21, 0xAC, 0x80, 0xD1, 0x6A, 0x25, 0xEA, 0x6A,
	0x74, 0xA7, 0x4C, 0x65, 0x32, 0xFA, 0x88, 0x48, 0x68, 0x35, 0x6B,
	0xD9, 0xB2, 0x2C, 0x89, 0xB3, 0x1E, 0x62, 0xAD, 0x72, 0x6C, 0xAB,
	0x5B, 0xE1, 0x1A, 0xD7, 0x2F, 0x97, 0x6D, 0x14, 0x77, 0xAB, 0x5F,
	0x20, 0x6B, 0x51, 0x0B, 0xBE, 0xE4, 0x22, 0xAF, 0x4B, 0xB8, 0xD2,
	0xFB, 0xF0, 0xA7, 0x48, 0x5D, 0xE8, 0x69, 0x70, 0xF6, 0x9D, 0xE4,
	0x60, 0x09, 0xBB, 0xBA, 0x59, 0x2A, 0x21, 0xCF, 0x8F, 0xE4, 0xD2,
	0x35, 0x34, 0xAB, 0xD9, 0x64, 0x10, 0xFA, 0xD0, 0x9F, 0x85, 0x1C,
	0x66, 0x51, 0x99, 0x4A, 0x3B, 0x27, 0xBA, 0x1B, 0xE4, 0xF8, 0x4C,
	0x9F, 0xE6, 0x51, 0x3A, 0x59, 0xA6, 0x36, 0x75, 0x7E, 0x66, 0xAD,
	0xA2, 0x5C, 0xBB, 0x4B, 0xD8, 0x26, 0x04, 0x22, 0x83, 0x92, 0x2D,
	0x6D, 0x75, 0x67, 0xDB, 0xDB, 0x7A, 0x44, 0xB7, 0x49, 0x50, 0xA6,
	0x49, 0x7C, 0xEB, 0xCC, 0x8F, 0x0A, 0x77, 0x9A, 0xC4, 0x0D, 0x8A,
	0x71, 0x89, 0x92, 0x94, 0xE4, 0x6E, 0xB3, 0x7A, 0x56, 0xB9, 0x5E,
	0xAE, 0xB9, 0xF2, 0xAB, 0xE8, 0xEE, 0xA5, 0xAF, 0x84, 0xD9, 0x2E,
	0x3B, 0xD7, 0xF9, 0x16, 0x56, 0x24, 0x8B, 0xD8, 0xEA, 0x8C, 0xA7,
	0x3C, 0xFF, 0x82, 0x17, 0xF1, 0x72, 0xCB, 0x15, 0x88, 0xBC, 0x4B,
	0x22, 0xF5, 0xC7, 0x3F, 0xC8, 0x1E, 0xE3, 0x7F, 0xEA, 0x0A, 0x68,
	0x17, 0x6A, 0x90, 0x84, 0x49, 0x12, 0xE1, 0xDB, 0xE0, 0x26, 0x42,
	0x13, 0x10, 0x47, 0x11, 0x8C, 0x84, 0xE4, 0x01, 0x0C, 0xB0, 0x57,
	0x43, 0x11, 0x7C, 0x5C, 0xA4, 0x14, 0x78, 0x28, 0x0E, 0x98, 0x82,
	0x03, 0x28, 0x30, 0xEF, 0xF5, 0x38, 0x40, 0xA3, 0xF8, 0xD6, 0xA8,
	0xF3, 0x7A, 0x32, 0x00, 0x2A, 0x40, 0x58, 0xC3, 0x31, 0x01, 0x38,
	0x70, 0x7F, 0xCB, 0xFF, 0x42, 0x10, 0xCA, 0xA4, 0xA4, 0xC5, 0x09,
	0x21, 0x72, 0x92, 0x50, 0x81, 0xD0, 0x34, 0xB8, 0x38, 0x18, 0xC4,
	0xD8, 0x89, 0x6B, 0xF8, 0x31, 0xEF, 0xD0, 0x58, 0x88, 0x06, 0x58,
	0x99, 0x7C, 0x70, 0xD8, 0xB2, 0xF4, 0xC4, 0x07, 0xA8, 0x20, 0x97,
	0x8F, 0xC8, 0x15, 0xB0, 0x81, 0x93, 0x0D, 0x91, 0x88, 0x46, 0xE4,
	0xB1, 0x7F, 0x7C, 0xFC, 0x63, 0xA3, 0x0D, 0xD9, 0xA9, 0x47, 0x4B,
	0x9A, 0x15, 0x91, 0x9C, 0xC5, 0xE5, 0x46, 0x05, 0xAB, 0x4E, 0xD6,
	0xAA, 0x18, 0xA5, 0x5C, 0xE5, 0x9E, 0xFB, 0x1C, 0x46, 0x63, 0x15,
	0xB3, 0xDA, 0xAE, 0xBC, 0x65, 0x47, 0x84, 0x42, 0xCB, 0x45, 0x1F,
	0x9B, 0x98, 0x09, 0x41, 0x66, 0xB8, 0xB1, 0x95, 0x48, 0xA7, 0xB8,
	0x41, 0x93, 0xBA, 0xA5, 0x37, 0xF3, 0xF2, 0xA0, 0x90, 0xA1, 0x7B,
	0xB3, 0xB5, 0xC6, 0xF1, 0xD7, 0x5F, 0xEC, 0x03, 0xD0, 0x89, 0x65,
	0xAD, 0xA4, 0xB6, 0x64, 0x5F, 0xC6, 0x19, 0xE3, 0xD0, 0x68, 0x4F,
	0x3B, 0xA2, 0xB3, 0xB1, 0x8E, 0xB4, 0x7F, 0x23, 0x19, 0xE3, 0x12,
	0xA8, 0xE9, 0x06, 0xA5, 0x28, 0xD4, 0x79, 0x66, 0x96, 0xAA, 0x6D,
	0x9D, 0xFF, 0x70, 0x27, 0x4B, 0x24, 0xB8, 0xD6, 0xEB, 0x9D, 0xF6,
	0xB4, 0x41, 0x40, 0x1D, 0xA8, 0xD9, 0x8E, 0x7A, 0x22, 0xBB, 0xBB,
	0x2D, 0x6E, 0x37, 0xF2, 0x91, 0xC6, 0x03, 0x4F, 0xD5, 0xBD, 0x2D,
	0xD5, 0x6F, 0x5D, 0xFD, 0x6A, 0x9E, 0xC4, 0x1A, 0x28, 0xB3, 0x3E,
	0x4A, 0xAD, 0x69, 0xA5, 0x5C, 0x6E, 0xE6, 0xDA, 0xB9, 0x2A, 0xE0,
	0xB5, 0x38, 0xBF, 0x3A, 0xDD, 0xF8, 0x95, 0x77, 0xBB, 0xA8, 0x77,
	0xDF, 0x75, 0xE3, 0x02, 0xAD, 0x5F, 0x57, 0x17, 0x9F, 0x81, 0x01,
	0x9C, 0x5F, 0x0A, 0xA3, 0x2D, 0x67, 0x6F, 0x0B, 0xF6, 0x73, 0x01,
	0x76, 0x64, 0xC2, 0xB5, 0xBF, 0x36, 0xFF, 0x41, 0x16, 0xDB, 0xAC,
	0xD3, 0x36, 0x17, 0x1E, 0xA0, 0x03, 0xC4, 0x85, 0xBB, 0x07, 0xE1,
	0x16, 0x77, 0x13, 0x34, 0x75, 0xEE, 0x07, 0x3C, 0xB3, 0xA1, 0x04,
	0x48, 0x8A, 0xAC, 0xA6, 0x1F, 0x81, 0x02, 0x5B, 0xFF, 0x3B, 0xF8,
	0xB6, 0x68, 0xBE, 0xB7, 0x0F, 0x45, 0x8E, 0x42, 0xA1, 0xDF, 0xFE,
	0x8E, 0x82, 0x86, 0x19, 0xC0, 0x12, 0xE8, 0x9C, 0x2A, 0x63, 0xC7,
	0x31, 0x95, 0x68, 0xEC, 0xF5, 0x70, 0xE1, 0x44, 0x41, 0x25, 0xF6,
	0xD2, 0x4D, 0x14, 0xB8, 0x60, 0x80, 0x06, 0xD0, 0x10, 0x64, 0xE5,
	0x31, 0xCF, 0x8B, 0x35, 0xAE, 0x71, 0xF1, 0xD8, 0x18, 0xE4, 0x07,
	0x80, 0x00, 0x05, 0x80, 0x00, 0x04, 0x88, 0x00, 0x09, 0x60, 0x32,
	0x29, 0x03, 0x80, 0x25, 0x33, 0x54, 0x1B, 0x60, 0x54, 0x2A, 0xE7,
	0x33, 0x2C, 0x67, 0x20, 0x43, 0x36, 0x81, 0x54, 0x14, 0x55, 0x52,
	0x85, 0x45, 0x55, 0x65, 0x73, 0x4B, 0xD6, 0x21, 0x53, 0xE3, 0x64,
	0x55, 0x43, 0x22, 0x3C, 0xF7, 0x73, 0x22, 0x38, 0x82, 0x64, 0x91,
	0x36, 0x62, 0xE3, 0x56, 0x41, 0x12, 0x09, 0x42, 0x47, 0x56, 0x60,
	0x93, 0x65, 0x4B, 0xF7, 0x36, 0x4D, 0x77, 0x24, 0x4F, 0xB7, 0x23,
	0x6C, 0x13, 0x03, 0x75, 0xF3, 0x24, 0x75, 0x95, 0x17, 0x51, 0x52,
	0x5E, 0xF8, 0x84, 0x4F, 0x7D, 0x21, 0x2E, 0x7E, 0x31, 0x04, 0x42,
	0x38, 0x84, 0x44, 0x38, 0x0E, 0x75, 0x66, 0x67, 0x77, 0x56, 0x4A,
	0x42, 0x20, 0x4C, 0x15, 0x71, 0x5F, 0xB2, 0x24, 0x5B, 0x04, 0x41,
	0x76, 0x8C, 0xC5, 0x38, 0x8F, 0xA5, 0x76, 0x84, 0x26, 0x3A, 0xA8,
	0x04, 0x0E, 0x99, 0x34, 0x0D, 0x97, 0xC5, 0x68, 0x9E, 0xC4, 0x0B,
	0xA2, 0x45, 0x69, 0x88, 0x67, 0x3A, 0x80, 0xC2, 0x28, 0xFB, 0xD0,
	0x05, 0x12, 0x41, 0x28, 0x03, 0x11, 0x0C, 0xC6, 0x20, 0xFF, 0x19,
	0xD7, 0x16, 0x3B, 0xF4, 0xC0, 0x69, 0x82, 0x17, 0x29, 0x01, 0x55,
	0x28, 0x94, 0x72, 0x78, 0xB5, 0x55, 0x6E, 0x8A, 0xC7, 0x78, 0x8D,
	0x77, 0x4C, 0xBB, 0x25, 0x3C, 0x47, 0x10, 0x79, 0xC5, 0xD3, 0x6A,
	0xC1, 0x55, 0x79, 0xA6, 0x71, 0x79, 0x42, 0x31, 0x6B, 0xC8, 0xC5,
	0x79, 0xB7, 0x26, 0x15, 0xD6, 0x03, 0x7A, 0xD0, 0xE5, 0x6B, 0xC7,
	0x76, 0x6C, 0xAB, 0x67, 0x5D, 0xB1, 0x97, 0x7A, 0xC2, 0xD6, 0x66,
	0xAF, 0x77, 0x3F, 0x97, 0x38, 0x67, 0x54, 0x52, 0x7B, 0xB6, 0x97,
	0x37, 0xEA, 0xC3, 0x89, 0x5A, 0xE7, 0x18, 0xA2, 0xB4, 0x5E, 0xFD,
	0xF4, 0x7B, 0xFF, 0x74, 0x87, 0x02, 0x85, 0x1C, 0xF3, 0x45, 0x04,
	0x3D, 0x10, 0x8B, 0xB2, 0x38, 0x8B, 0xB1, 0xA8, 0x7C, 0xCB, 0xD7,
	0x04, 0xCD, 0x97, 0x6E, 0xA3, 0xD1, 0x01, 0x27, 0x10, 0x01, 0x4F,
	0xD1, 0x00, 0x2C, 0x30, 0x7D, 0xD6, 0x77, 0x7D, 0x0B, 0xC2, 0x7D,
	0x1C, 0x80, 0x32, 0xC8, 0x88, 0x32, 0xFA, 0xE6, 0x7D, 0xF6, 0x11,
	0x7E, 0x1B, 0x96, 0x52, 0xD0, 0x18, 0x8D, 0x2C, 0x14, 0x7F, 0x19,
	0xF4, 0x7E, 0x34, 0x20, 0x1D, 0xCE, 0x67, 0x30, 0x18, 0x83, 0x53,
	0xDA, 0x81, 0x7F, 0xE8, 0x91, 0x71, 0x38, 0x44, 0x01, 0xE2, 0xA1,
	0x7F, 0x30, 0x33, 0x63, 0x23, 0x67, 0x00, 0x13, 0x90, 0x8E, 0x33,
	0x33, 0x80, 0x04, 0x58, 0x00, 0x26, 0x17, 0x1E, 0x07, 0x60, 0x00,
	0x29, 0xF7, 0x80, 0xFC, 0x11, 0x81, 0x2E, 0x47, 0x81, 0xF8, 0x28,
	0x73, 0x4A, 0xC3, 0x34, 0x15, 0x92, 0x45, 0x5B, 0xC4, 0x21, 0x1D,
	0xF8, 0x64, 0x20, 0x18, 0x82, 0x24, 0x58, 0x90, 0x22, 0x68, 0x82,
	0x60, 0x13, 0x36, 0x69, 0x83, 0x82, 0x09, 0x29, 0x74, 0x27, 0xD8,
	0x56, 0x30, 0x18, 0x83, 0x72, 0x33, 0x83, 0x7B, 0x14, 0x03, 0x37,
	0x20, 0xFF, 0x75, 0x74, 0x85, 0x37, 0x87, 0xD1, 0x5D, 0xCD, 0x42,
	0x2D, 0xA8, 0x84, 0x0B, 0x44, 0x18, 0x92, 0x45, 0x78, 0x27, 0xE0,
	0x50, 0x26, 0xE9, 0x22, 0x04, 0x8B, 0x87, 0x5B, 0x19, 0xE1, 0x0E,
	0x4E, 0x68, 0x87, 0x50, 0xC8, 0x10, 0x06, 0xD5, 0x58, 0x8E, 0x75,
	0x76, 0x72, 0x92, 0x75, 0x24, 0x99, 0x85, 0x48, 0xB8, 0x68, 0x8C,
	0x96, 0x0E, 0x70, 0xB7, 0x02, 0xA6, 0x43, 0x5A, 0x11, 0x61, 0x5A,
	0xA9, 0x95, 0x69, 0xF8, 0x00, 0x28, 0x88, 0x52, 0x77, 0x85, 0xB7,
	0x69, 0xC1, 0x00, 0x3B, 0xC0, 0xA0, 0x2E, 0x73, 0xD8, 0x19, 0x0E,
	0x11, 0x11, 0x84, 0x87, 0x87, 0x4C, 0xA8, 0x78, 0xB8, 0xD5, 0x87,
	0x8E, 0x07, 0x79, 0x81, 0x28, 0x79, 0x84, 0x18, 0x41, 0x86, 0x78,
	0x88, 0x88, 0xD8, 0x13, 0x99, 0xB7, 0x88, 0xB5, 0x62, 0x2B, 0xDC,
	0xD4, 0x5C, 0xD8, 0xA3, 0x3D, 0xBD, 0x16, 0x56, 0xD3, 0xB5, 0x3E,
	0xEE, 0x44, 0x89, 0x9B, 0x08, 0x4F, 0x98, 0xB8, 0x5D, 0x81, 0xF1,
	0x5D, 0xE0, 0x05, 0x8A, 0xA1, 0x68, 0x6C, 0x3E, 0x88, 0x4E, 0x6C,
	0x81, 0x0E, 0x91, 0x41, 0x2E, 0x7F, 0xE5, 0x4F, 0xE9, 0xB2, 0x2E,
	0xEE, 0xB5, 0x10, 0x03, 0xD1, 0x0F, 0x5D, 0x50, 0x01, 0x34, 0xC0,
	0x05, 0x88, 0x43, 0x8B, 0x8E, 0x39, 0x8B, 0x81, 0xF8, 0x78, 0x20,
	0xA4, 0x61, 0xC9, 0x43, 0x00, 0x0E, 0xE0, 0x14, 0x26, 0xE0, 0x14,
	0x15, 0x23, 0x2B, 0xC3, 0x48, 0x6F, 0x04, 0x40, 0x43, 0x27, 0xA6,
	0x00, 0x04, 0x40, 0x54, 0xC7, 0x98, 0x8C, 0xA6, 0x59, 0x1F, 0xDD,
	0x37, 0x14, 0xF8, 0xE6, 0x13, 0x04, 0xD0, 0x6F, 0x05, 0xA0, 0x61,
	0xD2, 0x18, 0x8D, 0x0A, 0x97, 0x31, 0x18, 0x93, 0x1C, 0x25, 0xF1,
	0x00, 0x24, 0x45, 0x1C, 0x0F, 0xC0, 0x05, 0x1C, 0x80, 0x53, 0xF9,
	0xF7, 0x9B, 0xE5, 0x41, 0xFF, 0x01, 0x29, 0x43, 0x1E, 0xE4, 0xC8,
	0x1E, 0x35, 0x96, 0x80, 0x41, 0x24, 0x72, 0x1F, 0x27, 0x72, 0x25,
	0x83, 0x1F, 0x26, 0x63, 0x32, 0x0D, 0x48, 0x8F, 0xF5, 0xE8, 0x63,
	0x12, 0xB8, 0x01, 0x10, 0x85, 0x8F, 0x15, 0x58, 0x64, 0x46, 0x46,
	0x21, 0x11, 0x50, 0x55, 0x22, 0xC0, 0x02, 0x5A, 0x74, 0x73, 0x4C,
	0xD6, 0x64, 0x21, 0x22, 0x46, 0x00, 0x40, 0x90, 0x06, 0x99, 0x9E,
	0xD1, 0x35, 0x56, 0x6A, 0x84, 0x65, 0x5A, 0xD6, 0x23, 0x2D, 0x10,
	0x74, 0x44, 0xB7, 0x82, 0x0A, 0xE9, 0x02, 0x12, 0x39, 0x91, 0x6A,
	0x63, 0x91, 0x16, 0x89, 0x91, 0x53, 0xA7, 0x83, 0xC4, 0x52, 0x2C,
	0x83, 0x21, 0x4A, 0x41, 0x28, 0x92, 0x04, 0x3A, 0x84, 0x5C, 0x57,
	0x92, 0xC0, 0xC0, 0x39, 0x9C, 0x82, 0x11, 0x14, 0xD1, 0x92, 0xA6,
	0x54, 0x78, 0x2F, 0x19, 0x85, 0x84, 0xB3, 0x10, 0x84, 0x63, 0x0D,
	0x6D, 0xB2, 0x59, 0xFB, 0x94, 0x75, 0x3B, 0x99, 0x75, 0x71, 0x92,
	0x03, 0xAD, 0xB4, 0x5A, 0x69, 0xF8, 0x0F, 0x96, 0x62, 0x94, 0x84,
	0x42, 0x0F, 0xD5, 0x70, 0x49, 0x7E, 0x17, 0x0C, 0xAF, 0xF5, 0x94,
	0xB5, 0x53, 0x87, 0x69, 0xC8, 0x77, 0x54, 0x29, 0x4C, 0x56, 0x89,
	0x95, 0x59, 0x29, 0x2A, 0x81, 0x28, 0x88, 0x2B, 0x31, 0x79, 0x85,
	0x58, 0x79, 0x61, 0xE9, 0x13, 0x99, 0xA7, 0x79, 0xD9, 0xD4, 0x79,
	0xB8, 0xE6, 0x4D, 0xBD, 0xB2, 0x3D, 0x92, 0xB8, 0x3E, 0x94, 0x28,
	0x6D, 0xDC, 0xC5, 0x2C, 0xC8, 0x56, 0x6C, 0x7A, 0x21, 0x25, 0xAD,
	0xC7, 0x83, 0xE9, 0x24, 0x7B, 0x76, 0x39, 0x7B, 0x78, 0x99, 0x97,
	0xAA, 0x20, 0x97, 0xF3, 0xF4, 0x0A, 0xE7, 0x05, 0x98, 0xFE, 0x84,
	0x01, 0x4D, 0xD9, 0x5A, 0x86, 0x69, 0x94, 0x7D, 0xD2, 0x05, 0x5C,
	0xB0, 0x61, 0xAF, 0x38, 0x8B, 0x3E, 0xB0, 0xFF, 0xA6, 0x6C, 0xDA,
	0xA6, 0x3E, 0x60, 0x1C, 0x5B, 0x09, 0x7F, 0xCF, 0xD7, 0x01, 0x04,
	0xD0, 0x00, 0x1A, 0x92, 0x99, 0x4D, 0xB1, 0x99, 0xD5, 0xD7, 0x99,
	0x14, 0x60, 0x99, 0xE6, 0x91, 0x7F, 0x14, 0xB0, 0x01, 0x41, 0x74,
	0x9A, 0xA7, 0xF9, 0x1E, 0xF8, 0x66, 0x00, 0x03, 0xD0, 0x01, 0xEF,
	0x31, 0x00, 0x0E, 0xD4, 0x40, 0xAD, 0x39, 0x00, 0x07, 0xF0, 0x9A,
	0xCF, 0x98, 0x31, 0x15, 0xF0, 0x1C, 0xD0, 0x81, 0x31, 0xB5, 0x59,
	0x9B, 0xC9, 0x01, 0x5C, 0xC4, 0x51, 0x05, 0xBB, 0xF9, 0x00, 0x2B,
	0x83, 0x1E, 0xDA, 0x01, 0x9C, 0xBF, 0x49, 0x72, 0xC5, 0xD9, 0x1E,
	0x41, 0x04, 0x1E, 0x37, 0xC3, 0x8E, 0x08, 0x90, 0x31, 0x05, 0x28,
	0x80, 0x26, 0x33, 0x01, 0x29, 0x63, 0xA8, 0x45, 0x25, 0x9D, 0xFA,
	0xE1, 0x63, 0x21, 0x50, 0x9D, 0x27, 0xF0, 0x1D, 0xD8, 0xF9, 0x32,
	0x46, 0x36, 0x55, 0x34, 0x97, 0x64, 0x37, 0xB7, 0x64, 0x5E, 0xF4,
	0x45, 0x1F, 0x78, 0x35, 0xE7, 0xA9, 0x9E, 0xCA, 0x3A, 0x65, 0xEC,
	0x89, 0x74, 0x6E, 0x54, 0x9F, 0x74, 0xC3, 0x65, 0x67, 0xE3, 0x82,
	0x6A, 0x15, 0x91, 0xF7, 0x99, 0x47, 0x34, 0x48, 0x09, 0x51, 0xB7,
	0x9F, 0x7F, 0x54, 0x0A, 0x1B, 0x29, 0x48, 0xA7, 0x07, 0xA0, 0x01,
	0xFA, 0x91, 0x39, 0x20, 0x92, 0x4F, 0x30, 0x04, 0x93, 0xD3, 0x0B,
	0x42, 0x48, 0x68, 0x26, 0x39, 0x03, 0x42, 0xE0, 0x3B, 0xCB, 0xB7,
	0x19, 0x2C, 0xC9, 0x67, 0x87, 0x12, 0x4B, 0x43, 0xE9, 0x4B, 0x61,
	0xE2, 0x94, 0x0A, 0x51, 0xA1, 0x55, 0x98, 0x5E, 0x36, 0xF9, 0xAF,
	0x76, 0x86, 0x84, 0x90, 0xB1, 0x02, 0x78, 0x87, 0x87, 0x96, 0x22,
	0x28, 0xAD, 0xC3, 0x5E, 0x6F, 0x08, 0x87, 0x04, 0xE1, 0x5A, 0x4C,
	0xF9, 0x3F, 0x2C, 0xAA, 0xA2, 0x53, 0x69, 0x69, 0x06, 0xDB, 0xFF,
	0x0F, 0x55, 0x49, 0x4C, 0x34, 0x0A, 0x12, 0x80, 0x78, 0xA3, 0x5C,
	0x69, 0x3C, 0x94, 0xC7, 0xA3, 0x3D, 0x0A, 0x05, 0x63, 0xB9, 0x79,
	0x65, 0xF9, 0x14, 0x9E, 0x47, 0xA4, 0xE0, 0x64, 0xA4, 0x6C, 0x89,
	0x2C, 0xA6, 0x77, 0x57, 0xD4, 0xD5, 0x66, 0xE3, 0xC3, 0x91, 0x2D,
	0x9B, 0x2C, 0xF5, 0x23, 0xA5, 0x86, 0x91, 0xA5, 0x4C, 0xDA, 0x89,
	0xD7, 0xC2, 0x6C, 0xF2, 0x83, 0xA5, 0xF5, 0x63, 0x2C, 0xBA, 0x17,
	0x38, 0xA2, 0x33, 0x2E, 0x93, 0xA1, 0x27, 0xFD, 0xD3, 0xA2, 0xBA,
	0x84, 0x98, 0x88, 0x07, 0x04, 0xC3, 0x47, 0x02, 0x5C, 0x00, 0x04,
	0x4D, 0x20, 0x8B, 0x6E, 0x3A, 0xB5, 0x6C, 0x2A, 0x53, 0x1E, 0xBB,
	0x8B, 0x14, 0xC0, 0x02, 0x4E, 0x76, 0x01, 0x51, 0x91, 0xA7, 0x0D,
	0xE0, 0x6E, 0xD7, 0x67, 0x6F, 0x81, 0x3A, 0xAA, 0xA4, 0x3A, 0x1F,
	0x39, 0x86, 0x32, 0x0B, 0xD0, 0x01, 0xCA, 0x08, 0x45, 0x88, 0xAA,
	0xA8, 0xCE, 0x29, 0x20, 0x03, 0x10, 0xB7, 0x8F, 0x0A, 0xA9, 0x05,
	0xF0, 0x9A, 0xB4, 0xD9, 0x70, 0xD2, 0xD8, 0x42, 0xA6, 0xF2, 0x00,
	0x15, 0xC0, 0x05, 0x15, 0x70, 0x00, 0xF9, 0x97, 0x43, 0xA4, 0xFA,
	0x9B, 0x3E, 0x65, 0x9C, 0x19, 0x17, 0x54, 0x13, 0x30, 0x72, 0xE7,
	0x88, 0x8E, 0xCC, 0xE9, 0x9C, 0x0B, 0x58, 0xAB, 0xD2, 0xC9, 0x72,
	0xB9, 0x0A, 0x64, 0x0B, 0x02, 0x60, 0xBC, 0x3A, 0x45, 0x3E, 0xF5,
	0xAB, 0x47, 0x86, 0x81, 0x22, 0x80, 0x42, 0x56, 0x25, 0x9E, 0xE3,
	0x49, 0x35, 0x3B, 0xB7, 0xAC, 0xA4, 0xFB, 0x55, 0x28, 0x70, 0xBA,
	0xA8, 0x9B, 0xBA, 0xAA, 0xBB, 0xBA, 0xAC, 0xDB, 0xBA, 0xAE, 0xFB,
	0xBA, 0xB0, 0x1B, 0xBB, 0xB2, 0x3B, 0xBB, 0xB4, 0x5B, 0xBB, 0xB6,
	0x7B, 0xBB, 0xB8, 0x9B, 0xBB, 0xBA, 0xBB, 0xBB, 0xBC, 0xDB, 0xBB,
	0xBE, 0xFB, 0xD9, 0xBB, 0xC0, 0x1B, 0xBC, 0xC2, 0x3B, 0xBC, 0xC4,
	0x5B, 0xBC, 0xC6, 0x7B, 0xBC, 0xC8, 0x9B, 0xBB, 0x5C, 0x60, 0x01,
	0xE6, 0xB2, 0x02, 0x1A, 0xF0, 0xBC, 0xD0, 0x1B, 0xBD, 0xD2, 0x3B,
	0xBD, 0xD4, 0x5B, 0xBD, 0xD6, 0x7B, 0xBD, 0xD8, 0x9B, 0xBD, 0xDA,
	0xBB, 0xBD, 0xDC, 0xDB, 0xBD, 0xDE, 0xFB, 0xBD, 0xE0, 0x1B, 0xBE,
	0xE2, 0x3B, 0xBE, 0xE4, 0x5B, 0xBE, 0xE6, 0x7B, 0xBE, 0xE8, 0x9B,
	0xBE, 0xEA, 0xBB, 0xBE, 0xEC, 0xDB, 0xBE, 0xEE, 0xFB, 0xBE, 0xF0,
	0xCB, 0xBD, 0x0C, 0xD0, 0xB7, 0x7F, 0x12, 0xB1, 0xF6, 0x7B, 0xBF,
	0xF8, 0x9B, 0xBF, 0xFA, 0xBB, 0xBF, 0xFC, 0xDB, 0xBF, 0xFE, 0xFB,
	0xBF, 0x00, 0x1C, 0xC0, 0x02, 0x3C, 0xC0, 0x04, 0x5C, 0xC0, 0x06,
	0x7C, 0xC0, 0x08, 0x4C, 0x3B, 0x1D, 0x50, 0x05, 0x93, 0x5A, 0xA9,
	0x0E, 0xFC, 0xC0, 0x10, 0x1C, 0xC1, 0x12, 0x3C, 0xC1, 0x14, 0x5C,
	0xC1, 0x16, 0x7C, 0xC1, 0x18, 0x9C, 0xC1, 0x1A, 0xBC, 0xC1, 0x1C,
	0xDC, 0xC1, 0x1E, 0xFC, 0xC1, 0x20, 0x1C, 0xC2, 0x22, 0x3C, 0xC2,
	0x24, 0x5C, 0xC2, 0x26, 0x7C, 0xC2, 0x28, 0x9C, 0xC2, 0x2A, 0xBC,
	0xC2, 0x2C, 0xDC, 0xC2, 0x2E, 0xAC, 0xC1, 0x0E, 0x70, 0x20, 0x1C,
	0xC0, 0x72, 0x34, 0x5C, 0xC3, 0x36, 0x7C, 0xC3, 0x38, 0x9C, 0xC3,
	0x3A, 0xBC, 0xC3, 0x3C, 0xDC, 0xC3, 0x3E, 0xFC, 0xC3, 0x40, 0x1C,
	0xC4, 0x42, 0x3C, 0xC4, 0x44, 0x5C, 0xC4, 0x46, 0x7C, 0xC4, 0x48,
	0x9C, 0xC4, 0x4A, 0xBC, 0xC4, 0x4C, 0xDC, 0xC4, 0x42, 0x1C, 0x08,
	0x00, 0x3B
};

static FLMBYTE gv_novlogo_gif[] = 
{
	0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x64, 0x00, 0x16, 0x00, 0xC4,
	0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xFD, 0xFB, 0xFD, 0xF6, 0xF6, 0xF7,
	0xFD, 0xFF, 0xFF, 0xFB, 0xFD, 0xFD, 0xFA, 0xFB, 0xFB, 0xF2, 0xF0,
	0xED, 0xF6, 0xF4, 0xF2, 0xEC, 0xEA, 0xE8, 0xF8, 0xEC, 0xE5, 0xF2,
	0xE6, 0xE4, 0xFD, 0x04, 0x04, 0xED, 0x47, 0x47, 0xE8, 0x6F, 0x6F,
	0xEC, 0xA2, 0xA2, 0xF1, 0xBC, 0xBC, 0xEF, 0xCB, 0xCB, 0xF4, 0xDC,
	0xDC, 0xFF, 0xFD, 0xFD, 0xFD, 0xFB, 0xFB, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
	0xF9, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00,
	0x00, 0x64, 0x00, 0x16, 0x00, 0x00, 0x05, 0xFF, 0x20, 0x20, 0x8E,
	0x64, 0x69, 0x9E, 0x68, 0xAA, 0xAE, 0x6C, 0xEB, 0xBE, 0x70, 0x2C,
	0xCF, 0x74, 0x6D, 0xDF, 0x78, 0xAE, 0xBF, 0x50, 0xD3, 0x44, 0x80,
	0x88, 0x0F, 0xB8, 0x63, 0x39, 0x50, 0x0E, 0xC6, 0xB1, 0xA8, 0x7A,
	0x2C, 0x16, 0x0F, 0x80, 0x13, 0xCA, 0x5C, 0x31, 0x18, 0x27, 0xC6,
	0x02, 0x5B, 0x45, 0x4D, 0xA3, 0xDF, 0x6E, 0x4A, 0xCB, 0x25, 0x91,
	0x4D, 0x91, 0xC7, 0x83, 0x28, 0x8A, 0x38, 0x1C, 0x0A, 0x92, 0xDB,
	0xC1, 0x4E, 0xBC, 0x1D, 0x8F, 0x09, 0x29, 0x1C, 0x16, 0x67, 0x9F,
	0x65, 0x22, 0x67, 0x23, 0x0A, 0x5A, 0x4F, 0x5B, 0x10, 0x22, 0x10,
	0x80, 0x66, 0x4F, 0x40, 0x13, 0x0E, 0x87, 0x80, 0x89, 0x22, 0x7C,
	0x4F, 0x51, 0x7E, 0x26, 0x86, 0x5B, 0x8D, 0x65, 0x11, 0x92, 0x92,
	0x98, 0x0D, 0x8E, 0x8A, 0x4F, 0x0D, 0x22, 0xA3, 0x80, 0x9B, 0x08,
	0x95, 0x97, 0x52, 0xAE, 0x99, 0x25, 0x9B, 0x88, 0x82, 0x9C, 0x00,
	0x04, 0x86, 0x0D, 0x10, 0x10, 0x91, 0x4F, 0x07, 0x41, 0xA6, 0xA8,
	0x4F, 0x71, 0x0A, 0x80, 0x02, 0xA5, 0x0B, 0xA7, 0xAF, 0x54, 0x7D,
	0xB1, 0x23, 0x5A, 0x3E, 0x87, 0x89, 0x83, 0x53, 0xCA, 0x00, 0x90,
	0x4F, 0x4B, 0xA9, 0x07, 0xC5, 0xC9, 0x22, 0xBD, 0x78, 0x6A, 0x10,
	0xD4, 0xAE, 0xCD, 0xCE, 0x00, 0xD0, 0x00, 0xA9, 0x0B, 0xE3, 0xB6,
	0xBD, 0x71, 0x23, 0x07, 0xE9, 0x00, 0x8B, 0x0B, 0x6F, 0xA4, 0xEA,
	0xA0, 0xA0, 0xAD, 0xCC, 0xB0, 0xE7, 0xE8, 0xDE, 0xF2, 0x49, 0xE2,
	0x92, 0xAA, 0x80, 0x2C, 0x5B, 0x00, 0x73, 0xE9, 0x11, 0x78, 0xA5,
	0x21, 0x83, 0x06, 0x5C, 0x2C, 0x51, 0xF9, 0x07, 0xD0, 0xDA, 0x3A,
	0x77, 0xFE, 0x80, 0x05, 0x1C, 0x30, 0xE5, 0x09, 0x25, 0x81, 0x09,
	0x48, 0x4C, 0x60, 0x23, 0x11, 0xD3, 0xBF, 0x79, 0xDF, 0x0E, 0x69,
	0x71, 0xE9, 0xC6, 0x80, 0x48, 0x02, 0x43, 0x1F, 0x01, 0x22, 0xA4,
	0x17, 0x4C, 0x44, 0x80, 0x51, 0xCA, 0x4A, 0x56, 0x3A, 0x87, 0x32,
	0x25, 0xC2, 0x5E, 0x5B, 0xD6, 0x59, 0x03, 0x30, 0xA0, 0x97, 0x49,
	0x00, 0x37, 0x01, 0xBD, 0x31, 0x14, 0xB1, 0x9C, 0x2B, 0x07, 0x0D,
	0x96, 0x64, 0xEA, 0xD9, 0xAA, 0xCC, 0x84, 0x8B, 0xA6, 0x0C, 0x94,
	0x08, 0x70, 0x65, 0xE1, 0x88, 0x97, 0xFA, 0xAC, 0xE9, 0xBC, 0xE3,
	0x0C, 0xEA, 0xD1, 0x11, 0x0F, 0x86, 0x4A, 0x81, 0xF8, 0xF0, 0x81,
	0x84, 0x13, 0x6F, 0x90, 0x34, 0x6C, 0x70, 0x54, 0xC8, 0x0F, 0x00,
	0x0A, 0x86, 0x48, 0xC1, 0x43, 0xB1, 0xAF, 0xDF, 0xBF, 0x80, 0x03,
	0x0B, 0x1E, 0x4C, 0x38, 0x53, 0x08, 0x00, 0x3B
};

static FLMBYTE gv_style_css[] = 
{
	0x61, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20,
	0x23, 0x30, 0x33, 0x39, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D,
	0x64, 0x65, 0x63, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x3A,
	0x20, 0x75, 0x6E, 0x64, 0x65, 0x72, 0x6C, 0x69, 0x6E, 0x65, 0x20,
	0x7D, 0x0D, 0x0A, 0x62, 0x6F, 0x64, 0x79, 0x2C, 0x20, 0x74, 0x68,
	0x2C, 0x20, 0x74, 0x72, 0x2C, 0x20, 0x74, 0x64, 0x2C, 0x20, 0x74,
	0x61, 0x62, 0x6C, 0x65, 0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x66, 0x61, 0x6D, 0x69, 0x6C, 0x79, 0x3A, 0x20, 0x22, 0x54,
	0x72, 0x65, 0x62, 0x75, 0x63, 0x68, 0x65, 0x74, 0x20, 0x4D, 0x53,
	0x22, 0x2C, 0x20, 0x41, 0x72, 0x69, 0x61, 0x6C, 0x2C, 0x20, 0x48,
	0x65, 0x6C, 0x76, 0x65, 0x74, 0x69, 0x63, 0x61, 0x2C, 0x20, 0x47,
	0x65, 0x6E, 0x65, 0x76, 0x61, 0x2C, 0x20, 0x53, 0x77, 0x69, 0x73,
	0x73, 0x2C, 0x20, 0x53, 0x75, 0x6E, 0x53, 0x61, 0x6E, 0x73, 0x2D,
	0x52, 0x65, 0x67, 0x75, 0x6C, 0x61, 0x72, 0x20, 0x7D, 0x0D, 0x0A,
	0x70, 0x2C, 0x20, 0x6F, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x2C, 0x20,
	0x6C, 0x69, 0x2C, 0x20, 0x6F, 0x6C, 0x2C, 0x20, 0x75, 0x6C, 0x20,
	0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x30, 0x2E, 0x39, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x0D, 0x0A, 0x68, 0x31, 0x20, 0x20, 0x7B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x2E, 0x33, 0x65, 0x6D,
	0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x31, 0x2E, 0x33, 0x65, 0x6D, 0x3B, 0x20,
	0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x62, 0x6F, 0x74, 0x74,
	0x6F, 0x6D, 0x3A, 0x20, 0x30, 0x2E, 0x36, 0x65, 0x6D, 0x20, 0x7D,
	0x0D, 0x0A, 0x68, 0x32, 0x20, 0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B,
	0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F,
	0x6D, 0x3A, 0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x68, 0x33, 0x20, 0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F,
	0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69,
	0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69,
	0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x31, 0x2E, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67,
	0x69, 0x6E, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A, 0x20,
	0x30, 0x2E, 0x32, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x68, 0x34,
	0x20, 0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69,
	0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x31, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A, 0x20, 0x30, 0x2E,
	0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x69, 0x6D,
	0x67, 0x2E, 0x66, 0x6C, 0x6F, 0x61, 0x74, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x20, 0x7B, 0x20, 0x66, 0x6C, 0x6F, 0x61, 0x74, 0x3A, 0x20,
	0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x7D, 0x0D, 0x0A, 0x69, 0x6D,
	0x67, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x31, 0x20, 0x7B,
	0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x3A, 0x20, 0x31, 0x70,
	0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x69, 0x6D, 0x67, 0x2E, 0x6D, 0x61,
	0x72, 0x67, 0x69, 0x6E, 0x32, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x3A, 0x20, 0x32, 0x70, 0x78, 0x20, 0x7D, 0x0D,
	0x0A, 0x69, 0x6D, 0x67, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x34, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x3A,
	0x20, 0x34, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x69, 0x6D, 0x67,
	0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x35, 0x72, 0x20, 0x7B,
	0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x35, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A,
	0x69, 0x6D, 0x67, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x35,
	0x6C, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D,
	0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x35, 0x70, 0x78, 0x20, 0x7D,
	0x0D, 0x0A, 0x69, 0x6D, 0x67, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x36, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x3A, 0x20, 0x36, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x69, 0x6D,
	0x67, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x38, 0x20, 0x7B,
	0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x3A, 0x20, 0x38, 0x70,
	0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x69, 0x6D, 0x67, 0x2E, 0x6D, 0x61,
	0x72, 0x67, 0x69, 0x6E, 0x31, 0x30, 0x20, 0x7B, 0x20, 0x6D, 0x61,
	0x72, 0x67, 0x69, 0x6E, 0x3A, 0x20, 0x31, 0x30, 0x70, 0x78, 0x20,
	0x7D, 0x0D, 0x0A, 0x69, 0x6D, 0x67, 0x2E, 0x6D, 0x61, 0x72, 0x67,
	0x69, 0x6E, 0x31, 0x30, 0x72, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x2D, 0x72, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x31, 0x30, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x69, 0x6D, 0x67,
	0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x31, 0x30, 0x6C, 0x20,
	0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65,
	0x66, 0x74, 0x3A, 0x20, 0x31, 0x30, 0x70, 0x78, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x72, 0x69, 0x67, 0x68, 0x74,
	0x3A, 0x20, 0x35, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A,
	0x73, 0x70, 0x61, 0x6E, 0x2E, 0x74, 0x61, 0x62, 0x31, 0x75, 0x20,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62,
	0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x7D, 0x0D, 0x0A, 0x73, 0x70,
	0x61, 0x6E, 0x2E, 0x74, 0x61, 0x62, 0x32, 0x75, 0x20, 0x7B, 0x20,
	0x74, 0x65, 0x78, 0x74, 0x2D, 0x64, 0x65, 0x63, 0x6F, 0x72, 0x61,
	0x74, 0x69, 0x6F, 0x6E, 0x3A, 0x20, 0x75, 0x6E, 0x64, 0x65, 0x72,
	0x6C, 0x69, 0x6E, 0x65, 0x20, 0x7D, 0x0D, 0x0A, 0x73, 0x70, 0x61,
	0x6E, 0x2E, 0x74, 0x61, 0x62, 0x32, 0x73, 0x20, 0x7B, 0x20, 0x74,
	0x65, 0x78, 0x74, 0x2D, 0x64, 0x65, 0x63, 0x6F, 0x72, 0x61, 0x74,
	0x69, 0x6F, 0x6E, 0x3A, 0x20, 0x75, 0x6E, 0x64, 0x65, 0x72, 0x6C,
	0x69, 0x6E, 0x65, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x63, 0x6F, 0x6C, 0x6F,
	0x72, 0x20, 0x7B, 0x20, 0x62, 0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F,
	0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20,
	0x23, 0x65, 0x38, 0x65, 0x38, 0x38, 0x37, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x74, 0x79, 0x70, 0x65, 0x67, 0x6F, 0x6C, 0x64, 0x31, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36,
	0x36, 0x33, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x65, 0x72, 0x72, 0x6F,
	0x72, 0x6C, 0x69, 0x6E, 0x6B, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F,
	0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x63, 0x38, 0x32, 0x37, 0x32,
	0x37, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74,
	0x6F, 0x70, 0x3A, 0x20, 0x32, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x65, 0x72, 0x72, 0x6F, 0x72, 0x68, 0x65, 0x61, 0x64, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x63,
	0x38, 0x32, 0x37, 0x32, 0x37, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x73, 0x74, 0x79, 0x6C, 0x65, 0x3A, 0x20, 0x6E, 0x6F, 0x72,
	0x6D, 0x61, 0x6C, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x38, 0x30, 0x30, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69, 0x6E,
	0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31,
	0x2E, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A, 0x20, 0x30,
	0x2E, 0x37, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E,
	0x66, 0x6F, 0x72, 0x6D, 0x63, 0x6F, 0x6C, 0x75, 0x6D, 0x6E, 0x68,
	0x65, 0x61, 0x64, 0x31, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F,
	0x72, 0x3A, 0x20, 0x23, 0x35, 0x35, 0x36, 0x63, 0x37, 0x39, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E,
	0x37, 0x65, 0x6D, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61,
	0x6C, 0x69, 0x67, 0x6E, 0x3A, 0x20, 0x63, 0x65, 0x6E, 0x74, 0x65,
	0x72, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x66, 0x6F, 0x72, 0x6D, 0x68,
	0x65, 0x61, 0x64, 0x31, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F,
	0x72, 0x3A, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B,
	0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x62,
	0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x62, 0x38, 0x38,
	0x39, 0x39, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C,
	0x69, 0x67, 0x6E, 0x3A, 0x20, 0x6C, 0x65, 0x66, 0x74, 0x3B, 0x20,
	0x74, 0x65, 0x78, 0x74, 0x2D, 0x69, 0x6E, 0x64, 0x65, 0x6E, 0x74,
	0x3A, 0x20, 0x30, 0x2E, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x65,
	0x74, 0x74, 0x65, 0x72, 0x2D, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6E,
	0x67, 0x3A, 0x20, 0x30, 0x2E, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x2D, 0x61, 0x6C, 0x69,
	0x67, 0x6E, 0x3A, 0x20, 0x6D, 0x69, 0x64, 0x64, 0x6C, 0x65, 0x20,
	0x7D, 0x0D, 0x0A, 0x2E, 0x66, 0x6F, 0x72, 0x6D, 0x68, 0x65, 0x61,
	0x64, 0x31, 0x62, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72,
	0x3A, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20,
	0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x62, 0x61,
	0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F,
	0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x62, 0x38, 0x38, 0x39,
	0x39, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C, 0x69,
	0x67, 0x6E, 0x3A, 0x20, 0x6C, 0x65, 0x66, 0x74, 0x3B, 0x20, 0x74,
	0x65, 0x78, 0x74, 0x2D, 0x69, 0x6E, 0x64, 0x65, 0x6E, 0x74, 0x3A,
	0x20, 0x30, 0x2E, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x63, 0x61, 0x6C, 0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E,
	0x3A, 0x20, 0x6D, 0x69, 0x64, 0x64, 0x6C, 0x65, 0x20, 0x7D, 0x0D,
	0x0A, 0x2E, 0x66, 0x6F, 0x72, 0x6D, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x65, 0x78, 0x74, 0x20, 0x7B, 0x20, 0x63, 0x6F,
	0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x33, 0x35, 0x35, 0x32, 0x36,
	0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x65, 0x6D, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A,
	0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x66, 0x6F,
	0x72, 0x6D, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x65,
	0x78, 0x74, 0x6D, 0x6C, 0x30, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C,
	0x6F, 0x72, 0x3A, 0x20, 0x23, 0x33, 0x35, 0x35, 0x32, 0x36, 0x33,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65,
	0x3A, 0x20, 0x30, 0x2E, 0x38, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x68, 0x65, 0x61, 0x64, 0x31, 0x20, 0x7B, 0x20, 0x63, 0x6F,
	0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x2E,
	0x33, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31, 0x2E, 0x33, 0x65,
	0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x62,
	0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A, 0x20, 0x30, 0x2E, 0x36, 0x65,
	0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x31,
	0x61, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20,
	0x23, 0x36, 0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x31, 0x2E, 0x33, 0x65, 0x6D, 0x3B, 0x20, 0x6C,
	0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x31, 0x2E, 0x33, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A,
	0x20, 0x30, 0x2E, 0x36, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x31,
	0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64,
	0x31, 0x62, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x2E, 0x33, 0x65, 0x6D, 0x3B,
	0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x31, 0x2E, 0x33, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x31, 0x77, 0x20, 0x7B, 0x20,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x77, 0x68, 0x69, 0x74,
	0x65, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20,
	0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20,
	0x31, 0x2E, 0x33, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65,
	0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31, 0x2E,
	0x33, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E, 0x68,
	0x65, 0x61, 0x64, 0x32, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F,
	0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65,
	0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74,
	0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x32, 0x61, 0x20, 0x7B,
	0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x36,
	0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20,
	0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20,
	0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67,
	0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x34,
	0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64,
	0x32, 0x62, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72,
	0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x36, 0x30, 0x30, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B,
	0x20, 0x6C, 0x65, 0x74, 0x74, 0x65, 0x72, 0x2D, 0x73, 0x70, 0x61,
	0x63, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x30, 0x2E, 0x31, 0x65, 0x6D,
	0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F,
	0x70, 0x3A, 0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F,
	0x6D, 0x3A, 0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x3B, 0x20, 0x62,
	0x6F, 0x72, 0x64, 0x65, 0x72, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F,
	0x6D, 0x3A, 0x20, 0x32, 0x70, 0x78, 0x20, 0x73, 0x6F, 0x6C, 0x69,
	0x64, 0x20, 0x23, 0x36, 0x63, 0x38, 0x38, 0x39, 0x39, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x32, 0x74, 0x6D, 0x36,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62,
	0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20,
	0x30, 0x2E, 0x36, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68,
	0x65, 0x61, 0x64, 0x32, 0x74, 0x6D, 0x38, 0x20, 0x7B, 0x20, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31,
	0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x65,
	0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x32,
	0x77, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20,
	0x23, 0x66, 0x66, 0x66, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x32, 0x69, 0x6E, 0x64,
	0x65, 0x6E, 0x74, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72,
	0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D,
	0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F,
	0x70, 0x3A, 0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A,
	0x20, 0x30, 0x2E, 0x35, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x0D,
	0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x33, 0x20, 0x7B, 0x20, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31,
	0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D,
	0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x33, 0x65, 0x6D, 0x20,
	0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x33, 0x61, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36,
	0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x33, 0x65,
	0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x33,
	0x62, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x6C,
	0x65, 0x74, 0x74, 0x65, 0x72, 0x2D, 0x73, 0x70, 0x61, 0x63, 0x69,
	0x6E, 0x67, 0x3A, 0x20, 0x30, 0x2E, 0x31, 0x65, 0x6D, 0x3B, 0x20,
	0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A,
	0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A,
	0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x3B, 0x20, 0x62, 0x6F, 0x72,
	0x64, 0x65, 0x72, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A,
	0x20, 0x32, 0x70, 0x78, 0x20, 0x73, 0x6F, 0x6C, 0x69, 0x64, 0x20,
	0x23, 0x36, 0x63, 0x38, 0x38, 0x39, 0x39, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x68, 0x65, 0x61, 0x64, 0x33, 0x64, 0x20, 0x7B, 0x20, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31,
	0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64,
	0x33, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20, 0x7B, 0x20, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31,
	0x65, 0x6D, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C,
	0x69, 0x67, 0x6E, 0x3A, 0x20, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x33, 0x69,
	0x6E, 0x64, 0x65, 0x6E, 0x74, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C,
	0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20,
	0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D,
	0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F,
	0x70, 0x3A, 0x20, 0x30, 0x2E, 0x33, 0x65, 0x6D, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A,
	0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65,
	0x61, 0x64, 0x33, 0x74, 0x6D, 0x36, 0x20, 0x7B, 0x20, 0x63, 0x6F,
	0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65,
	0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74,
	0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x36, 0x65, 0x6D, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x33, 0x74, 0x6D, 0x38,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62,
	0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E,
	0x38, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61,
	0x64, 0x33, 0x77, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72,
	0x3A, 0x20, 0x23, 0x66, 0x66, 0x66, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x34, 0x20, 0x7B,
	0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61,
	0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61,
	0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30,
	0x2E, 0x32, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65,
	0x61, 0x64, 0x34, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20, 0x7B,
	0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61,
	0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x74, 0x65,
	0x78, 0x74, 0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E, 0x3A, 0x20, 0x63,
	0x65, 0x6E, 0x74, 0x65, 0x72, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68,
	0x65, 0x61, 0x64, 0x34, 0x62, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C,
	0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x36, 0x33, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x35,
	0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D,
	0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x32, 0x65, 0x6D, 0x20,
	0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x34, 0x74, 0x6D,
	0x36, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D,
	0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F,
	0x70, 0x3A, 0x20, 0x30, 0x2E, 0x36, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x34, 0x74, 0x6D, 0x38, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C,
	0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65,
	0x3A, 0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20,
	0x30, 0x2E, 0x38, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68,
	0x65, 0x61, 0x64, 0x34, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x34,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62,
	0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20,
	0x62, 0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x64, 0x66, 0x64,
	0x64, 0x64, 0x35, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x3A, 0x20, 0x30, 0x2E, 0x34, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A,
	0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x35, 0x20, 0x20, 0x7B,
	0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61,
	0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x36, 0x30, 0x30, 0x3B, 0x20,
	0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20,
	0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E,
	0x32, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x20,
	0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x35, 0x61, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C,
	0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x36, 0x30, 0x30, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61,
	0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30,
	0x2E, 0x32, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x65,
	0x61, 0x64, 0x35, 0x62, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C,
	0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x36, 0x33, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x36, 0x30, 0x30, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x37, 0x35, 0x65,
	0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74,
	0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20,
	0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74,
	0x3A, 0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68,
	0x65, 0x61, 0x64, 0x35, 0x74, 0x6D, 0x36, 0x20, 0x7B, 0x20, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x36, 0x30, 0x30, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E,
	0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x36, 0x65,
	0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C,
	0x65, 0x66, 0x74, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64, 0x35, 0x74, 0x6D, 0x38, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C,
	0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x36, 0x30, 0x30, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61,
	0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30,
	0x2E, 0x38, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x31, 0x65, 0x6D,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x68, 0x69, 0x6E, 0x74, 0x31, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36,
	0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69,
	0x7A, 0x65, 0x3A, 0x20, 0x31, 0x32, 0x70, 0x78, 0x3B, 0x20, 0x6C,
	0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x31, 0x34, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A,
	0x2E, 0x69, 0x6E, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x20, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36,
	0x63, 0x38, 0x38, 0x39, 0x39, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x74, 0x6F, 0x70, 0x31, 0x20, 0x7B,
	0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70,
	0x3A, 0x20, 0x30, 0x2E, 0x33, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x74, 0x6F, 0x70, 0x32,
	0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74,
	0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x35, 0x65, 0x6D, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x74, 0x6F,
	0x70, 0x33, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x6C, 0x65,
	0x66, 0x74, 0x31, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x31, 0x65, 0x6D,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x6C, 0x65, 0x66, 0x74, 0x31, 0x62, 0x20, 0x7B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E,
	0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69,
	0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x31, 0x65, 0x6D,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x6C, 0x65, 0x66, 0x74, 0x32, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72,
	0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x32,
	0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x6D, 0x61, 0x72, 0x67,
	0x69, 0x6E, 0x6C, 0x65, 0x66, 0x74, 0x33, 0x20, 0x7B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A,
	0x20, 0x33, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x6D, 0x61,
	0x72, 0x67, 0x69, 0x6E, 0x6C, 0x65, 0x66, 0x74, 0x34, 0x20, 0x7B,
	0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66,
	0x74, 0x3A, 0x20, 0x34, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x0D,
	0x0A, 0x2E, 0x6E, 0x6F, 0x6E, 0x70, 0x72, 0x6F, 0x70, 0x6F, 0x72,
	0x74, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x20, 0x7B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31,
	0x30, 0x70, 0x74, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x66,
	0x61, 0x6D, 0x69, 0x6C, 0x79, 0x3A, 0x20, 0x22, 0x43, 0x6F, 0x75,
	0x72, 0x69, 0x65, 0x72, 0x20, 0x4E, 0x65, 0x77, 0x22, 0x2C, 0x20,
	0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x2C, 0x20, 0x4D, 0x6F,
	0x6E, 0x61, 0x63, 0x6F, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x70, 0x61,
	0x64, 0x64, 0x69, 0x6E, 0x67, 0x38, 0x20, 0x7B, 0x20, 0x70, 0x61,
	0x64, 0x64, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x38, 0x70, 0x78, 0x20,
	0x7D, 0x0D, 0x0A, 0x2E, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6E, 0x67,
	0x32, 0x78, 0x34, 0x20, 0x7B, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69,
	0x6E, 0x67, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x32, 0x70, 0x78,
	0x3B, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x2D, 0x62,
	0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A, 0x20, 0x32, 0x70, 0x78, 0x3B,
	0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x2D, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x3A, 0x20, 0x34, 0x70, 0x78, 0x3B, 0x20, 0x70,
	0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x2D, 0x6C, 0x65, 0x66, 0x74,
	0x3A, 0x20, 0x34, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x70,
	0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x32, 0x20, 0x7B, 0x20, 0x70,
	0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x32, 0x70, 0x78,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x73, 0x63, 0x72, 0x6F, 0x6C, 0x6C,
	0x31, 0x20, 0x7B, 0x20, 0x62, 0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F,
	0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20,
	0x23, 0x65, 0x66, 0x65, 0x65, 0x65, 0x39, 0x3B, 0x20, 0x70, 0x61,
	0x64, 0x64, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x31, 0x30, 0x70, 0x78,
	0x20, 0x31, 0x32, 0x70, 0x78, 0x20, 0x31, 0x30, 0x70, 0x78, 0x20,
	0x31, 0x30, 0x70, 0x78, 0x3B, 0x20, 0x6F, 0x76, 0x65, 0x72, 0x66,
	0x6C, 0x6F, 0x77, 0x3A, 0x20, 0x61, 0x75, 0x74, 0x6F, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x34,
	0x20, 0x7B, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x3A,
	0x20, 0x34, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x72, 0x6F,
	0x77, 0x61, 0x6C, 0x74, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x7B,
	0x20, 0x62, 0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64,
	0x2D, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x65, 0x66,
	0x65, 0x65, 0x65, 0x39, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E,
	0x72, 0x75, 0x6C, 0x65, 0x62, 0x6C, 0x75, 0x65, 0x20, 0x7B, 0x20,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x63, 0x38,
	0x38, 0x39, 0x39, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x72, 0x75, 0x6C,
	0x65, 0x62, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x7B, 0x20, 0x70, 0x61,
	0x64, 0x64, 0x69, 0x6E, 0x67, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F,
	0x6D, 0x3A, 0x20, 0x35, 0x70, 0x78, 0x3B, 0x20, 0x62, 0x6F, 0x72,
	0x64, 0x65, 0x72, 0x2D, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x3A,
	0x20, 0x32, 0x70, 0x78, 0x20, 0x73, 0x6F, 0x6C, 0x69, 0x64, 0x20,
	0x23, 0x36, 0x63, 0x38, 0x38, 0x39, 0x39, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x72, 0x75, 0x6C, 0x65, 0x61, 0x62, 0x6F, 0x76, 0x65, 0x20,
	0x7B, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x2D, 0x74,
	0x6F, 0x70, 0x3A, 0x20, 0x35, 0x70, 0x78, 0x3B, 0x20, 0x62, 0x6F,
	0x72, 0x64, 0x65, 0x72, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x32,
	0x70, 0x78, 0x20, 0x73, 0x6F, 0x6C, 0x69, 0x64, 0x20, 0x23, 0x36,
	0x63, 0x38, 0x38, 0x39, 0x39, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A,
	0x2E, 0x73, 0x6D, 0x61, 0x6C, 0x6C, 0x74, 0x65, 0x78, 0x74, 0x20,
	0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65,
	0x3A, 0x20, 0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6C,
	0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x73, 0x6D,
	0x61, 0x6C, 0x6C, 0x74, 0x65, 0x78, 0x74, 0x32, 0x61, 0x20, 0x7B,
	0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x36,
	0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20,
	0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x3A, 0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x73,
	0x6D, 0x61, 0x6C, 0x6C, 0x74, 0x65, 0x78, 0x74, 0x32, 0x62, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C,
	0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65,
	0x3A, 0x20, 0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6C,
	0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x73, 0x6D,
	0x61, 0x6C, 0x6C, 0x74, 0x65, 0x78, 0x74, 0x32, 0x63, 0x20, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x33,
	0x35, 0x35, 0x32, 0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x37, 0x35,
	0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31, 0x2E, 0x31, 0x65, 0x6D,
	0x3B, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3A, 0x20, 0x34, 0x38,
	0x30, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x73, 0x6D, 0x61,
	0x6C, 0x6C, 0x74, 0x65, 0x78, 0x74, 0x32, 0x64, 0x20, 0x7B, 0x20,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x33, 0x35, 0x35,
	0x32, 0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D,
	0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x6D, 0x65, 0x64, 0x69, 0x75, 0x6D, 0x74, 0x65, 0x78, 0x74,
	0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20,
	0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x3A, 0x20, 0x31, 0x2E, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A,
	0x2E, 0x74, 0x65, 0x78, 0x74, 0x62, 0x6C, 0x75, 0x65, 0x31, 0x20,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23,
	0x33, 0x35, 0x35, 0x32, 0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x39,
	0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31, 0x2E, 0x32, 0x65, 0x6D,
	0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x6C,
	0x65, 0x63, 0x6F, 0x6C, 0x75, 0x6D, 0x6E, 0x68, 0x65, 0x61, 0x64,
	0x31, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x23, 0x36, 0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F,
	0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69,
	0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x37, 0x65, 0x6D, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x63, 0x6F, 0x6C,
	0x75, 0x6D, 0x6E, 0x68, 0x65, 0x61, 0x64, 0x31, 0x72, 0x75, 0x6C,
	0x65, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x23, 0x36, 0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F,
	0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69,
	0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x37, 0x35, 0x65, 0x6D, 0x3B,
	0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E,
	0x3A, 0x20, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x3B, 0x20, 0x63,
	0x6C, 0x65, 0x61, 0x72, 0x3A, 0x20, 0x62, 0x6F, 0x74, 0x68, 0x3B,
	0x20, 0x62, 0x6F, 0x72, 0x64, 0x65, 0x72, 0x2D, 0x62, 0x6F, 0x74,
	0x74, 0x6F, 0x6D, 0x3A, 0x20, 0x31, 0x70, 0x78, 0x20, 0x73, 0x6F,
	0x6C, 0x69, 0x64, 0x20, 0x23, 0x36, 0x36, 0x33, 0x20, 0x7D, 0x0D,
	0x0A, 0x2E, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x63, 0x6F, 0x6C, 0x75,
	0x6D, 0x6E, 0x68, 0x65, 0x61, 0x64, 0x32, 0x20, 0x20, 0x7B, 0x20,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x36, 0x33,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x36, 0x30, 0x30, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E,
	0x37, 0x35, 0x65, 0x6D, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D,
	0x61, 0x6C, 0x69, 0x67, 0x6E, 0x3A, 0x20, 0x63, 0x65, 0x6E, 0x74,
	0x65, 0x72, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x6C,
	0x65, 0x68, 0x65, 0x61, 0x64, 0x31, 0x20, 0x7B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20,
	0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x3A, 0x20, 0x31, 0x2E, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x62, 0x61,
	0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F,
	0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x63, 0x63, 0x39, 0x3B, 0x20,
	0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E, 0x3A,
	0x20, 0x6C, 0x65, 0x66, 0x74, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74,
	0x2D, 0x69, 0x6E, 0x64, 0x65, 0x6E, 0x74, 0x3A, 0x20, 0x30, 0x2E,
	0x35, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x65, 0x74, 0x74, 0x65, 0x72,
	0x2D, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x30,
	0x2E, 0x31, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61,
	0x62, 0x6C, 0x65, 0x68, 0x65, 0x61, 0x64, 0x32, 0x20, 0x20, 0x7B,
	0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C, 0x61,
	0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x36, 0x30, 0x30, 0x3B, 0x20,
	0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20,
	0x30, 0x2E, 0x39, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65,
	0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31, 0x2E,
	0x31, 0x65, 0x6D, 0x3B, 0x20, 0x62, 0x61, 0x63, 0x6B, 0x67, 0x72,
	0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x23, 0x63, 0x63, 0x39, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74,
	0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E, 0x3A, 0x20, 0x6C, 0x65, 0x66,
	0x74, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x69, 0x6E, 0x64,
	0x65, 0x6E, 0x74, 0x3A, 0x20, 0x30, 0x2E, 0x35, 0x65, 0x6D, 0x3B,
	0x20, 0x6C, 0x65, 0x74, 0x74, 0x65, 0x72, 0x2D, 0x73, 0x70, 0x61,
	0x63, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x30, 0x2E, 0x31, 0x65, 0x6D,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x68,
	0x65, 0x61, 0x64, 0x31, 0x62, 0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x6C,
	0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x31, 0x2E, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x62, 0x61, 0x63,
	0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F, 0x6C,
	0x6F, 0x72, 0x3A, 0x20, 0x23, 0x63, 0x63, 0x39, 0x3B, 0x20, 0x74,
	0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E, 0x3A, 0x20,
	0x6C, 0x65, 0x66, 0x74, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D,
	0x69, 0x6E, 0x64, 0x65, 0x6E, 0x74, 0x3A, 0x20, 0x30, 0x2E, 0x35,
	0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x6C,
	0x65, 0x73, 0x75, 0x62, 0x68, 0x65, 0x61, 0x64, 0x31, 0x20, 0x20,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62,
	0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x35, 0x65, 0x6D, 0x3B, 0x20,
	0x62, 0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x65, 0x66, 0x65,
	0x65, 0x65, 0x39, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61,
	0x6C, 0x69, 0x67, 0x6E, 0x3A, 0x20, 0x6C, 0x65, 0x66, 0x74, 0x3B,
	0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x69, 0x6E, 0x64, 0x65, 0x6E,
	0x74, 0x3A, 0x20, 0x30, 0x2E, 0x32, 0x65, 0x6D, 0x3B, 0x20, 0x70,
	0x61, 0x64, 0x64, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x30, 0x2E, 0x32,
	0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E, 0x74, 0x61,
	0x62, 0x62, 0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65,
	0x3A, 0x20, 0x31, 0x34, 0x70, 0x74, 0x3B, 0x7D, 0x0D, 0x0A, 0x2E,
	0x74, 0x61, 0x62, 0x77, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F,
	0x72, 0x3A, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A,
	0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74,
	0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x34, 0x70, 0x74,
	0x3B, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x73,
	0x6B, 0x31, 0x20, 0x7B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E,
	0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20, 0x30, 0x2E, 0x33, 0x65, 0x6D,
	0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x6C, 0x65,
	0x66, 0x74, 0x3A, 0x20, 0x31, 0x65, 0x6D, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E,
	0x38, 0x65, 0x6D, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x73,
	0x6B, 0x31, 0x61, 0x20, 0x7B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x65, 0x6D,
	0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F,
	0x70, 0x3A, 0x20, 0x30, 0x2E, 0x33, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x2E, 0x74, 0x61, 0x73, 0x6B, 0x32, 0x20, 0x7B, 0x20, 0x6D,
	0x61, 0x72, 0x67, 0x69, 0x6E, 0x2D, 0x74, 0x6F, 0x70, 0x3A, 0x20,
	0x30, 0x2E, 0x33, 0x65, 0x6D, 0x3B, 0x20, 0x6D, 0x61, 0x72, 0x67,
	0x69, 0x6E, 0x2D, 0x6C, 0x65, 0x66, 0x74, 0x3A, 0x20, 0x32, 0x65,
	0x6D, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x30, 0x2E, 0x38, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x0D, 0x0A, 0x2E, 0x77, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x68,
	0x65, 0x61, 0x64, 0x64, 0x67, 0x72, 0x65, 0x79, 0x20, 0x7B, 0x20,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x35, 0x61, 0x35,
	0x39, 0x35, 0x38, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65,
	0x3A, 0x20, 0x31, 0x38, 0x70, 0x74, 0x3B, 0x20, 0x6C, 0x69, 0x6E,
	0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31,
	0x38, 0x70, 0x74, 0x3B, 0x20, 0x6C, 0x65, 0x74, 0x74, 0x65, 0x72,
	0x2D, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6E, 0x67, 0x3A, 0x20, 0x31,
	0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x77, 0x69, 0x6E, 0x64,
	0x6F, 0x77, 0x68, 0x65, 0x61, 0x64, 0x62, 0x6C, 0x61, 0x63, 0x6B,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23,
	0x35, 0x61, 0x35, 0x39, 0x35, 0x38, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x38, 0x70, 0x74, 0x3B, 0x20,
	0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x3A, 0x20, 0x31, 0x38, 0x70, 0x74, 0x3B, 0x20, 0x6C, 0x65, 0x74,
	0x74, 0x65, 0x72, 0x2D, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6E, 0x67,
	0x3A, 0x20, 0x31, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x77,
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x68, 0x65, 0x61, 0x64, 0x77, 0x68,
	0x69, 0x74, 0x65, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72,
	0x3A, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x38, 0x70, 0x74, 0x3B,
	0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x31, 0x38, 0x70, 0x74, 0x3B, 0x20, 0x6C, 0x65,
	0x74, 0x74, 0x65, 0x72, 0x2D, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6E,
	0x67, 0x3A, 0x20, 0x31, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x0D,
	0x0A, 0x2E, 0x77, 0x69, 0x64, 0x74, 0x68, 0x33, 0x35, 0x30, 0x20,
	0x7B, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3A, 0x20, 0x33, 0x35,
	0x30, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x33, 0x30, 0x30, 0x20, 0x7B, 0x20, 0x77, 0x69, 0x64,
	0x74, 0x68, 0x3A, 0x20, 0x33, 0x30, 0x30, 0x70, 0x78, 0x20, 0x7D,
	0x0D, 0x0A, 0x2E, 0x77, 0x69, 0x64, 0x74, 0x68, 0x34, 0x30, 0x30,
	0x20, 0x7B, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3A, 0x20, 0x34,
	0x30, 0x30, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x34, 0x35, 0x30, 0x20, 0x7B, 0x20, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x3A, 0x20, 0x34, 0x35, 0x30, 0x70, 0x78, 0x20,
	0x7D, 0x0D, 0x0A, 0x2E, 0x77, 0x69, 0x64, 0x74, 0x68, 0x35, 0x30,
	0x30, 0x20, 0x7B, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3A, 0x20,
	0x35, 0x30, 0x30, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A,
	0x2E, 0x68, 0x65, 0x61, 0x64, 0x63, 0x61, 0x70, 0x77, 0x69, 0x64,
	0x65, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20,
	0x23, 0x36, 0x36, 0x33, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x36, 0x30, 0x30,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65,
	0x3A, 0x20, 0x30, 0x2E, 0x36, 0x65, 0x6D, 0x3B, 0x20, 0x6C, 0x65,
	0x74, 0x74, 0x65, 0x72, 0x2D, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6E,
	0x67, 0x3A, 0x20, 0x30, 0x2E, 0x32, 0x65, 0x6D, 0x20, 0x7D, 0x0D,
	0x0A, 0x2E, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74, 0x6C, 0x65, 0x31,
	0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62,
	0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A,
	0x65, 0x3A, 0x20, 0x31, 0x34, 0x70, 0x78, 0x3B, 0x20, 0x6C, 0x69,
	0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x31, 0x34, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x73, 0x75,
	0x62, 0x74, 0x69, 0x74, 0x6C, 0x65, 0x32, 0x20, 0x7B, 0x20, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65,
	0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31,
	0x34, 0x70, 0x78, 0x3B, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x31, 0x34, 0x70, 0x78,
	0x20, 0x7D, 0x0D, 0x0A, 0x0D, 0x0A, 0x2E, 0x68, 0x65, 0x61, 0x64,
	0x70, 0x62, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x62, 0x6C, 0x61, 0x63, 0x6B, 0x3B, 0x20, 0x66, 0x6F, 0x6E,
	0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62,
	0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73,
	0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x35, 0x70, 0x78, 0x3B, 0x20,
	0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E, 0x3A,
	0x20, 0x6C, 0x65, 0x66, 0x74, 0x3B, 0x20, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x63, 0x61, 0x6C, 0x2D, 0x61, 0x6C, 0x69, 0x67, 0x6E, 0x3A,
	0x20, 0x74, 0x6F, 0x70, 0x3B, 0x20, 0x6C, 0x65, 0x74, 0x74, 0x65,
	0x72, 0x2D, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6E, 0x67, 0x3A, 0x20,
	0x32, 0x70, 0x78, 0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62,
	0x31, 0x73, 0x20, 0x20, 0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72,
	0x3A, 0x20, 0x77, 0x68, 0x69, 0x74, 0x65, 0x3B, 0x20, 0x66, 0x6F,
	0x6E, 0x74, 0x2D, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20,
	0x62, 0x6F, 0x6C, 0x64, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31, 0x32, 0x70, 0x78, 0x3B,
	0x20, 0x6C, 0x69, 0x6E, 0x65, 0x2D, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x3A, 0x20, 0x31, 0x37, 0x70, 0x78, 0x3B, 0x20, 0x74, 0x65,
	0x78, 0x74, 0x2D, 0x64, 0x65, 0x63, 0x6F, 0x72, 0x61, 0x74, 0x69,
	0x6F, 0x6E, 0x3A, 0x20, 0x6E, 0x6F, 0x6E, 0x65, 0x3B, 0x20, 0x62,
	0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63,
	0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x62, 0x38, 0x38,
	0x39, 0x39, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C,
	0x69, 0x67, 0x6E, 0x3A, 0x20, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x31, 0x75, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x62, 0x6C,
	0x61, 0x63, 0x6B, 0x3B, 0x20, 0x62, 0x61, 0x63, 0x6B, 0x67, 0x72,
	0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A,
	0x20, 0x23, 0x44, 0x46, 0x44, 0x44, 0x44, 0x35, 0x3B, 0x20, 0x66,
	0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A, 0x20, 0x31,
	0x32, 0x70, 0x78, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x64,
	0x65, 0x63, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x3A, 0x20,
	0x6E, 0x6F, 0x6E, 0x65, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C,
	0x64, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2D, 0x61, 0x6C, 0x69,
	0x67, 0x6E, 0x3A, 0x20, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20,
	0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x32, 0x73, 0x20, 0x7B,
	0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x77, 0x68, 0x69,
	0x74, 0x65, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x62, 0x6F, 0x6C, 0x64, 0x3B,
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69, 0x7A, 0x65, 0x3A,
	0x20, 0x31, 0x31, 0x70, 0x78, 0x3B, 0x20, 0x74, 0x65, 0x78, 0x74,
	0x2D, 0x64, 0x65, 0x63, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E,
	0x3A, 0x20, 0x6E, 0x6F, 0x6E, 0x65, 0x3B, 0x20, 0x62, 0x61, 0x63,
	0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D, 0x63, 0x6F, 0x6C,
	0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x62, 0x38, 0x38, 0x39, 0x39,
	0x20, 0x7D, 0x0D, 0x0A, 0x2E, 0x74, 0x61, 0x62, 0x32, 0x75, 0x20,
	0x7B, 0x20, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x77, 0x68,
	0x69, 0x74, 0x65, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x3A, 0x20, 0x6E, 0x6F, 0x72, 0x6D,
	0x61, 0x6C, 0x3B, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2D, 0x73, 0x69,
	0x7A, 0x65, 0x3A, 0x20, 0x31, 0x31, 0x70, 0x78, 0x3B, 0x20, 0x74,
	0x65, 0x78, 0x74, 0x2D, 0x64, 0x65, 0x63, 0x6F, 0x72, 0x61, 0x74,
	0x69, 0x6F, 0x6E, 0x3A, 0x20, 0x6E, 0x6F, 0x6E, 0x65, 0x3B, 0x20,
	0x62, 0x61, 0x63, 0x6B, 0x67, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x2D,
	0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x3A, 0x20, 0x23, 0x36, 0x62, 0x38,
	0x38, 0x39, 0x39, 0x20, 0x7D, 0x0D, 0x0A
};

static FLMBYTE gv_spacer_gif[] = 
{
	0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x01, 0x00, 0x01, 0x00, 0x80,
	0x00, 0x00, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x21, 0xF9, 0x04,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x01, 0x00, 0x00, 0x02, 0x02, 0x44, 0x01, 0x00, 0x3B
};

static FLMBYTE gv_head_bg_gif[] = 
{
	0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x01, 0x00, 0x41, 0x00, 0xA2,
	0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xE8, 0xE8, 0xEA,
	0xFB, 0xFB, 0xFB, 0xF3, 0xF3, 0xF3, 0xD9, 0xD9, 0xD9, 0xC5, 0xC5,
	0xC5, 0xAD, 0xAD, 0xAD, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x41, 0x00, 0x00, 0x03, 0x0C, 0x18, 0xBA, 0xDC, 0xFE, 0x30, 0x46,
	0x70, 0x4C, 0x11, 0x64, 0xB0, 0x04, 0x00, 0x3B
};

// Static file table entry

typedef struct
{
	const char *	pszPath;
	const char *	pszMimeType;
	FLMBYTE *		pucData;
	FLMUINT			uiSize;
} FlmStaticFile;

// Table of static files

static FlmStaticFile gv_StaticFileTbl[] =
{
	{
		"head_bg.gif",
		"image/gif",
		gv_head_bg_gif,
		sizeof( gv_head_bg_gif)
	},
	{
		"imonhdr.gif",
		"image/gif",
		gv_imonhdr_gif,
		sizeof( gv_imonhdr_gif)
	},
	{
		"novlogo.gif",
		"image/gif",
		gv_novlogo_gif,
		sizeof( gv_novlogo_gif)
	},
	{
		"spacer.gif",
		"image/gif",
		gv_spacer_gif,
		sizeof( gv_spacer_gif)
	},
	{
		"style.css",
		"text/css",
		gv_style_css,
		sizeof( gv_style_css)
	},
	{
		NULL,
		NULL,
		NULL,
		0
	}
};

/****************************************************************************
Desc: Displays information about FLAIM threads
****************************************************************************/
RCODE F_FlmThreadsPage::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	FLMBOOL				bRefresh = FALSE;
	char					szTmp[ 256];
	FLMUINT				uiLoop;
	FLMUINT				uiCurrentTime;
	FLMUINT				uiNumThreads;
	F_THREAD_INFO *	pThreadInfo = NULL;
	POOL					pool;

	GedPoolInit( &pool, 1024);

	printDocStart( "Threads", FALSE);

	// Determine if we are being requested to refresh this page or not.

	if ((bRefresh = DetectParameter( uiNumParams,
											   ppszParams, 
											   "refresh")) == TRUE)
	{
		fnPrintf( m_pHRequest, 
			"<META http-equiv=\"refresh\" content=\"5; url=%s/threads?refresh\">\n",
			m_pszURLString);
	}
	
	if( RC_OK( ExtractParameter( uiNumParams, ppszParams, 
			"shutdown", sizeof( szTmp), szTmp)))
	{
		FLMUINT	uiThreadId = f_atoi( szTmp);
		if( uiThreadId)
		{
			gv_FlmSysData.pThreadMgr->setThreadShutdownFlag( uiThreadId);
		}
	}

	// Table

	printTableStart( "Threads", 7);

	// Refresh link

	printTableRowStart();
	printColumnHeading( NULL, JUSTIFY_LEFT, 
		FLM_IMON_COLOR_PUTTY_1, 7, 1, FALSE);

	fnPrintf( m_pHRequest, "<A HREF=%s/threads", m_pszURLString);

	if( bRefresh)
	{
		fnPrintf( m_pHRequest, "?refresh");
	}

	fnPrintf( m_pHRequest, ">Refresh</A>");

	// Space

	fnPrintf( m_pHRequest, ", ");

	// Auto-refresh link

	fnPrintf( m_pHRequest, "<A HREF=%s/threads", m_pszURLString);

	if( !bRefresh)
	{
		fnPrintf( m_pHRequest, "?refresh");
		fnPrintf( m_pHRequest, ">Start Auto-Refresh (5 sec.)</A>");
	}
	else
	{
		fnPrintf( m_pHRequest, ">Stop Auto-Refresh</A>");
	}

	printColumnHeadingClose();
	printTableRowEnd();

	// Table column headers

	printTableRowStart();
	printColumnHeading( "ID");
	printColumnHeading( "Group");
	printColumnHeading( "Application ID");
	printColumnHeading( "Name");
	printColumnHeading( "Status");
	printColumnHeading( "Action");
	printColumnHeading( "Seconds Since Started");
	printTableRowEnd();

	// Output rows

	if( RC_BAD( FlmGetThreadInfo( &pool, &pThreadInfo, &uiNumThreads)))
	{
		fnPrintf( m_pHRequest, "Error getting thread information.");
		goto Exit;
	}
	f_timeGetSeconds( &uiCurrentTime);

	// Write out the table rows

	f_timeGetSeconds( &uiCurrentTime);
	for( uiLoop = 0; uiLoop < uiNumThreads; uiLoop++)
	{
		printTableRowStart( (uiLoop & 0x00000001) ? FALSE : TRUE);
		fnPrintf( m_pHRequest, TD_8x, (FLMUINT)pThreadInfo[ uiLoop].uiThreadId);
		fnPrintf( m_pHRequest, TD_8x, (FLMUINT)pThreadInfo[ uiLoop].uiThreadGroup);
		fnPrintf( m_pHRequest, TD_8x, (FLMUINT)pThreadInfo[ uiLoop].uiAppId);
		fnPrintf( m_pHRequest, TD_s, pThreadInfo[ uiLoop].pszThreadName 
							? (char *)pThreadInfo[ uiLoop].pszThreadName 
							: "Unknown");
		fnPrintf( m_pHRequest, TD_s, pThreadInfo[ uiLoop].pszThreadStatus
							? (char *)pThreadInfo[ uiLoop].pszThreadName 
							: "Unknown");

		f_sprintf( (char *)szTmp, "%s/threads?shutdown=%u", m_pszURLString,
			(unsigned)pThreadInfo[ uiLoop].uiThreadId);

		if( bRefresh)
		{
			f_strcat( szTmp, "?refresh");
		}

		fnPrintf( m_pHRequest, TD_a_s_s, szTmp, "Shutdown");

		fnPrintf( m_pHRequest, TD_ui, 
			(FLMUINT)(uiCurrentTime - pThreadInfo[ uiLoop].uiStartTime));

		printTableRowEnd();
	}

	// Close the table

	printTableEnd();


	// Close the document

	printDocEnd();

Exit:

	fnEmit();
	GedPoolFree( &pool);
	return( FERR_OK);
}

/****************************************************************************
Desc: Serves up a static file to a web browser
****************************************************************************/
RCODE F_HttpFile::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	FlmStaticFile *	pStaticFile;
	F_FileHdl *			pSrcFile = NULL;
	F_DirHdl *			pDirHdl = NULL;
	FLMUINT				uiSize;
	FLMUINT				uiBytesRead;
	FLMUINT				uiOffset;
	FLMBYTE *			pucBuf = NULL;
	FLMUINT				uiBufSize;
	FLMUINT				uiCount;
	char					szPath[ F_PATH_MAX_SIZE];
	char					szTmp[ F_PATH_MAX_SIZE];
	FLMBOOL				bHaveParent;
	FLMBOOL				bStaticOnly = FALSE;
	FLMBOOL				bMapSlashes = FALSE;
	RCODE					rc = FERR_OK;

	uiSize = 10;
	if( f_strnicmp( ppszParams[ 0], "staticfile", uiSize) == 0)
	{
		bStaticOnly = TRUE;

		if( f_strlen( ppszParams[ 0]) > uiSize)
		{
			if( ppszParams[ 0][ uiSize] == '/')
			{
				uiSize++;
			}
			f_strcpy( szPath, &ppszParams[ 0][ uiSize]);
			bMapSlashes = TRUE;
		}
		else
		{
			rc = RC_SET( FERR_IO_PATH_NOT_FOUND);
			goto NotFoundExit;
		}
	}
	else
	{
		if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
				"path", sizeof( szPath), szPath)))
		{
			if( f_strnicmp( ppszParams[ 0], "file/", 5) == 0 && 
				f_strlen( ppszParams[ 0]) > 5)
			{
				f_strcpy( szPath, &ppszParams[ 0][ 5]);
				bMapSlashes = TRUE;
			}
			else
			{
				printDocStart( "File Manager");

				// Insert a form into the page to get the file path

				fnPrintf( m_pHRequest, "<form type=\"submit\" "
										  "method=\"get\" action=\"%s/file\">\n",
										  m_pszURLString);

				fnPrintf( m_pHRequest, "<BR>\n<CENTER>\nPath<BR>\n"
								 "<INPUT type=\"text\" size=\"60\" maxlength=\"120\" name=\"path\"></INPUT><BR>\n");
				printButton( "Submit", BT_Submit);
				fnPrintf( m_pHRequest, "</CENTER>\n</form><BR>\n");
				printDocEnd();
				goto Exit;
			}
		}
	}

	// Translate any escaped characters in the path

	fcsDecodeHttpString( szPath);

	// Convert any forward slashes into back slashes on non-Unix platforms

#ifndef FLM_UNIX
	if( bMapSlashes)
	{
		char *		pszTmp = szPath;

		while( *pszTmp)
		{
			if( *pszTmp == '/')
			{
				*pszTmp = '\\';
			}
			pszTmp++;
		}
	}
#endif

	// Find the file in the table

	pStaticFile = &gv_StaticFileTbl[ 0];
	while( pStaticFile->pszPath)
	{
		if( f_strcmp( pStaticFile->pszPath, szPath) == 0)
		{
			break;
		}
		pStaticFile++;
	}

	// Found the file in the static file table

	if( pStaticFile->pszPath)
	{
		// Send the data

		fnSetHdrValue( "Content-Type", (char *)pStaticFile->pszMimeType);
		f_sprintf( (char *)szTmp, "%u", (unsigned)pStaticFile->uiSize);
		fnSetHdrValue( "Content-Length", (char *)szTmp);
		fnSendHeader( HTS_OK);
		fnSendBuffer( pStaticFile->pucData, pStaticFile->uiSize);
		goto Exit;
	}
	else if( bStaticOnly)
	{
		rc = RC_SET( FERR_IO_PATH_NOT_FOUND);
		goto NotFoundExit;
	}

	// See if a directory listing has been requested.

	if( gv_FlmSysData.pFileSystem->IsDir( szPath))
	{
		if (RC_BAD( rc = gv_FlmSysData.pFileSystem->OpenDir( 
			szPath, "*", &pDirHdl)))
		 {
			goto ReportErrorExit;
		}

		f_sprintf( (char *)szTmp, "Directory listing of %80s", szPath);

		// Document

		printDocStart( (char *)szTmp, FALSE);

		// Table

		printTableStart( (char *)szTmp, 5);

		// Table column headers

		printTableRowStart();
		printColumnHeading( "File Name");
		printColumnHeading( "Type");
		printColumnHeading( "Size");
		printColumnHeading( "Timestamp");
		printColumnHeading( "Action");
		printTableRowEnd();

		// Output the parent directory

		bHaveParent = FALSE;
		if( RC_BAD( rc = f_pathReduce( szPath, szTmp, NULL)))
		{
			if( rc == FERR_IO_AT_PATH_ROOT)
			{
				rc = FERR_OK;
			}
			else
			{
				goto Exit;
			}
		}
		else if( *szTmp)
		{
			bHaveParent = TRUE;
		}

		// Output the directory contents

		uiCount = 0;
		for (;;)
		{
			if( !bHaveParent)
			{
				if (RC_BAD( rc = pDirHdl->Next()))
				{
					if (rc == FERR_IO_NO_MORE_FILES)
					{
						rc = FERR_OK;
						break;
					}
					else
					{
						goto Exit;
					}
				}
				pDirHdl->CurrentItemPath( szTmp);
			}

			printTableRowStart( (uiCount & 0x00000001) ? FALSE : TRUE);

			// File Path

			printTableDataStart();
			fnPrintf( m_pHRequest, "<a href=\"%s", m_pszURLString);
			fnPrintf( m_pHRequest, "/file/");
			printEncodedString( szTmp, URL_PATH_ENCODING);
			fnPrintf( m_pHRequest, "\">");
			printEncodedString( 
				bHaveParent ? ".. <parent>" 
								: pDirHdl->CurrentItemName(), HTML_ENCODING);
			fnPrintf( m_pHRequest, "</a>\n");
			printTableDataEnd();

			// File type

			printTableDataStart();
			if( bHaveParent || pDirHdl->CurrentItemIsDir())
			{
				fnPrintf( m_pHRequest, "Dir");
			}
			else
			{
				fnPrintf( m_pHRequest, "File");
			}
			printTableDataEnd();

			// File size

			printTableDataStart();
			if( !bHaveParent && !pDirHdl->CurrentItemIsDir())
			{
				fnPrintf( m_pHRequest, "%u", pDirHdl->CurrentItemSize());
			}
			else
			{
				printTableDataEmpty();
			}
			printTableDataEnd();

			// Timestamp

			printTableDataStart();
			if( !bHaveParent)
			{
				FLMUINT		uiTimestamp;

				if( RC_BAD( gv_FlmSysData.pFileSystem->GetTimeStamp( 
					szTmp, &uiTimestamp)))
				{
					uiTimestamp = 0;
				}

				printDate( uiTimestamp);
			}
			else
			{
				printTableDataEmpty();
			}

			// Action

			printTableDataStart();
			if( !bHaveParent && 
					(f_strstr( pDirHdl->CurrentItemName(), ".db") != NULL ||
					f_strstr( pDirHdl->CurrentItemName(), ".DB") != NULL))
			{
				fnPrintf( m_pHRequest, "<a href=\"%s", m_pszURLString);
				fnPrintf( m_pHRequest, "/database?operation=open?path=");
				printEncodedString( szTmp, URL_PATH_ENCODING, FALSE);
				fnPrintf( m_pHRequest, "\">");
				fnPrintf( m_pHRequest, "Open");
				fnPrintf( m_pHRequest, "</a>\n");

				fnPrintf( m_pHRequest, ", <a href=\"%s", m_pszURLString);
				fnPrintf( m_pHRequest, "/dbbackup/");
				printEncodedString( szTmp, URL_PATH_ENCODING);
				fnPrintf( m_pHRequest, "\">");
				fnPrintf( m_pHRequest, "Backup");
				fnPrintf( m_pHRequest, "</a>\n");
			}
			else
			{
				printTableDataEmpty();
			}
			printTableDataEnd();
			printTableRowEnd();

			uiCount++;
			bHaveParent = FALSE;
		}

		printTableEnd();
		printDocEnd();

		pDirHdl->Release();
		pDirHdl = NULL;

		goto Exit;
	}

	// Try opening the file on the file system

	if( RC_BAD( rc = gv_FlmSysData.pFileSystem->Open( szPath,
		F_IO_RDONLY | F_IO_SH_DENYNONE, &pSrcFile)))
	{
		if( rc == FERR_IO_PATH_NOT_FOUND)
		{
			goto NotFoundExit;
		}
		else
		{
			goto ReportErrorExit;
		}
	}

	// Get the file size

	if( RC_BAD( rc = pSrcFile->Size( &uiSize)))
	{
		goto ReportErrorExit;
	}

	// Allocate a buffer for streaming the data back to the client

	uiBufSize = 2048;
	if( RC_BAD( f_alloc( uiBufSize, &pucBuf)))
	{
		goto ReportErrorExit;
	}

	// Send the HTTP header

	f_sprintf( (char *)szTmp, "%u", (unsigned)uiSize);
	fnSetHdrValue( "Content-Length", (char *)szTmp);
	fnSendHeader( HTS_OK);

	// Send the data

	uiOffset = 0;
	for( ;;)
	{
		if( RC_BAD( rc = pSrcFile->Read( uiOffset, uiBufSize, 
			pucBuf, &uiBytesRead)))
		{
			if( rc == FERR_IO_END_OF_FILE)
			{
				rc = FERR_OK;
			}
			else
			{
				goto Exit;
			}
		}

		if( uiBytesRead)
		{
			if( fnSendBuffer( pucBuf, uiBytesRead) != 0)
			{
				rc = RC_SET( FERR_FAILURE);
				goto Exit;
			}
			uiOffset += uiBytesRead;
		}
		
		if( uiBytesRead < uiBufSize || uiOffset == uiSize)
		{
			break;
		}
	}

Exit:

	fnEmit();

	if( pSrcFile)
	{
		pSrcFile->Release();
	}

	if( pDirHdl)
	{
		pDirHdl->Release();
	}

	if( pucBuf)
	{
		f_free( &pucBuf);
	}

	return( FERR_OK);

ReportErrorExit:

	printErrorPage( rc);
	goto Exit;

NotFoundExit:

	fnSetHdrValue( "Content-Type", "text/html");
	fnSendHeader( HTS_NOT_FOUND);
	printErrorPage( rc, FALSE);
	goto Exit;
}

/****************************************************************************
Desc: Streams data back to the web browser during a database backup
****************************************************************************/
RCODE F_HttpDbBackup::backupWriteHook(
	void *		pvBuffer,
	FLMUINT		uiBytesToWrite,
	void *		pvUserData)
{
	F_HttpDbBackup *	pThis = (F_HttpDbBackup *)pvUserData;
	RCODE					rc = FERR_OK;

	if( gv_FlmSysData.HttpConfigParms.fnSendBuffer( pThis->m_pHRequest,
					pvBuffer, uiBytesToWrite))
	{
		rc = RC_SET( FERR_FAILURE);
		goto Exit;
	}

Exit:

	return( rc);
}

/****************************************************************************
Desc: Interface for performing a web-based database backup
****************************************************************************/
RCODE F_HttpDbBackup::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	RCODE					rc = FERR_OK;
	char					szPath[ 256];
	HFDB					hDb = HFDB_NULL;
	HFBACKUP				hBackup = HFBACKUP_NULL;
	FLMBOOL				bMapSlashes = FALSE;

	// Get the database path

	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
			"path", sizeof( szPath), szPath)))
	{
		if( f_strnicmp( ppszParams[ 0], "dbbackup/", 9) == 0 && 
			f_strlen( ppszParams[ 0]) > 9)
		{
			f_strcpy( szPath, &ppszParams[ 0][ 9]);
			bMapSlashes = TRUE;
		}
		else
		{
			printDocStart( "Database Backup");

			// Insert a form into the page to get backup information

			fnPrintf( m_pHRequest, "<form type=\"submit\" "
									  "method=\"get\" action=\"%s/dbbackup\">\n",
									  m_pszURLString);
			fnPrintf( m_pHRequest, "<BR>\n<CENTER>\nPath<BR>\n"
							"<INPUT type=\"text\" size=\"60\" maxlength=\"120\" name=\"path\"></INPUT><BR>\n");
			printButton( "Submit", BT_Submit);
			fnPrintf( m_pHRequest, "</CENTER>\n</form>\n");

			printDocEnd();

			goto Exit;
		}
	}

	// Translate any escaped characters in the path

	fcsDecodeHttpString( szPath);

	// Convert any forward slashes into back slashes on non-Unix platforms

#ifndef FLM_UNIX
	if( bMapSlashes)
	{
		char *		pszTmp = szPath;

		while( *pszTmp)
		{
			if( *pszTmp == '/')
			{
				*pszTmp = '\\';
			}
			pszTmp++;
		}
	}
#endif

	// Open the database

	if( RC_BAD( rc = FlmDbOpen( szPath, NULL, NULL,
										 0, NULL, &hDb)))
	{
		goto ReportErrorExit;
	}

	// Start the backup.  This may return an error such as FERR_BACKUP_ACTIVE,
	// which we will want to report back to the client.

	if( RC_BAD( rc = FlmDbBackupBegin( hDb, FLM_FULL_BACKUP, TRUE, &hBackup)))
	{
		goto ReportErrorExit;
	}

	// Send the header.  We don't know how big the backup will be,
	// so we can't send a content length.

	fnSetHdrValue( "Content-Type", "x-novell/dbbackup");
	fnSendHeader( HTS_OK);

	// Perform the backup

	if( RC_BAD( rc = FlmDbBackup( hBackup, NULL, NULL,
		F_HttpDbBackup::backupWriteHook, NULL, this, NULL)))
	{
		goto Exit;
	}

Exit:

	fnEmit();

	if( hBackup != HFBACKUP_NULL)
	{
		FlmDbBackupEnd( &hBackup);
	}

	if( hDb != HFDB_NULL)
	{
		FlmDbClose( &hDb);
	}

	return( FERR_OK);

ReportErrorExit:

	printErrorPage( rc);
	goto Exit;
}

/****************************************************************************
Desc: Displays information about FLAIM indexes
****************************************************************************/
RCODE F_FlmIndexPage::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	FLMBOOL				bRefresh = FALSE;
	char					szTmp[ 128];
	char					szPath[ F_PATH_MAX_SIZE];
	char					szDbKey[ F_SESSION_DB_KEY_LEN];
	FLMUINT				uiIndexNum;
	FLMUINT				uiTransType;
	HFDB					hDb = HFDB_NULL;
	FINDEX_STATUS		indexStatus;
	FLMUINT				uiLoop;
	FlmRecord *			pRec = NULL;
	F_Session *			pFlmSession = m_pFlmSession;
	FLMBOOL				bMapSlashes = FALSE;
	FLMBOOL				bOpenedDb = FALSE;
	FLMBOOL				bStartedTrans = FALSE;
	RCODE					rc = FERR_OK;

	// Check the session

	if( !pFlmSession)
	{
		rc = RC_SET( m_uiSessionRC);
		goto ReportErrorExit;
	}

	// Initialize the path

	szPath[ 0] = '\0';

	// DB handle

	getDatabaseHandleParam( uiNumParams, ppszParams, 
		pFlmSession, &hDb, szDbKey);

	if( hDb == HFDB_NULL)
	{
		// Get the database path

		if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
				"path", sizeof( szPath), szPath)))
		{
			if( f_strnicmp( ppszParams[ 0], "index/", 6) == 0 && 
				f_strlen( ppszParams[ 0]) > 6)
			{
				f_strcpy( szPath, &ppszParams[ 0][ 6]);
				bMapSlashes = TRUE;
			}
			else
			{
				printDocStart( "Index Manager");

				// Insert a form into the page to get the database path

				fnPrintf( m_pHRequest, "<form type=\"submit\" "
										  "method=\"get\" action=\"%s/index\">\n",
										  m_pszURLString);
				fnPrintf( m_pHRequest, "<BR>\n<CENTER>\nDatabase Path<BR>\n"
						"<INPUT type=\"text\" size=\"60\" maxlength=\"120\" name=\"path\"></INPUT><BR>\n");
				printButton( "Submit", BT_Submit);
				fnPrintf( m_pHRequest, "</CENTER>\n</form>\n");

				printDocEnd();
				goto Exit;
			}
		}

		// Translate any escaped characters in the path

		fcsDecodeHttpString( szPath);

		// Convert any forward slashes into back slashes on non-Unix platforms

	#ifndef FLM_UNIX
		if( bMapSlashes)
		{
			char *		pszTmp = szPath;

			while( *pszTmp)
			{
				if( *pszTmp == '/')
				{
					*pszTmp = '\\';
				}
				pszTmp++;
			}
		}
	#endif

		// Open the database

		if( RC_BAD( rc = FlmDbOpen( szPath, NULL, NULL,
											 0, NULL, &hDb)))
		{
			goto ReportErrorExit;
		}

		bOpenedDb = TRUE;
	}

	// Get the current transaction type

	if( RC_BAD( rc = FlmDbGetTransType( hDb, &uiTransType)))
	{
		goto ReportErrorExit;
	}

	// Suspend?

	if( RC_OK( ExtractParameter( uiNumParams, ppszParams, 
			"suspend", sizeof( szTmp), szTmp)))
	{
		if( (uiIndexNum = f_atoi( szTmp)) != 0)
		{
			FlmIndexSuspend( hDb, uiIndexNum);
		}
		else if( f_stricmp( szTmp, "all") == 0)
		{
			if( uiTransType != FLM_UPDATE_TRANS)
			{
				if( RC_BAD( rc = FlmDbTransBegin( hDb, FLM_UPDATE_TRANS, 5)))
				{
					goto ReportErrorExit;
				}
				uiTransType = FLM_UPDATE_TRANS;
				bStartedTrans = TRUE;
			}

			uiIndexNum = 0;
			for( uiLoop = 0;; uiLoop++)
			{
				if( RC_BAD( FlmIndexGetNext( hDb, &uiIndexNum)))
				{
					break;
				}

				(void)FlmIndexSuspend( hDb, uiIndexNum);
			}

			if( bStartedTrans)
			{
				bStartedTrans = FALSE;
				if( RC_BAD( rc = FlmDbTransCommit( hDb)))
				{
					FlmDbTransAbort( hDb);
				}
			}
		}
	}

	// Resume?

	if( RC_OK( ExtractParameter( uiNumParams, ppszParams, 
			"resume", sizeof( szTmp), szTmp)))
	{
		if( (uiIndexNum = f_atoi( szTmp)) != 0)
		{
			FlmIndexResume( hDb, uiIndexNum);
		}
		else if( f_stricmp( szTmp, "all") == 0)
		{
			if( uiTransType != FLM_UPDATE_TRANS)
			{
				if( RC_BAD( rc = FlmDbTransBegin( hDb, FLM_UPDATE_TRANS, 5)))
				{
					goto ReportErrorExit;
				}
				uiTransType = FLM_UPDATE_TRANS;
				bStartedTrans = TRUE;
			}

			uiIndexNum = 0;
			for( uiLoop = 0;; uiLoop++)
			{
				if( RC_BAD( FlmIndexGetNext( hDb, &uiIndexNum)))
				{
					break;
				}

				(void)FlmIndexResume( hDb, uiIndexNum);
			}

			if( bStartedTrans)
			{
				bStartedTrans = FALSE;
				if( RC_BAD( rc = FlmDbTransCommit( hDb)))
				{
					FlmDbTransAbort( hDb);
				}
			}
		}
	}

	// Document start

	printDocStart( "Indexes", FALSE);

	// Determine if we are being requested to refresh this page or not.

	if ((bRefresh = DetectParameter( uiNumParams,
											   ppszParams, 
											   "refresh")) == TRUE)
	{
		fnPrintf( m_pHRequest, 
			"<META http-equiv=\"refresh\" content=\"5;");
		fnPrintf( m_pHRequest, " url=%s/index",
			m_pszURLString);

		if( bOpenedDb)
		{
			fnPrintf( m_pHRequest, "?path=");
			printEncodedString( szPath, URL_QUERY_ENCODING);
		}
		else
		{
			fnPrintf( m_pHRequest, "?dbhandle=%s", szDbKey);
		}
		fnPrintf( m_pHRequest, "?refresh");
		fnPrintf( m_pHRequest, "\">\n");
	}
	
	// Table

	printTableStart( "Indexes", 8);

	// Refresh link

	printTableRowStart();
	printColumnHeading( NULL, JUSTIFY_LEFT, 
		FLM_IMON_COLOR_PUTTY_1, 8, 1, FALSE);

	fnPrintf( m_pHRequest, "<A HREF=%s/index", m_pszURLString);
	if( bOpenedDb)
	{
		fnPrintf( m_pHRequest, "?path=");
		printEncodedString( szPath, URL_QUERY_ENCODING);
	}
	else
	{
		fnPrintf( m_pHRequest, "?dbhandle=%s", szDbKey);
	}

	if( bRefresh)
	{
		fnPrintf( m_pHRequest, "?refresh");
	}

	fnPrintf( m_pHRequest, ">Refresh</A>");

	// Space

	fnPrintf( m_pHRequest, ", ");

	// Auto-refresh link

	fnPrintf( m_pHRequest, "<A HREF=%s/index", m_pszURLString);
	if( bOpenedDb)
	{
		fnPrintf( m_pHRequest, "?path=");
		printEncodedString( szPath, URL_QUERY_ENCODING);
	}
	else
	{
		fnPrintf( m_pHRequest, "?dbhandle=%s", szDbKey);
	}

	if( !bRefresh)
	{
		fnPrintf( m_pHRequest, "?refresh");
		fnPrintf( m_pHRequest, ">Start Auto-Refresh (5 sec.)</A>");
	}
	else
	{
		fnPrintf( m_pHRequest, ">Stop Auto-Refresh</A>");
	}

	// Space

	fnPrintf( m_pHRequest, ", ");

	// Suspend all

	fnPrintf( m_pHRequest, "<A HREF=%s/index", m_pszURLString);
	if( bOpenedDb)
	{
		fnPrintf( m_pHRequest, "?path=");
		printEncodedString( szPath, URL_QUERY_ENCODING);
	}
	else
	{
		fnPrintf( m_pHRequest, "?dbhandle=%s", szDbKey);
	}

	if( bRefresh)
	{
		fnPrintf( m_pHRequest, "?refresh");
	}

	fnPrintf( m_pHRequest, "?suspend=all");
	fnPrintf( m_pHRequest, ">Suspend All Indexes</A>");

	// Space

	fnPrintf( m_pHRequest, ", ");

	// Resume all

	fnPrintf( m_pHRequest, "<A HREF=%s/index", m_pszURLString);
	if( bOpenedDb)
	{
		fnPrintf( m_pHRequest, "?path=");
		printEncodedString( szPath, URL_QUERY_ENCODING);
	}
	else
	{
		fnPrintf( m_pHRequest, "?dbhandle=%s", szDbKey);
	}

	if( bRefresh)
	{
		fnPrintf( m_pHRequest, "?refresh");
	}

	fnPrintf( m_pHRequest, "?resume=all");
	fnPrintf( m_pHRequest, ">Resume All Indexes</A>");

	printColumnHeadingClose();
	printTableRowEnd();

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Action");
	printColumnHeading( "Index Number", JUSTIFY_RIGHT);
	printColumnHeading( "Index Name");
	printColumnHeading( "Status");
	printColumnHeading( "Background Start Time");
	printColumnHeading( "Last Record ID Indexed", JUSTIFY_RIGHT);
	printColumnHeading( "Keys Processed", JUSTIFY_RIGHT);
	printColumnHeading( "Records Processed", JUSTIFY_RIGHT);
	printTableRowEnd();

	// Output index list

	uiIndexNum = 0;
	for( uiLoop = 0;; uiLoop++)
	{
		if( RC_BAD( rc = FlmIndexGetNext( hDb, &uiIndexNum)))
		{
			if( rc == FERR_EOF_HIT)
			{
				rc = FERR_OK;
				break;
			}
			goto Exit;
		}

		if( RC_BAD( FlmIndexStatus( hDb, uiIndexNum, &indexStatus)))
		{
			continue;
		}

		// Write out the table rows

		printTableRowStart( (uiLoop & 0x00000001) ? FALSE : TRUE);

		// Action

		printTableDataStart();
		fnPrintf( m_pHRequest, "<a href=\"");
		fnPrintf( m_pHRequest, "%s/index", m_pszURLString);
		if( bOpenedDb)
		{
			fnPrintf( m_pHRequest, "?path=");
			printEncodedString( szPath, URL_QUERY_ENCODING);
		}
		else
		{
			fnPrintf( m_pHRequest, "?dbhandle=%s", szDbKey);
		}

		fnPrintf( m_pHRequest, "?%s=%u", 
			indexStatus.bSuspended ? "resume" : "suspend",
			(unsigned)uiIndexNum);

		if( bRefresh)
		{
			fnPrintf( m_pHRequest, "?refresh");
		}

		fnPrintf( m_pHRequest, "\">");

		fnPrintf( m_pHRequest, "%s", 
			indexStatus.bSuspended ? "Resume" : "Suspend");

		fnPrintf( m_pHRequest, "</a>\n");

		printTableDataEnd();

		// Index Number

		printTableDataStart( TRUE, JUSTIFY_RIGHT);
		fnPrintf( m_pHRequest, "%u", (unsigned)indexStatus.uiIndexNum);
		printTableDataEnd();

		// Name

		f_sprintf( (char *)szTmp, "Unknown");
		if( RC_OK( FlmRecordRetrieve( hDb, FLM_DICT_CONTAINER, 
			uiIndexNum, FO_EXACT, &pRec, NULL)))
		{
			FLMUINT	uiBufLen = sizeof( szTmp);
			pRec->getNative( pRec->root(), szTmp, &uiBufLen);
		}

		printTableDataStart();
		fnPrintf( m_pHRequest, "%s", szTmp);
		printTableDataEnd();

		// Status

		printTableDataStart();
		if( indexStatus.bSuspended)
		{
			fnPrintf( m_pHRequest, "suspended");
		}
		else if( indexStatus.uiLastRecordIdIndexed != 0xFFFFFFFF)
		{
			fnPrintf( m_pHRequest, "bringing on-line");
		}
		else
		{
			fnPrintf( m_pHRequest, "on-line");
		}
		printTableDataEnd();

		// Start time

		printTableDataStart();
		if( indexStatus.uiStartTime)
		{
			printDate( indexStatus.uiStartTime);
		}
		else
		{
			printTableDataEmpty();
		}
		printTableDataEnd();

		// Last record indexed

		if( indexStatus.uiLastRecordIdIndexed != 0xFFFFFFFF)
		{
			printCommaNum( indexStatus.uiLastRecordIdIndexed);
		}
		else
		{
			printTableDataStart();
			printTableDataEmpty();
			printTableDataEnd();
		}

		// Keys processed

		if( indexStatus.uiKeysProcessed)
		{
			printCommaNum( indexStatus.uiKeysProcessed);
		}
		else
		{
			printTableDataStart();
			printTableDataEmpty();
			printTableDataEnd();
		}

		// Records processed

		if( indexStatus.uiRecordsProcessed)
		{
			printCommaNum( indexStatus.uiRecordsProcessed);
		}
		else
		{
			printTableDataStart();
			printTableDataEmpty();
			printTableDataEnd();
		}

		printTableRowEnd();
	}

	printTableEnd();
	printDocEnd();

Exit:

	fnEmit();

	if( pRec)
	{
		pRec->Release();
	}

	if( bStartedTrans)
	{
		FlmDbTransAbort( hDb);
	}

	if( bOpenedDb && hDb != HFDB_NULL)
	{
		FlmDbClose( &hDb);
	}

	return( FERR_OK);

ReportErrorExit:

	printErrorPage( rc);
	goto Exit;
}

/****************************************************************************
Desc: Displays information about return codes
****************************************************************************/
RCODE F_RCodeLookupPage::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	char				szCode[ 128];
	FLMUINT			uiLow;
	FLMUINT			uiCount;
	FLMUINT			uiHigh;
	FLMUINT			uiLoop;

	// Extract the lookup parameter
	
	szCode[ 0] = 0;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
			"rc", sizeof( szCode), szCode)))
	{
		if( f_strnicmp( ppszParams[ 0], "returncode/", 11) == 0 && 
			f_strlen( ppszParams[ 0]) > 11)
		{
			f_strcpy( szCode, &ppszParams[ 0][ 11]);
		}
	}
	else if( !szCode[ 0])
	{
		f_strcpy( szCode, "all");
	}

	// Document

	printDocStart( (char *)"Return Code Lookup");

	// Insert a form into the page to get the file path

	fnPrintf( m_pHRequest, "<form type=\"submit\" "
							  "method=\"get\" action=\"%s/returncode\">\n",
							  m_pszURLString);
	fnPrintf( m_pHRequest, "<BR>\n<CENTER>\nReturn Code<BR>\n"
								  "<INPUT type=\"text\" size=\"60\" maxlength=\"120\" name=\"rc\"></INPUT><BR>\n");
	printButton( "Submit", BT_Submit);
	fnPrintf( m_pHRequest, "<BR>\n</CENTER>\n</form>\n");

	// Done?

	if( !szCode[ 0])
	{
		printDocEnd();
		goto Exit;
	}

	// Translate any escaped characters in the path

	fcsDecodeHttpString( szCode);

	// Get the value of the RCODE

	if( f_stricmp( szCode, "all") != 0)
	{
		if( (uiLow = f_atoud( szCode)) < (FLMUINT)FIRST_FLAIM_ERROR)
		{
			uiLow = (FLMUINT)FIRST_FLAIM_ERROR;
		}

		if( (uiHigh = uiLow + 100) > (FLMUINT)LAST_FLAIM_ERROR)
		{
			uiHigh = (FLMUINT)LAST_FLAIM_ERROR;
		}
	}
	else
	{
		uiLow = (FLMUINT)FIRST_FLAIM_ERROR;
		uiHigh = (FLMUINT)LAST_FLAIM_ERROR;
	}

	// Put a little space between the form and the table

	fnPrintf( m_pHRequest, "<BR>\n");

	// Table

	printTableStart( (char *)"Return Code(s)", 3);

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Hex");
	printColumnHeading( "Decimal");
	printColumnHeading( "Name");
	printTableRowEnd();

	uiCount = 0;
	for( uiLoop = uiLow; uiLoop <= uiHigh; uiLoop++)
	{
		const char *		pszName = flmErrorString( (RCODE)uiLoop);

		if( pszName)
		{
			printTableRowStart( ((uiCount++) & 0x00000001) ? FALSE : TRUE);

			// Hex

			printTableDataStart();
			fnPrintf( m_pHRequest, "0x%04X", (unsigned)uiLoop);
			printTableDataEnd();

			// Decimal

			printTableDataStart();
			fnPrintf( m_pHRequest, "%u", (unsigned)uiLoop);
			printTableDataEnd();

			// Name

			printTableDataStart();
			fnPrintf( m_pHRequest, "%s", pszName);
			printTableDataEnd();

			printTableRowEnd();
		}
	}

	printTableEnd();
	printDocEnd();

Exit:

	fnEmit();
	return( FERR_OK);
}

/****************************************************************************
Desc:
****************************************************************************/
RCODE F_DatabasePage::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	char					szOperation[ 256];
	char					szTmp[ 128];
	char *				pszPath;
	char *				pszDataDir;
	char *				pszRflDir;
	char					szDbKey[ F_SESSION_DB_KEY_LEN];
	char *				pTmp;
	char *				pucPathBuf = NULL;
	FLMUINT				uiTransType;
	FLMUINT				uiEndType;
	FLMUINT				uiOperation;
	FLMUINT				uiLanguage;
	FLMBOOL				bExecute = FALSE;
	FLMBOOL				bPrintedParms;
	FLMBOOL				bDelRflFiles;
	FLMBOOL				bMustConfirm = FALSE;
	HFDB					hDb = HFDB_NULL;
	F_Session *			pFlmSession = m_pFlmSession;
	FLMBOOL				bHighlight;
	RCODE					rc = FERR_OK;

	// Check the session

	if( !pFlmSession)
	{
		rc = RC_SET( m_uiSessionRC);
		goto ReportErrorExit;
	}

	// Allocate a path buffer

	if( RC_BAD( f_alloc( 
		F_PATH_MAX_SIZE * 3, &pucPathBuf)))
	{
		goto ReportErrorExit;
	}

	pszPath = &pucPathBuf[ 0];
	pszDataDir = &pucPathBuf[ F_PATH_MAX_SIZE];
	pszRflDir = &pucPathBuf[ F_PATH_MAX_SIZE * 2];

	// Get the database operation

	uiOperation = 0;
	szOperation[ 0] = 0;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
			"operation", sizeof( szOperation), szOperation)))
	{
		pTmp = &szOperation[ 0];
		getFormValueByName( "operation", 
			&pTmp, sizeof( szOperation), NULL);
	}

	if( szOperation[ 0])
	{
		fcsDecodeHttpString( szOperation);
		if( (uiOperation = f_atoud( szOperation)) != 0)
		{
			szOperation[ 0] = 0;
		}
	}

	// DB handle

	if( RC_BAD( rc = getDatabaseHandleParam( uiNumParams, ppszParams, 
		pFlmSession, &hDb, szDbKey)))
	{
		if( rc != FERR_NOT_FOUND)
		{
			goto ReportErrorExit;
		}
		rc = FERR_OK;
	}

	// Transaction type

	szTmp[ 0] = '\0';
	uiTransType = FLM_NO_TRANS;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"transtype", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "transtype", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		uiTransType = f_atoud( szTmp);
	}

	// Language

	uiLanguage = DEFAULT_LANG;
	szTmp[ 0] = '\0';
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"language", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "language", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		uiLanguage = f_atoud( szTmp);
	}

	// End type

	szTmp[ 0] = '\0';
	uiEndType = 0;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"endtype", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "endtype", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		uiEndType = f_atoud( szTmp);
	}

	// Delete RFL files flag

	szTmp[ 0] = '\0';
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"delrfl", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "delrfl", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		bDelRflFiles = f_atoud( szTmp) ? TRUE : FALSE;
	}
	else
	{
		bDelRflFiles = FALSE;
	}

	// Path

	pszPath[ 0] = '\0';
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
			"path", F_PATH_MAX_SIZE, pszPath)))
	{
		getFormValueByName( "path", 
			&pszPath, F_PATH_MAX_SIZE, NULL);
	}

	if( pszPath[ 0])
	{
		fcsDecodeHttpString( pszPath);
	}

	// Data directory

	pszDataDir[ 0] = '\0';
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
			"datadir", F_PATH_MAX_SIZE, pszDataDir)))
	{
		getFormValueByName( "datadir", 
			&pszDataDir, F_PATH_MAX_SIZE, NULL);
	}

	if( pszDataDir[ 0])
	{
		fcsDecodeHttpString( pszDataDir);
	}

	// RFL directory

	pszRflDir[ 0] = '\0';
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
			"rfldir", F_PATH_MAX_SIZE, pszRflDir)))
	{
		getFormValueByName( "rfldir", 
			&pszRflDir, F_PATH_MAX_SIZE, NULL);
	}

	if( pszRflDir[ 0])
	{
		fcsDecodeHttpString( pszRflDir);
	}

	// Execute

	bExecute = FALSE;
	szTmp[ 0] = '\0';
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"Action", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "Action", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		bExecute = f_atoud( szTmp) ? TRUE : FALSE;
	}

	// Start document

	printDocStart( "Database Operations", FALSE);
	popupFrame();

	// Perform the requested operation

	if( f_stricmp( szOperation, "open") == 0 ||
		(uiOperation == FLM_DB_OPEN && bExecute))
	{
		// Open the database

		if( RC_OK( rc = FlmDbOpen( pszPath, pszDataDir, pszRflDir,
											0, NULL, &hDb)))
		{
			// Insert the handle into the session

			if( RC_BAD( rc = pFlmSession->addDbHandle( hDb)))
			{
				FlmDbClose( &hDb);
			}
		}
	}
	else if( f_stricmp( szOperation, "create") == 0 ||
		(uiOperation == FLM_DB_CREATE && bExecute))
	{
		CREATE_OPTS			createOpts;

		f_memset( &createOpts, 0, sizeof( CREATE_OPTS));
		createOpts.uiBlockSize = DEFAULT_BLKSIZ;
		createOpts.uiVersionNum = FLM_CURRENT_VERSION_NUM;
		createOpts.uiDefaultLanguage = uiLanguage;

		// Create the database

		if( RC_OK( rc = FlmDbCreate( pszPath, pszDataDir, pszRflDir,
			NULL, NULL, &createOpts, &hDb)))
		{
			// Insert the handle into the session

			if( RC_BAD( rc = pFlmSession->addDbHandle( hDb)))
			{
				FlmDbClose( &hDb);
			}
		}
	}
	else if( f_stricmp( szOperation, "remove") == 0 ||
		(uiOperation == FLM_DB_REMOVE && bExecute))
	{
		// Remove the database

		rc = FlmDbRemove( pszPath, pszDataDir, pszRflDir, bDelRflFiles);
	}
	else if ( f_stricmp( szOperation, "loghdr") == 0 ||
		(uiOperation == FLM_DB_LOGHDR && bExecute))
	{
		// Generate a new display to show the Log Header(s)
		// for the specified file.
		if (RC_OK( rc = displayLogFileHdr( pszPath)))
		{
			goto Exit;
		}
	}
	else if( f_stricmp( szOperation, "close") == 0)
	{
		if( hDb != HFDB_NULL)
		{
			pFlmSession->closeDb( szDbKey);
		}
	}
	else if( f_stricmp( szOperation, "transbegin") == 0)
	{
		if( hDb != HFDB_NULL && uiTransType != FLM_NO_TRANS)
		{
			rc = FlmDbTransBegin( hDb, uiTransType, 5);
		}
	}
	else if( f_stricmp( szOperation, "transend") == 0)
	{
		if( hDb != HFDB_NULL)
		{
			if( uiEndType)
			{
				if( RC_BAD( rc = FlmDbTransCommit( hDb)))
				{
					FlmDbTransAbort( hDb);
				}
			}
			else
			{
				FlmDbTransAbort( hDb);
			}
		}
	}
	else if( f_stricmp( szOperation, "checkpoint") == 0)
	{
		if( hDb != HFDB_NULL)
		{
			rc = FlmDbCheckpoint( hDb, 5);
		}
	}
	else if( f_stricmp( szOperation, "lock") == 0)
	{
		if( hDb != HFDB_NULL)
		{
			rc = FlmDbLock( hDb, FLM_LOCK_EXCLUSIVE, 0, 5);
		}
	}
	else if( f_stricmp( szOperation, "unlock") == 0)
	{
		if( hDb != HFDB_NULL)
		{
			rc = FlmDbUnlock( hDb);
		}
	}
	else if( f_stricmp( szOperation, "reduce") == 0)
	{
		if( hDb != HFDB_NULL)
		{
			rc = FlmDbReduceSize( hDb, 0, NULL);
		}
	}
	else
	{
		rc = RC_SET( FERR_ILLEGAL_OP);
	}

	// Table

	if( szOperation[ 0] || (uiOperation && bExecute))
	{
		f_sprintf( (char *)szTmp, 
			"Database Operations (Return Code = 0x%04X, %s)", 
			(unsigned)rc, FlmErrorString( rc));
	}
	else
	{
		f_sprintf( (char *)szTmp, "Database Operations");
	}

	printStartInputForm( "dbop", "database", 0);

	printTableStart( (char *)szTmp, 3);

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Operation", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printColumnHeading( "", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 50);
	printColumnHeading( "Execute", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printTableRowEnd();

	// Database parameters

	printTableRowStart();

	printTableDataStart( TRUE, JUSTIFY_LEFT, 25);

	fnPrintf( m_pHRequest, "<select name=\"operation\" size=1"
									  " onChange=\"document.dbop.Action.value='0';\n"
									  " document.dbop.submit();\n"
									  " \">\n");
	if( !uiOperation)
	{
		uiOperation = FLM_DB_OPEN;
	}

	printSelectOption( uiOperation, FLM_DB_OPEN, "Open", FALSE);
	printSelectOption( uiOperation, FLM_DB_CREATE, "Create", FALSE);
	printSelectOption( uiOperation, FLM_DB_REMOVE, "Remove", FALSE);
	printSelectOption( uiOperation, FLM_DB_LOGHDR, "View Log Header", FALSE);
	fnPrintf( m_pHRequest, "</select>\n");
	printTableDataEnd();

	printTableDataStart( TRUE, JUSTIFY_LEFT, 50);

	// Parameter table

	printTableStart( (char *)"Parameters", 2);

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Name", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 50);
	printColumnHeading( "Value", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 50);
	printTableRowEnd();
	bPrintedParms = FALSE;
	bHighlight = TRUE;
	
	if( uiOperation == FLM_DB_OPEN ||
		uiOperation == FLM_DB_CREATE ||
		uiOperation == FLM_DB_REMOVE ||
		uiOperation == FLM_DB_LOGHDR)
	{
		printTableRowStart( bHighlight = !bHighlight);

		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
		fnPrintf( m_pHRequest, "Path");
		printTableDataEnd();

		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
		fnPrintf( m_pHRequest, "<INPUT type=\"text\" size=\"20\" maxlength=\"120\""
									  " name=\"path\" value=\"");
		if( pszPath[ 0])
		{
			printEncodedString( pszPath, HTML_ENCODING);
		}
		fnPrintf( m_pHRequest, "\"></INPUT>\n");
		printTableDataEnd();
		printTableRowEnd();

		if (uiOperation != FLM_DB_LOGHDR)
		{
			printTableRowStart( bHighlight = !bHighlight);
			printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
			fnPrintf( m_pHRequest, "Data Directory (optional)");
			printTableDataEnd();

			printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
			fnPrintf( m_pHRequest, "<INPUT type=\"text\" size=\"20\" maxlength=\"120\""
										  " name=\"datadir\" value=\"");
			if( pszDataDir[ 0])
			{
				printEncodedString( pszDataDir, HTML_ENCODING);
			}
			fnPrintf( m_pHRequest, "\"></INPUT>\n");
			printTableDataEnd();
			printTableRowEnd();

			printTableRowStart( bHighlight = !bHighlight);
			printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
			fnPrintf( m_pHRequest, "RFL Directory (optional)");
			printTableDataEnd();

			printTableDataStart();
			fnPrintf( m_pHRequest, "<INPUT type=\"text\" size=\"20\" maxlength=\"120\""
										  " name=\"rfldir\" value=\"");
			if( pszRflDir[ 0])
			{
				printEncodedString( pszRflDir, HTML_ENCODING);
			}
			fnPrintf( m_pHRequest, "\"></INPUT>\n");
			printTableDataEnd();

			printTableRowEnd();
		}
		bPrintedParms = TRUE;
	}

	if( uiOperation == FLM_DB_REMOVE)
	{
		printTableRowStart( bHighlight = !bHighlight);

		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
		fnPrintf( m_pHRequest, "Delete RFL files");
		printTableDataEnd();

		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);

		fnPrintf( m_pHRequest, "<input name=\"delrfl\" type=\"checkbox\"");
		if( bDelRflFiles)
		{
			fnPrintf( m_pHRequest, " checked");
		}
		fnPrintf( m_pHRequest, " value=\"1\"></input>\n");
		printTableDataEnd();
		printTableRowEnd();
		bMustConfirm = TRUE;
	}

	if( uiOperation == FLM_DB_CREATE)
	{
		printTableRowStart( bHighlight = !bHighlight);

		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
		fnPrintf( m_pHRequest, "Default Language");
		printTableDataEnd();

		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
		printLanguagePulldown( uiLanguage);
		printTableDataEnd();
		printTableRowEnd();
	}

	if( !bPrintedParms)
	{
		printTableRowStart();
		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
		printTableDataEmpty();
		printTableDataEnd();
		printTableDataStart( TRUE, JUSTIFY_LEFT, 50);
		printTableDataEmpty();
		printTableDataEnd();
		printTableRowEnd();
	}

	printTableEnd();

	printTableDataStart( TRUE, JUSTIFY_LEFT, 25);

	if( bMustConfirm)
	{
		fnPrintf( m_pHRequest, "<script><!-- Hide script from old browsers\n");
		fnPrintf( m_pHRequest, "function confirmAction(myForm)\n"
			"{\n"
				"if( confirm(\"Are you sure?\"))\n"
				"{\n"
					"myForm.Action.value=\"1\";\n"
					"myForm.submit();\n"
				"}\n"
			"}\n");
		fnPrintf( m_pHRequest, "// End hiding here -->\n</script>\n");
		
		printButton( "Execute", BT_Button, NULL, NULL, "ONCLICK='confirmAction(document.dbop)'");
	}
	else
	{
		fnPrintf( m_pHRequest, "<script><!-- Hide script from old browsers\n");
		fnPrintf( m_pHRequest, "function doAction(myForm)\n"
			"{\n"
				"myForm.Action.value=\"1\";\n"
				"myForm.submit();\n"
			"}\n");
		fnPrintf( m_pHRequest, "// End hiding here -->\n</script>\n");

		printButton( "Execute", BT_Button, NULL, NULL, "ONCLICK='doAction(document.dbop)'");
	}

	printTableDataEnd();
	printTableRowEnd();

	// End the table

	printTableEnd();

	// End the form

	printEndInputForm();

	// Separator

	fnPrintf( m_pHRequest, "<BR>\n");

	// List the session's open databases

	printSessionDatabaseList( pFlmSession);

	// Separator

	fnPrintf( m_pHRequest, "<BR>\n");

	// List the global open databases

	printGlobalDatabaseList();

	// Close the document

	printDocEnd();

Exit:

	fnEmit();
	if( pucPathBuf)
	{
		f_free( &pucPathBuf);
	}
	return( FERR_OK);

ReportErrorExit:

	printErrorPage( rc);
	goto Exit;
}

/****************************************************************************
Desc:	Print an option for an open database
****************************************************************************/
void F_DatabasePage::printDbOption(
	FLMBOOL			bOpenPopup,
	const char *	pszMenuOption,
	const char *	pszPage,
	const char *	pszUrlOption1,
	const char *	pszDbKey)
{
	fnPrintf( m_pHRequest, "<option value=\"");
	if (bOpenPopup)
	{
		fnPrintf( m_pHRequest, "javascript:openPopup('");
	}
	fnPrintf( m_pHRequest, "%s/%s?dbhandle=%s",
									  m_pszURLString, pszPage, pszDbKey);
	if (pszUrlOption1)
	{
		fnPrintf( m_pHRequest, "&%s", pszUrlOption1);
	}
	if (bOpenPopup)
	{
		fnPrintf( m_pHRequest, "', 900, 600, 50, 50)");
	}
	fnPrintf( m_pHRequest, "\">%s</option>\n", pszMenuOption);
}

/****************************************************************************
Desc:
****************************************************************************/
void F_DatabasePage::printSessionDatabaseList(
	F_Session *			pFlmSession)
{
	HFDB				hTmpDb;
	FLMBOOL			bHighlight;
	char				szPath[ F_PATH_MAX_SIZE];
	F_SessionDb *	pSessionDb;
	FLMBOOL			bChecked;
	FLMUINT			uiTransType;
	FLOCK_TYPE		lockType;
	FLMBOOL			bImplicit;
	FLMBOOL			bAllowLock;
	FLMBOOL			bAllowUnlock;
	char *			pszDbKey;
	char				szDbOption [80];

	// Table

	printTableStart( "Session Databases", 4);

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Path", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printColumnHeading( "Transaction", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printColumnHeading( "Lock Type", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printColumnHeading( "Action", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printTableRowEnd();

	bChecked = FALSE;
	bHighlight = TRUE;
	pSessionDb = NULL;

	while( RC_OK( pFlmSession->getNextDb( &pSessionDb)))
	{
		hTmpDb = pSessionDb->getDbHandle();

		printTableRowStart( bHighlight);
		bHighlight = !bHighlight;

		// Path

		printTableDataStart( TRUE, JUSTIFY_LEFT, 25);
		if( RC_OK( FlmDbGetConfig( hTmpDb, FDB_GET_PATH, &szPath[ 0])))
		{
			fnPrintf( m_pHRequest, "%s", szPath);
		}
		else
		{
			printTableDataEmpty();
		}
		printTableDataEnd();

		// Transaction

		printTableDataStart( TRUE, JUSTIFY_LEFT, 25);
		if( RC_BAD( FlmDbGetTransType( hTmpDb, &uiTransType)))
		{
			uiTransType = FLM_NO_TRANS;
		}

		if( uiTransType == FLM_UPDATE_TRANS ||
			uiTransType == FLM_READ_TRANS)
		{
			fnPrintf( m_pHRequest, "%s (", uiTransType == FLM_UPDATE_TRANS ? "Update" : "Read");
			fnPrintf( m_pHRequest, "<A HREF=%s/database?operation=transend?endtype=1?dbhandle=%s",
				m_pszURLString, (char *)pSessionDb->getKey());
			fnPrintf( m_pHRequest, ">");
			fnPrintf( m_pHRequest, "Commit</A>\n");
			fnPrintf( m_pHRequest, ", ");
			fnPrintf( m_pHRequest, "<A HREF=%s/database?operation=transend?endtype=0?dbhandle=%s",
				m_pszURLString, (char *)pSessionDb->getKey());
			fnPrintf( m_pHRequest, ">");
			fnPrintf( m_pHRequest, "Abort</A>\n");
			fnPrintf( m_pHRequest, ")");
		}
		else
		{
			fnPrintf( m_pHRequest, "None (");
			fnPrintf( m_pHRequest, "<A HREF=%s/database?operation=transbegin?transtype=%u?dbhandle=%s",
				m_pszURLString, (unsigned)FLM_UPDATE_TRANS, (char *)pSessionDb->getKey());
			fnPrintf( m_pHRequest, ">");
			fnPrintf( m_pHRequest, "Update</A>\n");
			fnPrintf( m_pHRequest, ", ");
			fnPrintf( m_pHRequest, "<A HREF=%s/database?operation=transbegin?transtype=%u?dbhandle=%s",
				m_pszURLString, (unsigned)FLM_READ_TRANS, (char *)pSessionDb->getKey());
			fnPrintf( m_pHRequest, ">");
			fnPrintf( m_pHRequest, "Read</A>\n");
			fnPrintf( m_pHRequest, ")");
		}
		printTableDataEnd();

		// Lock Type

		(void)FlmDbGetLockType( hTmpDb, &lockType, &bImplicit);
		printTableDataStart( TRUE, JUSTIFY_LEFT, 25);
		switch( lockType)
		{
			case FLM_LOCK_NONE:
				fnPrintf( m_pHRequest, "None");
				break;
			case FLM_LOCK_EXCLUSIVE:
				fnPrintf( m_pHRequest, "Exclusive");
				break;
			case FLM_LOCK_SHARED:
				fnPrintf( m_pHRequest, "Shared");
				break;
			default:
				fnPrintf( m_pHRequest, "Unknown");
		}

		if( bImplicit)
		{
			fnPrintf( m_pHRequest, " (Implicit)");
		}
		printTableDataEnd();

		// Action

		printTableDataStart( TRUE, JUSTIFY_LEFT, 25);
		fnPrintf( m_pHRequest, "<form name=\"dbaction\">\n");
		fnPrintf( m_pHRequest, "<select name=\"select1\" size=1"
									  " onChange=\"if((this.options[this.selectedIndex].value) != 'none')\n"
									  " {\n"
									  " document.location = (this.options[this.selectedIndex].value)\n"
									  " }\n"
									  " (this.selectedIndex) = 0\">\n");
		fnPrintf( m_pHRequest, "<option value=none>Select Option");
		printSpaces( 30);
		fnPrintf( m_pHRequest, "</option>\n");
		pszDbKey = (char *)pSessionDb->getKey();
		printDbOption( FALSE, "Close", "database", "operation=close", pszDbKey);
		printDbOption( TRUE, "Index Manager", "index", NULL, pszDbKey);
		printDbOption( TRUE, "Record Manager (XML)", "recordmgr", NULL, pszDbKey);
		printDbOption( TRUE, "Record Manager (Traditional)", "ProcessRecord",
			"ReadOnly=TRUE&DRN=0&container=32001&Action=Retrieve", pszDbKey);
		printDbOption( TRUE, "Configuration", "dbconfig", NULL, pszDbKey);
		
		if( uiTransType == FLM_NO_TRANS)
		{
			f_sprintf( szDbOption, "operation=transbegin&transtype=%u",
				(unsigned)FLM_READ_TRANS);
			printDbOption( FALSE, "Start a Read Transaction", "database", szDbOption,
				pszDbKey);
			f_sprintf( szDbOption, "operation=transbegin&transtype=%u",
				(unsigned)FLM_UPDATE_TRANS);
			printDbOption( FALSE, "Start an Update Transaction", "database", szDbOption,
				pszDbKey);
		}
		else
		{
			printDbOption( FALSE, "Abort Transaction", "database",
				"operation=transend&endtype=0", pszDbKey);
			printDbOption( FALSE, "Commit Transaction", "database",
				"operation=transend&endtype=1", pszDbKey);
		}

		printDbOption( FALSE, "Force Checkpoint", "database",
				"operation=checkpoint", pszDbKey);

		printDbOption( FALSE, "Free Unused Blocks (Reduce)", "database",
				"operation=reduce", pszDbKey);

		bAllowLock = FALSE;
		bAllowUnlock = FALSE;
		if( RC_OK( FlmDbGetLockType( hTmpDb, &lockType, &bImplicit)))
		{
			if( lockType != FLM_LOCK_NONE && !bImplicit)
			{
				bAllowUnlock = TRUE;
			}
			else if( lockType == FLM_LOCK_NONE)
			{
				bAllowLock = TRUE;
			}
		}

		if( bAllowLock)
		{
			printDbOption( FALSE, "Lock", "database",
				"operation=lock", pszDbKey);
		}

		if( bAllowUnlock)
		{
			printDbOption( FALSE, "Unlock", "database",
				"operation=unlock", pszDbKey);
		}

		printDbOption( FALSE, "Run a Query", "select", NULL, pszDbKey);
		printDbOption( FALSE, "Check Database", "checkdb", NULL, pszDbKey);
		printDbOption( FALSE, "List Index Keys", "indexlist", NULL, pszDbKey);
		printDbOption( TRUE, "View File Log Headers", "LogHdr", NULL, pszDbKey);

		fnPrintf( m_pHRequest, "</select>\n");
		fnPrintf( m_pHRequest, "</form>\n");
		printTableDataEnd();

		printTableRowEnd();
	}

	// Close the table

	printTableEnd();
}

/****************************************************************************
Desc:
****************************************************************************/
void F_DatabasePage::printGlobalDatabaseList( void)
{
	FLMBOOL			bHighlight;
	FLMUINT			uiLoop;
	FBUCKET *		pBucket;
	FFILE *			pFile;

	// Table

	printTableStart( "Global Databases", 4);

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Path", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printColumnHeading( "External Opens", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printColumnHeading( "Internal Opens", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printColumnHeading( "Action", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 25);
	printTableRowEnd();

	f_mutexLock( gv_FlmSysData.hShareMutex);

	bHighlight = TRUE;
	pBucket = gv_FlmSysData.pFileHashTbl;
	for( uiLoop = 0; uiLoop < FILE_HASH_ENTRIES; uiLoop++)
	{
		if( (pBucket = &gv_FlmSysData.pFileHashTbl[ uiLoop]) != NULL)
		{
			pFile = (FFILE *)pBucket->pFirstInBucket;
			while( pFile)
			{
				// Start a new row

				printTableRowStart( bHighlight);
				bHighlight = !bHighlight;

				// Path

				printTableDataStart( TRUE, JUSTIFY_LEFT, 25);
				fnPrintf( m_pHRequest, "%s", pFile->pszDbPath);
				printTableDataEnd();

				// External open count

				printTableDataStart( TRUE, JUSTIFY_LEFT, 25);
				fnPrintf( m_pHRequest, "%u", (unsigned)pFile->uiUseCount);
				printTableDataEnd();

				// Internal open count

				printTableDataStart( TRUE, JUSTIFY_LEFT, 25);
				fnPrintf( m_pHRequest, "%u", (unsigned)pFile->uiInternalUseCount);
				printTableDataEnd();

				// Action

				printTableDataStart( TRUE, JUSTIFY_LEFT, 25);

				fnPrintf( m_pHRequest, "<form name=\"globaldbaction\">\n");
				fnPrintf( m_pHRequest, "<select name=\"select1\" size=1"
											  " onChange=\"if((this.options[this.selectedIndex].value) != 'none')\n"
											  " {\n"
											  " document.location = (this.options[this.selectedIndex].value)\n"
											  " }\n"
											  " (this.selectedIndex) = 0\">\n");
				fnPrintf( m_pHRequest, "<option value=none>Select Option");
				printSpaces( 30);
				fnPrintf( m_pHRequest, "</option>\n");

				// Open

				fnPrintf( m_pHRequest, "<option value=\"%s/database?operation=open?path=", m_pszURLString);
				printEncodedString( pFile->pszDbPath, URL_PATH_ENCODING, FALSE);
				fnPrintf( m_pHRequest, "\">");
				fnPrintf( m_pHRequest, "Open</option>\n");

				// Backup

				fnPrintf( m_pHRequest, "<option value=\"%s/dbbackup/", m_pszURLString);
				printEncodedString( pFile->pszDbPath, URL_PATH_ENCODING, FALSE);
				fnPrintf( m_pHRequest, "\">");
				fnPrintf( m_pHRequest, "Backup</option>\n");
				fnPrintf( m_pHRequest, "</select>\n");

				// End the action selection list

				fnPrintf( m_pHRequest, "</select>\n");
				fnPrintf( m_pHRequest, "</form>\n");

				// End the row

				printTableRowEnd();

				// Get the next FFILE

				pFile = pFile->pNext;
			}
		}
	}

	f_mutexUnlock( gv_FlmSysData.hShareMutex);


	// Close the table

	printTableEnd();
}

/****************************************************************************
Desc:
****************************************************************************/
RCODE F_RecordMgrPage::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	RCODE					rc = FERR_OK;
	char					szOperation[ 256];
	char					szTmp[ 128];
	char *				pTmp;
	FLMUINT				uiDrn;
	FLMUINT				uiContainer;
	FLMUINT				uiFlags;
	HFDB					hDb = HFDB_NULL;
	char *				pszXmlInRec = NULL;
	char *				pszXmlOutRec = NULL;
	FlmRecord *			pRec = NULL;
	FlmRecord *			pInRec = NULL;
	F_Session *			pFlmSession = m_pFlmSession;
	F_NameTable *		pNameTable = NULL;
	char					szDbKey[ F_SESSION_DB_KEY_LEN];
	FLMBOOL				bHighlight;
	FLMBOOL				bExecute = FALSE;
	FLMBOOL				bRetrieveSelected = FALSE;
	FLMBOOL				bAddSelected = FALSE;
	FLMBOOL				bUpdateSelected = FALSE;
	FLMBOOL				bDeleteSelected = FALSE;
	FLMBOOL				bReserveDrnSelected = FALSE;
	POOL					pool;

	// Initialize a pool for XML parsing

	GedPoolInit( &pool, 1024);

	// Check the session

	if( !pFlmSession)
	{
		rc = RC_SET( m_uiSessionRC);
		goto ReportErrorExit;
	}

	// Get the database operation

	szOperation[ 0] = 0;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
			"operation", sizeof( szOperation), szOperation)))
	{
		pTmp = &szOperation[ 0];
		getFormValueByName( "operation", 
			&pTmp, sizeof( szOperation), NULL);
	}

	if( szOperation[ 0])
	{
		fcsDecodeHttpString( szOperation);
	}

	// Execute

	szTmp[ 0] = '\0';
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"execute", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "execute", 
			&pTmp, sizeof( szTmp), NULL);
	}

	bExecute = (FLMBOOL)f_atoud( szTmp);

	// DB handle

	if( RC_BAD( rc = getDatabaseHandleParam( uiNumParams, 
		ppszParams, pFlmSession, &hDb, szDbKey)))
	{
		goto ReportErrorExit;
	}

	// Name table

	if( RC_BAD( rc = pFlmSession->getNameTable( hDb, &pNameTable)))
	{
		goto ReportErrorExit;
	}

	// Drn

	szTmp[ 0] = '\0';
	uiDrn = 0;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"drn", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "drn", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		uiDrn = f_atoud( szTmp);
	}

	// Container

	szTmp[ 0] = '\0';
	uiContainer = 0;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"container", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "container", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		uiContainer = f_atoud( szTmp);
	}

	// Flags

	szTmp[ 0] = '\0';
	uiFlags = 0;
	if( RC_BAD( ExtractParameter( uiNumParams, ppszParams, 
		"flags", sizeof( szTmp), szTmp)))
	{
		pTmp = &szTmp[ 0];
		getFormValueByName( "flags", 
			&pTmp, sizeof( szTmp), NULL);
	}

	if( szTmp[ 0])
	{
		uiFlags = f_atoud( szTmp);
	}

	// XML record

	if( RC_OK( getFormValueByName( "record", 
		&pszXmlInRec, 0, NULL)))
	{
		fcsDecodeHttpString( pszXmlInRec);
	}

	if( pszXmlInRec && *pszXmlInRec && hDb != HFDB_NULL)
	{
		FCS_BUFISTM	bufIStream( (FLMBYTE *)pszXmlInRec, f_strlen( pszXmlInRec));
		(void)pFlmSession->getXmlImport()->importDocument( 
			hDb, pNameTable, &bufIStream, TRUE, &pInRec);
	}

	if( hDb == HFDB_NULL)
	{
		rc = RC_SET( FERR_BAD_HDL);
		goto ReportErrorExit;
	}

	// Perform the requested operation

	if( f_stricmp( szOperation, "none") == 0)
	{
		bExecute = FALSE;
	}
	else if( f_stricmp( szOperation, "retrieve") == 0)
	{
		bRetrieveSelected = TRUE;
		if( bExecute)
		{
			rc = FlmRecordRetrieve( hDb, uiContainer, uiDrn, 
				uiFlags, &pRec, &uiDrn);

			if( pInRec)
			{
				pInRec->Release();
				pInRec = NULL;
			}

			if( pszXmlInRec)
			{
				f_free( &pszXmlInRec);
			}
		}
	}
	else if( f_stricmp( szOperation, "update") == 0)
	{
		bUpdateSelected = TRUE;
		if( bExecute)
		{
			if( !pInRec)
			{
				// The parser was unable to create a valid
				// FLAIM record from the XML data

				rc = RC_SET( FERR_SYNTAX);
			}
			else
			{
				rc = FlmRecordModify( hDb, uiContainer, uiDrn, pInRec, 
					FLM_AUTO_TRANS | 5);
			}
		}
	}
	else if( f_stricmp( szOperation, "add") == 0)
	{
		bAddSelected = TRUE;
		if( bExecute)
		{
			if( !pInRec)
			{
				// The parser was unable to create a valid
				// FLAIM record from the XML data

				rc = RC_SET( FERR_SYNTAX);
			}
			else
			{
				rc = FlmRecordAdd( hDb, uiContainer, &uiDrn, pInRec, 
					FLM_AUTO_TRANS | 5);
			}
		}
	}
	else if( f_stricmp( szOperation, "delete") == 0)
	{
		bDeleteSelected = TRUE;
		if( bExecute)
		{
			rc = FlmRecordDelete( hDb, uiContainer, uiDrn, 0);
			if( pInRec)
			{
				pInRec->Release();
				pInRec = NULL;
			}
		}
	}
	else if( f_stricmp( szOperation, "reservenextdrn") == 0)
	{
		bReserveDrnSelected = TRUE;
		if( bExecute)
		{
			rc = FlmReserveNextDrn( hDb, uiContainer, &uiDrn);
		}
	}
	else if( szOperation[ 0] != '\0')
	{
		rc = RC_SET( FERR_ILLEGAL_OP);
		goto ReportErrorExit;
	}

	// Start document

	printDocStart( "Record Manager", FALSE);

	// Form

	fnPrintf( m_pHRequest, "<form name=\"recordManager\" type=\"submit\" "
	  "method=\"post\" action=\"%s/recordmgr\">\n", m_pszURLString);

	fnPrintf( m_pHRequest, "<input name=\"dbhandle\" type=\"hidden\""
								  " value=\"%s\"></input>\n", szDbKey);

	fnPrintf( m_pHRequest, "<input name=\"execute\" type=\"hidden\""
								  " value=\"0\"></input>\n");

	fnPrintf( m_pHRequest,
		"<SCRIPT>\n"
		"function setExecute()\n"
		"{\n"
			"recordManager.execute.value = \"1\";\n"
			"recordManager.submit();\n"
		"}\n"
		"</SCRIPT>\n");

	// Table

	if( bExecute)
	{
		f_sprintf( (char *)szTmp, 
			"Record Manager (Return Code = 0x%04X, %s)", 
			(unsigned)rc, FlmErrorString( rc));
	}
	else
	{
		f_sprintf( (char *)szTmp, "Record Manager");
	}
	printTableStart( (char *)szTmp, 2);

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Parameter", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 20);
	printColumnHeading( "Value", JUSTIFY_LEFT, NULL, 1, 1, TRUE, 80);
	printTableRowEnd();
	bHighlight = TRUE;

	// Operation

	printTableRowStart( bHighlight);
	bHighlight = !bHighlight;
	printTableDataStart( TRUE, JUSTIFY_LEFT);
	fnPrintf( m_pHRequest, "Operation");
	printTableDataEnd();
	printTableDataStart( TRUE, JUSTIFY_LEFT);
	fnPrintf( m_pHRequest, "<select name=\"operation\" size=1 onChange=\"submit()\">\n");

	if( bRetrieveSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"retrieve\">Retrieve Record</option>\n");
	}
	else if( bAddSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"add\">Add Record</option>\n");
	}
	else if( bUpdateSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"update\">Update Record</option>\n");
	}
	else if( bDeleteSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"delete\">Delete Record</option>\n");
	}
	else if( bReserveDrnSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"reservenextdrn\">Reserve Next DRN</option>\n");
	}
	else
	{
		fnPrintf( m_pHRequest, "<option value=\"none\">Select Operation</option>\n");
	}

	if( !bRetrieveSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"retrieve\">Retrieve Record</option>\n");
	}

	if( !bAddSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"add\">Add Record</option>\n");
	}

	if( !bUpdateSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"update\">Update Record</option>\n");
	}

	if( !bDeleteSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"delete\">Delete Record</option>\n");
	}

	if( !bReserveDrnSelected)
	{
		fnPrintf( m_pHRequest, "<option value=\"reservenextdrn\">Reserve Next DRN</option>\n");
	}

	fnPrintf( m_pHRequest, "</select>\n");
	printSpaces( 2);
	printButton( "Execute", BT_Button, NULL, NULL, "onClick=\"setExecute()\"");
	printTableDataEnd();
	printTableRowEnd();

	// Flags

	if( bRetrieveSelected)
	{
		printTableRowStart( bHighlight);
		bHighlight = !bHighlight;
		printTableDataStart( TRUE, JUSTIFY_LEFT);
		fnPrintf( m_pHRequest, "Flags");
		printTableDataEnd();
		printTableDataStart( TRUE, JUSTIFY_LEFT);
		printRetrievalFlagsPulldown( uiFlags);
		printTableDataEnd();
		printTableRowEnd();
	}

	// DRN

	printTableRowStart( bHighlight);
	bHighlight = !bHighlight;
	printTableDataStart( TRUE, JUSTIFY_LEFT);
	fnPrintf( m_pHRequest, "DRN");
	printTableDataEnd();
	printTableDataStart( TRUE, JUSTIFY_LEFT);
	fnPrintf( m_pHRequest, "<INPUT type=\"text\" size=\"20\" maxlength=\"20\""
								  " name=\"drn\" value=\"%u\"></INPUT>\n", (unsigned)uiDrn);
	printTableDataEnd();
	printTableRowEnd();

	// Container

	printTableRowStart( bHighlight);
	bHighlight = !bHighlight;
	printTableDataStart( TRUE, JUSTIFY_LEFT);
	fnPrintf( m_pHRequest, "Container");
	printTableDataEnd();
	printTableDataStart();
	printContainerPulldown( pNameTable, uiContainer);
	printTableDataEnd();
	printTableRowEnd();

	// Record

	if( pRec || pInRec)
	{
		if( !pRec)
		{
			pRec = pInRec;
			pInRec = NULL;
		}

		if( RC_BAD( rc = pFlmSession->getXmlExport()->exportRecord( 
			pNameTable, pRec, 0, 3, &pool, &pszXmlOutRec, NULL)))
		{
			goto Exit;
		}
	}

	printTableRowStart( bHighlight);
	bHighlight = !bHighlight;
	printTableDataStart( TRUE, JUSTIFY_LEFT);
	fnPrintf( m_pHRequest, "Record");
	printTableDataEnd();
	printTableDataStart();
	fnPrintf( m_pHRequest, "<textarea name=\"record\" wrap=off rows=12 cols=80>");
	if( pszXmlOutRec)
	{
		printEncodedString( pszXmlOutRec, HTML_ENCODING);
	}
	else if( pszXmlInRec)
	{
		printEncodedString( pszXmlInRec, HTML_ENCODING);
	}
	fnPrintf( m_pHRequest, "</textarea>\n");
	printTableDataEnd();
	printTableRowEnd();

	// Close the table

	printTableEnd();

	// Close the form

	fnPrintf( m_pHRequest, "</form>\n");

	// Close the document

	printDocEnd();

Exit:

	fnEmit();

	if( pRec)
	{
		pRec->Release();
	}

	if( pInRec)
	{
		pInRec->Release();
	}

	if( pszXmlInRec)
	{
		f_free( &pszXmlInRec);
	}

	GedPoolFree( &pool);
	return( FERR_OK);

ReportErrorExit:

	printErrorPage( rc);
	goto Exit;
}

/****************************************************************************
Desc:	Print an option for a selection list.
****************************************************************************/
void F_WebPage::printSelectOption(
	FLMUINT			uiSelectedValue,
	FLMUINT			uiOptionValue,
	const char *	pszOptionName,
	FLMBOOL			bPrintOptionVal)
{
	fnPrintf( m_pHRequest, "<option");
	if (uiOptionValue == uiSelectedValue)
	{
		fnPrintf( m_pHRequest, " selected");
	}
	fnPrintf( m_pHRequest, " value=\"%u\">", (unsigned)uiOptionValue);
	printEncodedString( pszOptionName, HTML_ENCODING);

	if( bPrintOptionVal)
	{
		fnPrintf( m_pHRequest, " (%u)", (unsigned)uiOptionValue);
	}
		
	fnPrintf( m_pHRequest, "</option>\n");
}

/****************************************************************************
Desc:	Print a selection list for containers using the supplied name table.
****************************************************************************/
void F_WebPage::printContainerPulldown(
	F_NameTable *	pNameTable,
	FLMUINT			uiSelectedContainer)
{
	char				szNameBuf[ 128];
	FLMUINT			uiId;
	FLMUINT			uiType;
	FLMUINT			uiNextPos;

	fnPrintf( m_pHRequest, "<select name=\"container\" size=1>\n");

	// Output standard containers

	printSelectOption( uiSelectedContainer, FLM_DATA_CONTAINER, "Data");
	printSelectOption( uiSelectedContainer, FLM_DICT_CONTAINER, "Dictionary");
	printSelectOption( uiSelectedContainer, FLM_TRACKER_CONTAINER, "Tracker");

	if( !pNameTable)
	{
		goto Exit;
	}

	// Build the list from the passed-in name table

	uiNextPos = 0;
	while( pNameTable->getNextTagNameOrder( &uiNextPos, NULL, 
		szNameBuf, sizeof( szNameBuf), &uiId, &uiType))
	{
		if( uiType != FLM_CONTAINER_TAG)
		{
			continue;
		}
		printSelectOption( uiSelectedContainer, uiId, (char *)szNameBuf);
	}

Exit:

	fnPrintf( m_pHRequest, "</select>\n");
	return;
}

/****************************************************************************
Desc:	Print a selection list for fields using the supplied name table.
****************************************************************************/
void F_WebPage::printFieldPulldown(
	F_NameTable *	pNameTable,
	FLMUINT			uiSelectedField
	)
{
	FLMUINT			uiNextPos;
	char				szNameBuf[ 128];
	FLMUINT			uiId;
	FLMUINT			uiType;

	fnPrintf( m_pHRequest, "<select name=\"fieldlist\">\n");

	if( !pNameTable)
	{
		goto Exit;
	}

	uiNextPos = 0;
	while( pNameTable->getNextTagNameOrder( &uiNextPos, NULL, 
		szNameBuf, sizeof( szNameBuf), &uiId, &uiType))
	{
		if( uiType != FLM_FIELD_TAG)
		{
			continue;
		}

		printSelectOption( uiSelectedField, uiId, (char *)szNameBuf);
	}

Exit:

	fnPrintf( m_pHRequest, "</select>\n");
}

/****************************************************************************
Desc:	Print a selection list for indexes using the supplied name table.
****************************************************************************/
void F_WebPage::printIndexPulldown(
	F_NameTable *	pNameTable,
	FLMUINT			uiSelectedIndex,
	FLMBOOL			bIncludeNoIndex,
	FLMBOOL			bIncludeChooseBestIndex,
	FLMBOOL			bPrintSelect,
	const char *	pszExtra)
{
	FLMUINT			uiNextPos;
	char				szNameBuf[ 128];
	FLMUINT			uiId;
	FLMUINT			uiType;

	fnPrintf( m_pHRequest, "<select name=\"index\" %s>\n",
		(char *)(pszExtra ? pszExtra : (char *)""));

	if (bPrintSelect)
	{
		uiSelectedIndex = 0;
		printSelectOption( 0, 0,
			"Select An Index", FALSE);
	}
	if (bIncludeChooseBestIndex)
	{
		printSelectOption( uiSelectedIndex, FLM_SELECT_INDEX,
			"Let DB Optimize");
	}
	if (bIncludeNoIndex)
	{
		printSelectOption( uiSelectedIndex, 0, "No Index");
	}

	printSelectOption( uiSelectedIndex, FLM_DICT_INDEX, "Dictionary");

	if( !pNameTable)
	{
		goto Exit;
	}

	uiNextPos = 0;
	while( pNameTable->getNextTagNameOrder( &uiNextPos, NULL, 
		szNameBuf, sizeof( szNameBuf), &uiId, &uiType))
	{
		if( uiType != FLM_INDEX_TAG)
		{
			continue;
		}

		printSelectOption( uiSelectedIndex, uiId, (char *)szNameBuf);
	}

Exit:

	fnPrintf( m_pHRequest, "</select>\n");
}

/****************************************************************************
Desc: 
****************************************************************************/
RCODE F_DatabaseConfigPage::display(
	FLMUINT			uiNumParams,
	const char ** 	ppszParams)
{
	RCODE				rc = FERR_OK;
	HFDB				hDb;
	char				szDbKey[ F_SESSION_DB_KEY_LEN];
	char				szTmp[ 128];
	FLMBOOL			bExecuted = FALSE;
	FLMBOOL			bHighlight;

	// DB handle

	if( RC_BAD( rc = getDatabaseHandleParam( uiNumParams, ppszParams, 
		m_pFlmSession, &hDb, szDbKey)))
	{
		if( rc == FERR_NOT_FOUND)
		{
			rc = RC_SET( FERR_BAD_HDL);
		}
		goto Exit;
	}

	// Config parameters

	if( RC_OK( rc))
	{
		f_sprintf( (char *)szTmp, "%u", FDB_RFL_KEEP_FILES);
		if( RC_OK( ExtractParameter( uiNumParams, ppszParams, szTmp, sizeof( szTmp), szTmp)))
		{
			FLMBOOL	bFlag = f_atoi( szTmp) ? TRUE : FALSE;
			rc = FlmDbConfig( hDb, FDB_RFL_KEEP_FILES, (void *)bFlag, NULL);
			bExecuted = TRUE;
		}
	}

	if( RC_OK( rc))
	{
		f_sprintf( (char *)szTmp, "%u", FDB_AUTO_TURN_OFF_KEEP_RFL);
		if( RC_OK( ExtractParameter( uiNumParams, ppszParams, szTmp, sizeof( szTmp), szTmp)))
		{
			FLMBOOL	bFlag = f_atoi( szTmp) ? TRUE : FALSE;
			rc = FlmDbConfig( hDb, FDB_AUTO_TURN_OFF_KEEP_RFL, (void *)bFlag, NULL);
			bExecuted = TRUE;
		}
	}

	if( RC_OK( rc))
	{
		f_sprintf( (char *)szTmp, "%u", FDB_KEEP_ABORTED_TRANS_IN_RFL);
		if( RC_OK( ExtractParameter( uiNumParams, ppszParams, szTmp, sizeof( szTmp), szTmp)))
		{
			FLMBOOL	bFlag = f_atoi( szTmp) ? TRUE : FALSE;
			rc = FlmDbConfig( hDb, FDB_KEEP_ABORTED_TRANS_IN_RFL, (void *)bFlag, NULL);
			bExecuted = TRUE;
		}
	}

	if( RC_OK( rc))
	{
		f_sprintf( (char *)szTmp, "%u", FDB_FILE_EXTEND_SIZE);
		if( RC_OK( ExtractParameter( uiNumParams, ppszParams, szTmp, sizeof( szTmp), szTmp)))
		{
			FLMUINT	uiValue = f_atoud( szTmp);
			rc = FlmDbConfig( hDb, FDB_FILE_EXTEND_SIZE, (void *)uiValue, NULL);
			bExecuted = TRUE;
		}
	}

	// Document

	printDocStart( (char *)"Database Configuration", FALSE);

	// Table

	if( bExecuted)
	{
		f_sprintf( (char *)szTmp, 
			"Database Configuration (Return Code = 0x%04X, %s)", 
			(unsigned)rc, FlmErrorString( rc));
	}
	else
	{
		f_sprintf( (char *)szTmp, "Database Configuration");
	}
	printTableStart( (char *)szTmp, 2);

	// Table column headers

	printTableRowStart();
	printColumnHeading( "Option");
	printColumnHeading( "Value");
	printTableRowEnd();

	bHighlight = FALSE;
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_PATH, 
		"Database Path");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_RFL_DIR, 
		"RFL Directory");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_SIZES, 
		"Database Size");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_VERSION, 
		"Version");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_SERIAL_NUMBER, 
		"Serial Number");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_BLKSIZ, 
		"Block Size");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_DEFAULT_LANG, 
		"Default Language");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_TRANS_ID, 
		"Current Transaction ID");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_RFL_FILE_NUM, 
		"RFL File Number");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_RFL_HIGHEST_NU, 
		"RFL Highest Unused File");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_LAST_BACKUP_TRANS_ID, 
		"Last Backup Transaction ID");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_BLOCKS_CHANGED_SINCE_BACKUP, 
		"Blocks Changed Since Last Backup");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_NEXT_INC_BACKUP_SEQ_NUM, 
		"Next Incremental Backup Sequence Number");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_DICT_SEQ_NUM, 
		"Dictionary Sequence Number");
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_FILE_EXTEND_SIZE, 
		"File Extend Size", FDB_FILE_EXTEND_SIZE);
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_RFL_KEEP_FLAG, 
		"Keep RFL Files", FDB_RFL_KEEP_FILES);
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_KEEP_ABORTED_TRANS_IN_RFL_FLAG, 
		"Keep Aborted Transactions in RFL", FDB_KEEP_ABORTED_TRANS_IN_RFL);
	outputValue( &bHighlight, hDb, szDbKey, FDB_GET_AUTO_TURN_OFF_KEEP_RFL_FLAG, 
		"Auto Disable of RFL Keep Flag", FDB_AUTO_TURN_OFF_KEEP_RFL);

	printTableEnd();
	printDocEnd();

Exit:

	fnEmit();
	return( FERR_OK);
}

/****************************************************************************
Desc:
****************************************************************************/
void F_DatabaseConfigPage::outputValue(
	FLMBOOL *		pbHighlight,
	HFDB				hDb,
	const char *	szDbKey,
  	FLMUINT			uiType,
	const char *	pszParamDescription,
	FLMUINT			uiConfigVal)
{
	FLMUINT		uiValue1;
	FLMUINT64	ui64Value1;
	FLMUINT64	ui64Value2;
	FLMUINT64	ui64Value3;
	FLMBOOL		bFlag;
	char			szValue[ F_PATH_MAX_SIZE];
	FLMBYTE		ucSerialNum[ F_SERIAL_NUM_SIZE];
	FLMUINT		uiLoop;
	RCODE			rc = FERR_OK;

	printTableRowStart( *pbHighlight = !(*pbHighlight));
	fnPrintf( m_pHRequest, TD_s, pszParamDescription);

	switch( (eDbGetConfigType)uiType)
	{
		case FDB_GET_DEFAULT_LANG:
			if( RC_OK( rc = FlmDbGetConfig( hDb, (eDbGetConfigType)uiType, &uiValue1)))
			{
				FlmGetLanguage( uiValue1, (char *)szValue);
				fnPrintf( m_pHRequest, TD_s, szValue);
			}
			break;

		case FDB_GET_VERSION:
		case FDB_GET_BLKSIZ:
		case FDB_GET_TRANS_ID:
		case FDB_GET_RFL_FILE_NUM:
		case FDB_GET_RFL_HIGHEST_NU:
		case FDB_GET_LAST_BACKUP_TRANS_ID:
		case FDB_GET_BLOCKS_CHANGED_SINCE_BACKUP:
		case FDB_GET_FILE_EXTEND_SIZE:
		case FDB_GET_NEXT_INC_BACKUP_SEQ_NUM:
		case FDB_GET_DICT_SEQ_NUM:
			if( RC_OK( rc = FlmDbGetConfig( hDb, (eDbGetConfigType)uiType, &uiValue1)))
			{
				printTableDataStart();
				if( uiConfigVal)
				{
					fnPrintf( m_pHRequest, "<form type=\"submit\" "
						"method=\"get\" action=\"%s/dbconfig\">\n",
						 m_pszURLString);
					fnPrintf( m_pHRequest, "<input name=\"dbhandle\" type=\"hidden\""
												  " value=\"%s\"></input>\n", szDbKey);
					fnPrintf( m_pHRequest, "<INPUT type=\"text\" size=\"8\" "
													"maxlength=\"10\" name=\"%u\" value=\"%u\"></INPUT>\n",
													(unsigned)uiConfigVal, (unsigned)uiValue1);
					printButton( "Submit", BT_Submit);
					fnPrintf( m_pHRequest, "</form>\n");
				}
				else
				{
					fnPrintf( m_pHRequest, "%u", (unsigned)uiValue1);
				}
				printTableDataEnd();
			}
			break;

		case FDB_GET_SIZES:
			if( RC_OK( rc = FlmDbGetConfig( hDb, (eDbGetConfigType)uiType, 
				&ui64Value1, &ui64Value2, &ui64Value3)))
			{
				printTableDataStart();
				printTableStart( NULL, 2);

				printTableRowStart();
				printTableDataStart();
				fnPrintf( m_pHRequest, "Database");
				printTableDataEnd();
				printCommaNum( ui64Value1);
				printTableRowEnd();

				printTableRowStart();
				printTableDataStart();
				fnPrintf( m_pHRequest, "Rollback");
				printTableDataEnd();
				printCommaNum( ui64Value2);
				printTableRowEnd();

				printTableRowStart();
				printTableDataStart();
				fnPrintf( m_pHRequest, "RFL");
				printTableDataEnd();
				printCommaNum( ui64Value3);
				printTableRowEnd();

				printTableRowStart();
				printTableDataStart();
				fnPrintf( m_pHRequest, "Total");
				printTableDataEnd();
				printCommaNum( ui64Value1 + ui64Value2 + ui64Value3);
				printTableRowEnd();

				printTableEnd();
				printTableDataEnd();
			}
			break;

		case FDB_GET_PATH:
		case FDB_GET_RFL_DIR:
			if( RC_OK( rc = FlmDbGetConfig( hDb, (eDbGetConfigType)uiType, szValue)))
			{
				printTableDataStart();
				if( szValue[ 0])
				{
					printEncodedString( szValue, HTML_ENCODING);
				}
				else
				{
					printTableDataEmpty();
				}
				printTableDataEnd();
			}
			break;

		case FDB_GET_RFL_KEEP_FLAG:
		case FDB_GET_AUTO_TURN_OFF_KEEP_RFL_FLAG:
		case FDB_GET_KEEP_ABORTED_TRANS_IN_RFL_FLAG:
			if( RC_OK( rc = FlmDbGetConfig( hDb, (eDbGetConfigType)uiType, &bFlag)))
			{
				printTableDataStart();
				if( uiConfigVal)
				{
					fnPrintf( m_pHRequest, "<form type=\"submit\" "
						"method=\"get\" action=\"%s/dbconfig\">\n",
						 m_pszURLString);
					fnPrintf( m_pHRequest, "<input name=\"dbhandle\" type=\"hidden\""
												  " value=\"%s\"></input>\n", szDbKey);
					fnPrintf( m_pHRequest, "<select name=\"%u\" size=1 onChange=\"submit()\">\n", uiConfigVal);
					printSelectOption( bFlag ? 1 : 0, 0, "No", FALSE);
					printSelectOption( bFlag ? 1 : 0, 1, "Yes", FALSE);
					fnPrintf( m_pHRequest, "</select>\n");
					fnPrintf( m_pHRequest, "</form>\n");
				}
				else
				{
					fnPrintf( m_pHRequest, "%s", (char *)(bFlag ? "Yes" : "No"));
				}
				printTableDataEnd();
			}
			break;
		
		case FDB_GET_SERIAL_NUMBER:
			if( RC_OK( rc = FlmDbGetConfig( hDb, (eDbGetConfigType)uiType, ucSerialNum)))
			{
				printTableDataStart();
				for( uiLoop = 0; uiLoop < F_SERIAL_NUM_SIZE; uiLoop++)
				{
					if( uiLoop)
					{
						fnPrintf( m_pHRequest, " ");
					}
					fnPrintf( m_pHRequest, "%02X", (unsigned)ucSerialNum[ uiLoop]);
				}
				printTableDataEnd();
			}
			break;
		
		default:
			rc = RC_SET( FERR_INVALID_PARM);
	}

	if( RC_BAD( rc))
	{
		printTableDataStart();
		fnPrintf( m_pHRequest, "Error %04X", (unsigned)rc);
		printTableDataEnd();
	}

	printTableRowEnd();
}

/****************************************************************************
Desc:	Print a selection list for record retrieval flags.
****************************************************************************/
void F_WebPage::printRetrievalFlagsPulldown(
	FLMUINT			uiSelectedFlag)
{
	fnPrintf( m_pHRequest, "<select name=\"flags\">\n");

	printSelectOption( uiSelectedFlag, FO_EXACT, "Exact", FALSE);
	printSelectOption( uiSelectedFlag, FO_INCL, "Inclusive", FALSE);
	printSelectOption( uiSelectedFlag, FO_EXCL, "Exclusive", FALSE);
	printSelectOption( uiSelectedFlag, FO_FIRST, "First", FALSE);
	printSelectOption( uiSelectedFlag, FO_LAST, "Last", FALSE);

	fnPrintf( m_pHRequest, "</select>\n");
}

/****************************************************************************
Desc:	Print the setOperation javascript function.
****************************************************************************/
void F_WebPage::printSetOperationScript( void)
{
	fnPrintf( m_pHRequest,
		"<SCRIPT>\n"
		"function setOperation( theForm, theOperation)\n"
		"{\n"
			"if (theOperation == \"" OPERATION_DELETE "\")\n"
			"{\n"
				"if (confirm( \"OK to delete?\"))\n"
				"{\n"
					"theForm.Operation.value = theOperation;\n"
					"theForm.submit();\n"
				"}\n"
			"}\n"
			"else\n"
			"{\n"
				"theForm.Operation.value = theOperation;\n"
				"theForm.submit();\n"
			"}\n"
		"}\n"
		"</SCRIPT>\n"
		"<input name=\"Operation\" type=\"hidden\" value=\"none\">\n");
}

/****************************************************************************
Desc:	Print an operation button - this ties to the setOperation script.
****************************************************************************/
void F_WebPage::printOperationButton(
	const char *	pszFormName,
	const char *	pszButtonLabel,
	const char *	pszButtonValue)
{
	fnPrintf( m_pHRequest,
		"<input name=\"%s\" type=\"submit\" value=\"%s\" "
		"onClick=\"setOperation( document.%s, '%s')\">\n",
		pszButtonValue, pszButtonLabel, pszFormName, pszButtonValue);
}

/****************************************************************************
Desc:	Print the <center> HTML.
****************************************************************************/
void F_WebPage::printStartCenter( void)
{
	fnPrintf( m_pHRequest, "<center>");
}

/****************************************************************************
Desc:	Print the </center> HTML.
****************************************************************************/
void F_WebPage::printEndCenter(
	FLMBOOL	bPrintCR
	)
{
	if (bPrintCR)
	{
		fnPrintf( m_pHRequest, "</center>\n");
	}
	else
	{
		fnPrintf( m_pHRequest, "</center>");
	}
}

/****************************************************************************
Desc:	Print a selection list of FLAIM language codes
****************************************************************************/
void F_WebPage::printLanguagePulldown(
	FLMUINT		uiSelectedLang)
{
	FLMUINT		uiLoop;
	char			szLangCode [32];

	fnPrintf( m_pHRequest, "<select name=\"language\">\n");
	
	for( uiLoop = 0; uiLoop < LAST_LANG; uiLoop++)
	{
		FlmGetLanguage( uiLoop, szLangCode);
		printSelectOption( uiSelectedLang, uiLoop, szLangCode, FALSE);
	}

	fnPrintf( m_pHRequest, "</select>\n");
}


/****************************************************************************
Desc:	
****************************************************************************/
RCODE F_WebPage::displayLogFileHdr(
	const char *	pszPath)
{
	RCODE				rc = FERR_OK;
	F_FileHdl *		pFileHdl = NULL;
	FLMBYTE *		pucLogHdr = NULL;
	FLMBOOL			bFileOpened = FALSE;
	FLMUINT			uiBytesRead = 0;
	char				szTitle[ 128];

	// Create a new File Handle first to work with.
	if ((pFileHdl = f_new F_FileHdlImp) == NULL)
	{
		rc = RC_SET( FERR_MEM);
		goto Exit;
	}

	// Open the file
	if (RC_BAD( rc = pFileHdl->Open( pszPath, F_IO_RDONLY)))
	{
		goto Exit;
	}
	bFileOpened = TRUE;

	// Create a temporay buffer to hold the log header
	if( RC_BAD( rc = f_alloc( 
		LOG_HEADER_SIZE, &pucLogHdr)))
	{
		goto Exit;
	}

	// Read in the file log header
	if (RC_BAD( rc = pFileHdl->Read(
		(unsigned)DB_LOG_HEADER_START, (unsigned)LOG_HEADER_SIZE,
		(void *)pucLogHdr, &uiBytesRead)))
	{
		goto Exit;
	}

	if (uiBytesRead == LOG_HEADER_SIZE)
	{
		f_sprintf( (char *)szTitle, "Log File Header - %s", pszPath);
		printTableStart( (char *)szTitle, 1, 100);
		printTableEnd();
		printLogHeaders( pucLogHdr, NULL, NULL);
	}
	else
	{
		rc = RC_SET( FERR_READING_FILE);
		goto Exit;
	}

Exit:

	if (pFileHdl)
	{
		if (bFileOpened)
		{
			pFileHdl->Close();
		}
		pFileHdl->Release();
	}

	if (pucLogHdr)
	{
		f_free( &pucLogHdr);
	}

	return( rc);
}


