//-------------------------------------------------------------------------
// Desc:	Difference two FlmRecord objects - class definitions.
// Tabs:	3
//
//		Copyright (c) 1998-2000,2002-2006 Novell, Inc. All Rights Reserved.
//
//		This program is free software; you can redistribute it and/or
//		modify it under the terms of version 2 of the GNU General Public
//		License as published by the Free Software Foundation.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, contact Novell, Inc.
//
//		To contact Novell about this file by physical or electronic mail,
//		you may find current contact information at www.novell.com
//
// $Id: gddiff.h 12305 2006-01-19 15:04:41 -0700 (Thu, 19 Jan 2006) dsanders $
//-------------------------------------------------------------------------

#ifndef GDDIFF_H
#define GDDIFF_H

#include "fpackon.h"
// IMPORTANT NOTE: No other include files should follow this one except
// for fpackoff.h

enum GRD_DifferenceType
{
	GRD_Inserted,
	GRD_Deleted,
	GRD_Modified,
	GRD_DeletedSubtree
};

typedef struct 
{
	GRD_DifferenceType	type;					/* The 'type' indicates the nature 
		of the difference, and can have one of the following values:
			GRD_Inserted: a field was inserted.  In this case, the field only exists
							in the 'after record.'  'pAfterField' points to the 
							inserted field.  'pBeforeField' == NULL.
			GRD_Deleted: a field was deleted.  In this case, the field only exists in
							the 'before record'.  'pBeforeField' points to the 
							deleted field.  'pAfterField' == NULL.
			GRD_Modified: a field was modified.  In this case, 'pBeforeField' points 
							to the field before it was modified, and 'pAfterField'
							points to the field after it was modified.
			GRD_DeletedSubtree: a sub-tree was deleted.  In this case, the sub-tree only exists in
							the 'before record'.  'pBeforeField' points to the 
							deleted sub-tree.  'pAfterField' == NULL. */


	FLMUINT					uiAbsolutePosition; /* 'uiAbsolutePosition' is the
															1-based position where the
															difference occured.
			When using the list of differences generated by flmRecordDifference to
		undo changes, uiAbsolutePosition can be thought of as the 1-based position
		relative to the 'after record.'  In order for 'undo' to work correctly,
		the differences must be undone in reverse order.
			When using the list of differences to redo changes, uiAbsolutePosition
		can be thought of as the 1-based position relative to the 'before
		record.'  In order for 'redo' to work correctly, the differences must be
		redone in order.  Note that when a node is inserted or deleted, all
		subsequent nodes are, in essence, renumbered. */

	FlmRecord *				pBeforeRecord;

	FlmRecord *				pAfterRecord;

	void *					pvBeforeField;		/* 'pvBeforeField' is a pointer to 
															the field before the change.  
															There are situations where 
															'pBeforeField' will be NULL.  
															See a description of the 'type' 
															for more details. */
															
	void *					pvAfterField;		/* 'pvAfterField' is a pointer to the 
															field after the change.  There are
															situations where 'pBeforeField' 
															will be NULL.  See a description 
															of the 'type' for more details. */
}	GRD_DifferenceData;


/*
 * Function prototypes for record differencing
 */
 
typedef void (* GRD_CallBackFunction)(//Called for each difference found
	GRD_DifferenceData	&difference,//Description of difference
	void *				pCallBackData); //User-defined data

/****************************************************************************
Desc: Return the differences between the 'before' and 'after' record
In:	pBeforeRecord	- pointer to the record before any changes were
								made.
		pAfterRecord	- pointer to the record after changes were made.
		pCallBackFunction - pointer to a function that will be called for each
								difference found.
		pCallBackData	- pointer to data that will be passed as a parameter to
								the call back function.  This data is defined by the
								caller.
Note: In addition to the call back data, a GRD_DifferenceData structure is
		passed to the callback function.  For a description of this structure,
		please refer to its definition.
****************************************************************************/
void flmRecordDifference(
	FlmRecord *		pBeforeRecord,
	FlmRecord *		pAfterRecord,
	GRD_CallBackFunction	pCallBackFunction,
	void *			pvCallBackData);

/*
 * Data definitions for string differencing
 */
 
enum GSD_DifferenceType
{
	GSD_Inserted,
	GSD_Deleted
};

typedef struct 
{
	GSD_DifferenceType	type;					/* The 'type' indicates the nature 
															of the difference: Inserted or
															Deleted.*/

	FLMBYTE *				pSubString;			/* A pointer to the bytes that were
															inserted or deleted.  Note that 
		this pointer points into either the 'before' or 'after' string passed
		into flmStringDifference.  As a result, the callback function should 
		treat these substrings as read-only data.  */
															
	FLMUINT					uiLength;			/* The number of bytes that were
															inserted or deleted */

	FLMUINT					uiPosition;			/* 0-based position where the 
															substring was inserted or deleted.
			When using the list of differences generated by flmStringDifference to
		undo changes, the differences must be undone in reverse order.
			When using the list of differences to redo changes, the differences 
		must be redone in order.  Note that when a substring is inserted or 
		deleted, all subsequent bytes are, in essence, renumbered. */
}	GSD_DifferenceData;



/*
 * Function prototypes for string differencing
 */
 
typedef void (* GSD_CallBackFunction)(//Called for each difference found
	GSD_DifferenceData	&difference,//Description of difference
	void *					pvCallBackData); //User-defined data

/****************************************************************************
Desc:	Find the differences between the 2 strings.  The strings are not
		assumed to be NULL-terminated, thus the required length parameter.
In:	pBefore			- pointer to the string before any changes were made.
		lBeforeLength	- number of bytes in 'before string'
		pAfter			- pointer to the string after changes were made.
		lBeforeLength	- number of bytes in 'after string'
		pCallBackFunction - pointer to a function that will be called for each
								difference found.
		pvCallBackData	- pointer to data that will be passed as a parameter to
								the call back function.  This data is defined by the
								caller.
Note: In addition to the call back data, a GSD_DifferenceData structure is
		passed to the callback function.  For a description of this structure,
		please refer to its definition.
****************************************************************************/
void flmStringDifference(
	FLMBYTE *	pBefore,
	FLMUINT		uiBeforeLength,
	FLMBYTE *	pAfter,
	FLMUINT		uiAfterLength,
	GSD_CallBackFunction	pCallBackFunction,
	void *		pvCallBackData);

#include "fpackoff.h"

#endif	// GDDIFF_H
