//-------------------------------------------------------------------------
// Desc:	Convert error codes into strings.
// Tabs:	3
//
//		Copyright (c) 1991-2006 Novell, Inc. All Rights Reserved.
//
//		This program is free software; you can redistribute it and/or
//		modify it under the terms of version 2 of the GNU General Public
//		License as published by the Free Software Foundation.
//
//		This program is distributed in the hope that it will be useful,
//		but WITHOUT ANY WARRANTY; without even the implied warranty of
//		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//		GNU General Public License for more details.
//
//		You should have received a copy of the GNU General Public License
//		along with this program; if not, contact Novell, Inc.
//
//		To contact Novell about this file by physical or electronic mail,
//		you may find current contact information at www.novell.com
//
// $Id: flrcodes.cpp 12329 2006-01-20 17:49:30 -0700 (Fri, 20 Jan 2006) ahodgkinson $
//-------------------------------------------------------------------------

#include "flaimsys.h"

/*API~***********************************************************************
Desc:		Returns a pointer to the ASCII string representation of a FLAIM
			return code.
*END************************************************************************/
const char * FlmErrorString(
	RCODE			rc)
{
	const char *	pszStr;

	if( (pszStr = flmErrorString( rc)) == NULL)
	{
		pszStr = "Unknown Error";
	}

	return( pszStr);
}

/****************************************************************************
Desc: Returns a pointer to a static RCODE string or NULL if the RCODE
		cannot be mapped
****************************************************************************/
const char * flmErrorString(
	RCODE			rc)
{
	if( RC_OK( rc))
	{
		return( "FERR_OK");
	}

#define	CASE_RET( c) \
	case c: return( #c )
	
	switch( rc)
	{
		CASE_RET( FERR_BOF_HIT);
		CASE_RET( FERR_EOF_HIT);
		CASE_RET( FERR_END);
		CASE_RET( FERR_EXISTS);
		CASE_RET( FERR_FAILURE);
		CASE_RET( FERR_NOT_FOUND);
		CASE_RET( FERR_BAD_DICT_ID);
		CASE_RET( FERR_BAD_CONTAINER);
		CASE_RET( FERR_NO_ROOT_BLOCK);
		CASE_RET( FERR_BAD_DRN);
		CASE_RET( FERR_BAD_FIELD_NUM);
		CASE_RET( FERR_BAD_FIELD_TYPE);
		CASE_RET( FERR_BAD_HDL);
		CASE_RET( FERR_BAD_IX);
		CASE_RET( FERR_BACKUP_ACTIVE);
		CASE_RET( FERR_SERIAL_NUM_MISMATCH);
		CASE_RET( FERR_BAD_RFL_DB_SERIAL_NUM);
		CASE_RET( FERR_BTREE_ERROR);
		CASE_RET( FERR_BTREE_FULL);
		CASE_RET( FERR_BAD_RFL_FILE_NUMBER);
		CASE_RET( FERR_CANNOT_DEL_ITEM);
		CASE_RET( FERR_CANNOT_MOD_FIELD_TYPE);
		CASE_RET( FERR_CONV_BAD_DEST_TYPE);
		CASE_RET( FERR_CONV_BAD_DIGIT);
		CASE_RET( FERR_CONV_BAD_SRC_TYPE);
		CASE_RET( FERR_RFL_FILE_NOT_FOUND);
		CASE_RET( FERR_CONV_DEST_OVERFLOW);
		CASE_RET( FERR_CONV_ILLEGAL);
		CASE_RET( FERR_CONV_NULL_SRC);
		CASE_RET( FERR_CONV_NULL_DEST);
		CASE_RET( FERR_CONV_NUM_OVERFLOW);
		CASE_RET( FERR_CONV_NUM_UNDERFLOW);
		CASE_RET( FERR_DATA_ERROR);
		CASE_RET( FERR_DD_ERROR);
		CASE_RET( FERR_INVALID_FILE_SEQUENCE);
		CASE_RET( FERR_ILLEGAL_OP);
		CASE_RET( FERR_DUPLICATE_DICT_REC);
		CASE_RET( FERR_CANNOT_CONVERT);
		CASE_RET( FERR_UNSUPPORTED_VERSION);
		CASE_RET( FERR_FILE_ER);
		CASE_RET( FERR_BAD_FIELD_LEVEL);
		CASE_RET( FERR_GED_BAD_RECID);
		CASE_RET( FERR_GED_BAD_VALUE);
		CASE_RET( FERR_GED_MAXLVLNUM);
		CASE_RET( FERR_GED_SKIP_LEVEL);
		CASE_RET( FERR_ILLEGAL_TRANS);
		CASE_RET( FERR_ILLEGAL_TRANS_OP);
		CASE_RET( FERR_INCOMPLETE_LOG);
		CASE_RET( FERR_INVALID_BLOCK_LENGTH);
		CASE_RET( FERR_INVALID_TAG);
		CASE_RET( FERR_KEY_NOT_FOUND);
		CASE_RET( FERR_VALUE_TOO_LARGE);
		CASE_RET( FERR_MEM);
		CASE_RET( FERR_BAD_RFL_SERIAL_NUM);
		CASE_RET( FERR_NEWER_FLAIM);
		CASE_RET( FERR_CANNOT_MOD_FIELD_STATE);
		CASE_RET( FERR_NO_MORE_DRNS);
		CASE_RET( FERR_NO_TRANS_ACTIVE);
		CASE_RET( FERR_NOT_UNIQUE);
		CASE_RET( FERR_NOT_FLAIM);
		CASE_RET( FERR_NULL_RECORD);
		CASE_RET( FERR_NO_HTTP_STACK);
		CASE_RET( FERR_OLD_VIEW);
		CASE_RET( FERR_PCODE_ERROR);
		CASE_RET( FERR_PERMISSION);
		CASE_RET( FERR_SYNTAX);
		CASE_RET( FERR_CALLBACK_FAILURE);
		CASE_RET( FERR_TRANS_ACTIVE);
		CASE_RET( FERR_RFL_TRANS_GAP);
		CASE_RET( FERR_BAD_COLLATED_KEY);
		CASE_RET( FERR_UNSUPPORTED_FEATURE);
		CASE_RET( FERR_MUST_DELETE_INDEXES);
		CASE_RET( FERR_RFL_INCOMPLETE);
		CASE_RET( FERR_CANNOT_RESTORE_RFL_FILES);
		CASE_RET( FERR_INCONSISTENT_BACKUP);
		CASE_RET( FERR_BLOCK_CHECKSUM);
		CASE_RET( FERR_ABORT_TRANS);
		CASE_RET( FERR_NOT_RFL);
		CASE_RET( FERR_BAD_RFL_PACKET);
		CASE_RET( FERR_DATA_PATH_MISMATCH);
		CASE_RET( FERR_HTTP_REGISTER_FAILURE);
		CASE_RET( FERR_HTTP_DEREG_FAILURE);
		CASE_RET( FERR_IX_FAILURE);
		CASE_RET( FERR_HTTP_SYMS_EXIST);
		CASE_RET( FERR_FILE_EXISTS);
		CASE_RET( FERR_SYM_RESOLVE_FAIL);
		CASE_RET( FERR_BAD_SERVER_CONNECTION);
		CASE_RET( FERR_CLOSING_DATABASE);
		CASE_RET( FERR_INVALID_CRC);
		CASE_RET( FERR_KEY_OVERFLOW);
		CASE_RET( FERR_NOT_IMPLEMENTED);
		CASE_RET( FERR_MUTEX_OPERATION_FAILED);
		CASE_RET( FERR_MUTEX_UNABLE_TO_LOCK);
		CASE_RET( FERR_SEM_OPERATION_FAILED);
		CASE_RET( FERR_SEM_UNABLE_TO_LOCK);
		CASE_RET( FERR_BAD_REFERENCE);
		CASE_RET( FERR_UNALLOWED_UPGRADE);
		CASE_RET( FERR_ID_RESERVED);
		CASE_RET( FERR_CANNOT_RESERVE_ID);
		CASE_RET( FERR_DUPLICATE_DICT_NAME);
		CASE_RET( FERR_CANNOT_RESERVE_NAME);
		CASE_RET( FERR_BAD_DICT_DRN);
		CASE_RET( FERR_CANNOT_MOD_DICT_REC_TYPE);
		CASE_RET( FERR_PURGED_FLD_FOUND);
		CASE_RET( FERR_DUPLICATE_INDEX);
		CASE_RET( FERR_TOO_MANY_OPEN_DBS);
		CASE_RET( FERR_ACCESS_DENIED);
		CASE_RET( FERR_CACHE_ERROR);
		CASE_RET( FERR_BLOB_MISSING_FILE);
		CASE_RET( FERR_NO_REC_FOR_KEY);
		CASE_RET( FERR_DB_FULL);
		CASE_RET( FERR_TIMEOUT);
		CASE_RET( FERR_CURSOR_SYNTAX);
		CASE_RET( FERR_THREAD_ERR);
		CASE_RET( FERR_UNIMPORT_SYMBOL);
		CASE_RET( FERR_EMPTY_QUERY);
		CASE_RET( FERR_INDEX_OFFLINE);
		CASE_RET( FERR_TRUNCATED_KEY);
		CASE_RET( FERR_INVALID_PARM);
		CASE_RET( FERR_USER_ABORT);
		CASE_RET( FERR_RFL_DEVICE_FULL);
		CASE_RET( FERR_MUST_WAIT_CHECKPOINT);
		CASE_RET( FERR_NAMED_SEMAPHORE_ERR);
		CASE_RET( FERR_LOAD_LIBRARY);
		CASE_RET( FERR_UNLOAD_LIBRARY);
		CASE_RET( FERR_IMPORT_SYMBOL);
		CASE_RET( FERR_BLOCK_FULL);
		CASE_RET( FERR_BAD_BASE64_ENCODING);
		CASE_RET( FERR_MISSING_FIELD_TYPE);
		CASE_RET( FERR_BAD_DATA_LENGTH);
		CASE_RET( FERR_IO_ACCESS_DENIED);
		CASE_RET( FERR_IO_BAD_FILE_HANDLE);
		CASE_RET( FERR_IO_COPY_ERR);
		CASE_RET( FERR_IO_DISK_FULL);
		CASE_RET( FERR_IO_END_OF_FILE);
		CASE_RET( FERR_IO_OPEN_ERR);
		CASE_RET( FERR_IO_SEEK_ERR);
		CASE_RET( FERR_IO_MODIFY_ERR);
		CASE_RET( FERR_IO_PATH_NOT_FOUND);
		CASE_RET( FERR_IO_TOO_MANY_OPEN_FILES);
		CASE_RET( FERR_IO_PATH_TOO_LONG);
		CASE_RET( FERR_IO_NO_MORE_FILES);
		CASE_RET( FERR_DELETING_FILE);
		CASE_RET( FERR_IO_FILE_LOCK_ERR);
		CASE_RET( FERR_IO_FILE_UNLOCK_ERR);
		CASE_RET( FERR_IO_PATH_CREATE_FAILURE);
		CASE_RET( FERR_IO_RENAME_FAILURE);
		CASE_RET( FERR_IO_INVALID_PASSWORD);
		CASE_RET( FERR_SETTING_UP_FOR_READ);
		CASE_RET( FERR_SETTING_UP_FOR_WRITE);
		CASE_RET( FERR_IO_AT_PATH_ROOT);
		CASE_RET( FERR_INITIALIZING_IO_SYSTEM);
		CASE_RET( FERR_FLUSHING_FILE);
		CASE_RET( FERR_IO_INVALID_PATH);
		CASE_RET( FERR_IO_CONNECT_ERROR);
		CASE_RET( FERR_OPENING_FILE);
		CASE_RET( FERR_DIRECT_OPENING_FILE);
		CASE_RET( FERR_CREATING_FILE);
		CASE_RET( FERR_DIRECT_CREATING_FILE);
		CASE_RET( FERR_READING_FILE);
		CASE_RET( FERR_DIRECT_READING_FILE);
		CASE_RET( FERR_WRITING_FILE);
		CASE_RET( FERR_DIRECT_WRITING_FILE);
		CASE_RET( FERR_POSITIONING_IN_FILE);
		CASE_RET( FERR_GETTING_FILE_SIZE);
		CASE_RET( FERR_TRUNCATING_FILE);
		CASE_RET( FERR_PARSING_FILE_NAME);
		CASE_RET( FERR_CLOSING_FILE);
		CASE_RET( FERR_GETTING_FILE_INFO);
		CASE_RET( FERR_EXPANDING_FILE);
		CASE_RET( FERR_GETTING_FREE_BLOCKS);
		CASE_RET( FERR_CHECKING_FILE_EXISTENCE);
		CASE_RET( FERR_RENAMING_FILE);
		CASE_RET( FERR_SETTING_FILE_INFO);
		CASE_RET( FERR_NICI_CONTEXT);
		CASE_RET( FERR_NICI_FIND_INIT);
		CASE_RET( FERR_NICI_FIND_OBJECT);
		CASE_RET( FERR_NICI_WRAPKEY_NOT_FOUND);
		CASE_RET( FERR_NICI_ATTRIBUTE_VALUE);
		CASE_RET( FERR_NICI_BAD_ATTRIBUTE);
		CASE_RET( FERR_NICI_BAD_RANDOM);
		CASE_RET( FERR_NICI_WRAPKEY_FAILED);
		CASE_RET( FERR_NICI_GENKEY_FAILED);
		CASE_RET( FERR_REQUIRE_PASSWD);
		CASE_RET( FERR_NICI_SHROUDKEY_FAILED);
		CASE_RET( FERR_NICI_UNSHROUDKEY_FAILED);
		CASE_RET( FERR_NICI_UNWRAPKEY_FAILED);
		CASE_RET( FERR_NICI_ENC_INIT_FAILED);
		CASE_RET( FERR_NICI_ENCRYPT_FAILED);
		CASE_RET( FERR_NICI_DECRYPT_INIT_FAILED);
		CASE_RET( FERR_NICI_DECRYPT_FAILED);
		CASE_RET( FERR_NICI_INIT_FAILED);
		CASE_RET( FERR_NICI_KEY_NOT_FOUND);
		CASE_RET( FERR_NICI_INVALID_ALGORITHM);
		CASE_RET( FERR_FLD_NOT_ENCRYPTED);
		CASE_RET( FERR_BAD_ENCDEF_ID);
		CASE_RET( FERR_CANNOT_SET_KEY);
		CASE_RET( FERR_MISSING_ENC_TYPE);
		CASE_RET( FERR_CANNOT_MOD_ENC_TYPE);
		CASE_RET( FERR_MISSING_ENC_KEY);
		CASE_RET( FERR_CANNOT_CHANGE_KEY);
		CASE_RET( FERR_BAD_ENC_KEY);
		CASE_RET( FERR_CANNOT_MOD_ENC_STATE);
		CASE_RET( FERR_DATA_SIZE_MISMATCH);
		CASE_RET( FERR_ENCRYPTION_UNAVAILABLE);
		CASE_RET( FERR_PURGED_ENCDEF_FOUND);
		CASE_RET( FERR_FLD_NOT_DECRYPTED);
		CASE_RET( FERR_PBE_ENCRYPT_FAILED);
		CASE_RET( FERR_DIGEST_FAILED);
		CASE_RET( FERR_DIGEST_INIT_FAILED);
		CASE_RET( FERR_EXTRACT_KEY_FAILED);
		CASE_RET( FERR_INJECT_KEY_FAILED);
		CASE_RET( FERR_PBE_DECRYPT_FAILED);
		CASE_RET( FERR_PASSWD_INVALID);
		CASE_RET( FERR_SVR_NOIP_ADDR);
		CASE_RET( FERR_SVR_SOCK_FAIL);
		CASE_RET( FERR_SVR_CONNECT_FAIL);
		CASE_RET( FERR_SVR_BIND_FAIL);
		CASE_RET( FERR_SVR_LISTEN_FAIL);
		CASE_RET( FERR_SVR_ACCEPT_FAIL);
		CASE_RET( FERR_SVR_SELECT_ERR);
		CASE_RET( FERR_SVR_SOCKOPT_FAIL);
		CASE_RET( FERR_SVR_DISCONNECT);
		CASE_RET( FERR_SVR_READ_FAIL);
		CASE_RET( FERR_SVR_WRT_FAIL);
		CASE_RET( FERR_SVR_READ_TIMEOUT);
		CASE_RET( FERR_SVR_WRT_TIMEOUT);
		CASE_RET( FERR_SVR_ALREADY_CLOSED);
		default:
			return( NULL);
	}
}




