/** \file
 * Defines the fundamental interface for the Builder class.
 *
 * \author Martin F. Krafft <krafft@ailab.ch>
 * \date $Date: 2004/05/16 15:57:33 $
 * \version $Revision: 1.9 $
 */

#ifndef __INCLUDE_FACTORY_BUILDERBASE_H__
#define __INCLUDE_FACTORY_BUILDERBASE_H__

#include <factory++/constructor.hpp>
#include <factory++/destructor.hpp>

#include <memory>

namespace Factory
{
  template <typename _BaseType>
    class _Builder_base
    {
    public:
      inline
      _Builder_base() {}
      virtual inline
      ~_Builder_base() {}
      
      virtual _BaseType* build() const = 0;
      virtual _BaseType* build(_BaseType const&) const = 0;
      virtual void teardown(_BaseType* const) const = 0;

      template <typename _Type>
        inline _Type*
        custom_build(Constructor<_Type>& __constructor) const
        {
          return __constructor(reinterpret_cast<_Type*>(this->_M_allocate()));
        }

      template <typename _Type>
        inline _Type*
        custom_build(Constructor<_Type> const& __CONSTRUCTOR) const
        {
          return __CONSTRUCTOR(reinterpret_cast<_Type*>(this->_M_allocate()));
        }

      template <typename _Type, typename _Arg>
        inline _Type*
        custom_build(Constructor<_Type>& __constructor,
                     _Arg const& __ARG) const
        {

          return __constructor(reinterpret_cast<_Type*>(this->_M_allocate()),
              __ARG);
        }

      template <typename _Type, typename _Arg>
        inline _Type*
        custom_build(Constructor<_Type> const& __CONSTRUCTOR,
                     _Arg const& __ARG) const
        {

          return __CONSTRUCTOR(reinterpret_cast<_Type*>(this->_M_allocate()),
              __ARG);
        }

      template <typename _Type>
        inline void
        custom_teardown(_Type* const __OBJ,
                       Destructor<_Type>& __destructor) const
        {
          __destructor(__OBJ);
          this->_M_deallocate(__OBJ);
        }

      template <typename _Type>
        inline void
        custom_teardown(_Type* const __OBJ,
                       Destructor<_Type> const& __DESTRUCTOR) const
        {
          __DESTRUCTOR(__OBJ);
          this->_M_deallocate(__OBJ);
        }

    protected:

      virtual _BaseType* _M_allocate() const = 0;
      virtual void _M_deallocate(_BaseType* const) const = 0;

    };

}; // namespace Factory

#endif // include guard

/* COPYRIGHT --
 *
 * This file is part of libfactory++, a C++ template factory framework.
 * libfactory++ is (c) 2004 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
