#include "e-date-rfc.h"

typedef struct _dtest_data {
  const char * type_string;
  const char * date_string;
} dtest_data;

dtest_data dates_list[] = {
  { "Google Prefs Cookie", "Sun, 17-Jan-2038 19:14:07 GMT" },
  { "32-bit time_t Summit", "Sun, 18-Jan-2038 22:14:07 GMT" },
  { "Sourceforge Cookie", "Mon, 31-May-04 14:40:14 GMT" },
};
  
gint main (gint argc, gchar * argv[]) {
  time_t tt;
  gint i;

  for (i = 0; i < G_N_ELEMENTS (dates_list); i++) {
    tt = e_date_rfc_parse (dates_list[i].date_string);
    if (tt <= 0) {
      printf ("Test Failed: %s - %s - %d\n",
	      dates_list[i].type_string, dates_list[i].date_string, tt);
    } else {
      printf ("Test Passed: %s\n", dates_list[i].type_string);
    }
  }

  return 0;
}
