dnl ---------------------------------------------------------------------------
dnl Macro: ENABLE_DTRACE
dnl ---------------------------------------------------------------------------
AC_DEFUN([ENABLE_DTRACE],[
  AC_ARG_ENABLE([dtrace],
    [AS_HELP_STRING([--enable-dtrace],
            [Build with support for the DTRACE. @<:@default=off@:>@])],
    [ 
      AC_DEFINE([HAVE_DTRACE], [1], [Enables DTRACE Support])
      AC_DEFINE([_DTRACE_VERSION], [1], [DTRACE Version to Use])
      AC_CHECK_PROGS(DTRACE, dtrace)
      ac_cv_enable_dtrace="yes" 
      AC_SUBST(DTRACEFLAGS)
      AC_SUBST(HAVE_DTRACE)
    ],
    [
      ac_cv_enable_dtrace="no" 
    ])
AM_CONDITIONAL([HAVE_DTRACE], [ test "$ac_cv_enable_dtrace" = "yes" ])
])
dnl ---------------------------------------------------------------------------
dnl End Macro: ENABLE_DTRACE
dnl ---------------------------------------------------------------------------
