/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief Connection declarations for clients
 */

#ifndef __DRIZZLE_CON_CLIENT_H
#define __DRIZZLE_CON_CLIENT_H

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @addtogroup drizzle_con_client Connection Handling for Clients
 * @ingroup drizzle_client
 * These functions extend the core connection functions with a set of functions
 * for client application use.
 * @{
 */

/**
 * Add TCP (IPv4 or IPv6) connection with common arguments.
 */
DRIZZLE_API
drizzle_con_st *drizzle_con_add_tcp(drizzle_st *drizzle, drizzle_con_st *con,
                                    const char *host, in_port_t port,
                                    const char *user, const char *password,
                                    const char *db,
                                    drizzle_con_options_t options);

/*
 * Add Unix Domain Sockets connection with common arguments.
 */
DRIZZLE_API
drizzle_con_st *drizzle_con_add_uds(drizzle_st *drizzle, drizzle_con_st *con,
                                    const char *uds, const char *user,
                                    const char *password, const char *db,
                                    drizzle_con_options_t options);

/**
 * Connect to server.
 */
DRIZZLE_API
drizzle_return_t drizzle_con_connect(drizzle_con_st *con);

/** @} */

#ifdef __cplusplus
}
#endif

#endif /* __DRIZZLE_CON_CLIENT_H */
