/****************************************************************************
(c) 2006 Melanie Thielker

This file is part of libdjconsole.

libdjconsole is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

libdjconsole is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License along with
libdjconsole; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA 
****************************************************************************/

#ifndef _DJCONSOLE_H_INCLUDED
#define _DJCONSOLE_H_INCLUDED

#include <pthread.h>
#include <usb.h>

#include "delta.h"
#include "bitfield.h"

#define LEDS 16
#define BUTTONS 32

#define LEFT_PLAY 1
#define LEFT_CUE 2
#define RIGHT_PLAY 3
#define RIGHT_CUE 4
#define LEFT_MASTER_TEMPO 5
#define RIGHT_MASTER_TEMPO 6
#define LEFT_AUTO_BEAT 7
#define RIGHT_AUTO_BEAT 8
#define LEFT_FX 9
#define RIGHT_FX 10
#define LEFT_FX_CUE 11
#define RIGHT_FX_CUE 12
#define LEFT_LOOP 13
#define RIGHT_LOOP 14
#define LEFT_MONITOR 15
#define RIGHT_MONITOR 16
#define LEFT_SKIP_BACK 17
#define LEFT_SKIP_FORWARD 18
#define RIGHT_SKIP_BACK 19
#define RIGHT_SKIP_FORWARD 20
#define LEFT_PITCH_DOWN 21
#define LEFT_PITCH_UP 22
#define RIGHT_PITCH_DOWN 23
#define RIGHT_PITCH_UP 24
#define LEFT_1 25
#define LEFT_2 26
#define LEFT_3 27
#define RIGHT_1 28
#define RIGHT_2 29
#define RIGHT_3 30
#define LEFT_FX_SELECT 31
#define RIGHT_FX_SELECT 32
#define LEFT_BASS 33
#define LEFT_MID 34
#define LEFT_HIGH 35
#define RIGHT_BASS 36
#define RIGHT_MID 37
#define RIGHT_HIGH 38
#define LEFT_VOL 39
#define RIGHT_VOL 40
#define LEFT_PITCH 41
#define RIGHT_PITCH 42
#define LEFT_JOG 43
#define RIGHT_JOG 44
#define XFADER 45

#define MOUSE_X 46
#define MOUSE_Y 47
#define MOUSE_L 48
#define MOUSE_R 49

class DJConsole
{
public:
	DJConsole(bool load_data=false);
	~DJConsole();

	bool detected();
	bool ready();
	void setCallback(void (*)(void *, int, int), void *);
	void loadData();

	unsigned short vendor();
	unsigned short product();

	Delta ControlDelta;
	Delta MouseDelta;
	Bitfield Leds;
protected:
	pthread_t Worker1, Worker2;
	pthread_mutex_t EventLock;
	pthread_mutex_t StartLock;
	pthread_cond_t StartSignal;

	void (*Callback)(void *, int, int);
	void *UserData;

	bool Worker1Started, Worker1Running, Worker2Started, Worker2Running;
	static void *worker1Helper(void *);
	static void *worker2Helper(void *);
	static void worker1Reset(void *);
	static void worker2Reset(void *);

	void worker1();
	void worker2();

	bool startThreads();
	void stopThreads();
	void setLeds();

	void processEvent(DeltaEvent ev);

	bool Opened;
	usb_dev_handle *hdev1;
	usb_dev_handle *hdev2;
	struct usb_device *dev;
	int ControlInterface;
	int MouseInterface;
	int Configuration;
	unsigned short Vendor;
	unsigned short Product;
};

#endif
