/* lda-schema-to-gconf.c generated by valac 0.10.4, the Vala compiler
 * generated from lda-schema-to-gconf.vala, do not modify */

/*
 * Desktop Agnostic Library: Desktop Agnostic to GConf schema converter.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libdesktop-agnostic/config.h>
#include <libdesktop-agnostic/desktop-agnostic.h>
#include <glib/gstdio.h>
#include <stdio.h>

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



char* schema_type_to_string (GType type);
void value_array_to_string (GValue* src_value, GValue* dest_value);
gint _vala_main (char** args, int args_length1);
static void _value_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void _vala_GValue_free (GValue* self);
static int _vala_strcmp0 (const char * str1, const char * str2);



char* schema_type_to_string (GType type) {
	char* result = NULL;
	if (type == G_TYPE_BOOLEAN) {
		result = g_strdup ("bool");
		return result;
	} else {
		if (type == G_TYPE_INT) {
			result = g_strdup ("int");
			return result;
		} else {
			if (type == G_TYPE_FLOAT) {
				result = g_strdup ("float");
				return result;
			} else {
				if (type == G_TYPE_STRING) {
					result = g_strdup ("string");
					return result;
				} else {
					if (type == G_TYPE_VALUE_ARRAY) {
						result = g_strdup ("list");
						return result;
					} else {
						result = g_strdup ("string");
						return result;
					}
				}
			}
		}
	}
}


void value_array_to_string (GValue* src_value, GValue* dest_value) {
	GValueArray* arr;
	GString* res;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	arr = g_value_get_boxed (src_value);
	res = g_string_new ("[");
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GValue val;
				GValue val_str = {0};
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < arr->n_values)) {
					break;
				}
				val = *g_value_array_get_nth (arr, i);
				g_assert (g_value_type_transformable (G_VALUE_TYPE (&val), G_TYPE_STRING));
				g_value_init (&val_str, G_TYPE_STRING);
				g_value_transform (&val, &val_str);
				if (i != 0) {
					g_string_append (res, ",");
				}
				g_string_append (res, g_value_get_string (&val_str));
				G_IS_VALUE (&val_str) ? (g_value_unset (&val_str), NULL) : NULL;
			}
		}
	}
	g_string_append (res, "]");
	*dest_value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, res->str), _tmp1_), G_IS_VALUE (dest_value) ? (g_value_unset (dest_value), NULL) : NULL, _tmp2_);
	_g_string_free0 (res);
}


static void _value_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	value_array_to_string (src_value, dest_value);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	const char* current_group;
	const char* current_key;
	GError * _inner_error_ = NULL;
	current_group = NULL;
	current_key = NULL;
	if (args_length1 < 2) {
		result = 1;
		return result;
	}
	g_value_register_transform_func (G_TYPE_VALUE_ARRAY, G_TYPE_STRING, _value_array_to_string_gvalue_transform);
	{
		GType ct = 0UL;
		DesktopAgnosticConfigSchema* schema;
		GString* gconf;
		DesktopAgnosticConfigSchema* _tmp0_;
		DesktopAgnosticConfigSchema* _tmp1_;
		GString* _tmp2_;
		schema = NULL;
		gconf = NULL;
		ct = desktop_agnostic_module_loader_load (desktop_agnostic_module_loader_get_default (), "libda-cfg-gconf");
		if (ct == G_TYPE_INVALID) {
			g_critical ("lda-schema-to-gconf.vala:98: The GConf configuration module needs to b" \
"e installed for %s to function correctly.", args[0]);
			result = 1;
			_g_string_free0 (gconf);
			_g_object_unref0 (schema);
			return result;
		}
		if (!g_file_test (args[1], G_FILE_TEST_IS_REGULAR)) {
			g_critical ("lda-schema-to-gconf.vala:105: The schema file '%s' does not seem to ex" \
"ist.", args[1]);
			result = 1;
			_g_string_free0 (gconf);
			_g_object_unref0 (schema);
			return result;
		}
		_tmp0_ = desktop_agnostic_config_schema_new (args[1], &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_string_free0 (gconf);
			_g_object_unref0 (schema);
			goto __catch0_g_error;
		}
		schema = (_tmp1_ = _tmp0_, _g_object_unref0 (schema), _tmp1_);
		gconf = (_tmp2_ = g_string_new ("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"), _g_string_free0 (gconf), _tmp2_);
		g_string_append (gconf, "<gconfschemafile>\n  <schemalist>\n");
		{
			GList* group_collection;
			GList* group_it;
			group_collection = desktop_agnostic_config_schema_get_groups (schema);
			for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
				const char* group;
				group = (const char*) group_it->data;
				{
					char* base_path;
					char* app_name;
					char* path_prefix;
					GValue* _tmp3_;
					GValue* _tmp4_;
					char* _tmp5_;
					char* _tmp6_;
					base_path = NULL;
					app_name = NULL;
					path_prefix = NULL;
					current_group = group;
					_tmp3_ = desktop_agnostic_config_schema_get_metadata_option (schema, "GConf.base_path", &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (path_prefix);
						_g_free0 (app_name);
						_g_free0 (base_path);
						_g_list_free0 (group_collection);
						_g_string_free0 (gconf);
						_g_object_unref0 (schema);
						goto __catch0_g_error;
					}
					base_path = (_tmp5_ = g_strdup (g_value_get_string (_tmp4_ = _tmp3_)), _g_free0 (base_path), _tmp5_);
					__vala_GValue_free0 (_tmp4_);
					app_name = (_tmp6_ = g_strdup (desktop_agnostic_config_schema_get_app_name (schema)), _g_free0 (app_name), _tmp6_);
					if (_vala_strcmp0 (group, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT) == 0) {
						char* _tmp7_;
						path_prefix = (_tmp7_ = g_strdup_printf ("%s/%s", base_path, app_name), _g_free0 (path_prefix), _tmp7_);
					} else {
						char* _tmp8_;
						path_prefix = (_tmp8_ = g_strdup_printf ("%s/%s/%s", base_path, app_name, group), _g_free0 (path_prefix), _tmp8_);
					}
					{
						GList* key_collection;
						GList* key_it;
						key_collection = desktop_agnostic_config_schema_get_keys (schema, group);
						for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
							const char* key;
							key = (const char*) key_it->data;
							{
								DesktopAgnosticConfigSchemaOption* option;
								GType type;
								GValue default_value = {0};
								char* summary;
								char* _tmp9_;
								char* _tmp10_;
								char* _tmp11_;
								char* _tmp12_;
								char* _tmp13_;
								GValue _tmp16_ = {0};
								GValue _tmp17_;
								char* _tmp20_;
								char* _tmp21_;
								gboolean _tmp22_ = FALSE;
								char* _tmp24_;
								option = _g_object_ref0 (desktop_agnostic_config_schema_get_option (schema, group, key));
								type = desktop_agnostic_config_schema_option_get_option_type (option);
								g_value_init (&default_value, G_TYPE_STRING);
								summary = NULL;
								current_key = key;
								g_string_append (gconf, "    <schema>\n");
								g_string_append (gconf, _tmp9_ = g_markup_printf_escaped ("      <key>/schemas%s/%s</key>\n", path_prefix, key));
								_g_free0 (_tmp9_);
								g_string_append (gconf, _tmp10_ = g_markup_printf_escaped ("      <applyto>%s/%s</applyto>\n", path_prefix, key));
								_g_free0 (_tmp10_);
								g_string_append (gconf, _tmp11_ = g_markup_printf_escaped ("      <owner>%s</owner>\n", app_name));
								_g_free0 (_tmp11_);
								g_string_append (gconf, _tmp13_ = g_markup_printf_escaped ("      <type>%s</type>\n", _tmp12_ = schema_type_to_string (type)));
								_g_free0 (_tmp13_);
								_g_free0 (_tmp12_);
								if (type == G_TYPE_VALUE_ARRAY) {
									GType list_type;
									char* _tmp14_;
									char* _tmp15_;
									list_type = desktop_agnostic_config_schema_option_get_list_type (option);
									g_string_append (gconf, _tmp15_ = g_markup_printf_escaped ("      <list_type>%s</list_type>\n", _tmp14_ = schema_type_to_string (list_type)));
									_g_free0 (_tmp15_);
									_g_free0 (_tmp14_);
								}
								g_value_transform ((_tmp17_ = (desktop_agnostic_config_schema_option_get_default_value (option, &_tmp16_), _tmp16_), &_tmp17_), &default_value);
								if (NULL == g_value_get_string (&default_value)) {
									GValue _tmp18_ = {0};
									GValue _tmp19_;
									default_value = (_tmp19_ = (g_value_init (&_tmp18_, G_TYPE_STRING), g_value_set_string (&_tmp18_, ""), _tmp18_), G_IS_VALUE (&default_value) ? (g_value_unset (&default_value), NULL) : NULL, _tmp19_);
								}
								g_string_append (gconf, _tmp20_ = g_markup_printf_escaped ("      <default>%s</default>\n", g_value_get_string (&default_value)));
								_g_free0 (_tmp20_);
								g_string_append (gconf, "      <locale name=\"C\">\n");
								summary = (_tmp21_ = g_strdup (desktop_agnostic_config_schema_option_get_summary (option)), _g_free0 (summary), _tmp21_);
								if (summary != NULL) {
									_tmp22_ = _vala_strcmp0 (summary, "") != 0;
								} else {
									_tmp22_ = FALSE;
								}
								if (_tmp22_) {
									char* _tmp23_;
									g_string_append (gconf, _tmp23_ = g_markup_printf_escaped ("        <short>%s</short>\n", summary));
									_g_free0 (_tmp23_);
								}
								g_string_append (gconf, _tmp24_ = g_markup_printf_escaped ("        <long>%s</long>\n", desktop_agnostic_config_schema_option_get_description (option)));
								_g_free0 (_tmp24_);
								g_string_append (gconf, "      </locale>\n");
								g_string_append (gconf, "    </schema>\n");
								_g_free0 (summary);
								G_IS_VALUE (&default_value) ? (g_value_unset (&default_value), NULL) : NULL;
								_g_object_unref0 (option);
							}
						}
					}
					_g_free0 (path_prefix);
					_g_free0 (app_name);
					_g_free0 (base_path);
				}
			}
			_g_list_free0 (group_collection);
		}
		g_string_append (gconf, "  </schemalist>\n</gconfschemafile>\n");
		if (args_length1 < 3) {
			fprintf (stdout, "%s", gconf->str);
		} else {
			g_file_set_contents (args[2], gconf->str, gconf->len, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_string_free0 (gconf);
				_g_object_unref0 (schema);
				goto __catch0_g_error;
			}
		}
		_g_string_free0 (gconf);
		_g_object_unref0 (schema);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			gboolean _tmp25_ = FALSE;
			if (current_group == NULL) {
				_tmp25_ = TRUE;
			} else {
				_tmp25_ = current_key == NULL;
			}
			if (_tmp25_) {
				g_critical ("lda-schema-to-gconf.vala:194: Error: %s", err->message);
			} else {
				g_critical ("lda-schema-to-gconf.vala:198: Error (%s/%s): %s", current_group, current_key, err->message);
			}
			result = 1;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




