/* test-config-bridge.c generated by valac, the Vala compiler
 * generated from test-config-bridge.vala, do not modify */

/*
 * Tests the GObject <-> Config bridge
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libdesktop-agnostic/config.h>


#define TYPE_TEST_ENUM (test_enum_get_type ())

#define TYPE_TEST (test_get_type ())
#define TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST, Test))
#define TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST, TestClass))
#define IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST))
#define IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST))
#define TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST, TestClass))

typedef struct _Test Test;
typedef struct _TestClass TestClass;
typedef struct _TestPrivate TestPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TEST_DESTRUCT (test_destruct_get_type ())
#define TEST_DESTRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_DESTRUCT, TestDestruct))
#define TEST_DESTRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_DESTRUCT, TestDestructClass))
#define IS_TEST_DESTRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_DESTRUCT))
#define IS_TEST_DESTRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_DESTRUCT))
#define TEST_DESTRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_DESTRUCT, TestDestructClass))

typedef struct _TestDestruct TestDestruct;
typedef struct _TestDestructClass TestDestructClass;
typedef struct _TestDestructPrivate TestDestructPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	TEST_ENUM_ZERO = 0,
	TEST_ENUM_ONE,
	TEST_ENUM_TWO
} TestEnum;

struct _Test {
	GObject parent_instance;
	TestPrivate * priv;
};

struct _TestClass {
	GObjectClass parent_class;
};

struct _TestPrivate {
	char* _str;
	gint _num;
	float _dec;
	gboolean _tf;
	TestEnum _enum_val;
};

struct _TestDestruct {
	Test parent_instance;
	TestDestructPrivate * priv;
	gint foo_counter;
	gint str_counter;
};

struct _TestDestructClass {
	TestClass parent_class;
};

struct _TestDestructPrivate {
	DesktopAgnosticConfigBackend* cfg;
	gint _num2;
};


static gpointer test_parent_class = NULL;
extern gboolean test_destruct_instance_exists;
gboolean test_destruct_instance_exists = FALSE;
static gpointer test_destruct_parent_class = NULL;

GType test_enum_get_type (void);
#define DEFAULT_STR "Not expected string"
GType test_get_type (void);
#define TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST, TestPrivate))
enum  {
	TEST_DUMMY_PROPERTY,
	TEST_STR,
	TEST_NUM,
	TEST_DEC,
	TEST_TF,
	TEST_ENUM_VAL
};
Test* test_new (void);
Test* test_construct (GType object_type);
const char* test_get_str (Test* self);
void test_set_str (Test* self, const char* value);
gint test_get_num (Test* self);
void test_set_num (Test* self, gint value);
float test_get_dec (Test* self);
void test_set_dec (Test* self, float value);
gboolean test_get_tf (Test* self);
void test_set_tf (Test* self, gboolean value);
TestEnum test_get_enum_val (Test* self);
void test_set_enum_val (Test* self, TestEnum value);
static GObject * test_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void test_finalize (GObject* obj);
static void test_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void test_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType test_destruct_get_type (void);
#define TEST_DESTRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_DESTRUCT, TestDestructPrivate))
enum  {
	TEST_DESTRUCT_DUMMY_PROPERTY,
	TEST_DESTRUCT_NUM2
};
void test_destruct_set_num2 (TestDestruct* self, gint value);
static void test_destruct_on_str_notify_pre_bind (TestDestruct* self, GParamSpec* spec);
static void _test_destruct_on_str_notify_pre_bind_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
TestDestruct* test_destruct_new (DesktopAgnosticConfigBackend* cfg);
TestDestruct* test_destruct_construct (GType object_type, DesktopAgnosticConfigBackend* cfg);
static void test_destruct_on_str_notify_post_bind (TestDestruct* self, GParamSpec* spec);
static void _test_destruct_on_str_notify_post_bind_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void test_destruct_add_post_bind_notify (TestDestruct* self);
gint test_destruct_get_num2 (TestDestruct* self);
static void test_destruct_finalize (GObject* obj);
static void test_destruct_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void test_destruct_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void bridge_assertions (DesktopAgnosticConfigBackend* cfg, DesktopAgnosticConfigBridge* bridge, Test* obj, GError** error);
gint _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType test_enum_get_type (void) {
	static GType test_enum_type_id = 0;
	if (G_UNLIKELY (test_enum_type_id == 0)) {
		static const GEnumValue values[] = {{TEST_ENUM_ZERO, "TEST_ENUM_ZERO", "zero"}, {TEST_ENUM_ONE, "TEST_ENUM_ONE", "one"}, {TEST_ENUM_TWO, "TEST_ENUM_TWO", "two"}, {0, NULL, NULL}};
		test_enum_type_id = g_enum_register_static ("TestEnum", values);
	}
	return test_enum_type_id;
}


Test* test_construct (GType object_type) {
	Test * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


Test* test_new (void) {
	return test_construct (TYPE_TEST);
}


const char* test_get_str (Test* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_str;
	return result;
}


void test_set_str (Test* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_str = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_str), _tmp0_);
	g_object_notify ((GObject *) self, "str");
}


gint test_get_num (Test* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_num;
	return result;
}


void test_set_num (Test* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_num = value;
	g_object_notify ((GObject *) self, "num");
}


float test_get_dec (Test* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_dec;
	return result;
}


void test_set_dec (Test* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_dec = value;
	g_object_notify ((GObject *) self, "dec");
}


gboolean test_get_tf (Test* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tf;
	return result;
}


void test_set_tf (Test* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_tf = value;
	g_object_notify ((GObject *) self, "tf");
}


TestEnum test_get_enum_val (Test* self) {
	TestEnum result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_enum_val;
	return result;
}


void test_set_enum_val (Test* self, TestEnum value) {
	g_return_if_fail (self != NULL);
	self->priv->_enum_val = value;
	g_object_notify ((GObject *) self, "enum-val");
}


static GObject * test_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Test * self;
	parent_class = G_OBJECT_CLASS (test_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TEST (obj);
	{
		test_set_str (self, DEFAULT_STR);
		test_set_num (self, 1);
		test_set_dec (self, 2.71f);
		test_set_tf (self, FALSE);
		test_set_enum_val (self, TEST_ENUM_ZERO);
	}
	return obj;
}


static void test_class_init (TestClass * klass) {
	test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TestPrivate));
	G_OBJECT_CLASS (klass)->get_property = test_get_property;
	G_OBJECT_CLASS (klass)->set_property = test_set_property;
	G_OBJECT_CLASS (klass)->constructor = test_constructor;
	G_OBJECT_CLASS (klass)->finalize = test_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_STR, g_param_spec_string ("str", "str", "str", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_NUM, g_param_spec_int ("num", "num", "num", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_DEC, g_param_spec_float ("dec", "dec", "dec", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_TF, g_param_spec_boolean ("tf", "tf", "tf", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_ENUM_VAL, g_param_spec_enum ("enum-val", "enum-val", "enum-val", TYPE_TEST_ENUM, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void test_instance_init (Test * self) {
	self->priv = TEST_GET_PRIVATE (self);
}


static void test_finalize (GObject* obj) {
	Test * self;
	self = TEST (obj);
	_g_free0 (self->priv->_str);
	G_OBJECT_CLASS (test_parent_class)->finalize (obj);
}


GType test_get_type (void) {
	static GType test_type_id = 0;
	if (test_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Test), 0, (GInstanceInitFunc) test_instance_init, NULL };
		test_type_id = g_type_register_static (G_TYPE_OBJECT, "Test", &g_define_type_info, 0);
	}
	return test_type_id;
}


static void test_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Test * self;
	self = TEST (object);
	switch (property_id) {
		case TEST_STR:
		g_value_set_string (value, test_get_str (self));
		break;
		case TEST_NUM:
		g_value_set_int (value, test_get_num (self));
		break;
		case TEST_DEC:
		g_value_set_float (value, test_get_dec (self));
		break;
		case TEST_TF:
		g_value_set_boolean (value, test_get_tf (self));
		break;
		case TEST_ENUM_VAL:
		g_value_set_enum (value, test_get_enum_val (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void test_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Test * self;
	self = TEST (object);
	switch (property_id) {
		case TEST_STR:
		test_set_str (self, g_value_get_string (value));
		break;
		case TEST_NUM:
		test_set_num (self, g_value_get_int (value));
		break;
		case TEST_DEC:
		test_set_dec (self, g_value_get_float (value));
		break;
		case TEST_TF:
		test_set_tf (self, g_value_get_boolean (value));
		break;
		case TEST_ENUM_VAL:
		test_set_enum_val (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _test_destruct_on_str_notify_pre_bind_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	test_destruct_on_str_notify_pre_bind (self, pspec);
}


TestDestruct* test_destruct_construct (GType object_type, DesktopAgnosticConfigBackend* cfg) {
	TestDestruct * self;
	DesktopAgnosticConfigBackend* _tmp0_;
	g_return_val_if_fail (cfg != NULL, NULL);
	self = (TestDestruct*) test_construct (object_type);
	test_destruct_set_num2 (self, 1);
	self->priv->cfg = (_tmp0_ = _g_object_ref0 (cfg), _g_object_unref0 (self->priv->cfg), _tmp0_);
	test_destruct_instance_exists = TRUE;
	g_signal_connect_object ((GObject*) self, "notify::str", (GCallback) _test_destruct_on_str_notify_pre_bind_g_object_notify, self, 0);
	return self;
}


TestDestruct* test_destruct_new (DesktopAgnosticConfigBackend* cfg) {
	return test_destruct_construct (TYPE_TEST_DESTRUCT, cfg);
}


static void test_destruct_on_str_notify_pre_bind (TestDestruct* self, GParamSpec* spec) {
	char* str;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spec != NULL);
	str = g_strdup (test_get_str ((Test*) self));
	g_assert (_vala_strcmp0 (str, DEFAULT_STR) != 0);
	if (_vala_strcmp0 (str, "foo") == 0) {
		self->foo_counter++;
	} else {
		self->str_counter++;
	}
	_g_free0 (str);
}


static void _test_destruct_on_str_notify_post_bind_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	test_destruct_on_str_notify_post_bind (self, pspec);
}


void test_destruct_add_post_bind_notify (TestDestruct* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GObject*) self, "notify::str", (GCallback) _test_destruct_on_str_notify_post_bind_g_object_notify, self, 0);
}


static void test_destruct_on_str_notify_post_bind (TestDestruct* self, GParamSpec* spec) {
	char* str;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spec != NULL);
	str = g_strdup (test_get_str ((Test*) self));
	g_assert (_vala_strcmp0 (str, DEFAULT_STR) != 0);
	if (_vala_strcmp0 (str, "foo") == 0) {
		self->foo_counter--;
	} else {
		self->str_counter--;
	}
	_g_free0 (str);
}


gint test_destruct_get_num2 (TestDestruct* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_num2;
	return result;
}


void test_destruct_set_num2 (TestDestruct* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_num2 = value;
	g_object_notify ((GObject *) self, "num2");
}


static void test_destruct_class_init (TestDestructClass * klass) {
	test_destruct_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TestDestructPrivate));
	G_OBJECT_CLASS (klass)->get_property = test_destruct_get_property;
	G_OBJECT_CLASS (klass)->set_property = test_destruct_set_property;
	G_OBJECT_CLASS (klass)->finalize = test_destruct_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEST_DESTRUCT_NUM2, g_param_spec_int ("num2", "num2", "num2", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void test_destruct_instance_init (TestDestruct * self) {
	self->priv = TEST_DESTRUCT_GET_PRIVATE (self);
	self->foo_counter = 0;
	self->str_counter = 0;
}


static void test_destruct_finalize (GObject* obj) {
	TestDestruct * self;
	GError * _inner_error_;
	self = TEST_DESTRUCT (obj);
	_inner_error_ = NULL;
	{
		DesktopAgnosticConfigBridge* bridge;
		bridge = desktop_agnostic_config_bridge_get_default ();
		desktop_agnostic_config_bridge_remove_all_for_object (bridge, self->priv->cfg, (GObject*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		test_destruct_instance_exists = FALSE;
	}
	_g_object_unref0 (self->priv->cfg);
	G_OBJECT_CLASS (test_destruct_parent_class)->finalize (obj);
}


GType test_destruct_get_type (void) {
	static GType test_destruct_type_id = 0;
	if (test_destruct_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TestDestructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_destruct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestDestruct), 0, (GInstanceInitFunc) test_destruct_instance_init, NULL };
		test_destruct_type_id = g_type_register_static (TYPE_TEST, "TestDestruct", &g_define_type_info, 0);
	}
	return test_destruct_type_id;
}


static void test_destruct_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TestDestruct * self;
	self = TEST_DESTRUCT (object);
	switch (property_id) {
		case TEST_DESTRUCT_NUM2:
		g_value_set_int (value, test_destruct_get_num2 (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void test_destruct_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TestDestruct * self;
	self = TEST_DESTRUCT (object);
	switch (property_id) {
		case TEST_DESTRUCT_NUM2:
		test_destruct_set_num2 (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void bridge_assertions (DesktopAgnosticConfigBackend* cfg, DesktopAgnosticConfigBridge* bridge, Test* obj, GError** error) {
	GError * _inner_error_;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp4_;
	char* _tmp5_;
	gint _tmp6_;
	float _tmp7_;
	gboolean _tmp8_;
	gint _tmp9_;
	g_return_if_fail (cfg != NULL);
	g_return_if_fail (bridge != NULL);
	g_return_if_fail (obj != NULL);
	_inner_error_ = NULL;
	desktop_agnostic_config_backend_reset (cfg, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = desktop_agnostic_config_backend_get_string (cfg, "group", "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_assert (_vala_strcmp0 (_tmp1_ = _tmp0_, "foo") == 0);
	_g_free0 (_tmp1_);
	desktop_agnostic_config_bridge_bind (bridge, cfg, "group", "string", (GObject*) obj, "str", FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	desktop_agnostic_config_bridge_bind (bridge, cfg, "group", "number", (GObject*) obj, "num", TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (IS_TEST_DESTRUCT (obj)) {
		Test* _tmp2_;
		test_destruct_add_post_bind_notify ((_tmp2_ = obj, IS_TEST_DESTRUCT (_tmp2_) ? ((TestDestruct*) _tmp2_) : NULL));
		desktop_agnostic_config_bridge_bind (bridge, cfg, "group", "number", (GObject*) obj, "num2", TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	desktop_agnostic_config_bridge_bind (bridge, cfg, "group", "decimal", (GObject*) obj, "dec", FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	desktop_agnostic_config_bridge_bind (bridge, cfg, "group", "tf", (GObject*) obj, "tf", TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	desktop_agnostic_config_bridge_bind (bridge, cfg, "group", "enum", (GObject*) obj, "enum_val", TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_assert (_vala_strcmp0 (test_get_str (obj), "foo") == 0);
	g_assert (test_get_num (obj) == 10);
	if (IS_TEST_DESTRUCT (obj)) {
		Test* _tmp3_;
		g_assert (test_destruct_get_num2 ((_tmp3_ = obj, IS_TEST_DESTRUCT (_tmp3_) ? ((TestDestruct*) _tmp3_) : NULL)) == 10);
	}
	g_assert (test_get_dec (obj) == 3.14f);
	g_assert (test_get_tf (obj) == TRUE);
	g_assert (test_get_enum_val (obj) == TEST_ENUM_ONE);
	test_set_str (obj, "Some new string");
	test_set_num (obj, 100);
	test_set_dec (obj, 1.618f);
	test_set_tf (obj, FALSE);
	test_set_enum_val (obj, TEST_ENUM_TWO);
	_tmp4_ = desktop_agnostic_config_backend_get_string (cfg, "group", "string", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_assert (_vala_strcmp0 (_tmp5_ = _tmp4_, test_get_str (obj)) == 0);
	_g_free0 (_tmp5_);
	_tmp6_ = desktop_agnostic_config_backend_get_int (cfg, "group", "number", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_assert (_tmp6_ != test_get_num (obj));
	_tmp7_ = desktop_agnostic_config_backend_get_float (cfg, "group", "decimal", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_assert (_tmp7_ == test_get_dec (obj));
	_tmp8_ = desktop_agnostic_config_backend_get_bool (cfg, "group", "tf", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_assert (_tmp8_ != test_get_tf (obj));
	_tmp9_ = desktop_agnostic_config_backend_get_int (cfg, "group", "enum", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	g_assert (_tmp9_ != 2);
	if (IS_TEST_DESTRUCT (obj)) {
		Test* _tmp10_;
		TestDestruct* td;
		td = (_tmp10_ = obj, IS_TEST_DESTRUCT (_tmp10_) ? ((TestDestruct*) _tmp10_) : NULL);
		g_assert (td->foo_counter == 1);
		g_assert (td->str_counter == 1);
	}
}


gint _main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		DesktopAgnosticConfigSchema* schema;
		DesktopAgnosticConfigBackend* cfg;
		DesktopAgnosticConfigBridge* bridge;
		Test* t;
		TestDestruct* td;
		Test* _tmp0_;
		TestDestruct* _tmp1_;
		TestDestruct* _tmp2_;
		Test* _tmp3_;
		TestDestruct* _tmp4_;
		TestDestruct* _tmp5_;
		schema = desktop_agnostic_config_schema_new ("test-config-bridge.schema-ini", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		cfg = desktop_agnostic_config_new (schema, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			goto __catch0_g_error;
		}
		bridge = desktop_agnostic_config_bridge_get_default ();
		t = NULL;
		td = NULL;
		t = (_tmp0_ = test_new (), _g_object_unref0 (t), _tmp0_);
		bridge_assertions (cfg, bridge, t, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_object_unref0 (cfg);
			_g_object_unref0 (t);
			_g_object_unref0 (td);
			goto __catch0_g_error;
		}
		desktop_agnostic_config_bridge_remove_all_for_object (bridge, cfg, (GObject*) t, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_object_unref0 (cfg);
			_g_object_unref0 (t);
			_g_object_unref0 (td);
			goto __catch0_g_error;
		}
		desktop_agnostic_config_backend_reset (cfg, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_object_unref0 (cfg);
			_g_object_unref0 (t);
			_g_object_unref0 (td);
			goto __catch0_g_error;
		}
		td = (_tmp1_ = test_destruct_new (cfg), _g_object_unref0 (td), _tmp1_);
		bridge_assertions (cfg, bridge, (Test*) td, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_object_unref0 (cfg);
			_g_object_unref0 (t);
			_g_object_unref0 (td);
			goto __catch0_g_error;
		}
		td = (_tmp2_ = NULL, _g_object_unref0 (td), _tmp2_);
		g_assert (!test_destruct_instance_exists);
		t = (_tmp3_ = test_new (), _g_object_unref0 (t), _tmp3_);
		bridge_assertions (cfg, bridge, t, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_object_unref0 (cfg);
			_g_object_unref0 (t);
			_g_object_unref0 (td);
			goto __catch0_g_error;
		}
		td = (_tmp4_ = test_destruct_new (cfg), _g_object_unref0 (td), _tmp4_);
		bridge_assertions (cfg, bridge, (Test*) td, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_object_unref0 (cfg);
			_g_object_unref0 (t);
			_g_object_unref0 (td);
			goto __catch0_g_error;
		}
		td = (_tmp5_ = NULL, _g_object_unref0 (td), _tmp5_);
		g_assert (!test_destruct_instance_exists);
		desktop_agnostic_config_bridge_remove_all_for_object (bridge, cfg, (GObject*) t, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (schema);
			_g_object_unref0 (cfg);
			_g_object_unref0 (t);
			_g_object_unref0 (td);
			goto __catch0_g_error;
		}
		_g_object_unref0 (schema);
		_g_object_unref0 (cfg);
		_g_object_unref0 (t);
		_g_object_unref0 (td);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-config-bridge.vala:207: Error: %s", err->message);
			result = 1;
			_g_error_free0 (err);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _main (argv, argc);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




