/* config-type-color.c generated by valac, the Vala compiler
 * generated from config-type-color.vala, do not modify */

/*
 * Registers DesktopAgnostic.Color as a valid configuration type.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/config.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/desktop-agnostic.h>


#define DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE (desktop_agnostic_config_color_type_get_type ())
#define DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE, DesktopAgnosticConfigColorType))
#define DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE, DesktopAgnosticConfigColorTypeClass))
#define DESKTOP_AGNOSTIC_CONFIG_IS_COLOR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_IS_COLOR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE))
#define DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE, DesktopAgnosticConfigColorTypeClass))

typedef struct _DesktopAgnosticConfigColorType DesktopAgnosticConfigColorType;
typedef struct _DesktopAgnosticConfigColorTypeClass DesktopAgnosticConfigColorTypeClass;
typedef struct _DesktopAgnosticConfigColorTypePrivate DesktopAgnosticConfigColorTypePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))

struct _DesktopAgnosticConfigColorType {
	DesktopAgnosticConfigSchemaType parent_instance;
	DesktopAgnosticConfigColorTypePrivate * priv;
};

struct _DesktopAgnosticConfigColorTypeClass {
	DesktopAgnosticConfigSchemaTypeClass parent_class;
};


static gpointer desktop_agnostic_config_color_type_parent_class = NULL;

GType desktop_agnostic_config_color_type_get_type (void);
enum  {
	DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_NAME,
	DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_SCHEMA_TYPE
};
#define DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_DEFAULT_KEY "default"
static char* desktop_agnostic_config_color_type_real_serialize (DesktopAgnosticConfigSchemaType* base, GValue* val, GError** error);
static void desktop_agnostic_config_color_type_real_deserialize (DesktopAgnosticConfigSchemaType* base, const char* serialized, GValue* result, GError** error);
static void desktop_agnostic_config_color_type_real_parse_default_value (DesktopAgnosticConfigSchemaType* base, GKeyFile* schema, const char* group, GValue* result, GError** error);
static GValueArray* desktop_agnostic_config_color_type_real_parse_default_list_value (DesktopAgnosticConfigSchemaType* base, GKeyFile* schema, const char* group, GError** error);
DesktopAgnosticConfigColorType* desktop_agnostic_config_color_type_new (void);
DesktopAgnosticConfigColorType* desktop_agnostic_config_color_type_construct (GType object_type);
static void desktop_agnostic_config_color_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void desktop_agnostic_config_color_to_string (GValue* src_value, GValue* dest_value);
void desktop_agnostic_config_string_to_color (GValue* src_value, GValue* dest_value);
static void _desktop_agnostic_config_color_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void _desktop_agnostic_config_string_to_color_gvalue_transform (GValue* src_value, GValue* dest_value);
GType register_plugin (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static char* desktop_agnostic_config_color_type_real_serialize (DesktopAgnosticConfigSchemaType* base, GValue* val, GError** error) {
	DesktopAgnosticConfigColorType * self;
	char* result;
	DesktopAgnosticColor* color;
	self = (DesktopAgnosticConfigColorType*) base;
	color = g_value_get_object (val);
	if (color == NULL) {
		result = g_strdup ("");
		return result;
	} else {
		result = desktop_agnostic_color_to_string (color);
		return result;
	}
}


static void desktop_agnostic_config_color_type_real_deserialize (DesktopAgnosticConfigSchemaType* base, const char* serialized, GValue* result, GError** error) {
	DesktopAgnosticConfigColorType * self;
	GError * _inner_error_;
	GValue val = {0};
	self = (DesktopAgnosticConfigColorType*) base;
	g_return_if_fail (serialized != NULL);
	_inner_error_ = NULL;
	if (_vala_strcmp0 (serialized, "") == 0) {
		GValue _tmp1_;
		GValue _tmp0_ = {0};
		val = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_OBJECT), g_value_set_object (&_tmp0_, G_OBJECT (NULL)), _tmp0_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp1_);
		*result = val;
		return;
	}
	{
		DesktopAgnosticColor* color;
		GValue _tmp5_;
		GValue _tmp4_ = {0};
		DesktopAgnosticColor* _tmp3_;
		DesktopAgnosticColor* _tmp2_;
		color = desktop_agnostic_color_new_from_string (serialized, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR) {
				goto __catch0_desktop_agnostic_color_parse_error;
			}
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		val = (_tmp5_ = (g_value_init (&_tmp4_, DESKTOP_AGNOSTIC_TYPE_COLOR), g_value_set_object (&_tmp4_, _tmp3_ = (_tmp2_ = color, color = NULL, _tmp2_)), _tmp4_), G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL, _tmp5_);
		_g_object_unref0 (_tmp3_);
		*result = val;
		_g_object_unref0 (color);
		return;
	}
	goto __finally0;
	__catch0_desktop_agnostic_color_parse_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE, "Could not deserialize value: %s", err->message);
			{
				_g_error_free0 (err);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				goto __finally0;
			}
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			return;
		} else {
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}


static void desktop_agnostic_config_color_type_real_parse_default_value (DesktopAgnosticConfigSchemaType* base, GKeyFile* schema, const char* group, GValue* result, GError** error) {
	DesktopAgnosticConfigColorType * self;
	GError * _inner_error_;
	char* _tmp0_;
	GValue _tmp2_ = {0};
	char* _tmp1_;
	GValue _tmp3_;
	GValue _tmp4_;
	self = (DesktopAgnosticConfigColorType*) base;
	g_return_if_fail (schema != NULL);
	g_return_if_fail (group != NULL);
	_inner_error_ = NULL;
	_tmp0_ = g_key_file_get_string (schema, group, DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_DEFAULT_KEY, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = (_tmp3_ = (desktop_agnostic_config_schema_type_deserialize ((DesktopAgnosticConfigSchemaType*) self, _tmp1_ = _tmp0_, &_tmp2_, &_inner_error_), _tmp2_), _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	*result = _tmp4_;
	return;
}


static GValueArray* desktop_agnostic_config_color_type_real_parse_default_list_value (DesktopAgnosticConfigSchemaType* base, GKeyFile* schema, const char* group, GError** error) {
	DesktopAgnosticConfigColorType * self;
	GValueArray* result;
	GError * _inner_error_;
	GValueArray* array;
	self = (DesktopAgnosticConfigColorType*) base;
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_inner_error_ = NULL;
	array = NULL;
	{
		char** _tmp1_;
		gint list_size;
		gint list_length1;
		gsize _tmp0_;
		char** list;
		GValueArray* _tmp2_;
		list = (_tmp1_ = g_key_file_get_string_list (schema, group, DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_DEFAULT_KEY, &_tmp0_, &_inner_error_), list_length1 = _tmp0_, list_size = list_length1, _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_value_array_free0 (array);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		array = (_tmp2_ = g_value_array_new ((guint) list_length1), _g_value_array_free0 (array), _tmp2_);
		{
			char** item_collection;
			int item_collection_length1;
			int item_it;
			item_collection = list;
			item_collection_length1 = list_length1;
			for (item_it = 0; item_it < list_length1; item_it = item_it + 1) {
				const char* item;
				item = item_collection[item_it];
				{
					GValue _tmp3_ = {0};
					GValue _tmp4_;
					GValue _tmp6_;
					GValue _tmp5_;
					_tmp4_ = (desktop_agnostic_config_schema_type_deserialize ((DesktopAgnosticConfigSchemaType*) self, item, &_tmp3_, &_inner_error_), _tmp3_);
					if (_inner_error_ != NULL) {
						list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						goto __finally1;
					}
					g_value_array_append (array, (_tmp6_ = _tmp5_ = _tmp4_, &_tmp6_));
					G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
				}
			}
		}
		result = array;
		list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR, DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR_PARSE, "Could not parse the default list value: %s", err->message);
			{
				_g_error_free0 (err);
				_g_value_array_free0 (array);
				goto __finally1;
			}
			_g_error_free0 (err);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_SCHEMA_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_value_array_free0 (array);
			return NULL;
		} else {
			_g_value_array_free0 (array);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_value_array_free0 (array);
}


DesktopAgnosticConfigColorType* desktop_agnostic_config_color_type_construct (GType object_type) {
	DesktopAgnosticConfigColorType * self;
	self = (DesktopAgnosticConfigColorType*) desktop_agnostic_config_schema_type_construct (object_type);
	return self;
}


DesktopAgnosticConfigColorType* desktop_agnostic_config_color_type_new (void) {
	return desktop_agnostic_config_color_type_construct (DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE);
}


static char* desktop_agnostic_config_color_type_real_get_name (DesktopAgnosticConfigSchemaType* base) {
	char* result;
	DesktopAgnosticConfigColorType* self;
	self = (DesktopAgnosticConfigColorType*) base;
	result = g_strdup ("color");
	return result;
}


static GType desktop_agnostic_config_color_type_real_get_schema_type (DesktopAgnosticConfigSchemaType* base) {
	GType result;
	DesktopAgnosticConfigColorType* self;
	self = (DesktopAgnosticConfigColorType*) base;
	result = DESKTOP_AGNOSTIC_TYPE_COLOR;
	return result;
}


static void desktop_agnostic_config_color_type_class_init (DesktopAgnosticConfigColorTypeClass * klass) {
	desktop_agnostic_config_color_type_parent_class = g_type_class_peek_parent (klass);
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS (klass)->serialize = desktop_agnostic_config_color_type_real_serialize;
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS (klass)->deserialize = desktop_agnostic_config_color_type_real_deserialize;
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS (klass)->parse_default_value = desktop_agnostic_config_color_type_real_parse_default_value;
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS (klass)->parse_default_list_value = desktop_agnostic_config_color_type_real_parse_default_list_value;
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS (klass)->get_name = desktop_agnostic_config_color_type_real_get_name;
	DESKTOP_AGNOSTIC_CONFIG_SCHEMA_TYPE_CLASS (klass)->get_schema_type = desktop_agnostic_config_color_type_real_get_schema_type;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_config_color_type_get_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_SCHEMA_TYPE, "schema-type");
}


static void desktop_agnostic_config_color_type_instance_init (DesktopAgnosticConfigColorType * self) {
}


GType desktop_agnostic_config_color_type_get_type (void) {
	static GType desktop_agnostic_config_color_type_type_id = 0;
	if (desktop_agnostic_config_color_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticConfigColorTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_config_color_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticConfigColorType), 0, (GInstanceInitFunc) desktop_agnostic_config_color_type_instance_init, NULL };
		desktop_agnostic_config_color_type_type_id = g_type_register_static (DESKTOP_AGNOSTIC_CONFIG_TYPE_SCHEMA_TYPE, "DesktopAgnosticConfigColorType", &g_define_type_info, 0);
	}
	return desktop_agnostic_config_color_type_type_id;
}


static void desktop_agnostic_config_color_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticConfigColorType * self;
	self = DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_NAME:
		g_value_set_string (value, desktop_agnostic_config_schema_type_get_name ((DesktopAgnosticConfigSchemaType*) self));
		break;
		case DESKTOP_AGNOSTIC_CONFIG_COLOR_TYPE_SCHEMA_TYPE:
		g_value_set_gtype (value, desktop_agnostic_config_schema_type_get_schema_type ((DesktopAgnosticConfigSchemaType*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void desktop_agnostic_config_color_to_string (GValue* src_value, GValue* dest_value) {
	GError * _inner_error_;
	DesktopAgnosticConfigColorType* ct;
	char* _tmp0_;
	GValue _tmp3_;
	GValue _tmp2_ = {0};
	char* _tmp1_;
	_inner_error_ = NULL;
	ct = desktop_agnostic_config_color_type_new ();
	_tmp0_ = desktop_agnostic_config_schema_type_serialize ((DesktopAgnosticConfigSchemaType*) ct, src_value, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ct);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	*dest_value = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, _tmp1_ = _tmp0_), _tmp2_), G_IS_VALUE (dest_value) ? (g_value_unset (dest_value), NULL) : NULL, _tmp3_);
	_g_free0 (_tmp1_);
	_g_object_unref0 (ct);
}


void desktop_agnostic_config_string_to_color (GValue* src_value, GValue* dest_value) {
	GError * _inner_error_;
	DesktopAgnosticConfigColorType* ct;
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue _tmp2_;
	_inner_error_ = NULL;
	ct = desktop_agnostic_config_color_type_new ();
	_tmp1_ = (desktop_agnostic_config_schema_type_deserialize ((DesktopAgnosticConfigSchemaType*) ct, g_value_get_string (src_value), &_tmp0_, &_inner_error_), _tmp0_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ct);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	*dest_value = (_tmp2_ = _tmp1_, G_IS_VALUE (dest_value) ? (g_value_unset (dest_value), NULL) : NULL, _tmp2_);
	_g_object_unref0 (ct);
}


static void _desktop_agnostic_config_color_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	desktop_agnostic_config_color_to_string (src_value, dest_value);
}


static void _desktop_agnostic_config_string_to_color_gvalue_transform (GValue* src_value, GValue* dest_value) {
	desktop_agnostic_config_string_to_color (src_value, dest_value);
}


GType register_plugin (void) {
	GType result;
	g_value_register_transform_func (DESKTOP_AGNOSTIC_TYPE_COLOR, G_TYPE_STRING, _desktop_agnostic_config_color_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRING, DESKTOP_AGNOSTIC_TYPE_COLOR, _desktop_agnostic_config_string_to_color_gvalue_transform);
	result = DESKTOP_AGNOSTIC_CONFIG_TYPE_COLOR_TYPE;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




