/***************************************************************************
                          dcobject.h  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DCOBJECT_H_
#define _DCOBJECT_H_

/**
  *@author Mathias Kster
  */

#include <time.h>

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>
#include <dclib/core/types.h>
#include <dclib/core/cstring.h>
#include <dclib/core/clist.h>
#include <dclib/core/types.h>

#define DC_USER_FILELIST_HE3 	"MyList.DcLst"
#define DC_USER_FILELIST 	DC_USER_FILELIST_HE3
#define DC_USER_FILELIST_BZ 	"MyList.bz2"
#define DC_USER_FILELIST_XML	"files.xml.bz2"

#ifdef WIN32
template class DLL_EXPORT CList<CString>;
#endif

typedef enum eDCMessage {
	DC_MESSAGE_PARSE_ERROR=0,

	DC_MESSAGE_CONNECTION_STATE,	// internal con. state
	DC_MESSAGE_TRANSFER,		// transfer state

	DC_MESSAGE_UNKNOWN,

	// direct connect proto
	DC_MESSAGE_LOCK,
	DC_MESSAGE_HELLO,
	DC_MESSAGE_HUBNAME,
	DC_MESSAGE_CHAT,
	DC_MESSAGE_MYINFO,
	DC_MESSAGE_QUIT,
	DC_MESSAGE_NICKLIST,		// 10
	DC_MESSAGE_OPLIST,
	DC_MESSAGE_CONNECTTOME,
	DC_MESSAGE_KEY,
	DC_MESSAGE_PRIVATECHAT,
	DC_MESSAGE_SEARCH,
	DC_MESSAGE_REVCONNECTTOME,
	DC_MESSAGE_SEARCHRESULT,
	DC_MESSAGE_FORCEMOVE,
	DC_MESSAGE_MYNICK,		// connect to me
	DC_MESSAGE_DIRECTION,		// 20 connect to me
	DC_MESSAGE_MAXEDOUT,
	DC_MESSAGE_FILELENGTH,
	DC_MESSAGE_ERROR,		// file not found ...
	DC_MESSAGE_GET,
	DC_MESSAGE_GETLISTLEN,
	DC_MESSAGE_VALIDATEDENIDE,
	DC_MESSAGE_GETINFO,
	DC_MESSAGE_AGE,
	DC_MESSAGE_HUBISFULL,
	DC_MESSAGE_LISTLEN,		// 30
	DC_MESSAGE_SEND,
	DC_MESSAGE_PING,
	DC_MESSAGE_GETPASS,		// user need a password
	DC_MESSAGE_BADPASS,		// wrong password
	DC_MESSAGE_LOGEDIN,		// admin
	DC_MESSAGE_CANCEL,		// cancel a transfer
	DC_MESSAGE_CANCELED,		// the transfer is canceled
	DC_MESSAGE_SUPPORTS,
	DC_MESSAGE_CAPABILITIES,

	// download manager types
	DC_MESSAGE_FILE_OBJECT,		// 40
	DC_MESSAGE_TRANSFER_OBJECT,
	DC_MESSAGE_FILELIST_OBJECT,
	DC_MESSAGE_SLOT_OBJECT,
	DC_MESSAGE_LOG,
	DC_MESSAGE_DM_INFO,

	// search manager types
	DC_MESSAGE_SEARCH_FILE,
	DC_MESSAGE_SEARCH_USER,
	DC_MESSAGE_SEARCHRESULT_USER,

	// file manager
	DC_MESSAGE_FM_INFO,

	// traffic control
	DC_MESSAGE_TRAFFIC,
	// file transferrate
	DC_MESSAGE_FILE_TRANSFER_RATE,
	DC_MESSAGE_GETHUBLIST,
	DC_MESSAGE_CONNECT_CLIENT,

	// verlihub extension
	DC_MESSAGE_HUB_TOPIC,

	// nmdc
	DC_MESSAGE_GET_NET_INFO,
	// user command
	DC_MESSAGE_USER_COMMAND
};

#define EDONKEY_HASH_BLOCK_SIZE 9728000

class DLL_EXPORT CDCMessage : public CObject {
public:
	/** */
	CDCMessage( eDCMessage type = DC_MESSAGE_UNKNOWN ) {
		m_eType = type;
	};
	/** */
	virtual ~CDCMessage() {};

	/** */
	CDCMessage & operator = (const CDCMessage & p)
	{
		m_eType = p.m_eType;

		return *this;
	};

	/** */
	eDCMessage m_eType;
};

class DLL_EXPORT CMessagePing : public CDCMessage {
public:
	/** */
	CMessagePing() : CDCMessage(DC_MESSAGE_PING) {};
	/** */
	virtual ~CMessagePing() {};

	/** */
	CMessagePing & operator = (const CMessagePing & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageHubTopic : public CDCMessage {
public:
	/** */
	CMessageHubTopic() : CDCMessage(DC_MESSAGE_HUB_TOPIC) {};
	/** */
	virtual ~CMessageHubTopic() {};

	/** */
	CMessageHubTopic & operator = (const CMessageHubTopic & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sTopic = p.m_sTopic;
		return *this;
	};

	/** */
	CString m_sTopic;
};

class DLL_EXPORT CMessageGetInfo : public CDCMessage {
public:
	/** */
	CMessageGetInfo() : CDCMessage(DC_MESSAGE_GETINFO) {};
	/** */
	virtual ~CMessageGetInfo() {};

	/** */
	CMessageGetInfo & operator = (const CMessageGetInfo & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sSrcNick = p.m_sSrcNick;
		m_sDstNick = p.m_sDstNick;

		return *this;
	};

	/** */
	CString m_sSrcNick;
	/** */
	CString m_sDstNick;
};

class DLL_EXPORT CMessageGetNetInfo : public CDCMessage {
public:
	/** */
	CMessageGetNetInfo() : CDCMessage(DC_MESSAGE_GET_NET_INFO) {};
	/** */
	virtual ~CMessageGetNetInfo() {};

	/** */
	CMessageGetNetInfo & operator = (const CMessageGetNetInfo & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageConnectionState : public CDCMessage {
public:
	/** */
	CMessageConnectionState() : CDCMessage(DC_MESSAGE_CONNECTION_STATE) {
		m_eState = estNONE;
	};
	/** */
	virtual ~CMessageConnectionState() {};

	/** */
	CMessageConnectionState & operator = (const CMessageConnectionState & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_eState   = p.m_eState;
		m_sMessage = p.m_sMessage;

		return *this;
	};

	/** */
	eConnectionState m_eState;
	/** */
	CString m_sMessage;
};

class DLL_EXPORT CMessageTransfer : public CDCMessage {
public:
	/** */
	CMessageTransfer() : CDCMessage(DC_MESSAGE_TRANSFER) {
		m_eDirection  = edNONE;
		m_nTransfered = 0;
		m_nLength     = 0;
	};
	/** */
	virtual ~CMessageTransfer() {};

	/** */
	CMessageTransfer & operator = (const CMessageTransfer & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_eDirection  = p.m_eDirection;
		m_nTransfered = p.m_nTransfered;
		m_nLength     = p.m_nLength;

		return *this;
	};

	/** */
	eDirection m_eDirection;
	/** */
	ulonglong m_nTransfered;
	/** */
	ulonglong m_nLength;
};

class DLL_EXPORT CMessageFileTransferRate : public CDCMessage {
public:
	/** */
	CMessageFileTransferRate() : CDCMessage(DC_MESSAGE_FILE_TRANSFER_RATE) {
		m_nRate      = 0;
	};
	/** */
	virtual ~CMessageFileTransferRate() {};

	/** */
	CMessageFileTransferRate & operator = (const CMessageFileTransferRate & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sLocalFile = p.m_sLocalFile;
		m_nRate      = p.m_nRate;

		return *this;
	};

	/** */
	CString m_sLocalFile;
	/** */
	ulonglong m_nRate;
};

class DLL_EXPORT CMessageSupports : public CDCMessage {
public:
	/** */
	CMessageSupports() : CDCMessage(DC_MESSAGE_SUPPORTS) {
		m_bBZList    = FALSE;
		m_bSSL       = FALSE;
		m_bChunk     = FALSE;
		m_bMiniSlots = FALSE;
		m_bXMLBZList = FALSE;
		m_bZBlock    = FALSE;
	};
	/** */
	virtual ~CMessageSupports() {};

	/** */
	CMessageSupports & operator = (const CMessageSupports & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_bBZList    = p.m_bBZList;
		m_bSSL       = p.m_bSSL;
		m_bChunk     = p.m_bChunk;
		m_bMiniSlots = p.m_bMiniSlots;
		m_bXMLBZList = p.m_bXMLBZList;
		m_bZBlock    = p.m_bZBlock;
		return *this;
	};

	/** */
	bool m_bBZList;
	/** */
	bool m_bSSL;
	/** */
	bool m_bChunk;
	/** */
	bool m_bMiniSlots;
	/** */
	bool m_bXMLBZList;
	/** */
	bool m_bZBlock;
};

class DLL_EXPORT CMessageCapabilities : public CDCMessage {
public:
	/** */
	CMessageCapabilities() : CDCMessage(DC_MESSAGE_CAPABILITIES) {
		m_bUniSearch = FALSE;
		m_bXSearch   = FALSE;
		m_bMD4x      = FALSE;
	};
	/** */
	virtual ~CMessageCapabilities() {};

	/** */
	CMessageCapabilities & operator = (const CMessageCapabilities & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_bUniSearch = p.m_bUniSearch;
		m_bXSearch   = p.m_bXSearch;
		m_bMD4x      = p.m_bMD4x;

		return *this;
	};

	/** */
	bool m_bUniSearch;
	/** */
	bool m_bXSearch;
	/** */
	bool m_bMD4x;
};

class DLL_EXPORT CMessageError : public CDCMessage {
public:
	/** */
	CMessageError() : CDCMessage(DC_MESSAGE_ERROR) {};
	/** */
	virtual ~CMessageError() {};

	/** */
	CMessageError & operator = (const CMessageError & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sError = p.m_sError;

		return *this;
	};

	/** */
	CString m_sError;
};

class DLL_EXPORT CMessageGet : public CDCMessage {
public:
	/** */
	CMessageGet() : CDCMessage(DC_MESSAGE_GET) {
		m_nPos  = 0;
		m_nSize = 0;
	};
	/** */
	virtual ~CMessageGet() {};

	/** */
	CMessageGet & operator = (const CMessageGet & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sFilename = p.m_sFilename;
		m_nPos      = p.m_nPos;
		m_nSize     = p.m_nSize;

		return *this;
	};

	/** */
	CString m_sFilename;
	/** */
	ulonglong m_nPos;
	/** */
	ulonglong m_nSize;
};

class DLL_EXPORT CMessageGetPass : public CDCMessage {
public:
	/** */
	CMessageGetPass() : CDCMessage(DC_MESSAGE_GETPASS) {};
	/** */
	virtual ~CMessageGetPass() {};

	/** */
	CMessageGetPass & operator = (const CMessageGetPass & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageCancel : public CDCMessage {
public:
	/** */
	CMessageCancel() : CDCMessage(DC_MESSAGE_CANCEL) {};
	/** */
	virtual ~CMessageCancel() {};

	/** */
	CMessageCancel & operator = (const CMessageCancel & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageCanceled : public CDCMessage {
public:
	/** */
	CMessageCanceled() : CDCMessage(DC_MESSAGE_CANCELED) {};
	/** */
	virtual ~CMessageCanceled() {};

	/** */
	CMessageCanceled & operator = (const CMessageCanceled & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageKey : public CDCMessage {
public:
	/** */
	CMessageKey() : CDCMessage(DC_MESSAGE_KEY) {};
	/** */
	virtual ~CMessageKey() {};

	/** */
	CMessageKey & operator = (const CMessageKey & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageBadPass : public CDCMessage {
public:
	/** */
	CMessageBadPass() : CDCMessage(DC_MESSAGE_BADPASS) {};
	/** */
	virtual ~CMessageBadPass() {};

	/** */
	CMessageBadPass & operator = (const CMessageBadPass & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageLogedIn : public CDCMessage {
public:
	/** */
	CMessageLogedIn() : CDCMessage(DC_MESSAGE_LOGEDIN) {};
	/** */
	virtual ~CMessageLogedIn() {};

	/** */
	CMessageLogedIn & operator = (const CMessageLogedIn & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick = p.m_sNick;

		return *this;
	};

	/** */
	CString m_sNick;
};

class DLL_EXPORT CMessageSend : public CDCMessage {
public:
	/** */
	CMessageSend() : CDCMessage(DC_MESSAGE_SEND) {};
	/** */
	virtual ~CMessageSend() {};

	/** */
	CMessageSend & operator = (const CMessageSend & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageValidateDenide : public CDCMessage {
public:
	/** */
	CMessageValidateDenide() : CDCMessage(DC_MESSAGE_VALIDATEDENIDE) {};
	/** */
	virtual ~CMessageValidateDenide() {};

	/** */
	CMessageValidateDenide & operator = (const CMessageValidateDenide & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageHubIsFull : public CDCMessage {
public:
	/** */
	CMessageHubIsFull() : CDCMessage(DC_MESSAGE_HUBISFULL) {};
	/** */
	virtual ~CMessageHubIsFull() {};

	/** */
	CMessageHubIsFull & operator = (const CMessageHubIsFull & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageMaxedOut : public CDCMessage {
public:
	/** */
	CMessageMaxedOut() : CDCMessage(DC_MESSAGE_MAXEDOUT) {};
	/** */
	virtual ~CMessageMaxedOut() {};

	/** */
	CMessageMaxedOut & operator = (const CMessageMaxedOut & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageGetListLen : public CDCMessage {
public:
	/** */
	CMessageGetListLen() : CDCMessage(DC_MESSAGE_GETLISTLEN) {};
	/** */
	virtual ~CMessageGetListLen() {};

	/** */
	CMessageGetListLen & operator = (const CMessageGetListLen & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		return *this;
	};
};

class DLL_EXPORT CMessageLock : public CDCMessage {
public:
	/** */
	CMessageLock() : CDCMessage(DC_MESSAGE_LOCK) {
		m_eClientVersion = eucvNONE;
		m_bExtProtocol   = FALSE;
		m_nVersionMajor  = 0;
		m_nVersionMinor  = 0;
		m_nVersionPatch  = 0;
	};
	/** */
	virtual ~CMessageLock() {};

	/** */
	CMessageLock & operator = (const CMessageLock & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sPK            = p.m_sPK;
		m_sData          = p.m_sData;
		m_eClientVersion = p.m_eClientVersion;
		m_sVersionString = p.m_sVersionString;
		m_nVersionMajor  = p.m_nVersionMajor;
		m_nVersionMinor  = p.m_nVersionMinor;
		m_nVersionPatch  = p.m_nVersionPatch;
		m_bExtProtocol   = p.m_bExtProtocol;

		return *this;
	};

	/** */
	CString m_sPK;
	/** */
	CString m_sData;
	/** */
	eUserClientVersion m_eClientVersion;
	/** */
	CString m_sVersionString;
	/** */
	int m_nVersionMajor;
	/** */
	int m_nVersionMinor;
	/** */
	int m_nVersionPatch;
	/** */
	bool m_bExtProtocol;
};

class DLL_EXPORT CMessageFileLength : public CDCMessage {
public:
	/** */
	CMessageFileLength() : CDCMessage(DC_MESSAGE_FILELENGTH) {
		m_nFileLength = 0;
	};
	/** */
	virtual ~CMessageFileLength() {};

	/** */
	CMessageFileLength & operator = (const CMessageFileLength & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_nFileLength = p.m_nFileLength;

		return *this;
	};

	/** */
	ulonglong m_nFileLength;
};

class DLL_EXPORT CMessageDirection : public CDCMessage {
public:
	/** */
	CMessageDirection() : CDCMessage(DC_MESSAGE_DIRECTION) {
		m_nLevel     = 0;
		m_eDirection = edNONE;
	};
	/** */
	virtual ~CMessageDirection() {};

	/** */
	CMessageDirection & operator = (const CMessageDirection & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_eDirection = p.m_eDirection;
		m_nLevel     = p.m_nLevel;

		return *this;
	};

	/** */
	eDirection m_eDirection;
	/** */
	int m_nLevel;
};

class DLL_EXPORT CMessageNickList : public CDCMessage {
public:
	/** */
	CMessageNickList() : CDCMessage(DC_MESSAGE_NICKLIST) {};
	/** */
	virtual ~CMessageNickList() {};

	CMessageNickList & operator = (const CMessageNickList & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		// TODO: copy list

		return *this;
	};

	/** */
	CList<CString> m_NickList;
};

class DLL_EXPORT CMessageNick : public CDCMessage {
public:
	/** */
	CMessageNick() {};
	/** */
	virtual ~CMessageNick() {};

	CMessageNick & operator = (const CMessageNick & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick = p.m_sNick;

		return *this;
	};

	/** */
	CString m_sNick;
};

class DLL_EXPORT CMessageMyNick : public CDCMessage {
public:
	/** */
	CMessageMyNick() : CDCMessage(DC_MESSAGE_MYNICK) {};
	/** */
	virtual ~CMessageMyNick() {};

	CMessageMyNick & operator = (const CMessageMyNick & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick = p.m_sNick;

		return *this;
	};

	/** */
	CString m_sNick;
};

class DLL_EXPORT CMessageHello : public CDCMessage {
public:
	/** */
	CMessageHello() : CDCMessage(DC_MESSAGE_HELLO) {};
	/** */
	virtual ~CMessageHello() {};

	CMessageHello & operator = (const CMessageHello & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick = p.m_sNick;

		return *this;
	};

	/** */
	CString m_sNick;
};

class DLL_EXPORT CMessageQuit : public CDCMessage {
public:
	/** */
	CMessageQuit() : CDCMessage(DC_MESSAGE_QUIT) {};
	/** */
	virtual ~CMessageQuit() {};

	CMessageQuit & operator = (const CMessageQuit & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick = p.m_sNick;

		return *this;
	};

	/** */
	CString m_sNick;
};

class DLL_EXPORT CMessageChat : public CDCMessage {
public:
	/** */
	CMessageChat() : CDCMessage(DC_MESSAGE_CHAT) {};
	/** */
	virtual ~CMessageChat() {};

	CMessageChat & operator = (const CMessageChat & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick    = p.m_sNick;
		m_sMessage = p.m_sMessage;

		return *this;
	};

	/** */
	CString m_sNick;
	/** */
	CString m_sMessage;
};

class DLL_EXPORT CMessageMyInfo : public CDCMessage {
public:
	/** */
	CMessageMyInfo() : CDCMessage(DC_MESSAGE_MYINFO) {
		m_nShared        = 0;
		m_bOperator      = FALSE;
		m_eAwayMode      = euamNONE;
		m_eClientVersion = eucvNONE;
		m_nFreeSlot      = 0;
		m_nMaxSlot       = 0;
		m_eUserSpeed     = eusUNKNOWN;
		m_eClientMode    = ecmNONE;
	};
	/** */
	virtual ~CMessageMyInfo() {};

	/** */
	CMessageMyInfo & operator = (const CMessageMyInfo & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick          = p.m_sNick;
		m_sComment       = p.m_sComment;
		m_sUnknown       = p.m_sUnknown;
		m_eUserSpeed     = p.m_eUserSpeed;
		m_sUserSpeed     = p.m_sUserSpeed;
		m_sEMail         = p.m_sEMail;
		m_nShared        = p.m_nShared;
		m_eAwayMode      = p.m_eAwayMode;
		m_bOperator      = p.m_bOperator;
		m_sVerComment    = p.m_sVerComment;
		m_eClientVersion = p.m_eClientVersion;
		m_eClientMode    = p.m_eClientMode;
		m_nFreeSlot      = p.m_nFreeSlot;
		m_nMaxSlot       = p.m_nMaxSlot;
		m_sTransferHost  = p.m_sTransferHost;
		m_MessageLock    = p.m_MessageLock;
		m_MessageSupports = p.m_MessageSupports;

		return *this;
	};

	/** the nickname */
	CString m_sNick;
	/** the comment */
	CString m_sComment;
	/** */
	CString m_sUnknown;
	/** parsed speed */
	eUserSpeed m_eUserSpeed;
	/** the speed string */
	CString m_sUserSpeed;
	/** the email */
	CString m_sEMail;
	/** sharesize */
	ulonglong m_nShared;
	/** away mode */
	eUserAwayMode m_eAwayMode;
	/** operator status */
	bool m_bOperator;
	/** version */
	CString m_sVerComment;
	/** parsed client version */
	eUserClientVersion m_eClientVersion;
	/** client mode */
	eClientMode m_eClientMode;
	/** free slots */
	unsigned int m_nFreeSlot;
	/** max slots */
	unsigned int m_nMaxSlot;
	/** */
	CString m_sTransferHost;
	/** */
	CMessageLock m_MessageLock;
	/** */
	CMessageSupports m_MessageSupports;
};

class DLL_EXPORT CMessageConnectToMe : public CDCMessage {
public:
	/** */
	CMessageConnectToMe() : CDCMessage(DC_MESSAGE_CONNECTTOME) {
		m_nPort = 0;
	};
	/** */
	virtual ~CMessageConnectToMe() {};

	CMessageConnectToMe & operator = (const CMessageConnectToMe & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick = p.m_sNick;
		m_sHost = p.m_sHost;
		m_nPort = p.m_nPort;

		return *this;
	};

	/** */
	CString m_sNick;
	/** */
	CString m_sHost;
	/** */
	int m_nPort;
};

class DLL_EXPORT CMessageRevConnectToMe : public CDCMessage {
public:
	/** */
	CMessageRevConnectToMe() : CDCMessage(DC_MESSAGE_REVCONNECTTOME) {};
	/** */
	virtual ~CMessageRevConnectToMe() {};

	CMessageRevConnectToMe & operator = (const CMessageRevConnectToMe & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick    = p.m_sNick;
		m_sDstNick = p.m_sDstNick;

		return *this;
	};

	/** */
	CString m_sNick;
	/** */
	CString m_sDstNick;
};

class DLL_EXPORT CMessageSearch : public CDCMessage {
public:
	/** */
	CMessageSearch() : CDCMessage(DC_MESSAGE_SEARCH) {
		m_bLocal      = FALSE;
		m_nPort       = 0;
		m_bSizeLimit  = FALSE;
		m_bSizeAtMost = FALSE;
		m_nSize       = 0;
		m_eFileType   = eftUNKNOWN;
		m_bExtended   = FALSE;
	};
	/** */
	virtual ~CMessageSearch() {};

	/** */
	CMessageSearch & operator = (const CMessageSearch & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_bLocal      = p.m_bLocal;
		m_sSource     = p.m_sSource;
		m_nPort       = p.m_nPort;
		m_bSizeLimit  = p.m_bSizeLimit;
		m_bSizeAtMost = p.m_bSizeAtMost;
		m_nSize       = p.m_nSize;
		m_eFileType   = p.m_eFileType;
		m_sString     = p.m_sString;
		m_bExtended   = p.m_bExtended;

		return *this;
	};

	/** local or global search */
	bool m_bLocal;
	/** the source, nick or host */
	CString m_sSource;
	/** if source a host, this is the port */
	int m_nPort;
	/** search options */
	bool m_bSizeLimit;
	/** search options */
	bool m_bSizeAtMost;
	/** search options */
	ulonglong m_nSize;
	/** search options */
	eFileTypes m_eFileType;
	/** search string */
	CString m_sString;
	/** extended protocol */
	bool m_bExtended;
};

class DLL_EXPORT CMessageForceMove : public CDCMessage {
public:
	/** */
	CMessageForceMove() : CDCMessage(DC_MESSAGE_FORCEMOVE) {
		m_nPort = 0;
	};
	/** */
	virtual ~CMessageForceMove() {};

	/** */
	CMessageForceMove & operator = (const CMessageForceMove & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sHost = p.m_sHost;
		m_nPort = p.m_nPort;

		return *this;
	};

	/** */
	CString m_sHost;
	/** */
	int m_nPort;
};

class DLL_EXPORT CMessageSearchResult : public CDCMessage {
public:
	/** */
	CMessageSearchResult() : CDCMessage(DC_MESSAGE_SEARCHRESULT) {
		m_nFreeSlot = 0;
		m_nMaxSlot  = 0;
		m_nSize     = 0;
	};
	/** */
	virtual ~CMessageSearchResult() {};

	/** */
	CMessageSearchResult & operator = (const CMessageSearchResult & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sNick     = p.m_sNick;
		m_sFile     = p.m_sFile;
		m_nSize     = p.m_nSize;
		m_sHubName  = p.m_sHubName;
		m_sHubHost  = p.m_sHubHost;
		m_sHash     = p.m_sHash;
		m_nFreeSlot = p.m_nFreeSlot;
		m_nMaxSlot  = p.m_nMaxSlot;

		return *this;
	};

	/** */
	CString m_sNick;
	/** */
	CString m_sFile;
	/** */
	ulonglong m_nSize;
	/** */
	CString m_sHubName;
	/** */
	CString m_sHubHost;
	/** */
	CString m_sHash;
	/** */
	unsigned int m_nFreeSlot;
	/** */
	unsigned int m_nMaxSlot;
};

class DLL_EXPORT CMessagePrivateChat : public CDCMessage {
public:
	/** */
	CMessagePrivateChat() : CDCMessage(DC_MESSAGE_PRIVATECHAT) {
		m_eSecureState = esecsNONE;
	};
	/** */
	virtual ~CMessagePrivateChat() {};

	/** */
	CMessagePrivateChat & operator = (const CMessagePrivateChat & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sDstNick      = p.m_sDstNick;
		m_sSrcNick      = p.m_sSrcNick;
		m_sMultiSrcNick = p.m_sMultiSrcNick;
		m_sMessage      = p.m_sMessage;
		m_eSecureState  = p.m_eSecureState;

		return *this;
	};

	/** */
	CString m_sDstNick;
	/** */
	CString m_sSrcNick;
	/** */
	CString m_sMultiSrcNick;
	/** */
	CString m_sMessage;
	/** */
	eSecureState m_eSecureState;
};

class DLL_EXPORT CMessageHubName : public CDCMessage {
public:
	/** */
	CMessageHubName() : CDCMessage(DC_MESSAGE_HUBNAME) {};
	/** */
	virtual ~CMessageHubName() {};

	/** */
	CMessageHubName & operator = (const CMessageHubName & p)
	{
		(CDCMessage&)*this = (CDCMessage&)p;

		m_sHubName    = p.m_sHubName;
		m_sOldHubName = p.m_sOldHubName;

		return *this;
	};
	
	/** */
	CString m_sHubName;
	/** */
	CString m_sOldHubName;
};

// download manager object classes

class DLL_EXPORT CMessageDMFileObject : public CDCMessage {
public:
	/** */
	CMessageDMFileObject() : CDCMessage(DC_MESSAGE_FILE_OBJECT) {
		m_tTimeout           = 0;
		m_eTransferWaitState = etwsWAIT;
		m_nConnections       = 0;
		m_eTransferFileState = etfsNONE;
		m_nSize              = 0;
		m_nStartPosition     = 0;
		m_nCurrentPosition   = 0;
		m_nEndPosition       = 0;
		m_bMulti             = FALSE;
		m_bRemoveFile        = FALSE;
		m_nPriority          = 0;
	};
	/** */
	virtual ~CMessageDMFileObject() {};

	/** */
	CMessageDMFileObject & operator = (const CMessageDMFileObject & p)
	{
		m_sNick              = p.m_sNick;
		m_sHubName           = p.m_sHubName;
		m_sHubHost           = p.m_sHubHost;
		m_tTimeout           = p.m_tTimeout;
		m_eTransferWaitState = p.m_eTransferWaitState;
		m_nConnections       = p.m_nConnections;
		m_sRemoteFile        = p.m_sRemoteFile;
		m_sLocalFile         = p.m_sLocalFile;
		m_eTransferFileState = p.m_eTransferFileState;
		m_nSize              = p.m_nSize;
		m_nStartPosition     = p.m_nStartPosition;
		m_nCurrentPosition   = p.m_nCurrentPosition;
		m_nEndPosition       = p.m_nEndPosition;
		m_bMulti             = p.m_bMulti;
		m_bRemoveFile        = p.m_bRemoveFile;
		m_nPriority          = p.m_nPriority;

		return *this;
	};

	/** */
	CString m_sNick;
	/** */
	CString m_sHubName;
	/** */
	CString m_sHubHost;
	/** */
	time_t m_tTimeout;
	/** */
	eTransferWaitState m_eTransferWaitState;
	/** */
	int m_nConnections;
	/** remote file */
	CString m_sRemoteFile;
	/** the local file */
	CString m_sLocalFile;
	/** */
	eTransferFileState m_eTransferFileState;
	/** file size */
	ulonglong m_nSize;
	/** current file position */
	ulonglong m_nStartPosition;
	/** current file position */
	ulonglong m_nCurrentPosition;
	/** file end position */
	ulonglong m_nEndPosition;
	/** */
	bool m_bMulti;
	/** */
	bool m_bRemoveFile;
	/** */
	int m_nPriority;
};

class DLL_EXPORT CMessageDMTransferObject : public CDCMessage {
public:
	/** */
	CMessageDMTransferObject() : CDCMessage(DC_MESSAGE_TRANSFER_OBJECT) {
		m_nTransferID    = 0;
		lSize            = 0;
		lSizeDone        = 0;
		lRate            = 0;
		lStartPosition   = 0;
		lTransfered      = 0;
		lEndPosition     = 0;
		eState           = estNONE;
		bRemoveTransfer  = FALSE;
		m_nMultiRate     = 0;
		m_bEncrypted     = FALSE;
	};
	/** */
	virtual ~CMessageDMTransferObject() {};

	/** */
	CMessageDMTransferObject & operator = (const CMessageDMTransferObject & p)
	{
		m_nTransferID   = p.m_nTransferID;
		m_sSrcNick      = p.m_sSrcNick;
		m_sDstNick      = p.m_sDstNick;
		sHost           = p.sHost;
		m_sHubHost      = p.m_sHubHost;
		sHubName        = p.sHubName;
		m_sDstFile      = p.m_sDstFile;
		m_sSrcFile      = p.m_sSrcFile;
		lSize           = p.lSize;
		lSizeDone       = p.lSizeDone;
		lRate           = p.lRate;
		m_nMultiRate    = p.m_nMultiRate;
		lStartPosition  = p.lStartPosition;
		lTransfered     = p.lTransfered;
		lEndPosition    = p.lEndPosition;
		bRemoveTransfer = p.bRemoveTransfer;
		m_bEncrypted    = p.m_bEncrypted;

		return *this;
	};

	/** */
	ulonglong m_nTransferID;
	/** */
	CString m_sSrcNick;
	/** */
	CString m_sDstNick;
	/** */
	CString sHost;
	/** */
	CString m_sHubHost;
	/** */
	CString sHubName;
	/** */
	eConnectionState eState;

	/** remote file */
	CString m_sDstFile;
	/** local file */
	CString m_sSrcFile;
	/** file size */
	ulonglong lSize;
	/** file size done */
	ulonglong lSizeDone;
	/** rate of transfer */
	ulonglong lRate;
	/** rate of all transfers */
	ulonglong m_nMultiRate;
	/** */
	ulonglong lStartPosition;
	/** */
	ulonglong lTransfered;
	/** */
	ulonglong lEndPosition;
	/** */
	bool bRemoveTransfer;
	/** */
	bool m_bEncrypted;
};

class DLL_EXPORT CMessageDMFileListObject : public CDCMessage {
public:
	/** */
	CMessageDMFileListObject() : CDCMessage(DC_MESSAGE_FILELIST_OBJECT) {};
	/** */
	virtual ~CMessageDMFileListObject() {};

	/** */
	CMessageDMFileListObject & operator = (const CMessageDMFileListObject & p)
	{
		sNick      = p.sNick;
		sHubName   = p.sHubName;
		sHubHost   = p.sHubHost;
		sLocalFile = p.sLocalFile;

		return *this;
	};

	/** */
	CString sNick;
	/** */
	CString sHubName;
	/** */
	CString sHubHost;
	/** */
	CString sLocalFile;
};

class DLL_EXPORT CMessageDMSlotObject : public CDCMessage {
public:
	/** */
	CMessageDMSlotObject() : CDCMessage(DC_MESSAGE_SLOT_OBJECT) {
		iSlots     = 0;
		bPermanent = FALSE;
	};
	/** */
	virtual ~CMessageDMSlotObject() {};

	/** */
	CString sNick;
	/** */
	CString sHubName;
	/** */
	int iSlots;
	/** */
	bool bPermanent;
};

class DLL_EXPORT CMessageLog : public CDCMessage {
public:
	/** */
	CMessageLog() : CDCMessage(DC_MESSAGE_LOG) {};
	/** */
	virtual ~CMessageLog() {};

	/** */
	CString sMessage;
};

class DLL_EXPORT CMessageSearchUser : public CMessageNick {
public:
	/** */
	CMessageSearchUser() {
		m_eType = DC_MESSAGE_SEARCH_USER;
	};
	/** */
	virtual ~CMessageSearchUser() {};
};

class DLL_EXPORT CMessageSearchResultUser : public CMessageMyInfo {
public:
	/** */
	CMessageSearchResultUser() {
		m_eType = DC_MESSAGE_SEARCHRESULT_USER;
	};
	/** */
	virtual ~CMessageSearchResultUser() {};

	/** */
	CString m_sHubName;
};

class DLL_EXPORT CMessageSearchFile : public CMessageSearch {
public:
	/** */
	CMessageSearchFile() {
		m_eType  = DC_MESSAGE_SEARCH_FILE;
		m_bMulti = FALSE;
	};
	/** */
	virtual ~CMessageSearchFile() {};

	/** hub network search */
	bool m_bMulti;
};

class DLL_EXPORT DCHubObject : public CObject {
public:
	/** */
	DCHubObject() {
		m_bActive = FALSE;
	}
	/** */
	DCHubObject( DCHubObject * o ) {
		m_bActive  = o->m_bActive;
		m_sHubName = o->m_sHubName;
		m_sHubHost = o->m_sHubHost;
	}

	/** */
	virtual ~DCHubObject() {};

	/** */
	bool m_bActive;
	/** */
	CString m_sHubName;
	/** */
	CString m_sHubHost;
};

class DLL_EXPORT DCMessageTraffic : public CDCMessage {
public:
	/** */
	DCMessageTraffic() : CDCMessage(DC_MESSAGE_TRAFFIC) {
		m_nRx        = 0;
		m_nTx        = 0;
		m_nDataRx    = 0;
		m_nDataTx    = 0;
		m_nControlRx = 0;
		m_nControlTx = 0;
	}
	/** */
	virtual ~DCMessageTraffic() {};

	DCMessageTraffic & operator = (const DCMessageTraffic & s)
	{
		m_nRx        = s.m_nRx;
		m_nTx        = s.m_nTx;
		m_nDataRx    = s.m_nDataRx;
		m_nDataTx    = s.m_nDataTx;
		m_nControlRx = s.m_nControlRx;
		m_nControlTx = s.m_nControlTx;

		return *this;
	};

	/** */
	ulonglong m_nRx;
	/** */
	ulonglong m_nTx;
	/** */
	ulonglong m_nDataRx;
	/** */
	ulonglong m_nDataTx;
	/** */
	ulonglong m_nControlRx;
	/** */
	ulonglong m_nControlTx;
};

class DLL_EXPORT DCMessageGetHubList : public CDCMessage {
public:
	/** */
	DCMessageGetHubList() : CDCMessage(DC_MESSAGE_GETHUBLIST) {
		m_bRun = FALSE;
	}
	/** */
	virtual ~DCMessageGetHubList() {};

	/** */
	bool m_bRun;
};

class DLL_EXPORT DCMessageConnectClient : public CDCMessage {
public:
	/** */
	DCMessageConnectClient() : CDCMessage(DC_MESSAGE_CONNECT_CLIENT) {
	}
	/** */
	virtual ~DCMessageConnectClient() {};

	/** */
	CString m_sHubName;
	/** */
	CString m_sHubHost;
};

#endif
