/***************************************************************************
                           csharelist.cpp  -  description
                             -------------------
    begin                : Mon May 12 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef WIN32
#include <unistd.h>
#include <stdlib.h>
#endif

#include <dclib/core/che3.h>
#include <dclib/core/cbz.h>
#include <dclib/core/cdir.h>
#include <dclib/core/cbytearray.h>
#include <dclib/cconfig.h>

#include "csharelist.h"

/** */
CShareList::CShareList()
{
	m_nShareSize      = 0;
	m_pHE3ShareBuffer = 0;
	m_pBZShareBuffer  = 0;
}

/** */
CShareList::~CShareList()
{
	m_MutexShareList.Lock();

	if ( m_pHE3ShareBuffer )
	{
		delete m_pHE3ShareBuffer;
		 m_pHE3ShareBuffer = 0;
	}

	if ( m_pBZShareBuffer )
	{
		delete m_pBZShareBuffer;
		m_pBZShareBuffer = 0;
	}

	m_MutexShareList.UnLock();
}

/** */
bool CShareList::Load()
{
	CDir dir;
	ulonglong size;
	int err;
	FILE * in;
	CString s,s1,*share,slength;
	CHE3 *he3;
	CBZ * bz2;
	CByteArray ba;
	long i,j,d;
	ulonglong sharesize;

	m_MutexShareList.Lock();

	err = -1;

	m_nShareSize = 0;

	if ( m_pHE3ShareBuffer )
	{
		delete m_pHE3ShareBuffer;
		m_pHE3ShareBuffer = 0;
	}

	if ( m_pBZShareBuffer )
	{
		delete m_pBZShareBuffer;
		m_pBZShareBuffer = 0;
	}

	// load he3 compressed list
	s = CConfig::Instance()->GetConfigPath() + DC_USER_FILELIST_HE3;

	size = dir.getFileSize(s,FALSE);

	if ( size != 0 )
	{
		if ( (in = fopen(s.Data(),"r+b")) != 0 )
		{
			ba.SetSize(size);

			if ( fread( ba.Data(), 1, size, in ) == size )
			{
				m_pHE3ShareBuffer = new CByteArray();
				m_pHE3ShareBuffer->Append(ba.Data(),ba.Size());

				he3 = new CHE3();
				share = he3->decode_he3_data(m_pHE3ShareBuffer);
				delete he3;

				if ( share == 0 )
				{
					delete m_pHE3ShareBuffer;
					m_pHE3ShareBuffer = 0;
				}
				else
				{
					sharesize = 0;
					i = j = 0;
					CString fi="\xD\xA";
					while((i=share->Find(fi,j))>0)
					{
						s1 = share->Mid(j,i-j);

						if ( s1 != "" )
						{
							d = s1.FindRev('|');
							if ( d != -1 )
							{
								sharesize += s1.Mid(d+1,s1.Length()-d-1).asULL();
							}
						}

						j = i+2;
					}

					if ( sharesize == 0 )
					{
						delete m_pHE3ShareBuffer;
						m_pHE3ShareBuffer = 0;
					}
					else
					{
						m_nShareSize = sharesize;
						err = 0;
					}

					delete share;
				}
			}

			fclose(in);
		}
	}

#ifdef HAVE_LIBBZ2
	// load bz compressed list
	s = CConfig::Instance()->GetConfigPath() + DC_USER_FILELIST_BZ;

	size = dir.getFileSize(s,FALSE);

	if ( (size != 0) && (m_pHE3ShareBuffer) )
	{
		if ( (in = fopen(s.Data(),"r+b")) != 0 )
		{
			ba.SetSize(size);

			if ( fread( ba.Data(), 1, size, in ) == size )
			{
				m_pBZShareBuffer = new CByteArray();
				m_pBZShareBuffer->Append(ba.Data(),ba.Size());

				bz2 = new CBZ();

				if ( bz2->Decompress(m_pBZShareBuffer,&ba) == FALSE )
				{
					delete m_pBZShareBuffer;
					m_pBZShareBuffer = 0;
				}
				else
				{
					share = new CString();
					
					share->Set( (const char *)ba.Data(), ba.Size() );

					sharesize = 0;
					i = j = 0;
					CString fi="\xD\xA";
					while((i=share->Find(fi,j))>0)
					{
						s1 = share->Mid(j,i-j);

						if ( s1 != "" )
						{
							d = s1.FindRev('|');

							if ( d != -1 )
							{
								sharesize += s1.Mid(d+1,s1.Length()-d-1).asULL();
							}
						}

						j = i+2;
					}

					if ( sharesize != m_nShareSize )
					{
						delete m_pBZShareBuffer;
						m_pBZShareBuffer = 0;
						delete m_pHE3ShareBuffer;
						m_pHE3ShareBuffer = 0;

						m_nShareSize = 0;

						err = -1;
					}
					else
					{
						err = 0;
					}

					delete share;
				}

				delete bz2;
			}

			fclose(in);
		}
	}
#endif

	m_MutexShareList.UnLock();

	return (err==0);
}

/** */
void CShareList::Save()
{
	FILE * out;
	CString s;

	m_MutexShareList.Lock();

	// save he3 compressed list
	s = CConfig::Instance()->GetConfigPath() + DC_USER_FILELIST_HE3;

	if ( (out = fopen(s.Data(),"wb")) != 0 )
	{
		if ( m_pHE3ShareBuffer )
		{
			if ( fwrite( m_pHE3ShareBuffer->Data(), m_pHE3ShareBuffer->Size(), 1, out ) == (ulonglong)m_pHE3ShareBuffer->Size() )
			{
			}
		}

		fclose(out);
	}
	else
	{
		printf("[ERROR] open %s\n",s.Data());
	}

	// save bz compressed list
	s = CConfig::Instance()->GetConfigPath() + DC_USER_FILELIST_BZ;

	if ( (out = fopen(s.Data(),"wb")) != 0 )
	{
		if ( m_pBZShareBuffer )
		{
			if ( fwrite( m_pBZShareBuffer->Data(), m_pBZShareBuffer->Size(), 1, out ) == (ulonglong)m_pBZShareBuffer->Size() )
			{
			}
		}

		fclose(out);
	}
	else
	{
		printf("[ERROR] open %s\n",s.Data());
	}

	m_MutexShareList.UnLock();
}

/** */
void CShareList::SetShareBuffer( CString sharebuffer, ulonglong size )
{
	CByteArray * ba;
	CByteArray iba;
	CHE3  * he3;
	CBZ * bz;

	m_MutexShareList.Lock();

	if ( sharebuffer == "" )
	{
		m_nShareSize = 0;
	}
	else
	{
		m_nShareSize = size;
	}

	if ( m_pHE3ShareBuffer )
	{
		delete m_pHE3ShareBuffer;
		m_pHE3ShareBuffer = 0;
	}

	if ( m_pBZShareBuffer )
	{
		delete m_pBZShareBuffer;
		m_pBZShareBuffer = 0;
	}

	if ( sharebuffer != "" )
	{
		// he3 compression
		he3 = new CHE3();
		ba = he3->encode_he3_data(&sharebuffer);
		delete he3;

		if ( ba != 0 )
		{
			m_pHE3ShareBuffer = ba;
		}
		else
		{
			printf("[ERROR] he3 compression failed\n");
		}

		// bz compression
		m_pBZShareBuffer = new CByteArray();

		iba.Append(sharebuffer.Data(),sharebuffer.Length());

		bz = new CBZ();
		if ( !bz->Compress(&iba,m_pBZShareBuffer) )
		{
			delete m_pBZShareBuffer;
			m_pBZShareBuffer = 0;
			printf("[ERROR] bz2 compression failed\n");
		}
		delete bz;
	}

	m_MutexShareList.UnLock();

	// save share list
	Save();
}

/** */
int CShareList::GetShareBuffer( eShareBufferType type, CByteArray * sharebuffer )
{
	int err;

	m_MutexShareList.Lock();

	err = 0;

	if( !sharebuffer )
	{
		err = -1;
	}
	else
	{
		switch(type)
		{
			case esbtHE3:
				if ( !m_pHE3ShareBuffer )
					err = -1;
				else
					sharebuffer->Append(m_pHE3ShareBuffer->Data(),m_pHE3ShareBuffer->Size());
				break;
			case esbtBZ:
				if ( !m_pBZShareBuffer )
					err = -1;
				else
					sharebuffer->Append(m_pBZShareBuffer->Data(),m_pBZShareBuffer->Size());
				break;
			default:
				err = -1;
				break;
		}
	}

	m_MutexShareList.UnLock();

	return err;
}

/** */
unsigned long CShareList::GetShareBufferSize( eShareBufferType type )
{
	unsigned long i;

	m_MutexShareList.Lock();

	i = 0;

	switch(type)
	{
		case esbtHE3:
			if ( m_pHE3ShareBuffer )
				i = m_pHE3ShareBuffer->Size();
			break;
		case esbtBZ:
			if ( m_pBZShareBuffer )
				i = m_pBZShareBuffer->Size();
			break;
		case esbtXMLBZ:
			break;
		default:
			break;
	}

	m_MutexShareList.UnLock();

	return i;
}

/** */
ulonglong CShareList::GetShareSize() const
{
	return m_nShareSize;
}
