/***************************************************************************
                           csearchindex.h  -  description
                             -------------------
    begin                : Mon May 14 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSEARCHINDEX_H
#define CSEARCHINDEX_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>

#pragma pack(1)

typedef struct filebaseobject {
	/** */
	unsigned int m_eFileType;
	/** */
	ulonglong m_nSize;
	/** */
	unsigned long m_nPathIndex;
	/** */
	unsigned long m_nFileIndex;
	/** */
	unsigned long m_nHashIndex;
	/** */
	time_t m_tModTime;
} filebaseobject;

typedef struct searchindexobject {
	/** */
	unsigned long m_nIndex;
	/** */
	unsigned long m_nFileIndex;
} searchindexobject;

typedef struct fileindexobject {
	/** */
	ulonglong m_nFileBaseIndex;
	/** */
	unsigned long m_nNext;
} fileindexobject;

typedef struct long_s {
	/** */
	unsigned long n;
} long_s;

#pragma pack()

class CByteArray;

class DLL_EXPORT CSearchIndex : public CObject {

public:
	/** */
	CSearchIndex();
	/** */
	virtual ~CSearchIndex();

	/** */
	bool LoadIndex();
	/** */
	void SaveIndex();
	/** */
	void Reset();
	/** */
	void ResetIndex();
	/** */
	void InitIndex();

	/** */
	CStringList * Search( CString s );

	/** */
	bool GetFileBaseObject( CString id, struct filebaseobject * fbo, CString & filename );

	/** */
	CString GetFileName( ulonglong i );
	/** */
	void AddIndex( CString & s, ulonglong filebaseindex );
	/** */
	void AddIndex( CFileInfo *fileinfo, CString path, eFileTypes filetype );
	/** */
	unsigned long IndexCount();
private:
	/** */
	struct searchindexobject * FindIndex( CString & s );
	/** */
	struct searchindexobject * SearchIndex( CString & s );

	/** */
	CByteArray * m_pFileBaseArray;
	/** */
	CByteArray * m_pPathBaseArray;
	/** */
	CByteArray * m_pBaseArray;
	/** */
	CByteArray * m_pSearchIndex;
	/** */
	CByteArray * m_pSearchFileIndex;
	/** */
	CByteArray * m_pSearchBase;
	/** */
	CByteArray * m_pSearchArray[0x100];
	/** */
	struct long_s * m_nSearchFileIndex;
};

#endif
