/***************************************************************************
                           cpluginmanager.cpp  -  description
                             -------------------
    begin                : Fri Sep 27 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifndef WIN32
#include <dlfcn.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/cdir.h>
#include <dclib/core/cplugin.h>
#include <dclib/cconfig.h>
#include <dclib/core/cmanager.h>
#include <dclib/cconnectionmanager.h>
#include <dclib/cfilemanager.h>

#include "cpluginmanager.h"

/** */
CPluginManager::CPluginManager()
{
	m_pPluginInstance = new CPluginInstance();

	m_pPluginInstance->m_pConfig            = CConfig::Instance();
	m_pPluginInstance->m_pManager           = CManager::Instance();
	m_pPluginInstance->m_pDownloadManager   = CDownloadManager::Instance();
	m_pPluginInstance->m_pConnectionManager = CConnectionManager::Instance();
	m_pPluginInstance->m_pFileManager       = CFileManager::Instance();

	m_pPluginList     = new CList<CPluginObject>();

	SetInstance(this);
}

/** */
CPluginManager::~CPluginManager()
{
	SetInstance(0);

	if ( m_pPluginList )
	{
		delete m_pPluginList;
		m_pPluginList = 0;
	}

	if ( m_pPluginInstance )
	{
		delete m_pPluginInstance;
		m_pPluginInstance = 0;
	}
}

typedef ePluginStruct* (*PLUGIN_INIT_FUNC)();
typedef int (*PLUGIN_DEINIT_FUNC)();

/** */
void CPluginManager::Load()
{
	CDir dir;
	CList<CFileInfo> list;
	CFileInfo *fileinfo;
	CString path;
	PLUGIN_INIT_FUNC dclib_plugin_init;
	CPluginObject * Plugin;

#ifndef WIN32
	void *h;
#else
	HINSTANCE h;
#endif

	path = CConfig::Instance()->GetDatadir()+DIRSEPARATOR+"plugin";

	// set pluginpath
	dir.SetPath(path);

	// get all files
	if ( dir.ReadEntrys( CDir::Files, &list ) )
	{
		fileinfo = 0;
		while( (fileinfo=list.Next(fileinfo)) != 0 )
		{
#ifdef WIN32
			if ( dir.Extension(fileinfo->name).ToUpper() != "DLL" )
#else
			if ( dir.Extension(fileinfo->name).ToUpper() != "SO" )
#endif
				continue;

			printf("Found plugin: '%s'\n",fileinfo->name.Data());

#ifdef WIN32
			if ( (h = LoadLibraryEx((path+DIRSEPARATOR+fileinfo->name).Data(),NULL,0)) == NULL )
			{
#else
			if ( (h = dlopen( (path+DIRSEPARATOR+fileinfo->name).Data(), RTLD_LAZY )) == NULL )
			{
				printf("Error dlopen %s\n",dlerror());
#endif
				continue;
			}
#ifdef WIN32
			dclib_plugin_init = (PLUGIN_INIT_FUNC)GetProcAddress(h,"dclib_plugin_init");
#else
			dclib_plugin_init = (PLUGIN_INIT_FUNC)dlsym(h, "dclib_plugin_init");
#endif

			if ( dclib_plugin_init == NULL )
			{
#ifndef WIN32
				printf("Error dlsym %s\n",dlerror());
				dlclose(h);
#else
				FreeLibrary(h);
#endif
			}
			else
			{
				Plugin = new CPluginObject();

				Plugin->m_Handle = h;
				Plugin->m_ePluginStruct = dclib_plugin_init();

				Plugin->m_ePluginStruct->m_pPluginInstance = m_pPluginInstance;
				Plugin->m_ePluginStruct->init();

				//ps->deinit();

/*
				if ( Plugin->m_eType == eptNONE )
				{
					printf("Error init plugin\n");
#ifndef WIN32
					dlclose(h);
#else
					FreeLibrary(h);
#endif
					delete Plugin;
					continue;
				}
*/
				m_pPluginList->Add(Plugin);
			}
		}
	}
}

/** */
void CPluginManager::InitPlugins()
{
	CPluginObject * plugin = 0;

	while ( (plugin = m_pPluginList->Next(plugin)) != 0 )
	{
		if ( Init(plugin) == FALSE )
		{
			printf("Init Failed\n");
		}
	}
}

/** */
void CPluginManager::DeInitPlugins()
{
	CPluginObject * plugin = 0;

	while ( (plugin = m_pPluginList->Next(0)) != 0 )
	{
		plugin->m_ePluginStruct->deinit();

#ifndef WIN32
		dlclose(plugin->m_Handle);
#else
		FreeLibrary(plugin->m_Handle);
#endif
		m_pPluginList->Remove(plugin);
		delete plugin;
	}
}

/** */
bool CPluginManager::Init( CPluginObject * plugin )
{
	if ( plugin->m_ePluginStruct->m_eType != eptLIB )
	{
		printf("Plugin != LIB not for me ...\n");
		return FALSE;
	}

	return TRUE;
}
