/***************************************************************************
                          cthread.cpp  -  description
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <dclib/core/clist.h>
#include <dclib/core/ccallback.h>

#include "cthread.h"

/** */
CMutex::CMutex()
{
	int i;

	if ( (i=pthread_mutex_init(&mutex,NULL)) != 0 )
	{
		printf("pthread_mutex_init: %s\n",strerror(i));
	}
}

/** */
CMutex::~CMutex()
{
	int i;

	if ( (i=pthread_mutex_destroy(&mutex)) != 0 )
	{
		printf("pthread_mutex_destroy: %s\n",strerror(i));
	}
}

/** */
int CMutex::Lock()
{
	int i;

	if ( (i=pthread_mutex_lock(&mutex)) != 0 )
	{
		printf("pthread_mutex_lock: %s\n",strerror(i));
	}

	return i;
}

/** */
bool CMutex::TryLock()
{
	return ( pthread_mutex_trylock(&mutex) == 0 );
}

/** */
int CMutex::UnLock()
{
	int i;

	if ( (i=pthread_mutex_unlock(&mutex)) != 0 )
	{
		printf("pthread_mutex_unlock: %s\n",strerror(i));
	}

	return i;
}

CThread::CThread()
{
	_thread_callback_function = 0;

	iStop = 1;
	iRun  = 0;
}

CThread::~CThread()
{
	void * status;

	iStop = 1;

	if ( iRun == 1 )
	{
		pthread_join(thread,&status);
	}

	if ( _thread_callback_function )
	{
		delete _thread_callback_function;
		_thread_callback_function = 0;
	}
}

/** */
int CThread::Start()
{
	if (iRun==1)
		return -1;

	if (iStop==0)
		return -1;

	iStop = 0;

	return pthread_create(&thread, 0, MainThread, this);
}

/** */
int CThread::Stop( bool bHard )
{
	void * status;

	if (iRun==0)
		return -1;

	if (iStop==1)
		return -1;

	iStop=1;

	if ( bHard )
		pthread_join(thread,&status);

	return 0;
}

/** */
void CThread::SetThreadCallBackFunction( _CCallback * callback )
{
	Lock();

	if ( _thread_callback_function )
		delete _thread_callback_function;

	_thread_callback_function = callback;

	UnLock();
}

/** */
void * CThread::MainThread( void * object )
{
	int oldState = 0;
	CThread * pThread;

	pThread = (CThread*)object;

	pThread->iRun = 1;

	pthread_setcancelstate(PTHREAD_CANCEL_DISABLE,&oldState);

	for(;;)
	{
		if ( pThread->iStop == 1 )
		{
			break;
		}
		else
		{
			if ( pThread->_thread_callback_function != 0 )
			{
				pThread->_thread_callback_function->notify(0,0);
			}
			else
			{
				pThread->Thread(0);
			}
		}
	}

	if ( (oldState = pthread_detach(pthread_self())) != 0 )
	{
		printf("CThread: pthread_detach with %d\n",oldState);
	}

	pThread->iRun = 0;
	
	pthread_exit(0);
	return (void*)1;
}

/**
  * Sleep     : milliseconds : 0,001
  * usleep    : microseconds : 0,000001
  * nanosleep : nanoseconds  : 0,000000001
  */
void CThread::NanoSleep( unsigned int millisec )
{
#ifndef WIN32
#ifdef HAVE_NANOSLEEP
	struct timespec req, rem;

	req.tv_sec  = 0;
	req.tv_nsec = millisec*1000*1000;
	rem.tv_sec  = 0;
	rem.tv_nsec = 0;

	while( (nanosleep(&req,&rem) == -1) )
	{
		if ( errno != EINTR )
			break;
		if ( rem.tv_nsec == 0 )
			break;
		req.tv_sec  = 0;
		req.tv_nsec = rem.tv_nsec;
		rem.tv_sec  = 0;
		rem.tv_nsec = 0;
	}
#elif HAVE_USLEEP
	usleep(millisec*1000);
#else
#error "nanosleep or usleep not supported"
#endif
#else
	Sleep(millisec);
#endif
}
