/***************************************************************************
                          cstring.h  -  description
                             -------------------
    begin                : Fri Sep 21 2001
    copyright            : (C) 2001-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSTRING_H
#define CSTRING_H

/**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/cobject.h>

class DLL_EXPORT CString : public CObject {
public:
	/** Constructs a null string.
	    This is a string that has not been assigned to anything, i.e. both the length and data pointer is 0.
	*/
	CString();
	/** Constructs a string that is a deep copy of sz, interpreted as a classic C string. If sz is 0, then a null string is created.
	*/
	CString( const char * sz );
	/** Constructs a string giving it a length of one character, assigning it the character ch.
	*/
	CString( const char ch );
	/** Constructs an implicitly shared copy of stringSrc.
	*/
	CString( const CString & stringSrc );
	/** Destroys the string and frees the "real" string if this is the last copy of that string.
	*/
	virtual ~CString();

	/** */
	void Init();
	/** */
	void Empty();
	/** */
	bool IsEmpty() const;
	/** */
	inline CString& Set( const char * sz, long nLength ) { set(sz,nLength); return *this; }

	/** */
	long Find( const char ch, long nStart = -1 ) const;
	/** */
	long Find( const char * sz, long nStart = -1, bool cs = TRUE ) const;
	/** */
	long Find( const CString & string, long nStart = -1, bool cs = TRUE ) const;
	/** */
	long FindCase( const char * sz, long nStart = -1 ) const;
	/** */
	long FindCase( const CString & string, long nStart = -1 ) const;
	/** */
	long FindRev( char ch, long nStart = -1 ) const;
	/** */
	long FindRev( const CString & string ) const;

	/** */
	void Append( const char ch );
	/** */
	void Append( const CString & string );

	/** */
	inline CString Left( long nCount ) const { return Mid(0,nCount); }
	/** */
	inline CString Right( long nCount ) const { return Mid(Length()-nCount,nCount); };
	/** */
	CString Mid( long nFirst, long nCount = -1 ) const;
	/** */
	CString Section( const char sep, int start, int end ) const;

	/** */
	CString RightJustify( long nNewLength, char chFill = ' ', bool truncate = FALSE );

	/** */
	CString ToUpper();

	/** */
	CString Replace( CString src, CString string ) const;

	/** */
	CString setNum( const int n );
	/** */
	CString setNum( const unsigned int n );
	/** */
	CString setNum( const long n );
	/** */
	CString setNum( const ulonglong n );
	/** */
	CString setNum( const double n, const int p );
	/** */
	ulonglong asULL( int base = 10 ) const;
	/** */
	unsigned int asUINT( int base = 10 ) const;
	/** */
	int asINT( int base = 10 ) const;
	/** */
	long asLONG( int base = 10 ) const;
	/** */
	double asDOUBLE() const;

	/** */
	unsigned char GetHash( long value = 0 ) const;

	/** */
	inline CString& operator += ( const char ch ) { Append(ch); return *this; };
	/** */
	inline CString& operator += ( const char * sz ) { Append(sz); return *this; };
	/** */
	inline CString& operator += ( const CString & string ) { Append(string); return *this; };


	/** */
	inline CString & operator = ( const char * sz ) { set(sz); return *this; };
	/** */
	inline CString & operator = ( const CString & string ) { CString tmp(string);set(tmp.m_szBuffer,tmp.m_nStringLength); return *this; };

	/** */
	inline char * Data() const { return m_szBuffer; }
	/** */
	inline long Length() const { return m_nStringLength; }

private:
#ifdef WIN32
	ulonglong strtoull(const char *nptr, char **endptr, int base) const;
#endif
	/** */
	long m_nStringLength;
	/** */
	long m_nBufferSize;
	/** */
	char * m_szBuffer;

	/** */
	void set( const char * sz, long nLength = -1 );
	/** */
	void add( const char * sz, long nLength = -1 );
};

/** */
DLL_EXPORT bool operator == ( const CString & string1, const CString & string2 );
/** */
DLL_EXPORT bool operator == ( const char * sz, const CString & string );
/** */
DLL_EXPORT bool operator == ( const CString & string, const char * sz );
/** */
DLL_EXPORT bool operator != ( const CString & string1, const CString & string2 );
/** */
DLL_EXPORT bool operator != ( const char * sz, const CString & string );
/** */
DLL_EXPORT bool operator != ( const CString & string1, const char * sz );
/** */
DLL_EXPORT inline CString operator + ( const CString & string1, const CString & string2 ) { CString tmp(string1); tmp.Append(string2); return tmp; }
/** */
DLL_EXPORT inline CString operator + ( const char * sz, const CString & string ) { CString tmp(sz); return (tmp+string); }

#endif
