/***************************************************************************
                           cmanager.cpp  -  description
                             -------------------
    begin                : Thu Jan 23 2003
    copyright            : (C) 2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef WIN32
#include <sys/time.h>
#endif
#include <dclib/dcos.h>
#include <dclib/core/cdir.h>
#include <dclib/core/cplugin.h>
#include <dclib/core/platform.h>

#include "cmanager.h"

/** */
CManager::CManager()
{
	Start();

	SetInstance(this);
}

/** */
CManager::~CManager()
{
	Stop();
}

/** */
void CManager::Add( _CCallback * callback )
{
	if ( callback )
	{
		m_ThreadList.Lock();
		m_ThreadList.Add(callback);
		m_ThreadList.UnLock();
	}
}

/** */
void CManager::Remove( _CCallback * callback )
{
	if ( callback )
	{
		m_ThreadList.Lock();
		m_ThreadList.Remove(callback);
		m_ThreadList.UnLock();
	}
}

/** */
void CManager::Thread( CObject * )
{
	struct timeval tv_old, tv_new;
	_CCallback * callback = 0;
	ulonglong i;

	gettimeofday(&tv_old, NULL);

	while( TRUE )
	{
		m_ThreadList.Lock();

		callback = m_ThreadList.Next(callback);

		m_ThreadList.UnLock();

		if ( !callback )
		{
			break;
		}

		callback->notify(0,0);
	}

	gettimeofday(&tv_new, NULL);

	if ( (tv_new.tv_sec - tv_old.tv_sec) > 0 )
	{
		i = 0;
	}
	else
	{
		i = (tv_new.tv_usec - tv_old.tv_usec);

		if ( i >= 5000 )
		{
			i = 0;
		}
		else
		{
			i = 10 - (i/1000);
		}
	}

	//malloc_stats();

	//printf("%d %d %d\n",i,tv_new.tv_sec - tv_old.tv_sec,(tv_new.tv_usec - tv_old.tv_usec)/1000);

	NanoSleep(i);
}
