/***************************************************************************
                          clistenmanager.cpp  -  description
                             -------------------
    begin                : Sun Feb 29 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#ifndef WIN32
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#endif

#include <dclib/dcos.h>
#include <dclib/dcobject.h>
#include <dclib/core/clisten.h>
#include <dclib/core/cmanager.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/cconfig.h>

#include "clistenmanager.h"

/** */
CListenManager::CListenManager()
{
	printf("CListenManager: start listen\n");

	m_pListen = 0;
	m_nListenPort = 0;
	m_nConnectionWait = 0;
	
	m_pCallback = new CCallback<CListenManager>( this, &CListenManager::ManagerCallback );
	CManager::Instance()->Add( m_pCallback );

	SetInstance(this);
}

/** */
CListenManager::~CListenManager()
{
	SetInstance(0);

	m_Thread.Lock();
	
	if ( m_pCallback )
	{
		if ( CManager::Instance() )
			CManager::Instance()->Remove( m_pCallback );
		delete m_pCallback;
		m_pCallback = 0;
	}
	
	if ( m_pListen )
	{
		m_pListen->SetCallBackFunction(0);
		m_pListen->StopListen();
		
		delete m_pListen;
		m_pListen = 0;
	}
	
	m_Thread.UnLock();
}

/** */
unsigned int CListenManager::GetListenPort( bool connectionwait )
{
	unsigned int n;
	
	m_Thread.Lock();
	
	n = m_nListenPort;
	
	if ( connectionwait && (m_nListenPort != 0) )
	{
		m_nConnectionWait++;
	}
	
	m_Thread.UnLock();
	
	return n;
}

/** */
void CListenManager::AddConnectionWait()
{
	m_Thread.Lock();

	if ( m_nListenPort != 0 )
	{
		m_nConnectionWait++;
	}
	
	m_Thread.UnLock();
}

/** */
void CListenManager::RemoveConnectionWait()
{
	m_Thread.Lock();
	
	if ( m_nConnectionWait > 0 )
	{
		m_nConnectionWait--;
	}

	if ( m_nConnectionWait == 0 )
	{
		// TODO: change port
	}
	
	m_Thread.UnLock();
}

/** */
void CListenManager::StartListen()
{
	int n;

	if ( m_pListen != 0 )
	{
		m_pListen->SetCallBackFunction(0);
		m_pListen->StopListen();
		delete m_pListen;
	}
	
	m_pListen = new CListen();

	// reset listen port
	m_nListenPort = 0;

	// sanity check
	if ( CConfig::Instance() )
	{	
		n = CConfig::Instance()->GetTCPListenPort();
		
		// start listen
		if ( m_pListen->StartListen( n, CConfig::Instance()->GetListenHostString() ) == 0 )
		{
			m_pListen->SetCallBackFunction( new CCallback<CListenManager>( this, &CListenManager::ListenCallback ) );
			
			m_nListenPort = n;
			m_nConnectionWait = 0;
		}
	}
}

/** */
int CListenManager::ManagerCallback( CObject *, CObject * )
{
	m_Thread.Lock();

	// init listen
	if ( m_nListenPort == 0 )
	{
		StartListen();
	}
	else if ( m_pListen )
	{
		// check if listen socket connected
		if ( m_pListen->IsConnect() == -1 )
		{
			printf("relisten on socket\n");
			StartListen();
		}
	}
	
	m_Thread.UnLock();

	return 0;
}

/** */
int CListenManager::ListenCallback( CObject *, CObject * object )
{
	m_Thread.Lock();

	int handle = *((int*)object);

	printf("CListenManager: incoming connection %d\n",handle);
	
	if ( CDownloadManager::Instance() )
	{
		CDownloadManager::Instance()->DM_ListenCallBack(0,object);
	}
	else
	{
#ifdef WIN32
		_close(handle);
#else
		close(handle);
#endif
	}

	m_Thread.UnLock();

	return 0;
}
