/***************************************************************************
                          chubsearch.h  -  description
                             -------------------
    begin                : Fri Mar 15 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHUBSEARCH_H
#define CHUBSEARCH_H

/**
  *@author Mathias Kster
  */

#include <time.h>

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/csingleton.h>
#include <dclib/csearchsocket.h>
#include <dclib/cclient.h>

typedef enum eHubSearchType {
	ehstNONE=0,
	ehstLOCAL,
	ehstGLOBAL,
	ehstWAITTIMEOUT,
	ehstSTOP,
	ehstEXTERNAL
} eHubSearchType;

typedef enum eHubSearchHubs {
	ehshCONNECTEDSINGLE=0,
	ehshCONNECTEDALL,
	ehshPUBLIC,
	ehshBOOKMARK
} eHubSearchHubs;

class CClient;
class CHubSearch;
class CStringList;

class DLL_EXPORT sHubSearchClient : public CClient {
public:
	/** */
	sHubSearchClient() {
		m_bSearchRemove = FALSE;
		m_bSearchEnable = FALSE;
		m_tSearchHubTimeout = 0;
		m_pSearchCurrent = 0;
	};
	/** */
	virtual ~sHubSearchClient() {};

	/** */
	bool m_bSearchRemove;
	/** */
	time_t m_tSearchHubTimeout;
	/** */
	bool m_bSearchEnable;
	/** */
	CObject * m_pSearchCurrent;
	/** */
	time_t m_tSearchTimeout;
};

#ifdef WIN32
template class DLL_EXPORT CSingleton<CHubSearch>;
#endif

class CMessageSearchResult;
class CMessageSearchFile;

class DLL_EXPORT CHubSearch : public CSingleton<CHubSearch> {
public:
	/** */
	CHubSearch();
	/** */
	virtual ~CHubSearch();

	/** callback function */
	virtual int DC_CallBack( CObject * ) { return -1; };

	/** */
	bool ExternalSearch() { return (m_ehSearchType == ehstEXTERNAL); }
	/** */
	bool IsSearch() { return (m_ehSearchType != ehstNONE); }
	/** */
	bool ExternalSearch( bool enabled );

	/** */
	int StartSearch( eHubSearchHubs hubs, bool multi, CList<CObject> * searchlist, CStringList * hublist, CString s = "" );
	/** */
	void StopSearch();

	/** passive search results */
	bool HandleMessage( CMessageSearchResult * MessageSearchResult );
	/** */
	int DC_ClientCallBack( CObject * Client, CObject * Object );
	/** */
	int DC_ManagerCallBack( CObject *, CObject * );

	/** */
	int DC_SearchSocketCallBack( CObject *, CObject * );

	/** */
	CString GetSearchString( CMessageSearchFile * msg );

protected:
	/** */
	eHubSearchType m_ehSearchType;
	/** store clients */
	CList<CObject> * m_pHubSearchClientList;
	/** */
	CStringList * m_pHubServerList;
	/** */
	int m_nMaxThreads;
	/** */
	time_t m_tStartTime;
	/** */
	long m_nError;
	/** */
	long m_nCurrentHub;
	/** */
	bool m_bEnableTag;

private:
	/** */
	friend class CSingleton<CHubSearch>;
	/** */
	void SendDebug( CString s );
	/** */
	void SendSearchResult( CObject * object );
	/** */
	void CheckClient();
	/** create new client connection */
	void NewClient();
	/** send the search to this client */
	bool SendSearch( sHubSearchClient * HubSearchClient );
	/** send the search to this client */
	int SendSearch( CString s );
	/** */
	void UpdateClients();

	/** */
	_CCallback * m_pCallback;

	/** */
	CSearchSocket m_SearchSocket;
	
	/** */
	CThread ClientThread;
	/** */
	CThread HubSearchClientListThread;
	/** */
	CString * m_sCurrentServer;
	/** */
	CList<CObject> * m_pSearchList;
	/** */
	bool m_bHandleUserList;
	/** */
	time_t m_tHubSearchTimeout;
	/** */
	CString m_sHubName;
	/** */
	CObject * m_pCurrentSearchObject;
	/** */
	bool m_bMultiSearch;
	/** */
	CMutex m_HubSearchCallBackLock;
};

#endif
