/***************************************************************************
                          cdcproto.cpp  -  description
                             -------------------
    begin                : Sun Dec 15 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>

#ifndef WIN32
#include <stdlib.h>
#include <unistd.h>
#else
#include <wtypes.h>
#include <winbase.h>
#include <stdlib.h>
#endif

#include <dclib/dcos.h>
#include <dclib/cencrypt.h>
#include <dclib/core/cbase64.h>

#include "cdcproto.h"

CDCProto::CDCProto()
{
}

CDCProto::~CDCProto()
{
}

/** */
int CDCProto::SendChat( CString sNick, CString s )
{
	DCProtoThread.Lock();

	int err;
	CString t;
	CString msg;

	msg = s.Replace( "$", "&#36;");
	msg = msg.Replace( "|", "&#124;");

	t  = "<";
	t += sNick +"> ";
	t += msg + "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendVersion( CString /*sVersion*/ )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Version ";
	/* taken out to remove the confusion in some scripts reporting a version # of 0
	Hopefully will prevent users from getting kicked for Hacked Clients.   SMiLeaf
	t += sVersion; */
	t += "1,0091";
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendMyInfo( CString sNick, CString sComment, CString sConnectionType, eUserAwayMode eAwayMode, CString sEMail, CString sShare )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$MyINFO $ALL ";
	t += sNick + " " + sComment + "$";
	t += " $"; // ???
	t += sConnectionType;

	switch(eAwayMode)
	{
		case euamAWAY:
			t += "\x2";
			break;
		default:
			t += "\x1";
			break;
	}

	t += "$";
	t += sEMail + "$";
	t += sShare + "$"; // share
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendKey( CString s )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Key ";
	t += s;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendValidateNick( CString sNick )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$ValidateNick ";
	t += sNick;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendMyNick( CString sNick )
{
	DCProtoThread.Lock();

	int err;
	int i,l;
	CString t,s;
	CBase64 Base64;

	t  = "$MyNick ";
	t += sNick;
	t += "|";

	t += "$Lock ";

	l = 50+rand()%50;

	s  = "EXTENDEDPROTOCOL";
//	s  = (char)('%'+rand()%('z'-'%'));
//	s += "DCGUI-";
//	s += VERSION;
//	s += '!';
//	s += (char)('%'+rand()%('z'-'%'));
//	s  = Base64.Encode(s);
//	s += '!';

	t += s;
	l -= s.Length();

	for (i=0;i<l;i++)
	{
		t += (char)('%'+rand()%('z'-'%'));
	}

	t += " Pk=";
//	s  = (char)('%'+rand()%('z'-'%'));
	s = "DCGUI";
//	s  = Base64.Encode(s);
//	s += '!';

	while(s.Length()<16) s += (char)('%'+rand()%('z'-'%'));
	
	t += s;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendLock()
{
	DCProtoThread.Lock();

	int err;
	CString t;
	int i,l;

	t = "$Lock ";

	l = 50+rand()%50;

	for (i=0;i<l;i++)
	{
		t += (char)('%'+rand()%('z'-'%'));
	}

	t += " ";
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}


/** */
int CDCProto::SendPrivateMessage( CString sNick, CString sTo, CString sMsg, CString sFromNick )
{
	DCProtoThread.Lock();

	int err;
	CString t,msg;
	CEncrypt Encrypt;

	t = "$To: " + sTo + " From: " + sNick + " $<";
	if ( sFromNick == "" )
		t += sNick;
	else
		t += sFromNick;

	msg = sMsg.Replace( "$", "&#36;");
	msg = msg.Replace( "|", "&#124;");

	t += "> " + Encrypt.Encode(msg) + "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::RequestNickList()
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t = "$GetNickList|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendDirection( eDirection Direction, int level )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Direction ";

	if (Direction == edUPLOAD)
		t += "Upload";
	else if (Direction == edDOWNLOAD)
		t += "Download";

	t += " ";
	t += CString().setNum(level);
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendGet( CString file, ulonglong pos, ulonglong size )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Get ";
	t += file;
	t += "$";
	t += CString().setNum(pos);

	if ( size != 0 )
	{
		t += "$";
		t += CString().setNum(size);
	}

	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendRevConnectToMe( CString sNick, CString sDstNick )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$RevConnectToMe ";
	t += sNick;
	t += " ";
	t += sDstNick;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendSend()
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Send";
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendError( CString message )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Error ";
	t += message;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendFileLength( ulonglong len )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$FileLength ";
	t += CString().setNum(len);
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendListLen( ulonglong len )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$ListLen ";
	t += CString().setNum(len);
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendGetListLen()
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$GetListLen";
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendConnectToMe( CString sDstNick, CString host )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$ConnectToMe ";
	t += sDstNick + " ";
	t += host;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendCanceled()
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Canceled";
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** send string */
int CDCProto::SendString( CString message )
{
	DCProtoThread.Lock();

	int err;

	err = Write((const unsigned char*)message.Data(),message.Length());

	DCProtoThread.UnLock();

	return err;

}

/** send password */
int CDCProto::SendPass( CString pass )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$MyPass ";
	t += pass;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** operator kick */
int CDCProto::SendKick( CString nick )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$Kick ";
	t += nick;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** operator force move a user */
int CDCProto::SendOpForceMove( CString nick, CString host, CString message )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$OpForceMove $Who:";
	t += nick;
	t += "$Where:";
	t += host;
	t += "$Msg:";
	t += message;
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendMaxedOut()
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t  = "$MaxedOut";
	t += "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendGetInfo( CString sNick, CString sMyNick )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t = "$GetINFO " + sNick + " " + sMyNick + "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}

/** */
int CDCProto::SendSupports( CString s )
{
	DCProtoThread.Lock();

	int err;
	CString t;

	t = "$Supports " + s + "|";

	err = Write((const unsigned char*)t.Data(),t.Length());

	DCProtoThread.UnLock();

	return err;
}
